/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.Arguments;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.CSSDefinition;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeRulesProcessor;
import com.cognos.rap.actions.v5spechelpers.ChartElements;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DrillUpDownWithBehaviors;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5RSXCrosstab;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Style;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPMessageManager;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class V5Crosstab
extends V5RSXCrosstab {
    private ActionEnv actionEnv = null;
    private List<Element> nodes = null;
    private HashSet<String> edgeLocations = null;
    private List<Element> _nestedLocationWithSameHUN = null;

    public V5Crosstab(Element crosstabDataContainer) {
        this._container = crosstabDataContainer;
        this._typeID = V5DataContainer.containerTypeID.crosstab;
    }

    @Override
    public Element getDefaultMeasure() {
        return this._container.element("defaultMeasure");
    }

    public String nextFreeEdge() {
        if (this.edgeLocations == null) {
            this.edgeLocations = new HashSet();
            List edges = XMLUtility.selectNodes(this._container, ".//*[local-name()='crosstabNodeMember']");
            ListIterator iterator = edges.listIterator();
            while (iterator.hasNext()) {
                Element crosstabNodeMember = (Element)iterator.next();
                String sEdgeLocation = crosstabNodeMember.attributeValue("edgeLocation");
                if (sEdgeLocation == null) continue;
                this.edgeLocations.add(sEdgeLocation);
            }
        }
        int n = 1;
        String sNextFreeEdge = "e" + n;
        while (this.edgeLocations != null && this.edgeLocations.contains(sNextFreeEdge)) {
            sNextFreeEdge = "e" + n++;
        }
        this.edgeLocations.add(sNextFreeEdge);
        return sNextFreeEdge;
    }

    @Override
    public Element findItem(String refDataItem) {
        Element layoutItem = V5X.selectSingleNode(this._container, "crosstabNodeMember", "//V5X//ATTR", "refDataItem", refDataItem);
        if (layoutItem == null) {
            layoutItem = V5X.selectSingleNode(this._container, "defaultMeasure", "//V5X//ATTR", "refDataItem", refDataItem);
        }
        return layoutItem;
    }

    public static List<Element> getNestedLocation(Element crosstabNodeMember) {
        ArrayList<Element> ancestry = new ArrayList<Element>();
        Element crosstabNestedNodeOrAxis = V5SpecHelper.getAncestor(crosstabNodeMember, "crosstabNode").getParent();
        while ("crosstabNestedNodes".equals(crosstabNestedNodeOrAxis.getName())) {
            Element parentNode = V5X.selectSingleNode(crosstabNestedNodeOrAxis.getParent(), "//V5X//CHILD", "crosstabNodeMembers", "crosstabNodeMember");
            if (parentNode != null) {
                ancestry.add(parentNode);
            } else {
                parentNode = V5X.selectSingleNode(crosstabNestedNodeOrAxis.getParent(), "//V5X//CHILD", "crosstabNodeMembers", "crosstabSpacer");
            }
            if (parentNode == null) continue;
            crosstabNestedNodeOrAxis = V5SpecHelper.getAncestor(parentNode, "crosstabNode").getParent();
        }
        return ancestry;
    }

    public Depth matchCrosstabNodesToSelection(Element firstCrosstabNodeMember, SelectedCell selectedCell) {
        if (!selectedCell.nodeName.equals(firstCrosstabNodeMember.attributeValue("refDataItem"))) {
            return new Depth(0, 0);
        }
        int matchDepth = 1;
        SelectedCell cell = selectedCell;
        List<Element> ancestry = V5Crosstab.getNestedLocation(firstCrosstabNodeMember);
        for (Element ancestor : ancestry) {
            if (cell.definingCells.size() == 0) {
                return new Depth(ancestry.size(), matchDepth);
            }
            if ((cell = cell.findDefiningCell(ancestor.attributeValue("refDataItem"))) == null) {
                return new Depth(ancestry.size(), 0);
            }
            ++matchDepth;
        }
        return new Depth(ancestry.size(), matchDepth);
    }

    public Element findSelectedNodeMember(SelectedCell selectedCell) {
        Element bestMatch = null;
        Depth bestMatchDepth = new Depth(0, 0);
        List rdiNodes = V5X.selectNodes(this._container, "crosstabNodeMember", "//V5X//ATTR", "refDataItem", selectedCell.nodeName);
        for (Element rdiNode : rdiNodes) {
            Depth depth = this.matchCrosstabNodesToSelection(rdiNode, selectedCell);
            if (depth.matchDepth > bestMatchDepth.matchDepth) {
                bestMatchDepth = depth;
                bestMatch = rdiNode;
                continue;
            }
            if (depth.matchDepth != bestMatchDepth.matchDepth || Math.abs(depth.nestDepth - selectedCell.definingCells.size()) >= Math.abs(bestMatchDepth.nestDepth - selectedCell.definingCells.size())) continue;
            bestMatchDepth = depth;
            bestMatch = rdiNode;
        }
        return bestMatch;
    }

    @Override
    public Element findItemLabelByRDI(String dataItemName) {
        Element nodeMember = V5X.selectSingleNode(this._container, "//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", dataItemName);
        if (nodeMember != null) {
            return V5X.selectSingleNode(nodeMember, "contents", "//V5X//CHILD", "textItem");
        }
        return null;
    }

    @Override
    public Element findItemLabel(Element crosstabNodeMemberOrCrosstabCorner) {
        return V5DataContainer.selectSingleNode(this._container, crosstabNodeMemberOrCrosstabCorner, "contents", "//V5X//CHILD", "textItem");
    }

    public Element insertNodeAfter(String sDataItemName, String sNewNodeRDI) throws ActionException {
        try {
            Element newCrosstabNode;
            Element insertionPoint;
            Element insertionNodeMember = (Element)this._container.selectSingleNode(".//*[@refDataItem='" + sDataItemName + "']");
            if (insertionNodeMember != null && (insertionPoint = V5SpecHelper.getAncestor(insertionNodeMember, "crosstabNode")) != null && V5Crosstab.insertLayoutElementAfter(insertionPoint, newCrosstabNode = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"crosstabNode", (Namespace)insertionPoint.getNamespace()))) >= 0) {
                Element newCrosstabNodeMember = (Element)insertionNodeMember.clone();
                String newMemberEdgeLocation = this.nextFreeEdge();
                Element crosstabNodeMembers = newCrosstabNode.addElement("crosstabNodeMembers");
                crosstabNodeMembers.add(newCrosstabNodeMember);
                Attribute rdiAttribute = newCrosstabNodeMember.attribute("refDataItem");
                newCrosstabNodeMember.remove(rdiAttribute);
                newCrosstabNodeMember.addAttribute("refDataItem", sNewNodeRDI);
                Attribute edgeLocationAttribute = newCrosstabNodeMember.attribute("edgeLocation");
                if (edgeLocationAttribute != null) {
                    newCrosstabNodeMember.remove(edgeLocationAttribute);
                }
                newCrosstabNodeMember.addAttribute("edgeLocation", newMemberEdgeLocation);
                List rdiNodes = XMLUtility.selectNodes(newCrosstabNodeMember, ".//*[@refDataItem='" + sDataItemName + "']");
                for (int i = 0; i < rdiNodes.size(); ++i) {
                    Element rdiNode = (Element)rdiNodes.get(i);
                    rdiAttribute = rdiNode.attribute("refDataItem");
                    rdiNode.remove(rdiAttribute);
                    rdiNode.addAttribute("refDataItem", sNewNodeRDI);
                }
                List conditionalStyleNodes = XMLUtility.selectNodes(newCrosstabNodeMember, ".//*[local-name()='conditionalStyles']");
                for (int i = 0; i < conditionalStyleNodes.size(); ++i) {
                    Element conditionalStyleNode = (Element)conditionalStyleNodes.get(i);
                    conditionalStyleNode.getParent().remove(conditionalStyleNode);
                }
                this.applyIntersectionStyle(newCrosstabNodeMember, insertionPoint.element("crosstabNodeMembers").element("crosstabNodeMember"));
                return newCrosstabNodeMember;
            }
        }
        catch (Exception e) {
            throw new ActionException();
        }
        return null;
    }

    protected List<Element> getRelatedIntersections(Element crosstabNode) {
        Element intersectionsElement = (Element)this._container.selectSingleNode(".//*[local-name()='crosstabIntersections']");
        if (intersectionsElement == null) {
            return null;
        }
        String crosstabNodeEdgeLocation = crosstabNode.attributeValue("edgeLocation");
        return XMLUtility.selectNodes(intersectionsElement, ".//*[@row='" + crosstabNodeEdgeLocation + "' or @column='" + crosstabNodeEdgeLocation + "' ]");
    }

    @Override
    public List<Element> getCellStyles(Element layoutElement) {
        ArrayList<Element> styleNodes = new ArrayList<Element>();
        List<Element> relatedIntersections = this.getRelatedIntersections(layoutElement);
        if (relatedIntersections != null) {
            for (Element intersection : relatedIntersections) {
                styleNodes.addAll(V5X.selectNodes(intersection, "style"));
            }
        }
        styleNodes.addAll(V5X.selectNodes(this._container, "crosstabFactCell", "style"));
        return styleNodes;
    }

    public void updateIntersectionDataFormats(Element crosstabNode, String dataFormat) {
        List<Element> intersectionList = this.getRelatedIntersections(crosstabNode);
        if (intersectionList == null) {
            return;
        }
        V5Style style = new V5Style();
        ListIterator<Element> intersectionIterator = intersectionList.listIterator();
        while (intersectionIterator.hasNext()) {
            Element eIntersection = intersectionIterator.next();
            style.setDataFormat(eIntersection, dataFormat);
        }
    }

    @Override
    public boolean isLeafNode(Element thisNodeMember) {
        return thisNodeMember.getParent() != null && thisNodeMember.getParent().getParent() != null && thisNodeMember.getParent().getParent().element("crosstabNestedNodes") == null;
    }

    public void applyIntersectionStyle(Element targetCrosstabNode, Element sourceCrosstabNode) {
        Element intersectionsElement = (Element)this._container.selectSingleNode(".//*[local-name()='crosstabIntersections']");
        if (intersectionsElement == null) {
            return;
        }
        String sourceEdgeLocation = sourceCrosstabNode.attributeValue("edgeLocation");
        String targetEdgeLocation = targetCrosstabNode.attributeValue("edgeLocation");
        List intersectionList = XMLUtility.selectNodes(intersectionsElement, ".//*[@row='" + sourceEdgeLocation + "' or @column='" + sourceEdgeLocation + "' ]");
        ListIterator intersectionIterator = intersectionList.listIterator();
        while (intersectionIterator.hasNext()) {
            Element newIintersectionElement = (Element)((Element)intersectionIterator.next()).clone();
            if (newIintersectionElement.attributeValue("row").equals(sourceEdgeLocation)) {
                newIintersectionElement.addAttribute("row", targetEdgeLocation);
            }
            if (newIintersectionElement.attributeValue("column").equals(sourceEdgeLocation)) {
                newIintersectionElement.addAttribute("column", targetEdgeLocation);
            }
            intersectionsElement.add(newIintersectionElement);
        }
    }

    @Override
    public void addSortList(String columnName, String sortOrder) {
        this.addSortList(columnName, columnName, sortOrder);
    }

    @Override
    public void addSortList(String columnName, String sortedDataItem, String sortOrder) {
        Element nodeMember = this.findItem(columnName);
        if (nodeMember != null && !"defaultMeasure".equals(nodeMember.getName())) {
            Element sortList = nodeMember.element("sortList");
            if (sortList != null) {
                sortList.detach();
            }
            sortList = DocumentHelper.makeElement((Branch)nodeMember, (String)"sortList");
            V5SpecHelper.addSortItem(sortList, sortedDataItem, sortOrder);
        }
    }

    @Override
    public void removeSortList(String columnName) throws ActionException {
        Element sortList;
        Element nodeMember = this.findItem(columnName);
        if (nodeMember != null && (sortList = nodeMember.element("sortList")) != null) {
            sortList.detach();
        }
    }

    @Override
    public Element getCrosstabElement() {
        return this._container;
    }

    @Override
    public Element findAxis(String refDataItem) {
        Element rdi = this.findItemLabelByRDI(refDataItem);
        if (rdi == null) {
            return null;
        }
        Element axisRoot = V5SpecHelper.getAncestor(rdi, "crosstabRows");
        if (axisRoot == null) {
            axisRoot = V5SpecHelper.getAncestor(rdi, "crosstabColumns");
        }
        return axisRoot;
    }

    @Override
    public Element findOppositeAxis(String refDataItem) {
        Element thisAxis = this.findAxis(refDataItem);
        if (thisAxis != null) {
            if ("crosstabRows".equals(thisAxis.getName())) {
                return thisAxis.getParent().element("crosstabColumns");
            }
            return thisAxis.getParent().element("crosstabRows");
        }
        return null;
    }

    @Override
    public List<Element> axisNodeMembers(Element axis) {
        return XMLUtility.selectNodes(axis, V5X.select("crosstabNodeMember"));
    }

    @Override
    public List<Element> collectNodes() {
        if (this.nodes == null) {
            this.nodes = XMLUtility.selectNodes(this._container, V5X.select("crosstabNodeMember"));
            Element defaultMeasure = this._container.element("defaultMeasure");
            if (defaultMeasure != null) {
                if (this.nodes == null) {
                    this.nodes = new ArrayList<Element>();
                }
                this.nodes.add(defaultMeasure);
            }
        }
        return this.nodes;
    }

    @Override
    public List<Element> collectEdgeNodes() {
        return XMLUtility.selectNodes(this._container, V5X.select("crosstabNodeMember"));
    }

    @Override
    public void setActionEnv(ActionEnv actionEnv) {
        this.actionEnv = actionEnv;
    }

    @Override
    public Collection<Element> getLayoutSortItems() {
        return V5X.selectNodes(this.getContainerElement(), "crosstabNodeMember", "//V5X//CHILD", "sortList", "//V5X//CHILD", "sortItem");
    }

    @Override
    public Element changeDisplayType(ActionEnv env) throws ActionException {
        this.actionEnv = env;
        Element newDataContainerElement = null;
        ChangeDisplayTypeHelper.TargetDisplayType targetType = ChangeDisplayTypeHelper.getTargetDisplayType(env.getActionArguments());
        if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.chart) {
            this.removeAggregateEdges();
            this.removeSetParentNode(env.getRAPReport());
            newDataContainerElement = this.convertToChart(env.getActionArguments().getArgument("target"));
        } else if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.list) {
            if (!this.ifCanConvertToList()) {
                throw new ActionException(RAPMessageManager.convert("RAP_CANNOT_CONVERT_TO_LIST", this.actionEnv.getLocale()));
            }
            this.removeUnionNodesOnNestedEdges();
            this.removeAggregateEdges();
            this.getV5Query().revertToRegularSet();
            this.removeSetParentNode(env.getRAPReport());
            newDataContainerElement = this.convertToList();
        } else if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.crosstab) {
            return this.getContainerElement();
        }
        if (newDataContainerElement != null) {
            if (this.actionEnv.getActionArg("id").equals(this.getID())) {
                ChangeDisplayTypeRulesProcessor rulesProcessor = new ChangeDisplayTypeRulesProcessor(env);
                rulesProcessor.applyChartConversionRules(this.getContainerElement(), newDataContainerElement);
                ChangeDisplayTypeHelper.stripConversionRulesNodes(newDataContainerElement);
            }
            ChangeDisplayTypeHelper.setDataContainerName(newDataContainerElement, this._container.attributeValue("name"), env.getActionArguments());
            return newDataContainerElement;
        }
        return super.changeDisplayType(env);
    }

    public void removeUnionNodesOnNestedEdges() throws ActionException {
        Element crosstabColumns = V5X.selectSingleNode(this.getContainerElement(), "crosstabColumns");
        this.removeUnionNodesOnNestedEdge(crosstabColumns);
        Element crosstabRows = V5X.selectSingleNode(this.getContainerElement(), "crosstabRows");
        this.removeUnionNodesOnNestedEdge(crosstabRows);
    }

    private void removeUnionNodesOnNestedEdge(Element crosstabEdge) throws ActionException {
        if (crosstabEdge == null) {
            return;
        }
        List crosstabNodeElements = XMLUtility.selectNodes(crosstabEdge, V5X.selectImmediateChildren("crosstabNode"));
        if (this.ifContainsNestedNodes(crosstabNodeElements)) {
            Iterator crosstabNodeIterator = crosstabNodeElements.iterator();
            Element remainingCrosstabNode = (Element)crosstabNodeIterator.next();
            while (crosstabNodeIterator.hasNext()) {
                ((Element)crosstabNodeIterator.next()).detach();
            }
            this.removeUnionNodesOnNestedEdge((Element)remainingCrosstabNode.selectSingleNode(V5X.selectImmediateChildren("crosstabNestedNodes")));
        }
    }

    private boolean ifContainsNestedNodes(List<Element> crosstabNodeElements) {
        for (Element crosstabNodeElement : crosstabNodeElements) {
            Element crosstabNestedNodes = (Element)crosstabNodeElement.selectSingleNode(V5X.selectImmediateChildren("crosstabNestedNodes"));
            if (crosstabNestedNodes == null) continue;
            return true;
        }
        return false;
    }

    public void removeAggregateEdges() {
        List crosstabNodeMemberElements = XMLUtility.selectNodes(this.getContainerElement(), V5X.select("crosstabNodeMember"));
        for (Element crosstabNodeMember : crosstabNodeMemberElements) {
            Element crosstabNode;
            Element parent;
            if (!this.ifAggregateCrosstabNodeMember(crosstabNodeMember) || this.ifCrosstabNodeMembersAllAggregate(parent = (crosstabNode = crosstabNodeMember.getParent().getParent()).getParent())) continue;
            crosstabNode.detach();
        }
    }

    public void removeSetParentNode(RAPReport reportToModify) throws ActionException {
        List crosstabNodeMemberElements = XMLUtility.selectNodes(this.getContainerElement(), V5X.select("crosstabNodeMember"));
        for (Element crosstabNodeMember : crosstabNodeMemberElements) {
            if (!this.ifHasChildrenSetNode(reportToModify, crosstabNodeMember.attributeValue("refDataItem"))) continue;
            crosstabNodeMember.getParent().getParent().detach();
        }
    }

    public boolean ifHasChildrenSetNode(RAPReport report, String parentRDI) throws ActionException {
        block4: {
            Element munE;
            V5QueryItem queryItem;
            block3: {
                queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), this.getV5Query().findItem(parentRDI));
                if (queryItem.evaluateHighLevelSpecTypes()) break block3;
                String expression = queryItem.getQueryItemExpression();
                if (expression == null) break block4;
                List dataItems = XMLUtility.selectNodes(this.getV5Query().getQuerySelection(), V5X.select("dataItem"));
                for (Element dataItem : dataItems) {
                    Element expressionE = (Element)dataItem.selectSingleNode(V5X.select("expression"));
                    if (expressionE == null || !V5Crosstab.isChildrenSetForm(expression, expressionE.getText()) || !this.ifRDIReferencedByCrosstabNodeMember(dataItem.attributeValue("name"))) continue;
                    return true;
                }
                break block4;
            }
            if (queryItem.evaluate().equals((Object)V5QueryItem.ItemType.member) && (munE = (Element)queryItem.getDOM().selectSingleNode(V5X.select("MUN"))) != null) {
                String mun = munE.getText();
                List childrenSetDataItems = XMLUtility.selectNodes(this.getV5Query().getQuerySelection(), V5X.select("dataItemChildrenSet"));
                for (Element dataItem : childrenSetDataItems) {
                    Element childrenSetMUN = (Element)dataItem.selectSingleNode(V5X.select("MUN"));
                    if (childrenSetMUN == null || !childrenSetMUN.getText().equals(mun) || !this.ifRDIReferencedByCrosstabNodeMember(dataItem.attributeValue("name"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isChildrenSetForm(String parentExpression, String childrenSetExpression) {
        String escaped = V5Query.escapeRegExpression(parentExpression);
        return childrenSetExpression.matches("\\s*children\\(\\s*" + escaped + "\\s*\\)\\s*");
    }

    public boolean ifRDIReferencedByCrosstabNodeMember(String rdi) {
        return this.getContainerElement().selectSingleNode(V5X.select("crosstabNodeMember", "refDataItem", rdi)) != null;
    }

    private boolean ifCrosstabNodeMembersAllAggregate(Element parent) {
        List crosstabNodeMemberElements = V5X.selectNodes(parent, "//V5X//CHILD", "crosstabNode", "crosstabNodeMembers", "crosstabNodeMember");
        for (Element crosstabNodeMember : crosstabNodeMemberElements) {
            if (this.ifAggregateCrosstabNodeMember(crosstabNodeMember)) continue;
            return false;
        }
        return true;
    }

    private boolean ifAggregateCrosstabNodeMember(Element crosstabNodeMember) {
        Element drillSimpleType;
        Element drillDataItemBehavior;
        Element memberSet;
        String rdi = crosstabNodeMember.attributeValue("refDataItem");
        Element dataItem = this.getV5Query().findItem(rdi);
        if (dataItem.getName().equals("dataItem") && (memberSet = V5X.selectSingleNode(this.getV5Query().getQueryElement(), "memberSet", "//V5X//ATTR", "refDataItem", rdi)) != null && (drillDataItemBehavior = V5X.selectSingleNode(this._container.getDocument().getRootElement(), "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.getV5Query().getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", rdi)) != null && (drillSimpleType = V5X.selectSingleNode(drillDataItemBehavior, "drillSimpleType", "//V5X//ATTR", "type", "replaceItem")) != null) {
            return true;
        }
        V5QueryItem queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), dataItem);
        return queryItem.getQueryItemExpression() != null && queryItem.isKnownAggregateForm() || dataItem.getName().equals("dataItemDimensionalEdgeSummary") || dataItem.getName().equals("dataItemEdgeSummary");
    }

    private Element createNewChart(String targetDisplayType, Element columnRoot, Element rowRoot, List<Element> measureNodes) throws ActionException {
        Element chartElement = ChangeDisplayTypeHelper.getNewChartElement(targetDisplayType, this.getContainerElement().getNamespace());
        ChangeDisplayTypeHelper.puffChart(chartElement);
        boolean swapAxes = this.ifSwapAxes(chartElement, rowRoot, columnRoot);
        Element defaultMeasure = this.getDefaultMeasureForChart(measureNodes);
        if (defaultMeasure != null) {
            measureNodes.remove(defaultMeasure);
        }
        ChangeDisplayTypeHelper.populateMeasuresForChart(chartElement, measureNodes);
        V5Chart v5Chart = new V5Chart(chartElement);
        if (defaultMeasure != null) {
            v5Chart.setDefaultMeasure(defaultMeasure.attributeValue("refDataItem"));
            Element crosstabElement = defaultMeasure.getParent();
            if (crosstabElement != null) {
                Element dataFormat = V5X.selectSingleNode(crosstabElement, "//V5X//CHILD", "crosstabFactCell", "style", "dataFormat");
                if (dataFormat == null && defaultMeasure.getName().equals("crosstabNodeMember")) {
                    dataFormat = V5X.selectSingleNode(defaultMeasure, "//V5X//CHILD", "factCell", "style", "dataFormat");
                }
                if (dataFormat != null) {
                    v5Chart.setDataFormatStyleOnDefaultMeasure((Element)dataFormat.clone());
                }
            }
            defaultMeasure.detach();
        } else {
            v5Chart.removeDefaultMeasure();
        }
        this.updateChartEdgeFromCrosstab(targetDisplayType, chartElement, columnRoot, rowRoot, swapAxes);
        chartElement.addAttribute("refQuery", this.getContainerElement().attributeValue("refQuery"));
        ChangeDisplayTypeHelper.fixRefQuery(chartElement);
        ChangeDisplayTypeHelper.fixChartElement(chartElement);
        XMLUtility.cloneChildNode(chartElement, this.getContainerElement(), "masterDetailLinks");
        this.copySuppressionToChart(chartElement, swapAxes);
        XMLUtility.cloneChildNode(chartElement, this.getContainerElement(), "noDataHandler");
        ChangeDisplayTypeHelper.setMatrixElementForV2Chart(chartElement);
        return chartElement;
    }

    private Element getDefaultMeasureForChart(List<Element> measureNodes) {
        Element defaultMeasure = null;
        if (measureNodes.size() == 1) {
            defaultMeasure = measureNodes.get(0);
        } else {
            for (Element measureNode : measureNodes) {
                if (!"defaultMeasure".equals(measureNode.getName())) continue;
                defaultMeasure = measureNode;
                break;
            }
        }
        return defaultMeasure;
    }

    private Element createNewList(Element crosstabColumns, Element crosstabRows, List<Element> measureNodes) throws ActionException {
        Arguments arguments = this.actionEnv.getActionArguments();
        Element listElement = ChangeDisplayTypeHelper.getNewChartElement(arguments, this.getContainerElement().getNamespace());
        ChangeDisplayTypeHelper.puffChart(listElement);
        listElement.addAttribute("refQuery", this.getRefQuery());
        ChangeDisplayTypeHelper.fixRefQuery(listElement);
        ArrayList<Element> dataItemsList = new ArrayList<Element>();
        this.updateListFromCrosstab(listElement, crosstabColumns, true, dataItemsList);
        this.updateListFromCrosstab(listElement, crosstabRows, false, dataItemsList);
        this.updateListFromMeasureNodes(listElement, measureNodes, dataItemsList);
        this.copySuppressionToList(listElement);
        return listElement;
    }

    private Element convertToChart(String targetDisplayType) throws ActionException {
        this.removeDrillThroughFromCrosstab();
        Element crosstabRows = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabRows"));
        Element crosstabColumns = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabColumns"));
        List<Element> measureNodes = this.collectMeasures(crosstabRows, crosstabColumns);
        if (measureNodes.isEmpty()) {
            throw new ActionException(RAPMessageManager.convert("RAP_NOT_ENOUGH_MEASURES_FOR_CHART", this.actionEnv.getLocale()));
        }
        Iterator<Element> ite = measureNodes.iterator();
        while (ite.hasNext()) {
            if (!this.isANSMeasureSet(ite.next())) continue;
            ite.remove();
        }
        if (ChartElements.noneMeasureEdgeCharts.contains(ChangeDisplayTypeHelper.getChartElementName(targetDisplayType))) {
            for (Element measureNode : measureNodes) {
                measureNode.detach();
            }
        }
        if (crosstabColumns == null && crosstabRows == null) {
            throw new ActionException(RAPMessageManager.convert("RAP_NOT_ENOUGH_DIMENSIONS_FOR_CHART", this.actionEnv.getLocale()));
        }
        Element changedLayoutElement = this.createNewChart(targetDisplayType, crosstabColumns, crosstabRows, measureNodes);
        Element parentElement = this.getContainerElement().getParent();
        int index = parentElement.indexOf((Node)this.getContainerElement());
        parentElement.content().add(index, changedLayoutElement);
        this.getContainerElement().detach();
        return changedLayoutElement;
    }

    private List<Element> collectMeasures(Element rowsRoot, Element columnsRoot) throws ActionException {
        ArrayList<Element> measures = new ArrayList<Element>();
        measures.addAll(this.getContainedMeasure(rowsRoot));
        measures.addAll(this.getContainedMeasure(columnsRoot));
        Element defaultMeasure = (Element)this.getContainerElement().selectSingleNode(V5X.select("defaultMeasure"));
        if (defaultMeasure != null) {
            measures.add(defaultMeasure);
        }
        return measures;
    }

    private Element convertToList() throws ActionException {
        Element changedLayoutElement = null;
        Element crosstabRows = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabRows"));
        Element crosstabColumns = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabColumns"));
        List<Element> measureNodes = this.collectMeasures(crosstabRows, crosstabColumns);
        for (Element measureNode : measureNodes) {
            if (!this.isANSMeasureSet(measureNode)) continue;
            throw new ActionException(RAPMessageManager.convert("RAP_CANNOT_CONVERT_TO_LIST", this.actionEnv.getLocale()));
        }
        changedLayoutElement = this.createNewList(crosstabColumns, crosstabRows, measureNodes);
        Element parentElement = this.getContainerElement().getParent();
        int index = parentElement.indexOf((Node)this.getContainerElement());
        parentElement.content().add(index, changedLayoutElement);
        this.getContainerElement().detach();
        return changedLayoutElement;
    }

    public List<Element> getContainedMeasure(Element crosstabNestedNodes) throws ActionException {
        if (crosstabNestedNodes != null) {
            Element containedNestedNodes = (Element)crosstabNestedNodes.selectSingleNode(V5X.select("crosstabNestedNodes"));
            if (containedNestedNodes != null) {
                return this.getContainedMeasure(containedNestedNodes);
            }
            if (this.ifContainedNodesAllNumeric(crosstabNestedNodes)) {
                return V5X.selectNodes(crosstabNestedNodes, "//V5X//CHILD", "crosstabNode", "//V5X//CHILD", "crosstabNodeMembers", "//V5X//CHILD", "crosstabNodeMember");
            }
        }
        return new ArrayList<Element>();
    }

    public boolean ifContainedNodesAllNumeric(Element crosstabEdgeNodes) throws ActionException {
        if (crosstabEdgeNodes == null) {
            return false;
        }
        boolean isAllNumeric = false;
        List crosstabNodeMemberElements = XMLUtility.selectNodes(crosstabEdgeNodes, V5X.selectImmediateChildren("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember"));
        if (crosstabNodeMemberElements.size() == 0) {
            return false;
        }
        for (Element crosstabNodeMemberElement : crosstabNodeMemberElements) {
            V5QueryItem.NumericSubType subType;
            Element dataItem = this.getV5Query().findItem(crosstabNodeMemberElement.attributeValue("refDataItem"));
            if (dataItem == null) continue;
            V5QueryItem queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), dataItem);
            if (queryItem.confirmIsNumeric() && (V5QueryItem.NumericSubType.measure.equals((Object)(subType = queryItem.getNumericSubType())) || queryItem.getProperties() != null && queryItem.getProperties().getModelItem() == null)) {
                isAllNumeric = true;
            }
            if (isAllNumeric) continue;
            break;
        }
        return isAllNumeric;
    }

    public static V5Query createAndPopulateNewQuery(V5Query query) {
        Element newQuerySelection = (Element)query.getQuerySelection().clone();
        Element newQueryElement = V5SpecHelper.createNewQuery(query);
        newQueryElement.element("selection").detach();
        newQueryElement.add(newQuerySelection);
        String newQueryName = newQueryElement.attributeValue("name");
        Element sourceDetailFilters = query.getQueryElement().element("detailFilters");
        if (sourceDetailFilters != null) {
            newQueryElement.add((Element)sourceDetailFilters.clone());
        }
        return new V5Query(newQueryElement, newQueryName);
    }

    public void insertCrosstabNodeOfRDI(String rdi, Element dataFormat, Element crosstabRoot) {
        Element crosstabNodeMember = crosstabRoot.addElement("crosstabNode").addElement("crosstabNodeMembers").addElement("crosstabNodeMember");
        crosstabNodeMember.addAttribute("refDataItem", rdi);
        crosstabNodeMember.addAttribute("edgeLocation", this.nextFreeEdge());
        Element dataItemLabel = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"contents/textItem/dataSource/dataItemLabel");
        dataItemLabel.addAttribute("refDataItem", rdi);
        Element style = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"style");
        Element defaultStyle = DocumentHelper.makeElement((Branch)style, (String)"defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "ml");
        if (dataFormat != null) {
            Element factCellstyle = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)V5X.getMakeElementPath("factCell", "style"));
            factCellstyle.add(dataFormat);
        }
    }

    public void setDefaultMeasureForCrosstab(String rdi, Element dataFormat) {
        Element crosstabColumns = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabColumns"));
        Element crosstabRows = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabRows"));
        if (crosstabColumns.elements().size() == 0) {
            this.insertCrosstabNodeOfRDI(rdi, dataFormat, crosstabColumns);
        } else if (crosstabRows.elements().size() == 0) {
            this.insertCrosstabNodeOfRDI(rdi, dataFormat, crosstabRows);
        } else {
            Element crosstabFactCellStyle;
            Element defaultMeasure = DocumentHelper.makeElement((Branch)this.getContainerElement(), (String)"defaultMeasure");
            defaultMeasure.addAttribute("refDataItem", rdi);
            Element contentsElement = V5X.selectSingleNode(this.getContainerElement(), "crosstabCorner", "//V5X//CHILD", "contents");
            Element dataItemLabel = DocumentHelper.makeElement((Branch)contentsElement, (String)"textItem/dataSource/dataItemLabel");
            dataItemLabel.addAttribute("refDataItem", rdi);
            if (dataFormat != null && (crosstabFactCellStyle = DocumentHelper.makeElement((Branch)this.getContainerElement(), (String)V5X.getMakeElementPath("crosstabFactCell", "style"))) != null) {
                crosstabFactCellStyle.add(dataFormat);
            }
        }
    }

    private boolean updateChartEdgeFromCrosstab(String targetDisplayType, Element chartElement, Element columnRoot, Element rowRoot, boolean swapAxes) throws ActionException {
        boolean axesSwapped = false;
        Element categoryRoot = columnRoot;
        Element seriesRoot = rowRoot;
        if (swapAxes) {
            categoryRoot = rowRoot;
            seriesRoot = columnRoot;
            axesSwapped = true;
        }
        this.updateChartCategoryFromCrosstab(chartElement, categoryRoot);
        this.updateChartSeriesFromCrosstab(targetDisplayType, chartElement, seriesRoot);
        return axesSwapped;
    }

    private boolean ifSwapAxes(Element chartElement, Element rowRoot, Element columnRoot) throws ActionException {
        if ("pieChart".equals(chartElement.getName()) || "v2_pieChart".equals(chartElement.getName())) {
            V5QueryItem queryItem;
            if (rowRoot == null) {
                return true;
            }
            List crosstabNodeMemberElements = V5X.selectNodes(rowRoot, "crosstabNodeMember");
            if (crosstabNodeMemberElements.size() == 1 && (queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), this.getV5Query().findItem(((Element)crosstabNodeMemberElements.get(0)).attributeValue("refDataItem")))).confirmIsNumeric()) {
                return true;
            }
        }
        return false;
    }

    private void updateChartCategoryFromCrosstab(Element chartElement, Element crosstabRoot) throws ActionException {
        Element categoryRoot = null;
        if (ChartElements.ordinalAxis.get(chartElement.getName()) != null) {
            if (crosstabRoot != null) {
                Element ordinalEdge = DocumentHelper.makeElement((Branch)chartElement, (String)ChartElements.ordinalAxis.get(chartElement.getName()));
                categoryRoot = DocumentHelper.makeElement((Branch)ordinalEdge, (String)"chartNodes");
                this.populateChartEdgeFromCrosstabEdge(crosstabRoot, categoryRoot);
            } else {
                Element ordinalEdge = (Element)chartElement.selectSingleNode(V5X.select(ChartElements.ordinalAxis.get(chartElement.getName())));
                Element parent = ordinalEdge.getParent();
                ordinalEdge.detach();
                DocumentHelper.makeElement((Branch)parent, (String)ChartElements.ordinalAxis.get(chartElement.getName()));
            }
        }
    }

    private void updateChartSeriesFromCrosstab(String targetDisplayType, Element chartElement, Element crosstabRoot) throws ActionException {
        Element seriesRoot = null;
        if (ChartElements.legendEdgeName.get(chartElement.getName()) != null) {
            if (crosstabRoot != null) {
                Element seriesEdge = V5X.selectSingleNode(chartElement, ChartElements.legendEdgeName.get(chartElement.getName()));
                if (ChartElements.comboChart.contains(chartElement.getName())) {
                    seriesEdge = (Element)seriesEdge.elements().get(0);
                    if (V5Chart.isV2Chart(chartElement)) {
                        String legendEdgeSubTypeName = ChangeDisplayTypeHelper.getLegendEdgeSubTypeName(targetDisplayType);
                        Element seriesEdgeSubType = (Element)chartElement.selectSingleNode(V5X.select(legendEdgeSubTypeName));
                        if (seriesEdgeSubType == null) {
                            seriesEdgeSubType = seriesEdge.addElement(legendEdgeSubTypeName);
                        }
                        seriesEdge = seriesEdgeSubType;
                    }
                }
                seriesRoot = DocumentHelper.makeElement((Branch)seriesEdge, (String)"chartNodes");
                this.populateChartEdgeFromCrosstabEdge(crosstabRoot, seriesRoot);
            } else {
                Element legendEdge = (Element)chartElement.selectSingleNode(V5X.select(ChartElements.legendEdgeName.get(chartElement.getName())));
                if (ChartElements.comboChart.contains(chartElement.getName())) {
                    V5SpecHelper.removeLeafNodesByName(chartElement, legendEdge.getName());
                } else if (!"v2_gaugeChart".equals(chartElement.getName())) {
                    legendEdge.detach();
                }
            }
        }
    }

    public void updateListFromCrosstab(Element listElement, Element crosstabElements, boolean group, List<Element> dataItemsList) throws ActionException {
        Element crosstabNode;
        V5QueryItem queryItem;
        if (crosstabElements == null) {
            return;
        }
        ArrayList<Element> crosstabNodeMembers = new ArrayList<Element>();
        Element crosstabNodeMember = (Element)crosstabElements.selectSingleNode(V5X.selectImmediateChildren("crosstabNode") + V5X.subselectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember"));
        if (crosstabNodeMember != null && !(queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), this.getV5Query().findItem(crosstabNodeMember.attributeValue("refDataItem")))).confirmIsNumeric()) {
            crosstabNodeMembers.add(crosstabNodeMember);
        }
        Element crosstabNestedNodes = (Element)crosstabElements.selectSingleNode(V5X.selectImmediateChildren("crosstabNode") + V5X.subselectImmediateChildren("crosstabNestedNodes"));
        while (crosstabNestedNodes != null && (crosstabNode = (Element)crosstabNestedNodes.selectSingleNode(V5X.selectImmediateChildren("crosstabNode"))) != null) {
            crosstabNodeMember = (Element)crosstabNode.selectSingleNode(V5X.selectPath("//V5X//CHILD", "crosstabNodeMembers", "//V5X//CHILD", "crosstabNodeMember"));
            V5QueryItem queryItem2 = new V5QueryItem(this.actionEnv, this.getV5Query(), this.getV5Query().findItem(crosstabNodeMember.attributeValue("refDataItem")));
            if (!queryItem2.confirmIsNumeric()) {
                crosstabNodeMembers.add(crosstabNodeMember);
            }
            crosstabNestedNodes = (Element)crosstabNode.selectSingleNode(V5X.selectPath("//V5X//CHILD", "crosstabNestedNodes"));
        }
        Element listGroups = null;
        if (group) {
            if (crosstabNodeMembers.size() > 0) {
                listGroups = DocumentHelper.makeElement((Branch)listElement, (String)"listGroups");
            } else {
                Element listGroupElement;
                Element listGroupsElement = (Element)listElement.selectSingleNode(V5X.select("listGroups"));
                if (listGroupsElement != null && (listGroupElement = (Element)listGroupsElement.selectSingleNode(V5X.select("listGroup"))) == null) {
                    listGroupsElement.detach();
                }
            }
        }
        for (int i = 0; i < crosstabNodeMembers.size(); ++i) {
            Element listGroup;
            Element currentCrosstabNodeMember = (Element)crosstabNodeMembers.get(i);
            this.createListColumnFromCrosstabNodeMember(listElement, currentCrosstabNodeMember, group, dataItemsList);
            if (!group || (listGroup = listGroups.addElement("listGroup")) == null) continue;
            listGroup.addAttribute("refDataItem", currentCrosstabNodeMember.attributeValue("refDataItem"));
        }
        Element listGroupsElement = (Element)listElement.selectSingleNode(V5X.select("listGroups"));
        if (listGroupsElement != null && listGroupsElement.nodeCount() == 0) {
            listGroupsElement.detach();
        }
    }

    private void updateListFromMeasureNodes(Element listElement, List<Element> measureNodes, List<Element> dataItemsList) {
        Element crosstabCorner;
        if (measureNodes == null) {
            return;
        }
        Element defaultMeasure = (Element)this.getContainerElement().selectSingleNode(V5X.select("defaultMeasure"));
        if (defaultMeasure == null && (crosstabCorner = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabCorner"))) != null) {
            defaultMeasure = (Element)crosstabCorner.selectSingleNode(V5X.selectByAttr("refDataItem"));
        }
        if (defaultMeasure != null) {
            this.createListColumnFromCrosstabNodeMember(listElement, defaultMeasure, false, dataItemsList);
        }
        int measureNodesSize = measureNodes.size();
        for (int i = 0; i < measureNodesSize; ++i) {
            Element currentMeasureNode = measureNodes.get(i);
            if (defaultMeasure == null) {
                this.createListColumnFromCrosstabNodeMember(listElement, currentMeasureNode, false, dataItemsList);
                continue;
            }
            if (defaultMeasure.attributeValue("refDataItem").equals(currentMeasureNode.attributeValue("refDataItem"))) continue;
            this.createListColumnFromCrosstabNodeMember(listElement, currentMeasureNode, false, dataItemsList);
        }
    }

    public void createListColumnFromCrosstabNodeMember(Element listElement, Element crosstabNodeMember, boolean grouped, List<Element> dataItemsList) {
        Element xmlAttributes;
        if (crosstabNodeMember == null) {
            return;
        }
        Element dataItem = this.getV5Query().findItem(crosstabNodeMember.attributeValue("refDataItem")).createCopy();
        dataItemsList.add(dataItem);
        Element listColumns = (Element)listElement.selectSingleNode(V5X.select("listColumns"));
        if (listColumns == null) {
            return;
        }
        Element listColumn = listColumns.addElement("listColumn");
        Element listColumnTitle = listColumn.addElement("listColumnTitle");
        Element listColumnTitleStyle = listColumnTitle.addElement("style").addElement("defaultStyles").addElement("defaultStyle");
        listColumnTitleStyle.addAttribute("refStyle", "lt");
        Element textItemOfList = listColumnTitle.addElement("contents").addElement("textItem");
        Element dataItemLabel = textItemOfList.addElement("dataSource").addElement("dataItemLabel");
        dataItemLabel.addAttribute("refDataItem", crosstabNodeMember.attributeValue("refDataItem"));
        Element textItem = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "contents", "textItem");
        if (textItem != null) {
            for (Element child : textItem.elements()) {
                if (child.getName().equals("dataSource")) continue;
                textItemOfList.add(child.createCopy());
            }
        }
        if ((xmlAttributes = crosstabNodeMember.element("XMLAttributes")) != null) {
            listColumnTitle.add(xmlAttributes.createCopy());
        }
        Element listColumnBody = listColumn.addElement("listColumnBody");
        Element listColumnBodyStyle = listColumnBody.addElement("style").addElement("defaultStyles").addElement("defaultStyle");
        listColumnBodyStyle.addAttribute("refStyle", "lc");
        Element listColumnBodyContents = listColumnBody.addElement("contents").addElement("textItem").addElement("dataSource").addElement("dataItemValue");
        listColumnBodyContents.addAttribute("refDataItem", crosstabNodeMember.attributeValue("refDataItem"));
        if ("defaultMeasure".equals(crosstabNodeMember.getName())) {
            Element style;
            Element dataFormat = V5X.selectSingleNode(crosstabNodeMember.getParent(), "//V5X//CHILD", "crosstabFactCell", "style", "dataFormat");
            if (dataFormat == null) {
                Element matchingCrosstabNodeMember = this.selectSingleNode("crosstabNodeMember", "//V5X//ATTR", "refDataItem", crosstabNodeMember.attributeValue("refDataItem"));
                if (matchingCrosstabNodeMember != null) {
                    dataFormat = V5X.selectSingleNode(matchingCrosstabNodeMember, "//V5X//CHILD", "factCell", "style", "dataFormat");
                } else if (this._container.element("crosstabColumns") == null || this._container.element("crosstabRows") == null) {
                    dataFormat = this.selectSingleNode("crosstabNodeMember", "//V5X//CHILD", "factCell", "style", "dataFormat");
                }
            }
            if (dataFormat != null && (style = DocumentHelper.makeElement((Branch)listColumn, (String)V5X.getMakeElementPath("listColumnBody", "style"))) != null) {
                style.add((Element)dataFormat.clone());
            }
        } else {
            Element dataFormatOfFactCellOfCrosstabNodeMember;
            Element dataFormatOfCrosstabNodeMember = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "style", "dataFormat");
            if (dataFormatOfCrosstabNodeMember != null) {
                Element style = DocumentHelper.makeElement((Branch)listColumn, (String)"style");
                style.add((Element)dataFormatOfCrosstabNodeMember.clone());
            }
            if ((dataFormatOfFactCellOfCrosstabNodeMember = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "factCell", "style", "dataFormat")) != null) {
                Element style = DocumentHelper.makeElement((Branch)listColumn, (String)V5X.getMakeElementPath("listColumnBody", "style"));
                style.add((Element)dataFormatOfFactCellOfCrosstabNodeMember.clone());
            }
        }
        if (grouped) {
            Element listColumnRowSpan = listColumnBody.addElement("listColumnRowSpan");
            listColumnRowSpan.addAttribute("refDataItem", crosstabNodeMember.attributeValue("refDataItem"));
        }
    }

    public int getNumberOfMeasuresForChangeDisplayType(ActionEnv env) throws ActionException {
        this.setActionEnv(env);
        this.removeUnionNodesOnNestedEdges();
        this.removeAggregateEdges();
        this.removeSetParentNode(env.getRAPReport());
        Element columns = this.getContainerElement().element("crosstabColumns");
        Element rows = this.getContainerElement().element("crosstabRows");
        Element columnEdge = V5SpecHelper.getInnerMostNestedCrosstabNodes(columns);
        Element rowEdge = V5SpecHelper.getInnerMostNestedCrosstabNodes(rows);
        columnEdge = columnEdge == null ? columns : columnEdge;
        rowEdge = rowEdge == null ? rows : rowEdge;
        int numberOfMeasures = this.getContainedMeasure(columnEdge).size();
        numberOfMeasures += this.getContainedMeasure(rowEdge).size();
        if (this.getDefaultMeasure() != null) {
            ++numberOfMeasures;
        }
        return numberOfMeasures;
    }

    private void populateChartEdgeFromCrosstabEdge(Element crosstabRoot, Element chartRoot) throws ActionException {
        List crosstabNodeElements = XMLUtility.selectNodes(crosstabRoot, V5X.selectImmediateChildren("crosstabNode"));
        for (Element crosstabNode : crosstabNodeElements) {
            Element crosstabNestedNodes;
            List crosstabNodeMemberElments = XMLUtility.selectNodes(crosstabNode, V5X.selectImmediateChildren("crosstabNodeMembers") + V5X.subselectImmediateChildren("crosstabNodeMember"));
            Element chartNode = null;
            if (crosstabNodeMemberElments.size() > 0) {
                chartNode = this.createChartNodeFromCrosstabNode(crosstabNodeMemberElments, chartRoot);
            }
            if ((crosstabNestedNodes = (Element)crosstabNode.selectSingleNode(V5X.selectImmediateChildren("crosstabNestedNodes"))) == null || chartNode == null) continue;
            Element nestedNode = (Element)crosstabNestedNodes.selectSingleNode(V5X.select("crosstabNode"));
            Element chartNestedNodes = DocumentHelper.makeElement((Branch)chartNode, (String)"chartNestedNodes");
            this.populateChartEdgeFromCrosstabEdge(crosstabNestedNodes, chartNestedNodes);
            if (chartNestedNodes.elements().size() != 0) continue;
            chartNestedNodes.detach();
        }
    }

    private Element createChartNodeFromCrosstabNode(List<Element> crosstabNodeMemberElments, Element chartRoot) {
        Element chartNode = chartRoot.addElement("chartNode");
        Element chartNodeMembers = chartNode.addElement("chartNodeMembers");
        for (Element crosstabNodeMember : crosstabNodeMemberElments) {
            V5Crosstab.createChartNodeMemberFromCrosstabNodeMember(crosstabNodeMember, chartNodeMembers);
        }
        return chartNode;
    }

    private static void createChartNodeMemberFromCrosstabNodeMember(Element crosstabNodeMember, Element chartNodeMembers) {
        Element xmlAttributes;
        Element chartNodeMember = chartNodeMembers.addElement("chartNodeMember");
        chartNodeMember.addAttribute("refDataItem", crosstabNodeMember.attributeValue("refDataItem"));
        List textItems = V5X.selectNodes(crosstabNodeMember, "//V5X//CHILD", "contents", "textItem");
        Element chartContents = DocumentHelper.makeElement((Branch)chartNodeMember, (String)"chartContents");
        for (Element textItem : textItems) {
            Attribute displayForOrientationAttr;
            Attribute useDetailValueAttr = textItem.attribute("useDetailValue");
            if (useDetailValueAttr != null) {
                textItem.remove(useDetailValueAttr);
            }
            if ((displayForOrientationAttr = textItem.attribute("displayForOrientation")) != null) {
                textItem.remove(displayForOrientationAttr);
            }
            chartContents.add(textItem.createCopy(new QName("chartTextItem", crosstabNodeMember.getNamespace())));
        }
        XMLUtility.cloneChildNode(chartNodeMember, crosstabNodeMember, "sortList");
        XMLUtility.cloneChildNode(chartNodeMember, crosstabNodeMember, "propertyList");
        Element dataFormatOfCrosstabNodeMember = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "style", "dataFormat");
        Element dataFormatOfFactCellOfCrosstabNodeMember = V5X.selectSingleNode(crosstabNodeMember, "//V5X//CHILD", "factCell", "style", "dataFormat");
        Element dataFormat = null;
        if (dataFormatOfFactCellOfCrosstabNodeMember != null) {
            dataFormat = (Element)dataFormatOfFactCellOfCrosstabNodeMember.clone();
        } else if (dataFormatOfCrosstabNodeMember != null) {
            dataFormat = (Element)dataFormatOfCrosstabNodeMember.clone();
        }
        if (dataFormat != null) {
            Element style = DocumentHelper.makeElement((Branch)chartNodeMember, (String)"style");
            style.add(dataFormat);
        }
        if ((xmlAttributes = crosstabNodeMember.element("XMLAttributes")) != null) {
            chartNodeMember.add(xmlAttributes.createCopy());
        }
    }

    private void copySuppressionToChart(Element chartElement, boolean axesSwapped) {
        Element crosstabSuppress = this.getContainerElement().element("crosstabSuppress");
        if (crosstabSuppress == null) {
            return;
        }
        Element chartSuppress = (Element)crosstabSuppress.clone();
        chartSuppress.setQName(new QName("chartSuppress", chartElement.getNamespace()));
        chartElement.add(chartSuppress);
        String type = crosstabSuppress.attributeValue("type");
        if ("rowsAndColumns".equals(type)) {
            type = "categoriesAndSeries";
        } else if ("rows".equals(type)) {
            type = axesSwapped ? "categories" : "series";
        } else if ("columns".equals(type)) {
            type = axesSwapped ? "series" : "categories";
        }
        chartSuppress.addAttribute("type", type);
    }

    private void copySuppressionToList(Element listElement) {
        Element crosstabSuppress = (Element)this.getContainerElement().selectSingleNode(V5X.select("crosstabSuppress"));
        if (crosstabSuppress == null) {
            return;
        }
        Element listSuppress = (Element)crosstabSuppress.clone();
        listSuppress.setQName(new QName("listSuppress", crosstabSuppress.getNamespace()));
        listSuppress.remove(listSuppress.attribute("type"));
        listElement.add(listSuppress);
    }

    @Override
    public void setNoDataHandler(String localeValue) {
        Element conditionalDataSource;
        String localeVariableName = "locale";
        localeValue = localeValue == null || localeValue.length() == 0 ? "en" : localeValue;
        Element noDataHandler = this.getContainerElement().element("noDataHandler");
        Element textItem = null;
        if (noDataHandler == null) {
            textItem = DocumentHelper.makeElement((Branch)this.getContainerElement(), (String)"noDataHandler/contents/block/contents/textItem");
            textItem.addAttribute("name", "RAP_NDH_" + this._container.attributeValue("name"));
            Element staticValue = DocumentHelper.makeElement((Branch)textItem, (String)"dataSource/staticValue");
            staticValue.setText(RAPMessageManager.convert("NO_DATA_MESSAGE", localeValue));
            noDataHandler = this.getContainerElement().element("noDataHandler");
        }
        if ((textItem = V5X.selectSingleNode(noDataHandler, "textItem", "//V5X//ATTR", "name", "RAP_NDH_" + this._container.attributeValue("name"))) != null && (conditionalDataSource = V5X.selectSingleNode(textItem, "conditionalDataSource", "//V5X//ATTR", "refVariableValue", localeValue)) == null) {
            V5Variables v5Variables = new V5Variables(this.getContainerElement().getDocument().getRootElement());
            Element eLocale = v5Variables.addLocaleVariable(localeVariableName);
            v5Variables.addVariableValue(eLocale, localeValue);
            String message = RAPMessageManager.convert("NO_DATA_MESSAGE", localeValue);
            V5Style v5Style = new V5Style();
            v5Style.setConditionalText(textItem, localeVariableName, localeValue, message);
        }
        this.encloseNoDataHandlerWithTaggedBlock();
    }

    @Override
    public void delete(SelectedCell selectedCell) {
        Element itemToDelete = this.findSelectedNodeMember(selectedCell);
        if (itemToDelete != null) {
            List<String> aggregates = this.findAggregatesOfItem(itemToDelete.attributeValue("refDataItem"));
            this.deleteCrosstabNodeMember(itemToDelete);
            if (aggregates != null) {
                for (String aggregate : aggregates) {
                    Element aggregateElement = this.findItem(aggregate);
                    this.deleteCrosstabNodeMember(aggregateElement);
                }
            }
        }
    }

    public void deleteCrosstabNodeMember(Element itemToDelete) {
        if (itemToDelete != null) {
            Element crosstabFactCell;
            String rdi = itemToDelete.attributeValue("refDataItem");
            Element crosstabNode = V5SpecHelper.getAncestor(itemToDelete, "crosstabNode");
            Element parentOfItemToDelete = itemToDelete.getParent();
            itemToDelete.detach();
            while (parentOfItemToDelete.elements().size() == 0) {
                itemToDelete = parentOfItemToDelete;
                parentOfItemToDelete = parentOfItemToDelete.getParent();
                itemToDelete.detach();
            }
            this.promoteNestedCrosstabNodes(crosstabNode);
            V5SpecHelper.removeContainedMasterDetail(this._container, rdi);
            if (!this.shouldKeepCrosstabFactCell() && (crosstabFactCell = this._container.element("crosstabFactCell")) != null) {
                crosstabFactCell.detach();
            }
        }
    }

    private boolean shouldKeepCrosstabFactCell() {
        if (this._container.element("defaultMeasure") != null) {
            return true;
        }
        return this._container.element("crosstabRows") != null && this._container.element("crosstabColumns") != null;
    }

    public List<String> findAggregatesOfItem(String itemName) {
        ArrayList<String> aggregatesList = null;
        Element itemToRemove = this.findItem(itemName);
        Element parentCrosstabNode = V5SpecHelper.getAncestor(itemToRemove, "crosstabNode");
        Element crosstabNodeContainer = parentCrosstabNode.getParent();
        if (crosstabNodeContainer != null) {
            for (Element crosstabNode : crosstabNodeContainer.elements("crosstabNode")) {
                List crosstabNodeMembers = V5X.selectNodes(crosstabNode, "//V5X//CHILD", "crosstabNodeMembers", "crosstabNodeMember");
                for (Element crosstabNodeMember : crosstabNodeMembers) {
                    String otherItemName;
                    V5Query v5Query = this.getV5Query();
                    V5QueryItem qi = new V5QueryItem(this.actionEnv, v5Query, v5Query.findItem(otherItemName = crosstabNodeMember.attributeValue("refDataItem")));
                    if (!qi.isKnownAggregateForm(itemName)) continue;
                    if (aggregatesList == null) {
                        aggregatesList = new ArrayList<String>();
                    }
                    aggregatesList.add(otherItemName);
                }
            }
        }
        return aggregatesList;
    }

    private void promoteNestedCrosstabNodes(Element crosstabNodeWithNestedNodes) {
        Element crosstabNestedNodesElement = crosstabNodeWithNestedNodes.element("crosstabNestedNodes");
        if (!"crosstabNode".equals(crosstabNodeWithNestedNodes.getName()) || crosstabNestedNodesElement == null) {
            return;
        }
        Element originalNodeListContainer = crosstabNodeWithNestedNodes.getParent();
        Element parentOfNodeListContainer = originalNodeListContainer.getParent();
        Element finalNodeListContainer = V5SpecHelper.shallowCopy(originalNodeListContainer);
        List originalNodeList = originalNodeListContainer.elements();
        for (Element node : originalNodeList) {
            if (node == crosstabNodeWithNestedNodes) {
                List nodesInNestedNodes = crosstabNestedNodesElement.elements("crosstabNode");
                for (Element nestedNode : nodesInNestedNodes) {
                    finalNodeListContainer.add((Element)nestedNode.clone());
                }
                continue;
            }
            finalNodeListContainer.add((Element)node.clone());
        }
        originalNodeListContainer.detach();
        parentOfNodeListContainer.add(finalNodeListContainer);
    }

    private void removeDrillThroughFromCrosstab() {
        List reportDrillsNodes = V5X.selectNodes(this.getContainerElement(), "reportDrills");
        if (reportDrillsNodes == null) {
            return;
        }
        for (Element reportDrills : reportDrillsNodes) {
            reportDrills.detach();
        }
    }

    public void swapEdges() {
        Element eRows = V5X.selectSingleNode(this._container, "//V5X//CHILD", "crosstabRows");
        Element eColumns = V5X.selectSingleNode(this._container, "//V5X//CHILD", "crosstabColumns");
        List elRowContents = null;
        List elColumnContents = null;
        String sXPath = "";
        if (eRows != null) {
            sXPath = "./*[local-name()='crosstabRows']/*";
            elRowContents = this._container.selectNodes(sXPath);
        }
        if (eColumns != null) {
            sXPath = "./*[local-name()='crosstabColumns']/*";
            elColumnContents = this._container.selectNodes(sXPath);
        }
        sXPath = "./*[local-name()='crosstabRows' or local-name()='crosstabColumns']";
        V5SpecHelper.removeNodes(this._container, sXPath);
        if (elRowContents != null) {
            eColumns = DocumentHelper.makeElement((Branch)this._container, (String)"crosstabColumns");
            eColumns.setContent(elRowContents);
        }
        if (elColumnContents != null) {
            eRows = DocumentHelper.makeElement((Branch)this._container, (String)"crosstabRows");
            eRows.setContent(elColumnContents);
        }
        String sXPathRowNodeStyle = "./*[local-name()='crosstabRowNodeStyle']/*";
        List elRowStyleContents = XMLUtility.selectNodes(this._container, sXPathRowNodeStyle);
        String sXPathColumnNodeStyle = "./*[local-name()='crosstabColumnNodeStyle']/*";
        List elColumnStyleContents = XMLUtility.selectNodes(this._container, sXPathColumnNodeStyle);
        if (elRowStyleContents.size() > 0) {
            Element eColStyle = DocumentHelper.makeElement((Branch)this._container, (String)"crosstabColumnNodeStyle");
            for (Element e : elRowStyleContents) {
                eColStyle.add(e.detach());
            }
        }
        if (elColumnStyleContents.size() > 0) {
            Element eRowStyle = DocumentHelper.makeElement((Branch)this._container, (String)"crosstabRowNodeStyle");
            for (Element e : elColumnStyleContents) {
                eRowStyle.add(e.detach());
            }
        }
        sXPath = ".//*[local-name()='crosstabFactCell' or local-name()='crosstabCorner' or local-name()='crosstabIntersection' or local-name()='factCell' or local-name()='crosstabNodeMember'or local-name()='crosstabColumnNodeStyle' or local-name()='crosstabRowNodeStyle']";
        List elNodesToSwapStyles = XMLUtility.selectNodes(this._container, sXPath);
        this.swapStyles(elNodesToSwapStyles);
        ArrayList<Element> elCrosstabNode = new ArrayList<Element>();
        elCrosstabNode.add(this._container);
        this.swapStyles(elCrosstabNode);
        List elCrosstabIntersectionNodes = V5X.selectNodes(this._container, "crosstabIntersection");
        for (Element node : elCrosstabIntersectionNodes) {
            String sRow = node.attributeValue("row");
            node.addAttribute("row", node.attributeValue("column"));
            node.addAttribute("column", sRow);
        }
    }

    private void swapStyles(List<Element> elNodesToSwapStyles) {
        for (Element eNode : elNodesToSwapStyles) {
            String cssString;
            Element cssElement;
            Element eStyleNode = V5X.selectSingleNode(eNode, "//V5X//CHILD", "style");
            if (eStyleNode == null || (cssElement = V5X.selectSingleNode(eStyleNode, "//V5X//CHILD", "CSS")) == null || !(cssString = cssElement.attributeValue("value")).contains("padding") && !cssString.contains("border")) continue;
            CSSDefinition cssDefinition = new CSSDefinition(cssElement);
            String sPaddingLeft = cssDefinition.getProperty("padding-left");
            String sPaddingRight = cssDefinition.getProperty("padding-right");
            String sPaddingTop = cssDefinition.getProperty("padding-top");
            String sPaddingBottom = cssDefinition.getProperty("padding-bottom");
            cssDefinition.setProperty("padding-top", sPaddingLeft);
            cssDefinition.setProperty("padding-left", sPaddingTop);
            cssDefinition.setProperty("padding-bottom", sPaddingRight);
            cssDefinition.setProperty("padding-right", sPaddingBottom);
            String[] aBorderLeftStyles = this.getBorderStyles(cssDefinition, "left");
            String[] aBorderTopStyles = this.getBorderStyles(cssDefinition, "top");
            String[] aBorderBottomStyles = this.getBorderStyles(cssDefinition, "bottom");
            String[] aBorderRightStyles = this.getBorderStyles(cssDefinition, "right");
            this.updateBorderStyles(cssDefinition, "top", aBorderLeftStyles);
            this.updateBorderStyles(cssDefinition, "left", aBorderTopStyles);
            this.updateBorderStyles(cssDefinition, "bottom", aBorderRightStyles);
            this.updateBorderStyles(cssDefinition, "right", aBorderBottomStyles);
            cssElement.addAttribute("value", cssDefinition.toString());
        }
    }

    private void updateBorderStyles(CSSDefinition cssDef, String side, String[] aBorderValues) {
        cssDef.setProperty("border-" + side + "-color", aBorderValues[0]);
        cssDef.setProperty("border-" + side + "-style", aBorderValues[1]);
        cssDef.setProperty("border-" + side + "-width", aBorderValues[2]);
    }

    private String[] getBorderStyles(CSSDefinition cssDef, String side) {
        String[] aBorderStyles = new String[]{cssDef.getProperty("border-" + side + "-color"), cssDef.getProperty("border-" + side + "-style"), cssDef.getProperty("border-" + side + "-width")};
        return aBorderStyles;
    }

    private boolean isANSMeasureSet(Element measureCrosstabNodeMemberElement) {
        if ("defaultMeasure".equals(measureCrosstabNodeMemberElement.getName())) {
            return false;
        }
        return V5DrillUpDownWithBehaviors.getRootMemberSet(measureCrosstabNodeMemberElement.getDocument().getRootElement(), this.getRefQuery(), measureCrosstabNodeMemberElement.attributeValue("refDataItem")) != null;
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element crosstabNodeMember, String startNodeHUN) throws ActionException {
        Element parentNodeMember;
        if (this._nestedLocationWithSameHUN != null) {
            return this._nestedLocationWithSameHUN;
        }
        this._nestedLocationWithSameHUN = new ArrayList<Element>();
        Element crosstabNode = V5SpecHelper.getAncestor(crosstabNodeMember, "crosstabNode");
        Element crosstabNestedNodeOrAxis = V5SpecHelper.getInnerMostNestedCrosstabNodes(crosstabNode);
        if (crosstabNestedNodeOrAxis != null) {
            Element tempCrosstabNode = V5X.selectSingleNode(crosstabNestedNodeOrAxis, "//V5X//CHILD", "crosstabNode", "crosstabNodeMembers", "crosstabNodeMember");
            if (tempCrosstabNode != null && this.hasSameHUN(v5Query, tempCrosstabNode, startNodeHUN)) {
                this._nestedLocationWithSameHUN.add(tempCrosstabNode);
            }
        } else {
            this._nestedLocationWithSameHUN.add(crosstabNodeMember);
            crosstabNestedNodeOrAxis = V5SpecHelper.getAncestor(crosstabNodeMember, "crosstabNode").getParent();
        }
        while ("crosstabNestedNodes".equals(crosstabNestedNodeOrAxis.getName()) && (parentNodeMember = V5X.selectSingleNode(crosstabNestedNodeOrAxis.getParent(), "//V5X//CHILD", "crosstabNodeMembers", "crosstabNodeMember")) != null) {
            if (!this.hasSameHUN(v5Query, parentNodeMember, startNodeHUN)) {
                crosstabNestedNodeOrAxis = V5SpecHelper.getAncestor(parentNodeMember, "crosstabNode").getParent();
                continue;
            }
            this._nestedLocationWithSameHUN.add(parentNodeMember);
            crosstabNestedNodeOrAxis = V5SpecHelper.getAncestor(parentNodeMember, "crosstabNode").getParent();
        }
        return this._nestedLocationWithSameHUN;
    }

    private boolean hasSameHUN(V5Query v5Query, Element crosstabNode, String sHUN) {
        V5QueryItem queryItem = new V5QueryItem(this.actionEnv, v5Query, v5Query.findItem(crosstabNode.attributeValue("refDataItem")));
        return queryItem.getProperties()._hun != null && sHUN.equals(queryItem.getProperties()._hun);
    }

    public static class Depth {
        public int nestDepth;
        public int matchDepth;

        public Depth(int nestDepth, int matchDepth) {
            this.nestDepth = nestDepth;
            this.matchDepth = matchDepth;
        }
    }
}

