/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Variables;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class V5DataContainer {
    public static final String RAP_LAYOUT_TAG = "rap_layout_tag";
    public static final String NO_DATA_ITEM_COLUMN = "no_data_item_column";
    public static final String DEFAULT_NAME_PREFIX = "unnamed";
    protected Element _container = null;
    private V5Query _v5Query = null;
    protected containerTypeID _typeID = containerTypeID.unknown;
    protected ActionEnv _env = null;
    public static final String NO_DATA_MESSAGE = "NO_DATA_MESSAGE";
    public static final String NO_DATA_HANDLER_LAYOUT_ELEMENT_NAME_PREFIX = "RAP_NDH_";

    public void setActionEnv(ActionEnv env) {
        this._env = env;
    }

    public ActionEnv getActionEnv() {
        return this._env;
    }

    public void focusFirstDomain() {
    }

    public boolean focusNextDomain() {
        return false;
    }

    public boolean hasNextDomain() {
        return false;
    }

    public Element getContainerElement() {
        return this._container;
    }

    public String getID() {
        return this._container.attributeValue("name");
    }

    public void setID(String newName) {
        String oldName = this.getID();
        if (oldName != null && oldName.equals(newName)) {
            return;
        }
        Element taggedElement = (Element)this.getContainerElement().selectSingleNode(".//*[starts-with(@name, 'RAP_NDH_')]");
        if (taggedElement != null) {
            taggedElement.addAttribute("name", NO_DATA_HANDLER_LAYOUT_ELEMENT_NAME_PREFIX + newName);
        }
        this._container.addAttribute("name", newName);
    }

    public String getType() {
        return this._container.getName();
    }

    public String getTypeID() {
        return this._container.getName();
    }

    public String getRDIName(Element nodeMember) {
        return nodeMember.attributeValue("refDataItem");
    }

    public void addSortList(String columnName, String sortOrder) {
    }

    public void addSortList(String columnName, String sortedDataItemName, String sortOrder) {
        this.addSortList(columnName, sortOrder);
    }

    public void removeSortList(String columnName) throws ActionException {
    }

    public void removeSortByLabel(String columnName) throws ActionException {
        Element setSorting;
        this.removeSortList(columnName);
        Element dataItem = this.getV5Query().findItem(columnName);
        if (dataItem != null && (setSorting = dataItem.element("setSorting")) != null && setSorting.elements().size() == 0) {
            setSorting.detach();
        }
    }

    public Element findItem(String refDataItem) {
        return null;
    }

    public Element getDefaultMeasure() {
        return null;
    }

    public Element findItemLabelByRDI(String dataItemName) {
        return null;
    }

    public Element findItemLabel(Element parentNodeMemberOrListColumn) {
        return null;
    }

    public Element findItemLabelByLayoutTag(String tag) {
        return null;
    }

    public Element findListGroup(String rdiName) {
        return null;
    }

    public String getBestItemLabel(String rdiName, ActionEnv env) throws ActionException {
        return this.getBestItemLabel(rdiName, env, false);
    }

    public String getBestItemLabel(String rdiName, ActionEnv env, boolean requestLocalizedLabelsIfNeeded) throws ActionException {
        return this.getBestItemLabel(null, rdiName, env, requestLocalizedLabelsIfNeeded);
    }

    public String getBestItemLabel(Element collectedParent, String rdiName, ActionEnv env, boolean requestLocalizedLabelsIfNeeded) throws ActionException {
        Element overrideDefaultText;
        V5Variables variables;
        Element labelNode;
        String label = null;
        Element element = labelNode = collectedParent != null ? this.findItemLabel(collectedParent) : this.findItemLabelByRDI(rdiName);
        if (labelNode != null && (label = this.getRenamedStaticValue(variables = new V5Variables(this._container.getDocument().getRootElement()), labelNode, env.getLocale())) == null && (overrideDefaultText = V5X.selectSingleNode(labelNode, "dataSource", "staticValue")) != null) {
            label = overrideDefaultText.getText();
        }
        if (label == null && this.getV5Query() != null) {
            label = this.getV5Query().getBestItemLabel(rdiName, env, requestLocalizedLabelsIfNeeded);
        }
        if (label == null) {
            label = rdiName;
        }
        return label;
    }

    public String getRenamedStaticValue(V5Variables variables, String rdiName, String locale) {
        return this.getRenamedStaticValue(variables, this.findItemLabelByRDI(rdiName), locale);
    }

    public String getRenamedStaticValue(V5Variables variables, Element labelNode, String locale) {
        List<String> localeVariables = variables.findLocaleVariables();
        String label = null;
        if (labelNode != null && localeVariables != null) {
            for (String localeVariableName : localeVariables) {
                Element localeStaticText = V5X.selectSingleNode(labelNode, "conditionalDataSources", "//V5X//ATTR", "refVariable", localeVariableName, "conditionalDataSource", "//V5X//ATTR", "refVariableValue", locale, "staticValue");
                if (localeStaticText == null) {
                    localeStaticText = V5X.selectSingleNode(labelNode, "conditionalDataSources", "//V5X//ATTR", "refVariable", localeVariableName, "conditionalDataSource", "//V5X//ATTR", "refVariableValue", locale.substring(0, 2), "staticValue");
                }
                if (localeStaticText == null) continue;
                label = localeStaticText.getText();
                break;
            }
        }
        return label;
    }

    public void tagSortedLayoutItems() {
    }

    public static void cloneAttribute(Element sourceNode, String attrName, Element targetNode) {
        Attribute attr = sourceNode.attribute(attrName);
        if (attr != null) {
            targetNode.addAttribute(attrName, attr.getValue());
        }
    }

    public static void cloneChild(Element sourceNode, String childNodeName, Element targetNode) {
        Element clonedChild = null;
        if (sourceNode.element(childNodeName) != null) {
            clonedChild = (Element)sourceNode.element(childNodeName).clone();
            targetNode.add(clonedChild);
        }
    }

    protected static int insertLayoutElementAfter(Element insertionPoint, Element newLayoutElement) {
        int nInsertionIndex = -1;
        if (insertionPoint != null && newLayoutElement != null) {
            Element insertionParent = insertionPoint.getParent();
            List nodes = insertionParent.elements();
            ListIterator iterator = nodes.listIterator();
            while (iterator.hasNext()) {
                Element listNode = (Element)iterator.next();
                insertionParent.remove(listNode);
            }
            int nCurrentListIndex = 0;
            nInsertionIndex = 0;
            iterator = nodes.listIterator();
            while (iterator.hasNext()) {
                Element listNode = (Element)iterator.next();
                insertionParent.add(listNode);
                ++nCurrentListIndex;
                if (listNode != insertionPoint) continue;
                insertionParent.add(newLayoutElement);
                nInsertionIndex = nCurrentListIndex;
            }
        }
        return nInsertionIndex;
    }

    protected static void insertFirstChildElement(Element insertionParent, Element newLayoutElement) {
        Element listNode;
        List nodes = insertionParent.elements();
        ListIterator iterator = nodes.listIterator();
        while (iterator.hasNext()) {
            listNode = (Element)iterator.next();
            insertionParent.remove(listNode);
        }
        insertionParent.add(newLayoutElement);
        iterator = nodes.listIterator();
        while (iterator.hasNext()) {
            listNode = (Element)iterator.next();
            insertionParent.add(listNode);
        }
    }

    public void delete(SelectedCell selectedCell) {
    }

    public Element findAxis(String refDataItem) {
        return null;
    }

    public Element findOppositeAxis(String refDataItem) {
        return null;
    }

    public String getRefQuery() {
        if (this._container != null) {
            return this._container.attributeValue("refQuery");
        }
        return null;
    }

    public V5Query getV5Query() {
        if (this._v5Query == null && this.getRefQuery() != null) {
            this._v5Query = new V5Query();
            this._v5Query.focusQuery(this.getContainerElement(), this.getRefQuery());
        }
        return this._v5Query;
    }

    public void setV5Query(V5Query query) {
        this._v5Query = query;
    }

    public boolean isLeafNode(Element node) {
        return false;
    }

    public List<Element> axisNodeMembers(Element axis) {
        return null;
    }

    public List<Element> collectNodes() {
        return null;
    }

    public List<Element> collectItemInfo() {
        return this.collectNodes();
    }

    public List<Element> collectEdgeNodes() {
        return null;
    }

    public Element changeDisplayType(ActionEnv actionEnv) throws ActionException {
        return null;
    }

    public void prepareForVisCoach(ActionEnv actionEnv) throws ActionException {
    }

    public boolean isListColumnTitleNode(Element layoutElement) {
        return false;
    }

    public Collection<Element> getLayoutSortItems() {
        List sortLists = V5X.selectNodes(this.getContainerElement(), "sortList");
        ArrayList<Element> sortItems = new ArrayList<Element>();
        for (Element sortList : sortLists) {
            sortItems.addAll(sortList.elements());
        }
        return sortItems;
    }

    public void replaceRDIOfSortItem(String oldRDI, String newRDI) {
        List sortItemElements = V5X.selectNodes(this._container, "sortList", "sortItem", "//V5X//ATTR", "refDataItem", oldRDI);
        for (Element sortItem : sortItemElements) {
            sortItem.addAttribute("refDataItem", newRDI);
        }
    }

    public void encloseNoDataHandlerWithTaggedBlock() {
        Element noDataHandler = this.getContainerElement().element("noDataHandler");
        if (noDataHandler != null) {
            Element contents = noDataHandler.element("contents");
            Element taggedElement = V5X.selectSingleNode(noDataHandler, "//V5X//ANYCHILD", "//V5X//ATTR", "name", NO_DATA_HANDLER_LAYOUT_ELEMENT_NAME_PREFIX + this.getID());
            if (taggedElement != null) {
                return;
            }
            List children = contents.elements();
            Element block = contents.addElement("block");
            block.addAttribute("name", NO_DATA_HANDLER_LAYOUT_ELEMENT_NAME_PREFIX + this.getID());
            Element blockContents = block.addElement("contents");
            for (Element child : children) {
                child.detach();
                blockContents.add(child);
            }
        }
    }

    public void setNoDataHandler(String localeValue) {
        this.encloseNoDataHandlerWithTaggedBlock();
    }

    public List<Element> getCellStyles(Element layoutItem) {
        ArrayList<Element> styleNodes = new ArrayList<Element>();
        styleNodes.addAll(V5X.selectNodes(layoutItem, "style"));
        return styleNodes;
    }

    public boolean ifCanConvertToList() {
        if ("list".equals(this._container.getName())) {
            return true;
        }
        for (Element dataItem : this.getV5Query().getItemList().getDataItemElements()) {
            if (!"dataItem".equals(dataItem.getName()) || !dataItem.element("expression").getText().contains("currentMember")) continue;
            return false;
        }
        return true;
    }

    public void tagLayoutItems(boolean preserveTags) {
    }

    public Element findBestRDINode(Element rootNode, String locale) {
        V5Variables variables = new V5Variables(rootNode.getDocument().getRootElement());
        List<String> localeVariables = variables.findLocaleVariables();
        if (localeVariables != null) {
            for (String localeVariableName : localeVariables) {
                List rdiNodesForLocale = V5X.selectNodes(rootNode, "conditionalDataSources", "//V5X//ATTR", "refVariable", localeVariableName, "conditionalDataSource", "//V5X//ATTR", "refVariableValue", locale, "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refDataItem");
                for (Element rdiNodeForLocale : rdiNodesForLocale) {
                    if (V5SpecHelper.findParentContainer(rdiNodeForLocale) != this._container) continue;
                    return rdiNodeForLocale;
                }
            }
        }
        List rdiNodes = V5X.selectNodes(rootNode, "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refDataItem");
        for (Element rdiNode : rdiNodes) {
            if (V5SpecHelper.findParentContainer(rdiNode) != this._container) continue;
            return rdiNode;
        }
        return null;
    }

    public V5DataContainer selectContainerForChangeDisplayType() {
        return this;
    }

    public Element selectSingleNode(String ... pathElements) {
        return V5DataContainer.selectSingleNode(this._container, pathElements);
    }

    public static Element selectSingleNode(Element dataContainer, String ... pathElements) {
        return V5DataContainer.selectSingleNode(dataContainer, dataContainer, pathElements);
    }

    public static Element selectSingleNode(Element dataContainer, Element startElement, String ... pathElements) {
        List allMatches = V5X.selectNodes(startElement, pathElements);
        for (Element match : allMatches) {
            if (V5SpecHelper.findParentContainer(match) != dataContainer) continue;
            return match;
        }
        return null;
    }

    public List<Element> selectNodes(String ... pathElements) {
        return V5DataContainer.selectNodes(this._container, this._container, pathElements);
    }

    public List<Element> selectNodesInCurrentDomain(String ... pathElements) {
        return V5DataContainer.selectNodes(this._container, this._container, pathElements);
    }

    public static List<Element> selectNodes(Element dataContainer, String ... pathElements) {
        return V5DataContainer.selectNodes(dataContainer, dataContainer, pathElements);
    }

    public static List<Element> selectNodes(Element dataContainer, Element startElement, String ... pathElements) {
        List allMatches = V5X.selectNodes(startElement, pathElements);
        Iterator ite = allMatches.iterator();
        while (ite.hasNext()) {
            Element match = (Element)ite.next();
            if (dataContainer == V5SpecHelper.findParentContainer(match)) continue;
            ite.remove();
        }
        return allMatches;
    }

    public abstract List<Element> getNestedLocationWithSameHUN(V5Query var1, Element var2, String var3) throws ActionException;

    public List<Element> findPotentialChartSummaryNodes(Element layoutElement, String itemName) {
        return null;
    }

    public static enum containerTypeID {
        unknown,
        list,
        chart,
        crosstab,
        singleton,
        mapChart;

    }
}

