/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5CrosstabDefaultMeasure;
import com.cognos.rap.actions.v5spechelpers.V5CrosstabNodeMember;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerNode;
import com.cognos.rap.actions.v5spechelpers.V5List;
import com.cognos.rap.actions.v5spechelpers.V5ListColumn;
import com.cognos.rap.actions.v5spechelpers.V5MapChart;
import com.cognos.rap.actions.v5spechelpers.V5RSXChart;
import com.cognos.rap.actions.v5spechelpers.V5Repeater;
import com.cognos.rap.actions.v5spechelpers.V5RepeaterTable;
import com.cognos.rap.actions.v5spechelpers.V5Singleton;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5VizChart;
import com.cognos.rap.actions.v5spechelpers.V5X;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class V5DataContainerFactory {
    public static V5DataContainer create(Element reportToModify, String layoutID) {
        if (layoutID != null) {
            Element dataContainer = V5X.selectSingleNode(reportToModify.getDocument().getRootElement().element("layouts"), "//V5X//CHILDATTR", "name", layoutID);
            if (dataContainer == null) {
                return null;
            }
            return V5DataContainerFactory.create(dataContainer);
        }
        return null;
    }

    public static boolean isDataContainer(Element dataContainer) {
        return "list".equals(dataContainer.getName()) || "crosstab".equals(dataContainer.getName()) || "repeater".equals(dataContainer.getName()) || "repeaterTable".equals(dataContainer.getName()) || V5RSXChart.isChart(dataContainer.getName()) || "singleton".equals(dataContainer.getName()) || "viz".equals(dataContainer.getName());
    }

    public static V5DataContainer create(Element dataContainer) {
        if ("list".equals(dataContainer.getName())) {
            return new V5List(dataContainer);
        }
        if ("crosstab".equals(dataContainer.getName())) {
            return new V5Crosstab(dataContainer);
        }
        if ("repeater".equals(dataContainer.getName())) {
            return new V5Repeater(dataContainer);
        }
        if ("repeaterTable".equals(dataContainer.getName())) {
            return new V5RepeaterTable(dataContainer);
        }
        if ("mapChart".equals(dataContainer.getName())) {
            return new V5MapChart(dataContainer);
        }
        if (V5RSXChart.isChart(dataContainer.getName())) {
            return new V5Chart(dataContainer);
        }
        if ("singleton".equals(dataContainer.getName())) {
            return new V5Singleton(dataContainer);
        }
        if ("viz".equals(dataContainer.getName())) {
            return new V5VizChart(dataContainer);
        }
        return null;
    }

    public static ArrayList<V5DataContainer> createChildContainers(Element parentElement) {
        ArrayList<V5DataContainer> childContainers = new ArrayList<V5DataContainer>();
        List potentialChildContainers = V5X.selectNodes(parentElement, "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refQuery");
        for (Element potentialChildContainer : potentialChildContainers) {
            V5DataContainer childContainer;
            if ("vizDataSet".equals(potentialChildContainer.getName())) {
                potentialChildContainer = V5SpecHelper.findParentContainer(potentialChildContainer);
            }
            if ((childContainer = V5DataContainerFactory.create(potentialChildContainer)) == null) continue;
            childContainers.add(childContainer);
        }
        return childContainers;
    }

    public static V5DataContainerNode createNode(Element dataContainerNode) {
        if (dataContainerNode == null) {
            return null;
        }
        if ("listColumn".equals(dataContainerNode.getName())) {
            return new V5ListColumn(dataContainerNode);
        }
        if ("crosstabNodeMember".equals(dataContainerNode.getName())) {
            return new V5CrosstabNodeMember(dataContainerNode);
        }
        if ("defaultMeasure".equals(dataContainerNode.getName())) {
            return new V5CrosstabDefaultMeasure(dataContainerNode);
        }
        return null;
    }
}

