/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.BaseAction;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5actionset.DrillDown;
import com.cognos.rap.actions.v5actionset.DrillUp;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.actions.v5spechelpers.V5Drillability;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class V5DrillUpDownWithBehaviors {
    public static final String DRILL_DOWN = "DrillDown";
    public static final String DRILL_UP = "DrillUp";
    private SelectedCell selectedCell = null;
    private Element reportToModifyRootElement = null;
    private Element rootMemberSetElement = null;
    private int distance = 0;
    private boolean isDrillingOnLeaf = false;
    private boolean isDrillingOnTop = false;
    private boolean isIsolatedOnLeaf = false;
    private boolean isIsolatedOnTop = false;
    private BaseAction baseAction = null;
    private V5Query v5Query = new V5Query();

    public V5DrillUpDownWithBehaviors(BaseAction action, Document reportToModify, SelectedCell selCell) {
        this.reportToModifyRootElement = reportToModify.getRootElement();
        this.selectedCell = selCell;
        this.setQueryInfo(this.selectedCell.queryName, this.selectedCell.nodeName);
        this.baseAction = action;
    }

    public void setQueryInfo(String refQuery, String refDataItem) {
        this.rootMemberSetElement = V5DrillUpDownWithBehaviors.getRootMemberSet(this.reportToModifyRootElement, refQuery, refDataItem);
        this.v5Query.focusQuery(this.reportToModifyRootElement, refQuery);
    }

    public boolean shouldUseAuthoredDrillBehaviors() {
        boolean useAuthoredDrillBehaviors = false;
        if (this.isDataItemOrganizedIntoMemberSet() && this.anyItemInMemberSetHasDrillBehavior()) {
            useAuthoredDrillBehaviors = true;
        }
        return useAuthoredDrillBehaviors;
    }

    public boolean isDataItemOrganizedIntoMemberSet() {
        boolean isDataItemOrganizedIntoMemberSet = false;
        isDataItemOrganizedIntoMemberSet = this.rootMemberSetElement != null;
        return isDataItemOrganizedIntoMemberSet;
    }

    public boolean anyItemInMemberSetHasDrillBehavior() {
        boolean hasDrillEnabledBehavior = false;
        Element drillBehaviorElement = (Element)this.reportToModifyRootElement.selectSingleNode(".//*[local-name()='drillBehavior']");
        String drillUpDown = "";
        if (drillBehaviorElement != null && (drillUpDown = drillBehaviorElement.attributeValue("drillUpDown")) != null && drillUpDown.length() != 0 && drillUpDown.equals("true")) {
            if (this.rootMemberSetElement == null) {
                return hasDrillEnabledBehavior;
            }
            String rootRefDataItem = this.rootMemberSetElement.attributeValue("refDataItem");
            Element drillQueryBehaviorElement = V5X.selectSingleNode(drillBehaviorElement, "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName());
            if (drillQueryBehaviorElement != null) {
                Element drillDataItemBehaviorElement = V5X.selectSingleNode(drillQueryBehaviorElement, "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", rootRefDataItem);
                if (drillDataItemBehaviorElement == null) {
                    List memberSetNodes = this.rootMemberSetElement.selectNodes(".//*[local-name()='memberSet']");
                    int memberSetNodesSize = memberSetNodes.size();
                    if (memberSetNodesSize > 0) {
                        for (int i = 0; i < memberSetNodesSize; ++i) {
                            Element memberSetElement = (Element)memberSetNodes.get(i);
                            if (memberSetElement != null) {
                                String memberSetRefDataItem = memberSetElement.attributeValue("refDataItem");
                                drillDataItemBehaviorElement = V5X.selectSingleNode(drillQueryBehaviorElement, "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", memberSetRefDataItem);
                                if (drillDataItemBehaviorElement == null) continue;
                                hasDrillEnabledBehavior = true;
                                break;
                            }
                            hasDrillEnabledBehavior = false;
                        }
                    }
                } else {
                    hasDrillEnabledBehavior = true;
                }
            }
        }
        return hasDrillEnabledBehavior;
    }

    public void applyAuthoredDrillBehaviors(String drillDirection) throws CognosServiceRequestException, ActionException {
        Element matchingLinkedDrillItem = this.getLinkedDrillItem();
        if (matchingLinkedDrillItem == null) {
            this.drillOnMemberSet(drillDirection);
        } else {
            List linkedDrillItemElements = matchingLinkedDrillItem.getParent().elements();
            for (Element linkedDrillItem : linkedDrillItemElements) {
                this.selectedCell.nodeName = linkedDrillItem.attributeValue("refDataItem");
                this.selectedCell.queryName = linkedDrillItem.attributeValue("refQuery");
                this.setQueryInfo(this.selectedCell.queryName, this.selectedCell.nodeName);
                if (this.rootMemberSetElement != null) {
                    this.drillOnMemberSet(drillDirection);
                    continue;
                }
                Collection<Element> createdDataItems = drillDirection.equals(DRILL_DOWN) ? ((DrillDown)this.baseAction).drillDownWithoutBehavioursAllContainersOfSameQuery(this.reportToModifyRootElement.getDocument(), this.selectedCell) : ((DrillUp)this.baseAction).drillUpWithoutBehavioursAllContainersOfSameQuery(this.reportToModifyRootElement.getDocument(), this.selectedCell);
                if (createdDataItems.isEmpty()) continue;
                String newDataItemName = createdDataItems.iterator().next().attributeValue("name");
                linkedDrillItem.addAttribute("refDataItem", newDataItemName);
            }
        }
    }

    public void drillOnMemberSet(String drillDirection) throws CognosServiceRequestException, ActionException {
        List memberSetNodes;
        boolean continueProcessingItems = true;
        if (this.rootMemberSetElement == null) {
            return;
        }
        this.preProcessBlockBase(drillDirection);
        String rootRefDataItem = this.rootMemberSetElement.attributeValue("refDataItem");
        continueProcessingItems = this.processDefinedItemDrillBehavior(drillDirection, rootRefDataItem, this.rootMemberSetElement, this.getDrillBehavior(drillDirection, this.v5Query.getQueryName(), rootRefDataItem), this.selectedCell.nodeUse);
        if (continueProcessingItems && (memberSetNodes = this.rootMemberSetElement.selectNodes(".//*[local-name()='memberSets']/*[local-name()='memberSet']")) != null) {
            int memberSetNodesSize = memberSetNodes.size();
            for (int i = 0; i < memberSetNodesSize; ++i) {
                Element memberSetElement = (Element)memberSetNodes.get(i);
                if (memberSetElement == null) continue;
                String memberSetRefDataItem = memberSetElement.attributeValue("refDataItem");
                continueProcessingItems = this.processDefinedItemDrillBehavior(drillDirection, memberSetRefDataItem, memberSetElement, this.getDrillBehavior(drillDirection, this.v5Query.getQueryName(), memberSetRefDataItem), this.selectedCell.nodeUse);
            }
        }
    }

    public static Element getRootMemberSet(Element report, String refQuery, String refDataItem) {
        Element memberSet = V5X.selectSingleNode(report, "//V5X//CHILD", "queries", "query", "//V5X//ATTR", "name", refQuery, "memberSetStructure", "//V5X//ANY", "memberSet", "//V5X//ATTR", "refDataItem", refDataItem);
        if (memberSet != null) {
            return (Element)memberSet.selectSingleNode("./ancestor-or-self::*[local-name()='memberSet'  and parent::*[local-name()='memberSetStructure']]");
        }
        return null;
    }

    public String getDrillBehavior(String drillDirection, String queryRef, String refDataItem) {
        Element drillUpBehaviorElement;
        Element drillDataItemBehaviorElement;
        String drillBehavior = "";
        Element drillBehaviorElement = null;
        if (drillDirection.equals(DRILL_DOWN)) {
            Element drillDownBehaviorElement;
            Element drillDataItemBehaviorElement2 = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", queryRef, "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem);
            if (drillDataItemBehaviorElement2 != null && (drillDownBehaviorElement = (Element)drillDataItemBehaviorElement2.selectSingleNode(".//*[local-name()='drillDownBehavior']")) != null) {
                drillBehaviorElement = (Element)drillDownBehaviorElement.selectSingleNode(".//*[local-name()='drillSimpleType']");
                if (drillBehaviorElement != null) {
                    drillBehavior = drillBehaviorElement.attributeValue("type");
                } else {
                    Element drillAncestor;
                    Element drillChangeToDepthBasedExpressionElement;
                    Element drillChangeBehaviorElement = (Element)drillDataItemBehaviorElement2.selectSingleNode(".//*[local-name()='drillChange']");
                    if (drillChangeBehaviorElement != null) {
                        drillBehavior = DrillBehavior.drillChange.toString();
                    }
                    if ((drillChangeToDepthBasedExpressionElement = (Element)drillDataItemBehaviorElement2.selectSingleNode(".//*[local-name()='drillChangeToDepthBasedExpression']")) != null) {
                        drillBehavior = DrillBehavior.drillChangeToDepthBasedExpression.toString();
                    }
                    if ((drillAncestor = (Element)drillDataItemBehaviorElement2.selectSingleNode(".//*[local-name()='drillAncestor']")) != null) {
                        drillBehavior = DrillBehavior.drillAncestor.toString();
                    }
                }
            }
        } else if (drillDirection.equals(DRILL_UP) && (drillDataItemBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", queryRef, "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem)) != null && (drillUpBehaviorElement = (Element)drillDataItemBehaviorElement.selectSingleNode(".//*[local-name()='drillUpBehavior']")) != null) {
            drillBehaviorElement = (Element)drillUpBehaviorElement.selectSingleNode(".//*[local-name()='drillSimpleType']");
            if (drillBehaviorElement != null) {
                drillBehavior = drillBehaviorElement.attributeValue("type");
            } else {
                Element drillAncestor;
                Element drillChangeToDepthBasedExpressionElement;
                Element drillChangeBehaviorElement = (Element)drillDataItemBehaviorElement.selectSingleNode(".//*[local-name()='drillChange']");
                if (drillChangeBehaviorElement != null) {
                    drillBehavior = DrillBehavior.drillChange.toString();
                }
                if ((drillChangeToDepthBasedExpressionElement = (Element)drillDataItemBehaviorElement.selectSingleNode(".//*[local-name()='drillChangeToDepthBasedExpression']")) != null) {
                    drillBehavior = DrillBehavior.drillChangeToDepthBasedExpression.toString();
                }
                if ((drillAncestor = (Element)drillDataItemBehaviorElement.selectSingleNode(".//*[local-name()='drillAncestor']")) != null) {
                    drillBehavior = DrillBehavior.drillAncestor.toString();
                }
            }
        }
        return drillBehavior;
    }

    public boolean processDefinedItemDrillBehavior(String drillDirection, String refDataItem, Element memberSetElement, String drillBehavior, String drillMUN) throws CognosServiceRequestException, ActionException {
        boolean continueProcessingItems = true;
        if (drillBehavior != null && drillBehavior.length() != 0) {
            Element dataItemElement = this.v5Query.findItem(refDataItem);
            String originalExpression = dataItemElement == null ? null : dataItemElement.elementText("expression");
            switch (DrillBehavior.valueOf(drillBehavior)) {
                case replaceExpression: {
                    continueProcessingItems = this.applyReplaceExpression(drillDirection, refDataItem, drillMUN);
                    break;
                }
                case replaceItem: {
                    continueProcessingItems = this.applyReplaceItem(drillDirection, refDataItem, drillMUN);
                    break;
                }
                case emptySet: {
                    continueProcessingItems = this.applyEmptySet(drillDirection, refDataItem, drillMUN);
                    break;
                }
                case drillChange: {
                    continueProcessingItems = this.applyDrillChange(drillDirection, refDataItem, drillMUN);
                    break;
                }
                case drillChangeToDepthBasedExpression: {
                    continueProcessingItems = this.applyDrillChangeToDepthBasedExpression(drillDirection, refDataItem, drillMUN);
                    break;
                }
                case drillAncestor: {
                    continueProcessingItems = this.applyDrillAncestor(drillDirection, refDataItem, drillMUN);
                    break;
                }
                default: {
                    assert (DrillBehavior.valueOf(drillBehavior).equals((Object)DrillBehavior.preserve));
                    continueProcessingItems = this.applyPreserve(drillDirection, refDataItem);
                }
            }
            if (DrillBehavior.valueOf(drillBehavior) != DrillBehavior.preserve && originalExpression != null) {
                if (dataItemElement.elementText("expression") != null && V5SpecHelper.getXMLAttribute(dataItemElement, "RAP_DrillResetExpression") == null) {
                    V5SpecHelper.setXMLAttribute(dataItemElement, "RAP_DrillResetExpression", originalExpression, "no");
                }
                if (this.selectedCell.nodeHierarchyUniqueName != null) {
                    V5SpecHelper.setXMLAttribute(dataItemElement, "RAP_HUN", this.selectedCell.nodeHierarchyUniqueName, "no");
                }
            }
        }
        return continueProcessingItems;
    }

    public boolean applyReplaceExpression(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException, ActionException {
        String label = "";
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (this.isHighLevelDataItem(dataItemElement) && (dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN, true)) == null) {
            return false;
        }
        Element expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']");
        if (expressionElement == null) {
            return false;
        }
        if (drillDirection.equals(DRILL_DOWN)) {
            List<Element> listDataContainers = V5SpecHelper.getListLayoutComponentByQuery(this.reportToModifyRootElement, this.selectedCell.queryName);
            if (listDataContainers.size() > 0 && this.isDrillingOnLeaf) {
                V5Drillability.setDrillDownDisabled(this.v5Query, dataItemElement);
                V5Drillability.setIsIsolated(dataItemElement);
            } else {
                drillMUN = "children(" + drillMUN + ")";
            }
            label = this.selectedCell.nodeDisplay;
        } else if (drillDirection.equals(DRILL_UP)) {
            if (this.distance != 1) {
                this.distance = 2;
            }
            boolean bIsIsolatedOnList = V5Drillability.isIsolated(dataItemElement);
            switch (this.distance) {
                case 1: {
                    if (this.isIsolatedOnTop) break;
                    MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
                    if (parent == null) {
                        return false;
                    }
                    label = parent.getMemberCaption();
                    drillMUN = parent.getMUN();
                    if (drillMUN == null || drillMUN.length() == 0) {
                        return false;
                    }
                    drillMUN = "children(" + drillMUN + ")";
                    break;
                }
                case 2: {
                    if (this.isDrillingOnLeaf && this.isIsolatedOnLeaf || this.isDrillingOnTop && !this.isIsolatedOnTop || bIsIsolatedOnList) {
                        MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
                        if (parent == null) {
                            return false;
                        }
                        label = parent.getMemberCaption();
                        drillMUN = parent.getMUN();
                        if (drillMUN == null || drillMUN.length() == 0) {
                            return false;
                        }
                        if (this.isDrillingOnLeaf && this.isIsolatedOnLeaf || bIsIsolatedOnList) {
                            drillMUN = "children(" + drillMUN + ")";
                        }
                        if (!bIsIsolatedOnList) break;
                        V5Drillability.clearIsIsolated(dataItemElement);
                        break;
                    }
                    if (this.isDrillingOnTop) break;
                    MemberInfo grandparent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
                    if (grandparent == null) {
                        return false;
                    }
                    label = grandparent.getMemberCaption();
                    drillMUN = grandparent.getMUN();
                    drillMUN = "children(" + drillMUN + ")";
                    break;
                }
            }
        }
        expressionElement.setText(drillMUN);
        if (label.equals(this.selectedCell.nodeName)) {
            Attribute labelAttribute = dataItemElement.attribute("label");
            if (labelAttribute != null) {
                dataItemElement.remove(labelAttribute);
            }
        } else {
            this.addLabelToDataItem(dataItemElement, label);
        }
        return true;
    }

    public boolean applyReplaceItem(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException, ActionException {
        String label = "";
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (this.isHighLevelDataItem(dataItemElement) && (dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN)) == null) {
            return false;
        }
        Element expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']");
        if (expressionElement == null) {
            return false;
        }
        if (drillDirection.equals(DRILL_DOWN)) {
            MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
            label = parent.getMemberCaption();
            this.addLabelToDataItem(dataItemElement, label);
        } else if (drillDirection.equals(DRILL_UP)) {
            this.distance = this.getDistance();
            switch (this.distance) {
                case 1: {
                    MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
                    if (this.isDrillingOnLeaf && this.isIsolatedOnLeaf) {
                        label = parent.getMemberCaption();
                    } else {
                        MemberInfo grandParent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
                        if (parent == null || grandParent == null) {
                            return false;
                        }
                        label = grandParent.getMemberCaption();
                    }
                    drillMUN = parent.getMUN();
                    if (drillMUN == null || drillMUN.length() == 0) {
                        return false;
                    }
                    this.addLabelToDataItem(dataItemElement, label);
                    break;
                }
                case 2: {
                    if (this.isOneLevelAbove(refDataItem)) {
                        Attribute labelAttribute;
                        if (refDataItem.equals(this.selectedCell.nodeName)) {
                            this.distance = 1;
                            MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, this.distance);
                            if (parent == null) {
                                return false;
                            }
                            label = parent.getMemberCaption();
                            drillMUN = parent.getMUN();
                            if (drillMUN == null || drillMUN.length() == 0) {
                                return false;
                            }
                        } else {
                            MemberInfo grandParent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
                            if (grandParent == null) {
                                return false;
                            }
                            label = grandParent.getMemberCaption();
                            drillMUN = grandParent.getMUN();
                            if (drillMUN == null || drillMUN.length() == 0) {
                                return false;
                            }
                        }
                        if ((labelAttribute = dataItemElement.attribute("label")) == null) break;
                        dataItemElement.remove(labelAttribute);
                        break;
                    }
                    MemberInfo grandParent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
                    if (grandParent == null) {
                        return false;
                    }
                    drillMUN = grandParent.getMUN();
                    if (drillMUN == null || drillMUN.length() == 0) {
                        return false;
                    }
                    this.addLabelToDataItem(dataItemElement, label);
                    break;
                }
            }
        }
        expressionElement.setText(drillMUN);
        return true;
    }

    public boolean applyPreserve(String drillDirection, String refDataItem) throws CognosServiceRequestException, ActionException {
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (drillDirection.equals(DRILL_DOWN)) {
            this.addLabelToDataItem(dataItemElement, this.selectedCell.nodeDisplay);
        } else if (drillDirection.equals(DRILL_UP)) {
            MemberInfo grandparent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
            String label = grandparent.getMemberCaption();
            if (label.equals(this.selectedCell.nodeName)) {
                Attribute labelAttribute = dataItemElement.attribute("label");
                if (labelAttribute != null) {
                    dataItemElement.remove(labelAttribute);
                }
            } else {
                this.addLabelToDataItem(dataItemElement, label);
            }
        }
        return true;
    }

    public boolean applyEmptySet(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException, ActionException {
        String label = "";
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (this.isHighLevelDataItem(dataItemElement) && (dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN)) == null) {
            return false;
        }
        Element expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']");
        if (expressionElement == null) {
            return false;
        }
        if (drillDirection.equals(DRILL_DOWN)) {
            drillMUN = "emptySet(hierarchy(" + drillMUN + "))";
            label = this.selectedCell.nodeDisplay;
        } else if (drillDirection.equals(DRILL_UP)) {
            if (this.distance != 1) {
                this.distance = 2;
            }
            switch (this.distance) {
                case 1: {
                    MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
                    if (parent == null) {
                        return false;
                    }
                    label = parent.getMemberCaption();
                    drillMUN = parent.getMUN();
                    if (drillMUN == null || drillMUN.length() == 0) {
                        return false;
                    }
                    drillMUN = "emptySet(hierarchy(" + drillMUN + "))";
                    break;
                }
                case 2: {
                    MemberInfo grandparent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
                    if (grandparent == null) {
                        return false;
                    }
                    label = grandparent.getMemberCaption();
                    drillMUN = grandparent.getMUN();
                    if (drillMUN == null || drillMUN.length() == 0) {
                        MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
                        if (parent == null) {
                            return false;
                        }
                        label = parent.getMemberCaption();
                        drillMUN = parent.getMUN();
                        if (drillMUN == null || drillMUN.length() == 0) {
                            return false;
                        }
                    }
                    drillMUN = "emptySet(hierarchy(" + drillMUN + "))";
                    break;
                }
            }
        }
        expressionElement.setText(drillMUN);
        if (label.equals(this.selectedCell.nodeName)) {
            Attribute labelAttribute = dataItemElement.attribute("label");
            if (labelAttribute != null) {
                dataItemElement.remove(labelAttribute);
            }
        } else {
            this.addLabelToDataItem(dataItemElement, label);
        }
        return true;
    }

    public boolean applyDrillChange(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException {
        Element expressionElement;
        String changeRefDataItem = "";
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        Element drillBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem, DRILL_UP.equals(drillDirection) ? "drillUpBehavior" : "drillDownBehavior", "drillChange");
        if (drillBehaviorElement == null) {
            return true;
        }
        changeRefDataItem = drillBehaviorElement.attributeValue("refDataItem");
        if (this.isHighLevelDataItem(dataItemElement)) {
            if ("dataItemMemberSet".equals(dataItemElement.getName())) {
                boolean sameHierarchy = V5DrillUpDownWithBehaviors.getRootMemberSet(dataItemElement.getDocument().getRootElement(), this.v5Query.getQueryName(), changeRefDataItem) == this.rootMemberSetElement;
                dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN, sameHierarchy);
            } else {
                dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN);
            }
        }
        if ((expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']")) != null) {
            String expression = '[' + changeRefDataItem + ']';
            expressionElement.setText(expression);
            Element changeDataItemElement = this.v5Query.findItem(changeRefDataItem);
            if (changeDataItemElement != null && changeDataItemElement.attribute("label") != null) {
                this.addLabelToDataItem(dataItemElement, changeDataItemElement.attributeValue("label"));
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean applyDrillChangeToDepthBasedExpression(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException, ActionException {
        Element drillBehaviorElement;
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (this.isHighLevelDataItem(dataItemElement) && (dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN)) == null) {
            return false;
        }
        String depthOffset = "";
        String drillMUNLevel = drillMUN;
        String label = "";
        if (drillDirection.equals(DRILL_DOWN)) {
            drillBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem, "drillDownBehavior", "drillChangeToDepthBasedExpression");
            if (drillBehaviorElement == null) {
                return true;
            }
            depthOffset = drillBehaviorElement.attributeValue("depthOffset");
            MemberInfo childInfo = this.baseAction.getRapServiceRequestManager().getChildInfo(this.v5Query, this.selectedCell.nodeUse);
            String drillMUNChild = childInfo.getMUN();
            if (drillMUNChild != null && drillMUNChild.length() != 0) {
                int ancestorDistance = Integer.parseInt(depthOffset);
                MemberInfo ancestor = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUNChild, ancestorDistance);
                String drillMUNAncestor = "";
                drillMUNAncestor = ancestor != null ? ancestor.getMUN() : drillMUNChild;
                int endIndexLevel = drillMUNAncestor.indexOf("->");
                if (endIndexLevel > 0) {
                    drillMUNLevel = drillMUNAncestor.substring(0, endIndexLevel);
                    int beginIndexLabel = drillMUNLevel.lastIndexOf(91) + 1;
                    int endIndexLabel = drillMUNLevel.lastIndexOf(93);
                    label = drillMUNLevel.substring(beginIndexLabel, endIndexLabel);
                }
            }
        } else if (drillDirection.equals(DRILL_UP)) {
            int endIndexLevel;
            drillBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem, "drillUpBehavior", "drillChangeToDepthBasedExpression");
            if (drillBehaviorElement == null) {
                return true;
            }
            depthOffset = drillBehaviorElement.attributeValue("depthOffset");
            int ancestorDistance = Integer.parseInt(depthOffset) + 1;
            MemberInfo ancestor = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, ancestorDistance);
            String drillMUNAncestor = ancestor.getMUN();
            if (drillMUNAncestor != null && drillMUNAncestor.length() != 0 && (endIndexLevel = drillMUNAncestor.indexOf("->")) > 0) {
                drillMUNLevel = drillMUNAncestor.substring(0, endIndexLevel);
                int beginIndexLabel = drillMUNLevel.lastIndexOf(91) + 1;
                int endIndexLabel = drillMUNLevel.lastIndexOf(93);
                label = drillMUNLevel.substring(beginIndexLabel, endIndexLabel);
            }
        }
        Element expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']");
        if (expressionElement != null) {
            if (drillMUNLevel.length() != 0) {
                expressionElement.setText(drillMUNLevel);
            }
            if (label.length() != 0) {
                this.addLabelToDataItem(dataItemElement, label);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean applyDrillAncestor(String drillDirection, String refDataItem, String drillMUN) throws CognosServiceRequestException, ActionException {
        Element expressionElement;
        Element drillBehaviorElement;
        Element dataItemElement = this.v5Query.findItem(refDataItem);
        if (dataItemElement == null) {
            return false;
        }
        if (this.isHighLevelDataItem(dataItemElement) && (dataItemElement = this.preProcessHighLevelDataItem(dataItemElement, drillMUN)) == null) {
            return false;
        }
        String depthOffset = "";
        String drillMUNAncestor = "";
        String labelAncestor = "";
        if (drillDirection.equals(DRILL_DOWN)) {
            if (this.isDrillingOnLeaf) {
                return true;
            }
            drillBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem, "drillDownBehavior", "drillAncestor");
            if (drillBehaviorElement == null) {
                return true;
            }
            depthOffset = drillBehaviorElement.attributeValue("depthOffset");
            switch (Integer.parseInt(depthOffset)) {
                case 0: {
                    MemberInfo childInfo = this.baseAction.getRapServiceRequestManager().getChildInfo(this.v5Query, this.selectedCell.nodeUse);
                    drillMUNAncestor = childInfo.isValid() ? childInfo.getMUN() : drillMUN;
                    labelAncestor = this.selectedCell.nodeDisplay;
                    break;
                }
                case 1: {
                    drillMUNAncestor = drillMUN;
                    labelAncestor = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, 1).getMemberCaption();
                    break;
                }
                default: {
                    int ancestorOffset = Integer.parseInt(depthOffset);
                    int ancestorDistance = ancestorOffset - 1;
                    MemberInfo ancestor = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, ancestorDistance);
                    drillMUNAncestor = ancestor.getMUN();
                    MemberInfo ancestor2 = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, ++ancestorDistance);
                    labelAncestor = ancestor2.getMemberCaption();
                    break;
                }
            }
        } else if (drillDirection.equals(DRILL_UP)) {
            if (this.isDrillingOnTop) {
                return true;
            }
            drillBehaviorElement = V5X.selectSingleNode(this.reportToModifyRootElement, "drillBehavior", "//V5X//CHILD", "drillQueryBehavior", "//V5X//ATTR", "refQuery", this.v5Query.getQueryName(), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", refDataItem, "drillUpBehavior", "drillAncestor");
            if (drillBehaviorElement == null) {
                return true;
            }
            depthOffset = drillBehaviorElement.attributeValue("depthOffset");
            int ancestorOffset = Integer.parseInt(depthOffset);
            int ancestorDistance = ancestorOffset + 1;
            MemberInfo ancestor = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, ancestorDistance);
            drillMUNAncestor = ancestor.getMUN();
            MemberInfo ancestor2 = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, drillMUN, ++ancestorDistance);
            labelAncestor = ancestor2.getMemberCaption();
        }
        if ((expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']")) != null) {
            if (drillMUNAncestor.length() != 0) {
                expressionElement.setText(drillMUNAncestor);
            }
            if (labelAncestor.length() != 0) {
                this.addLabelToDataItem(dataItemElement, labelAncestor);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isHighLevelDataItem(Element queryDataItem) {
        boolean isHighLevelDataItem = false;
        if (queryDataItem != null && !"dataItem".equals(queryDataItem.getName())) {
            isHighLevelDataItem = true;
        }
        return isHighLevelDataItem;
    }

    public Element preProcessHighLevelDataItem(Element queryDataItem, String drillMUN) {
        return this.preProcessHighLevelDataItem(queryDataItem, drillMUN, false);
    }

    public Element preProcessHighLevelDataItem(Element queryDataItem, String drillMUN, boolean MemberSetExpressionToDataItemSetExpression) {
        String targetItemName;
        String expression = "";
        Element expressionElement = queryDataItem.element("expression");
        if (expressionElement != null) {
            return queryDataItem;
        }
        String string = targetItemName = queryDataItem.element("setSorting") == null ? "dataItem" : "dataItemSetExpression";
        if (MemberSetExpressionToDataItemSetExpression && "dataItemMemberSet".equals(queryDataItem.getName())) {
            expressionElement = V5X.selectSingleNode(queryDataItem, "setExpression", "expression");
            if (expressionElement != null) {
                expression = expressionElement.getText();
                targetItemName = "dataItemSetExpression";
            }
        } else {
            Element munElement = V5X.selectSingleNode(queryDataItem, "MUN");
            if (munElement != null) {
                expression = munElement.getText();
            } else if (drillMUN != null && drillMUN.length() != 0) {
                expression = drillMUN;
            }
        }
        Element dataItemElementNew = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)targetItemName, (Namespace)queryDataItem.getNamespace()));
        dataItemElementNew.addAttribute("name", queryDataItem.attributeValue("name"));
        if (targetItemName.equals("dataItemSetExpression")) {
            Element setSorting = queryDataItem.element("setSorting");
            if (setSorting != null) {
                dataItemElementNew.add(setSorting.createCopy());
            }
            if (queryDataItem.element("dmDimension") != null) {
                dataItemElementNew.add(queryDataItem.element("dmDimension").createCopy());
            }
            if (queryDataItem.element("dmHierarchy") != null) {
                dataItemElementNew.add(queryDataItem.element("dmHierarchy").createCopy());
            }
        }
        Element expressionElementNew = dataItemElementNew.addElement("expression");
        expressionElementNew.setText(expression);
        boolean isDataItemRemoved = this.v5Query.getItemList().removeDataItem(queryDataItem);
        if (!isDataItemRemoved) {
            return queryDataItem;
        }
        this.v5Query.getItemList().addDataItem(dataItemElementNew);
        return dataItemElementNew;
    }

    private int getDistance() throws ActionException {
        DimensionalOperations dimensionalOperations = new DimensionalOperations(this.baseAction);
        return dimensionalOperations.getAncestorDistance(this.v5Query, this.selectedCell);
    }

    public boolean isOneLevelAbove(String refDataItem) throws CognosServiceRequestException, ActionException {
        boolean isDataItemOneAbove = false;
        MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
        if (parent == null) {
            return false;
        }
        String labelParent = parent.getMemberCaption();
        Element queryDataItemElement = this.v5Query.findItem(refDataItem);
        if (queryDataItemElement == null) {
            return false;
        }
        String label = queryDataItemElement.attributeValue("label");
        if (label == null || label.equals(labelParent)) {
            isDataItemOneAbove = true;
        }
        return isDataItemOneAbove;
    }

    public void addLabelToDataItem(Element dataItemElement, String label) {
        dataItemElement.addAttribute("label", label);
    }

    public boolean isDrillingOnLeaf(String mun) throws CognosServiceRequestException, ActionException {
        boolean isDrillOnLeaf = false;
        if (this.baseAction != null) {
            isDrillOnLeaf = !this.baseAction.getRapServiceRequestManager().ifHasChild(this.v5Query, mun);
        }
        return isDrillOnLeaf;
    }

    public boolean isDrillingOnTop(String mun) throws CognosServiceRequestException, ActionException {
        boolean isDrillOnTop = false;
        if (this.baseAction != null) {
            MemberInfo grandParent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 2);
            if (grandParent == null) {
                return true;
            }
            String drillMUN = grandParent.getMUN();
            if (drillMUN == null || drillMUN.length() == 0) {
                isDrillOnTop = true;
            }
        }
        return isDrillOnTop;
    }

    public String getBaseRefDataItem(String drillDirection) {
        for (Element memberSet : V5X.selectNodes(this.rootMemberSetElement, "memberSet")) {
            String rdi = memberSet.attributeValue("refDataItem");
            Element drillType = V5X.selectSingleNode(this.reportToModifyRootElement.element("drillBehavior"), "drillDataItemBehavior", "//V5X//ATTR", "refDataItem", rdi, drillDirection.equals(DRILL_DOWN) ? "drillDownBehavior" : "drillUpBehavior", "//V5X//CHILD", "//V5X//ANYCHILD");
            if (drillType == null || !"replaceExpression".equals(drillType.attributeValue("type"))) continue;
            return rdi;
        }
        return "";
    }

    public void preProcessBlockBase(String drillDirection) throws CognosServiceRequestException, ActionException {
        if (drillDirection.equals(DRILL_DOWN)) {
            this.isDrillingOnLeaf = this.isDrillingOnLeaf(this.selectedCell.nodeUse);
            this.isIsolatedOnLeaf = this.isIsolatedOnLeaf(drillDirection);
        } else if (drillDirection.equals(DRILL_UP)) {
            this.isDrillingOnTop = this.isDrillingOnTop(this.selectedCell.nodeUse);
            this.isIsolatedOnTop = this.isIsolatedOnTop();
            this.isDrillingOnLeaf = this.isDrillingOnLeaf(this.selectedCell.nodeUse);
            this.isIsolatedOnLeaf = this.isIsolatedOnLeaf(drillDirection);
        }
    }

    public boolean isIsolatedOnLeaf(String drillDirection) {
        Element expressionElement;
        boolean isolatedOnLeaf = false;
        String baseRefDataItem = this.getBaseRefDataItem(drillDirection);
        Element baseDataItem = this.v5Query.findItem(baseRefDataItem);
        if (baseDataItem != null && (expressionElement = (Element)baseDataItem.selectSingleNode(".//*[local-name()='expression']")) != null) {
            String expression = expressionElement.getText();
            isolatedOnLeaf = !expression.startsWith("children(");
        }
        return isolatedOnLeaf;
    }

    public boolean isIsolatedOnTop() throws CognosServiceRequestException, ActionException {
        boolean isolatedOnTop = false;
        MemberInfo parent = this.baseAction.getRapServiceRequestManager().getAncestorInfo(this.v5Query, this.selectedCell.nodeUse, 1);
        if (parent == null) {
            isolatedOnTop = true;
        } else {
            String drillMUN = parent.getMUN();
            if (drillMUN == null || drillMUN.length() == 0) {
                isolatedOnTop = true;
            }
        }
        return isolatedOnTop;
    }

    private Element getLinkedDrillItem() {
        if (this.rootMemberSetElement == null) {
            return V5SpecHelper.getLinkedDrillItem(this.reportToModifyRootElement.getDocument(), this.selectedCell.queryName, this.selectedCell.nodeName);
        }
        ArrayList<String> rdisInMemberSet = new ArrayList<String>();
        rdisInMemberSet.add(this.rootMemberSetElement.attributeValue("refDataItem"));
        for (Element memberSet : V5X.selectNodes(this.rootMemberSetElement, "memberSet")) {
            rdisInMemberSet.add(memberSet.attributeValue("refDataItem"));
        }
        for (String rdi : rdisInMemberSet) {
            Element linkedDrillItem = V5SpecHelper.getLinkedDrillItem(this.reportToModifyRootElement.getDocument(), this.selectedCell.queryName, rdi);
            if (linkedDrillItem == null) continue;
            return linkedDrillItem;
        }
        return null;
    }

    public void revertToRegularSet() {
        String rdiName = this.selectedCell.nodeName;
        this.v5Query.revertToRegularSet(rdiName);
    }

    public static enum DrillBehavior {
        replaceExpression,
        replaceItem,
        emptySet,
        preserve,
        drillAncestor,
        drillChangeToDepthBasedExpression,
        drillChange;

    }
}

