/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import java.util.List;
import org.dom4j.Element;

public class V5Drillability {
    private static final String RS_drillparent = "RS_drillparent";
    private static final String BUX_drillUpDisabled = "BUX_drillUpDisabled";
    private static final String BUX_drillDownDisabled = "BUX_drillDownDisabled";

    public static void setDrillDownDisabled(V5Query query, Element dataItem) {
        if (query != null) {
            V5Drillability.setDisableDrill(query, dataItem, BUX_drillDownDisabled);
        }
    }

    public static void setDrillParent(Element dataItem) {
        V5SpecHelper.setXMLAttribute(dataItem, RS_drillparent, "true", "no");
    }

    private static void setDisableDrill(V5Query query, Element item, String drillabilityType) {
        String hun;
        if (query != null && item != null && (hun = V5Query.getExtendedDataItemProperty(item, "HUN")) != null) {
            List<Element> hunItems = query.getDataItemsInHierarchy(hun);
            for (Element hunItem : hunItems) {
                V5SpecHelper.setXMLAttribute(hunItem, drillabilityType, "true", "no");
            }
        }
    }

    public static void clearDrillDownDisabled(V5Query query, Element dataItem) {
        if (query != null) {
            V5Drillability.clearDisableDrill(query, dataItem, BUX_drillDownDisabled);
        }
    }

    public static void clearDrillUpDisabled(V5Query query, Element dataItem) {
        V5Drillability.clearDisableDrill(query, dataItem, BUX_drillUpDisabled);
    }

    private static void clearDisableDrill(V5Query query, Element item, String drillabilityType) {
        String hun;
        if (query != null && item != null && (hun = V5Query.getExtendedDataItemProperty(item, "HUN")) != null) {
            List<Element> hunItems = query.getDataItemsInHierarchy(hun);
            for (Element hunItem : hunItems) {
                V5SpecHelper.removeXMLAttribute(hunItem, drillabilityType);
            }
        }
    }

    public static void setDrillUpDisabled(V5Query query, String itemName) {
        if (query != null) {
            V5Drillability.setDisableDrill(query, query.findItem(itemName), BUX_drillUpDisabled);
        }
    }

    public static boolean isDrillDownDisabled(Element dataItem) {
        return "true".equals(V5SpecHelper.getXMLAttribute(dataItem, RS_drillparent)) || "true".equals(V5SpecHelper.getXMLAttribute(dataItem, BUX_drillDownDisabled));
    }

    public static boolean isDrillUpDisabled(Element dataItem) {
        return "true".equals(V5SpecHelper.getXMLAttribute(dataItem, BUX_drillUpDisabled));
    }

    public static void setIsIsolated(Element dataItem) {
        V5SpecHelper.setXMLAttribute(dataItem, "RAP_drillIsolated", "true", "no");
    }

    public static boolean isIsolated(Element dataItem) {
        return "true".equals(V5SpecHelper.getXMLAttribute(dataItem, "RAP_drillIsolated"));
    }

    public static void clearIsIsolated(Element dataItemElement) {
        V5SpecHelper.removeXMLAttribute(dataItemElement, "RAP_drillIsolated");
    }
}

