/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.CCLDbTypesInfo;
import com.cognos.rap.actions.v5requestcreators.V5ConfirmIsNumericRequest;
import com.cognos.rap.actions.v5spechelpers.QueryItemProperties;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.CognosServiceOptions;
import com.cognos.rap.controller.CognosServiceResponse;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestAuthException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.exceptions.CognosServiceRequestWorkingStatusException;
import com.cognos.rap.utility.RAPLogger;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class V5ItemUpgrader {
    private Element _report = null;
    private V5QueryItem _v5QueryItem = null;
    private Element _queryItem = null;
    private V5Query _query = null;
    private String _queryItemExpression = null;

    public V5ItemUpgrader(V5QueryItem v5QueryItem) {
        this._v5QueryItem = v5QueryItem;
        this.initialize(v5QueryItem.getDOM().getDocument().getRootElement(), v5QueryItem.getDOM(), v5QueryItem.getQuery());
    }

    private void initialize(Element report, Element dataItem, V5Query query) {
        Element exprNode;
        this._report = report;
        this._query = query;
        this._queryItem = dataItem;
        if (this._queryItem != null && (exprNode = (Element)this._queryItem.selectSingleNode(V5X.select("expression"))) != null) {
            this._queryItemExpression = exprNode.getText();
        }
    }

    public boolean createSet(ActionEnv env, QueryItemProperties properties) throws ActionException {
        List rows;
        if (properties != null && properties.isConfirmedSet()) {
            this.convertDataItemToDataItemSetExpression(properties._hun, properties._dun);
            return true;
        }
        if (!env.hasCognosServiceInterface()) {
            return false;
        }
        env.addEventTiming("set?:" + this._queryItem.attributeValue("name"), "2");
        Element result = null;
        CognosServiceOptions options = new CognosServiceOptions();
        options.addOption("asynch.primaryWaitThreshold", "0");
        options.addOption("run.outputFormat", "XML");
        try {
            result = env.getRapServiceRequestManager().executeQuery(this.createV5SetInfoReport(), options);
        }
        catch (CognosServiceRequestAuthException authException) {
            throw authException;
        }
        catch (CognosServiceRequestWorkingStatusException statusException) {
            throw statusException;
        }
        catch (CognosServiceRequestException e) {
            RAPLogger.info(e.getMessage(), V5ItemUpgrader.class);
        }
        if (result != null && this.responseHasDimensionalContent(rows = XMLUtility.selectNodes(result, ".//*[local-name()='row']"))) {
            if (rows.size() == 1) {
                this.setPropertiesValues((Element)rows.get(0), properties);
                this._v5QueryItem.setItemType(V5QueryItem.ItemType.memberOrSingleMemberSet);
                return false;
            }
            if (rows.size() > 0) {
                this.convertDataItemToDataItemSetExpression((Element)rows.get(0), properties);
                return true;
            }
        }
        properties.setBasicValue();
        properties.saveJSONXMLAttribute(this._queryItem, false);
        return false;
    }

    public boolean responseHasDimensionalContent(List<Element> responseRows) {
        List columnData;
        if (responseRows != null && responseRows.size() > 0 && (columnData = responseRows.get(0).elements("value")) != null && columnData.size() > V5SetInfoReport_Columns._hun && columnData.size() > V5SetInfoReport_Columns._dun) {
            String hun = ((Element)columnData.get(V5SetInfoReport_Columns._hun)).getText();
            String dun = ((Element)columnData.get(V5SetInfoReport_Columns._dun)).getText();
            return hun != null && hun.length() > 0 && dun != null && dun.length() > 0;
        }
        return false;
    }

    private void convertDataItemToDataItemSetExpression(Element firstRow, QueryItemProperties properties) {
        this.setPropertiesValues(firstRow, properties);
        List columnData = firstRow.elements("value");
        String hun = properties != null ? properties._hun : ((Element)columnData.get(V5SetInfoReport_Columns._hun)).getText();
        String dun = properties != null ? properties._dun : ((Element)columnData.get(V5SetInfoReport_Columns._dun)).getText();
        this.convertDataItemToDataItemSetExpression(hun, dun);
    }

    private void setPropertiesValues(Element firstRow, QueryItemProperties properties) {
        if (properties != null) {
            List columnData = firstRow.elements("value");
            String hun = ((Element)columnData.get(V5SetInfoReport_Columns._hun)).getText();
            String dun = ((Element)columnData.get(V5SetInfoReport_Columns._dun)).getText();
            String caption = this._queryItem.attributeValue("name");
            properties._hun = hun;
            properties._dun = dun;
            properties.setHierarchyCaption(caption);
        }
    }

    private void convertDataItemToDataItemSetExpression(String hun, String dun) {
        Attribute attrDataItemPreSort;
        Attribute attrNaInCalcMemberContext;
        Attribute attrRollupAggregate;
        this._queryItem.setQName(DocumentHelper.createQName((String)"dataItemSetExpression", (Namespace)this._queryItem.getNamespace()));
        Attribute attrAggregate = this._queryItem.attribute("aggregate");
        if (attrAggregate != null) {
            this._queryItem.remove(attrAggregate);
        }
        if ((attrRollupAggregate = this._queryItem.attribute("rollupAggregate")) != null) {
            this._queryItem.remove(attrRollupAggregate);
        }
        if ((attrNaInCalcMemberContext = this._queryItem.attribute("naInCalcMemberContext")) != null) {
            this._queryItem.remove(attrNaInCalcMemberContext);
        }
        if ((attrDataItemPreSort = this._queryItem.attribute("sort")) != null) {
            this._queryItem.remove(attrDataItemPreSort);
        }
        if (this._queryItem.selectSingleNode(".//*[local-name()='dmHierarchy']") == null) {
            String caption = this._queryItem.attributeValue("name");
            this._query.setDimensionalDataItemInfo(this._queryItem, caption, null, hun, dun);
        }
        this._v5QueryItem.setItemType(V5QueryItem.ItemType.set);
    }

    public static String extractContextInfo(String outputPageXML, Pattern tableStartPattern, Pattern tableEndPattern) {
        Matcher endOfTableMatcher;
        String returnValue = null;
        Matcher startOfTableMatcher = tableStartPattern.matcher(outputPageXML);
        if (startOfTableMatcher.find() && (endOfTableMatcher = tableEndPattern.matcher(returnValue = outputPageXML.substring(startOfTableMatcher.end() - 1))).find()) {
            return returnValue.substring(0, endOfTableMatcher.start() + 1);
        }
        return null;
    }

    public boolean createNumeric_ReportMethod(ActionEnv env, QueryItemProperties properties) throws ActionException {
        if (!env.hasCognosServiceInterface()) {
            return false;
        }
        if (properties == null) {
            throw new ActionException("properties must be defined to call createNumeric!");
        }
        CognosServiceOptions options = new CognosServiceOptions();
        options.addOption("run.xslURL", "null.xsl");
        options.addOption("asynch.primaryWaitThreshold", "0");
        CognosServiceResponse response = null;
        try {
            env.addEventTiming("numeric? (rpt):" + this._queryItem.attributeValue("name"), "2");
            V5ConfirmIsNumericRequest confirmIsNumericRequest = new V5ConfirmIsNumericRequest(this._report, this._query, this._queryItem);
            confirmIsNumericRequest.create();
            response = env.getRapServiceRequestManager().runReportSpecification(confirmIsNumericRequest.getDocument().asXML(), options);
        }
        catch (CognosServiceRequestAuthException authException) {
            throw authException;
        }
        catch (CognosServiceRequestWorkingStatusException statusException) {
            throw statusException;
        }
        catch (CognosServiceRequestException e) {
            RAPLogger.info(e.getMessage(), V5ItemUpgrader.class);
        }
        if (response != null) {
            String contextData = response.getJSONContextDataBlock();
            String metaData = response.getJSONMetaDataBlock();
            boolean contextInitialized = properties.initializeFromJSONContextTables(contextData, metaData);
            properties.setNumeric(contextInitialized);
            properties.saveJSONXMLAttribute(this._queryItem, false);
            return contextInitialized;
        }
        properties.setNumeric(false);
        properties.saveJSONXMLAttribute(this._queryItem, false);
        return false;
    }

    public boolean createNumeric_GetParametersMethod(ActionEnv env, QueryItemProperties properties) throws ActionException {
        if (!env.hasCognosServiceInterface()) {
            return false;
        }
        if (properties == null) {
            throw new ActionException("properties must be defined to call createNumeric!");
        }
        CognosServiceOptions options = new CognosServiceOptions();
        options.addOption("asynch.primaryWaitThreshold", "0");
        CognosServiceResponse response = null;
        String parameterName = null;
        try {
            env.addEventTiming("numeric? (getParms):" + this._queryItem.attributeValue("name"), "2");
            V5ConfirmIsNumericRequest confirmIsNumericRequest = new V5ConfirmIsNumericRequest(this._report, this._query, this._queryItem);
            confirmIsNumericRequest.createGetParametersSpecification();
            response = env.getRapServiceRequestManager().runGetParametersSpecification(confirmIsNumericRequest.getDocument().asXML(), options);
            parameterName = confirmIsNumericRequest.getParameterName();
        }
        catch (CognosServiceRequestAuthException authException) {
            throw authException;
        }
        catch (CognosServiceRequestWorkingStatusException statusException) {
            throw statusException;
        }
        catch (CognosServiceRequestException e) {
            RAPLogger.info(e.getMessage(), V5ItemUpgrader.class);
        }
        if (response != null) {
            try {
                JSONObject params = JSONObject.parse((String)response.getValue());
                JSONObject parm = (JSONObject)params.get(parameterName);
                if (parm != null) {
                    String type = (String)parm.get((Object)"type");
                    if (CCLDbTypesInfo.isKnownNumericTypeString(type)) {
                        properties.setNumeric(true);
                        String modelItem = (String)parm.get((Object)"modelItem");
                        if (modelItem != null) {
                            properties.setModelItem(modelItem);
                        }
                        properties.saveJSONXMLAttribute(this._queryItem, false);
                        return true;
                    }
                    if (CCLDbTypesInfo.isKnownDateTypeString(type)) {
                        properties.setNumeric(false);
                        properties.setDateTime(true);
                        String modelItem = (String)parm.get((Object)"modelItem");
                        if (modelItem != null) {
                            properties.setModelItem(modelItem);
                        }
                        properties.saveJSONXMLAttribute(this._queryItem, false);
                        return true;
                    }
                }
                properties.setNumeric(false);
                properties.saveJSONXMLAttribute(this._queryItem, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public Document createV5SetInfoReport() throws ActionException {
        try {
            Element reportPageContents = this.createV5ReportPageContents();
            V5SpecHelper.setXMLAttribute(reportPageContents.getDocument().getRootElement(), "confirmIsSet", this._queryItem.attributeValue("name"), "no");
            Element listNode = reportPageContents.addElement("list");
            listNode.addAttribute("name", "confirmIsSet");
            listNode.addAttribute("refQuery", this._query.getQueryName());
            Element listColumns = listNode.addElement("listColumns");
            V5Query newDocQuery = new V5Query();
            newDocQuery.focusQuery(listColumns, this._query.getQueryName());
            String listSeparator = V5SpecHelper.getListSeparator(this._query.getQuerySelection().getDocument());
            Element qi_firstItem = newDocQuery.getItemList().addDataItem("__firstItem__", "subset([" + this._queryItem.attributeValue("name") + "]" + listSeparator + " 0" + listSeparator + " 2)");
            V5QueryFilters.disableFilters(newDocQuery.getQueryElement().getDocument().getRootElement());
            Element hun = newDocQuery.getItemList().addDataItem("__hunFirstItem__", "roleValue('_hierarchyUniqueName'" + listSeparator + "[" + qi_firstItem.attributeValue("name") + "])");
            Element dun = newDocQuery.getItemList().addDataItem("__dunFirstItem__", "roleValue('_dimensionUniqueName'" + listSeparator + "[" + qi_firstItem.attributeValue("name") + "])");
            this.addRefColumn(listColumns, qi_firstItem);
            this.addRefColumn(listColumns, hun);
            this.addRefColumn(listColumns, dun);
            return listColumns.getDocument();
        }
        catch (Exception e) {
            throw new ActionException("upgrade error");
        }
    }

    public Element createV5ReportPageContents() throws ActionException {
        try {
            Element newRootElement = V5SpecHelper.shallowCopy(this._report);
            Element sourceModelPath = this._report.element("modelPath");
            Element cloneModelPath = (Element)sourceModelPath.clone();
            newRootElement.add(cloneModelPath);
            Document newDoc = DocumentHelper.createDocument((Element)newRootElement);
            Element queries = (Element)this._report.selectSingleNode(".//*[local-name()='queries']");
            Element newQueries = (Element)queries.clone();
            newRootElement.add(newQueries);
            V5Query.removeAllDynamicDataFilters(newRootElement, false);
            Element pageNode = DocumentHelper.makeElement((Branch)newDoc.getRootElement(), (String)"layouts/layout/reportPages/page");
            pageNode.addAttribute("name", "Page1");
            Element pageContentsNode = DocumentHelper.makeElement((Branch)pageNode, (String)"pageBody/contents");
            return pageContentsNode;
        }
        catch (Exception e) {
            throw new ActionException("upgrade error");
        }
    }

    private void addRefColumn(Element listColumns, Element queryItemRef) {
        Element listColumn = listColumns.addElement("listColumn");
        DocumentHelper.makeElement((Branch)listColumn, (String)"listColumnTitle/contents");
        Element bodyDataItemValueNode = DocumentHelper.makeElement((Branch)listColumn, (String)"listColumnBody/contents/textItem/dataSource/dataItemValue");
        bodyDataItemValueNode.addAttribute("refDataItem", queryItemRef.attributeValue("name"));
    }

    public String getItemExpression() {
        return this._queryItemExpression;
    }

    public Element getQueryItem() {
        return this._queryItem;
    }

    static class V5SetInfoReport_Columns {
        public static int _firstItemOfSet = 0;
        public static int _hun = 1;
        public static int _dun = 2;
        public static int _hierarchyCaption = 3;

        V5SetInfoReport_Columns() {
        }
    }
}

