/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SortArgument;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeHelper;
import com.cognos.rap.actions.v5spechelpers.ChangeDisplayTypeRulesProcessor;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5ListColumn;
import com.cognos.rap.actions.v5spechelpers.V5ListGroup;
import com.cognos.rap.actions.v5spechelpers.V5ListGroups;
import com.cognos.rap.actions.v5spechelpers.V5MasterDetailLinkUpdater;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public class V5List
extends V5DataContainer {
    private ActionEnv actionEnv = null;
    private ArrayList<Element> nodes = null;
    private ArrayList<Element> nodesWithListGroup = null;

    public V5List(Element listDataContainer) {
        this._container = listDataContainer;
        this._typeID = V5DataContainer.containerTypeID.list;
    }

    @Override
    public Element findItem(String rdiName) {
        Element elementWithSameRDI = this.selectSingleNode("//V5X//CHILD", "listColumns", "listColumn", "listColumnBody", "contents", "//V5X//ANY", "textItem", "dataSource", "dataItemValue", "//V5X//ATTR", "refDataItem", rdiName);
        if (elementWithSameRDI != null) {
            return V5SpecHelper.getAncestor(elementWithSameRDI, "listColumn");
        }
        return null;
    }

    @Override
    public Element findItemLabelByRDI(String dataItemName) {
        List<Element> rdiChildrenOfListColumn = this.selectNodes("//V5X//CHILD", "listColumns", "listColumn", "listColumnBody", "//V5X//ANY", "//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", dataItemName);
        Iterator<Element> iterator = rdiChildrenOfListColumn.iterator();
        if (iterator.hasNext()) {
            Element rdiChildOfListColumn = iterator.next();
            Element listColumn = V5SpecHelper.getAncestor(rdiChildOfListColumn, "listColumn");
            return V5DataContainer.selectSingleNode(this._container, listColumn, "//V5X//CHILD", "listColumnTitle", "contents", "textItem");
        }
        return null;
    }

    @Override
    public Element findItemLabel(Element listColumn) {
        return V5DataContainer.selectSingleNode(this._container, listColumn, "//V5X//CHILD", "listColumnTitle", "contents", "textItem");
    }

    @Override
    public Element findItemLabelByLayoutTag(String tag) {
        Element layoutItem = this.findLayoutItemByTag(tag);
        if (layoutItem != null && "listColumn".equals(layoutItem.getName())) {
            return V5X.selectSingleNode(layoutItem, "//V5X//CHILD", "listColumnTitle", "contents", "textItem");
        }
        return null;
    }

    @Override
    public boolean isListColumnTitleNode(Element layoutElement) {
        boolean isListColumnTitleNode = false;
        if ("listColumnTitle".equals(layoutElement.getName())) {
            isListColumnTitleNode = true;
        } else {
            Element search;
            for (search = layoutElement.getParent(); search != null && !"listColumnTitle".equals(search.getName()) && !"list".equals(search.getName()); search = search.getParent()) {
            }
            if (search != null) {
                isListColumnTitleNode = "listColumnTitle".equals(search.getName());
            }
        }
        return isListColumnTitleNode;
    }

    @Override
    public Element findListGroup(String rdiName) {
        if (rdiName == null) {
            return null;
        }
        return V5X.selectSingleNode(this._container, "//V5X//CHILD", "listGroups", "listGroup", "//V5X//ATTR", "refDataItem", rdiName);
    }

    private Element findListColumnRowSpan(String rdiName) {
        return this.selectSingleNode("listColumnBody", "//V5X//CHILD", "listColumnRowSpan", "//V5X//ATTR", "refDataItem", rdiName);
    }

    public Element insertColumnAfter(String sDataItemName, String sNewNodeRDI) throws ActionException {
        try {
            Element insertionPoint = this.findItem(sDataItemName);
            Element newListColumn = null;
            if (insertionPoint != null) {
                newListColumn = (Element)insertionPoint.clone();
                List rdiNodes = newListColumn.selectNodes(".//*[@refDataItem=" + V5X.safeValue(sDataItemName) + "]");
                for (int i = 0; i < rdiNodes.size(); ++i) {
                    Element rdiNode = (Element)rdiNodes.get(i);
                    Attribute rdiAttribute = rdiNode.attribute("refDataItem");
                    rdiNode.remove(rdiAttribute);
                    rdiNode.addAttribute("refDataItem", sNewNodeRDI);
                }
                List conditionalStyleNodes = newListColumn.selectNodes(".//*[local-name()='conditionalStyles']");
                for (int i = 0; i < conditionalStyleNodes.size(); ++i) {
                    Element conditionalStyleNode = (Element)conditionalStyleNodes.get(i);
                    conditionalStyleNode.getParent().remove(conditionalStyleNode);
                }
                Element clonedListColumnRowSpan = (Element)newListColumn.selectSingleNode("./*[local-name()='listColumnBody']/*[local-name()='listColumnRowSpan']");
                if (clonedListColumnRowSpan != null) {
                    clonedListColumnRowSpan.getParent().remove(clonedListColumnRowSpan);
                }
                int nInsertionIndex = V5List.insertLayoutElementAfter(insertionPoint, newListColumn);
                V5ListGroups listGroups = new V5ListGroups(this._container);
                listGroups.insertColumn(nInsertionIndex);
            }
            return newListColumn;
        }
        catch (Exception e) {
            throw new ActionException();
        }
    }

    @Override
    public void tagSortedLayoutItems() {
        int i;
        this.removeSortTags();
        ArrayList<SortArgument> sortedItems = new ArrayList<SortArgument>();
        List listGroups = this._container.selectNodes("./*[local-name()='listGroups']/*");
        for (int i2 = 0; i2 < listGroups.size(); ++i2) {
            Element listGroup = (Element)listGroups.get(i2);
            if (listGroup.elements("sortList").size() <= 0) continue;
            String sortOrder = listGroup.element("sortList").element("sortItem").attributeValue("sortOrder");
            sortedItems.add(new SortArgument(sortOrder, listGroup.attributeValue("refDataItem")));
        }
        List sortItems = this._container.selectNodes("./*[local-name()='sortList']/*");
        for (i = 0; i < sortItems.size(); ++i) {
            Element sortItem = (Element)sortItems.get(i);
            sortedItems.add(new SortArgument(sortItem.attributeValue("sortOrder"), sortItem.attributeValue("refDataItem")));
        }
        for (i = 0; i < sortedItems.size(); ++i) {
            SortArgument sortArgument = (SortArgument)sortedItems.get(i);
            String tagValue = sortedItems.size() <= 1 ? sortArgument.getOrderTagValue() : sortArgument.getOrderTagValue() + "." + (i + 1);
            this.tagLayoutItem(sortArgument.getRefDataItem(), "rp_sort", tagValue);
        }
    }

    private void tagLayoutItem(String layoutItemName, String tagName, String tagValue) {
        Element insertionPoint = (Element)this._container.selectSingleNode(".//*[local-name()='listColumnTitle']//*[@refDataItem=" + V5X.safeValue(layoutItemName) + "]");
        if (insertionPoint != null) {
            insertionPoint = (Element)insertionPoint.selectSingleNode("ancestor::*[local-name()='listColumnTitle']");
        } else {
            insertionPoint = (Element)this._container.selectSingleNode(".//*[local-name()='listColumnBody']//*[@refDataItem=" + V5X.safeValue(layoutItemName) + "]");
            if (insertionPoint != null) {
                insertionPoint = (Element)insertionPoint.selectSingleNode("ancestor::*[local-name()='listColumn']/*[local-name()='listColumnTitle']");
            }
        }
        if (insertionPoint != null) {
            V5SpecHelper.setXMLAttribute(insertionPoint, tagName, tagValue, "HTML");
        }
    }

    @Override
    public void addSortList(String columnName, String sortOrder) {
        Element sortItem = this.getOrAddSortItem(columnName);
        if (sortItem != null) {
            sortItem.addAttribute("refDataItem", columnName);
            sortItem.addAttribute("sortOrder", sortOrder);
            if (this.isSingleRowDetails(this.getActionEnv())) {
                this.addSortListToInnerMostGroup(sortItem);
            }
        }
    }

    @Override
    public void addSortList(String columnName, String sortedDataItemName, String sortOrder) {
        Element sortItem = this.getOrAddSortItem(columnName);
        if (sortItem != null) {
            sortItem.addAttribute("refDataItem", sortedDataItemName);
            sortItem.addAttribute("sortOrder", sortOrder);
            if (this.isSingleRowDetails(this.getActionEnv())) {
                this.addSortListToInnerMostGroup(sortItem);
            }
        }
    }

    private void addSortListToInnerMostGroup(Element sortItem) {
        Element eleSortItemParent;
        Element eleInnermostListGroup;
        if (sortItem != null && (eleInnermostListGroup = this.getInnermostListGroup()) != null && (eleSortItemParent = sortItem.getParent()) != null && eleSortItemParent.getName().equals("sortList")) {
            Element eleSortListCopy = eleSortItemParent.createCopy();
            Element eleInnermostGroup = eleInnermostListGroup;
            Element eleSortList = eleInnermostGroup.element("sortList");
            if (eleSortList != null) {
                eleInnermostGroup.remove(eleSortList);
            }
            eleInnermostGroup.add(eleSortListCopy);
        }
    }

    private Element getOrAddSortItem(String columnName) {
        Element sortList;
        V5Query v5query = this.getV5Query();
        if (v5query == null || v5query.findItem(columnName) == null) {
            return null;
        }
        Element mainSortListItem = V5X.selectSingleNode(this._container, "//V5X//CHILD", "sortList", "sortItem", "//V5X//ATTR", "refDataItem", columnName);
        if (mainSortListItem != null) {
            return mainSortListItem;
        }
        Element insertionPoint = V5X.selectSingleNode(this._container, "listGroup", "//V5X//ATTR", "refDataItem", columnName);
        if (insertionPoint == null) {
            insertionPoint = this._container;
        }
        if ((sortList = insertionPoint.element("sortList")) != null && insertionPoint != this._container) {
            sortList.detach();
            sortList = null;
        }
        if (sortList == null) {
            sortList = insertionPoint.addElement("sortList");
        }
        return sortList.addElement("sortItem");
    }

    @Override
    public void removeSortList(String columnName) throws ActionException {
        Element sortList;
        if (!this._removeSortList(this._container, columnName) && (sortList = this.selectSingleNode("listGroup", "//V5X//OR", "listOverallGroup", "//V5X//ATTR", "refDataItem", columnName, "sortList")) != null) {
            sortList.detach();
        }
        this._removeSortList(this.getInnermostListGroup(), columnName);
    }

    private Element getInnermostListGroup() {
        List list = V5X.selectNodes(this._container, "listGroup");
        if (!list.isEmpty()) {
            return (Element)list.get(list.size() - 1);
        }
        return null;
    }

    private boolean _removeSortList(Element containerNode, String columnName) {
        Element sortItem;
        boolean removed = false;
        if (containerNode != null && (sortItem = V5X.selectSingleNode(containerNode, "//V5X//CHILD", "sortList", "sortItem", "//V5X//ATTR", "refDataItem", columnName)) != null) {
            Element sortList = sortItem.getParent();
            sortItem.detach();
            removed = true;
            if (sortList != null && sortList.elements().size() == 0) {
                sortList.detach();
            }
        }
        return removed;
    }

    private void removeSortTags() {
        List columns = this._container.selectNodes(".//*[local-name() ='listColumn']/*[local-name()='listColumnTitle'][.//@name='rp_sort']");
        for (int i = 0; i < columns.size(); ++i) {
            V5SpecHelper.removeXMLAttribute((Element)columns.get(i), "rp_sort");
        }
    }

    public void toggleColumnGrouping(ActionEnv env, String columnName) throws ActionException {
        this.actionEnv = env;
        Element listColumn = this.findItem(columnName);
        Element listGroup = this.findListGroup(columnName);
        if (listGroup == null) {
            this.groupColumn(listColumn, columnName);
        } else {
            this.ungroupColumn(listColumn, listGroup, columnName);
        }
    }

    public List<SelectedCell> prepareSelectionsForGrouping(List<SelectedCell> selectedCells) {
        if (selectedCells.size() == 1) {
            return selectedCells;
        }
        boolean allAreUngrouped = true;
        boolean allAreGrouped = true;
        ArrayList<SelectedCell> ungroupedCells = new ArrayList<SelectedCell>();
        HashMap<String, SelectedCell> groupedCells = new HashMap<String, SelectedCell>();
        HashSet<String> columnNames = new HashSet<String>();
        for (SelectedCell cell : selectedCells) {
            if (columnNames.contains(cell.nodeName)) continue;
            columnNames.add(cell.nodeName);
            if (this.findListGroup(cell.nodeName) != null) {
                allAreUngrouped = false;
                groupedCells.put(cell.nodeName, cell);
                continue;
            }
            allAreGrouped = false;
            ungroupedCells.add(cell);
        }
        if (allAreUngrouped) {
            return ungroupedCells;
        }
        if (!allAreGrouped) {
            return ungroupedCells;
        }
        ArrayList<SelectedCell> finalSelectedCells = new ArrayList<SelectedCell>();
        List groups = V5X.selectNodes(this._container, "//V5X//CHILD", "listGroups", "listGroup");
        if (groups != null) {
            for (int i = groups.size() - 1; i >= 0; --i) {
                Element group = (Element)groups.get(i);
                SelectedCell groupedCell = (SelectedCell)groupedCells.get(group.attributeValue("refDataItem"));
                if (groupedCell == null) continue;
                finalSelectedCells.add(groupedCell);
            }
        }
        return finalSelectedCells;
    }

    private void groupColumn(Element listColumn, String columnName) throws ActionException {
        Element listColumnRowSpan;
        Element detailSortItemForColumn;
        Element targetColumn = null;
        boolean bMoveAndAggregateColumn = true;
        V5ListGroups v5ListGroups = new V5ListGroups(this._container);
        try {
            targetColumn = v5ListGroups.findLastGroupedColumnInWellFormedList();
        }
        catch (Exception e) {
            bMoveAndAggregateColumn = false;
        }
        Element newListGroups = DocumentHelper.makeElement((Branch)this._container, (String)"listGroups");
        Element newListGroup = newListGroups.addElement("listGroup");
        newListGroup.addAttribute("refDataItem", columnName);
        Element detailSortList = this._container.element("sortList");
        if (detailSortList != null && (detailSortItemForColumn = V5X.selectSingleNode(detailSortList, "//V5X//CHILD", "sortItem", "//V5X//ATTR", "refDataItem", columnName)) != null) {
            detailSortItemForColumn.detach();
            Element newSortList = newListGroup.addElement("sortList");
            newSortList.add(detailSortItemForColumn);
            if (detailSortList.elements().size() == 0) {
                detailSortList.detach();
            }
        }
        if ((listColumnRowSpan = this.findListColumnRowSpan(columnName)) == null) {
            Element newListColumnRowSpan = DocumentHelper.makeElement((Branch)listColumn, (String)"listColumnBody/listColumnRowSpan");
            newListColumnRowSpan.addAttribute("refDataItem", columnName);
        }
        if (bMoveAndAggregateColumn) {
            int toColumnIndex = this.moveColumn(listColumn, targetColumn);
            this.addTotalFooterRow(newListGroup, toColumnIndex, columnName);
        }
    }

    private boolean isSingleRowDetails(ActionEnv env) {
        boolean isSingleRowDetails = true;
        List<Element> listColumns = this.selectNodes("listColumn");
        if (listColumns != null) {
            for (int columnIndex = 0; columnIndex < listColumns.size(); ++columnIndex) {
                V5QueryItem queryItem;
                Element e;
                String rdi = new V5ListColumn(listColumns.get(columnIndex)).getDataItemName();
                if (rdi == null || this.findListGroup(rdi) != null || (e = this.getV5Query().findItem(rdi)) == null || this.isNumericAndMeasureOrCal(queryItem = new V5QueryItem(env, this.getV5Query(), e))) continue;
                isSingleRowDetails = false;
                break;
            }
        }
        return isSingleRowDetails;
    }

    private boolean isNumericAndMeasureOrCal(V5QueryItem queryItem) {
        try {
            V5QueryItem.NumericSubType subType;
            queryItem.setEvaluateSpecOnly(true);
            if (queryItem.confirmIsNumeric() && ((subType = queryItem.getNumericSubType()).equals((Object)V5QueryItem.NumericSubType.measure) || subType.equals((Object)V5QueryItem.NumericSubType.calculation) || subType.equals((Object)V5QueryItem.NumericSubType.calculationOrAggregate))) {
                return true;
            }
        }
        catch (ActionException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void addTotalFooterRow(Element listGroup, int toColumnIndex, String columnName) throws ActionException {
        V5Query v5Query = new V5Query();
        Element queries = (Element)this._container.selectSingleNode("ancestor::*[local-name()='report']");
        if (v5Query.focusQuery(queries, this._container.attributeValue("refQuery"))) {
            List listColumns = this._container.selectNodes(".//*[local-name()='listColumn']");
            Element groupFooterRowCells = V5ListGroup.startGroupFooterRow(listGroup);
            int colSpan = 1;
            String dataItemRDI = columnName;
            String footerStyle = "if";
            String summaryStyle = "is";
            if (listGroup.getParent().indexOf((Node)listGroup) == 0) {
                footerStyle = "of";
                summaryStyle = "os";
            }
            int columnIndexOfThisList = 0;
            for (int columnIndex = 0; columnIndex < listColumns.size(); ++columnIndex) {
                V5QueryItem queryItem;
                Element listColumn = (Element)listColumns.get(columnIndex);
                Element detailContainer = V5SpecHelper.findParentContainer(listColumn);
                if (detailContainer != this._container || ++columnIndexOfThisList - 1 < toColumnIndex + 1) continue;
                V5ListColumn v5ListColumn = new V5ListColumn(listColumn);
                String rdi = v5ListColumn.getDataItemName();
                Element aggregateDataItem = null;
                if (rdi != null && (queryItem = new V5QueryItem(this.actionEnv, v5Query, v5Query.findItem(rdi))).confirmIsNumeric() && queryItem.getNumericSubType().equals((Object)V5QueryItem.NumericSubType.measure)) {
                    aggregateDataItem = v5Query.addListTotalDataItem(rdi);
                }
                if (aggregateDataItem != null) {
                    if (colSpan > 0) {
                        V5ListGroup.addGroupFooterRowCell(groupFooterRowCells, colSpan, dataItemRDI, footerStyle);
                        colSpan = 0;
                        dataItemRDI = null;
                    }
                    V5ListGroup.addGroupFooterRowCell(groupFooterRowCells, 1, aggregateDataItem.attributeValue("name"), summaryStyle);
                    continue;
                }
                ++colSpan;
            }
            if (colSpan > 0) {
                V5ListGroup.addGroupFooterRowCell(groupFooterRowCells, colSpan, dataItemRDI, "of");
            }
        }
    }

    private void ungroupColumn(Element listColumn, Element listGroup, String columnName) {
        Element listColumnRowSpan = this.findListColumnRowSpan(columnName);
        if (listColumnRowSpan != null) {
            Element lastGroupedColumn = this.getLastGroupedColumn();
            Element groupSortOnColumn = V5X.selectSingleNode(listGroup, "sortList", "sortItem", "//V5X//ATTR", "refDataItem", columnName);
            if (groupSortOnColumn != null) {
                groupSortOnColumn.detach();
                Element detailSortList = V5X.selectSingleNode(this._container, "//V5X//CHILD", "sortList");
                if (detailSortList == null) {
                    detailSortList = this._container.addElement("sortList");
                }
                V5List.insertFirstChildElement(detailSortList, groupSortOnColumn);
            }
            Element listGroups = listGroup.getParent();
            listGroups.remove(listGroup);
            if (listGroups.elements().size() == 0) {
                listGroups.getParent().remove(listGroups);
            }
            listColumnRowSpan.getParent().remove(listColumnRowSpan);
            if (lastGroupedColumn != null && lastGroupedColumn != listColumn) {
                this.moveColumn(listColumn, lastGroupedColumn);
            }
        }
    }

    private Element getLastGroupedColumn() {
        Element lastGroupedColumn = null;
        List<Element> listColumnRowSpans = this.selectNodes("listColumnBody", "//V5X//CHILD", "listColumnRowSpan");
        if (listColumnRowSpans.size() > 0) {
            lastGroupedColumn = V5SpecHelper.getAncestor(listColumnRowSpans.get(listColumnRowSpans.size() - 1), "listColumn");
        }
        return lastGroupedColumn;
    }

    public String columnBodyRDIName(Element column) {
        Element columnBodyRDINode;
        if (column != null && (columnBodyRDINode = (Element)column.selectSingleNode(".//*[local-name()='listColumnBody']//*[local-name()='dataItemValue']")) != null) {
            return columnBodyRDINode.attributeValue("refDataItem");
        }
        return null;
    }

    @Override
    public String getRDIName(Element columnOrListGroup) {
        String result = this.columnBodyRDIName(columnOrListGroup);
        return result != null ? result : this.getlistGroupRDIName(columnOrListGroup);
    }

    private String getlistGroupRDIName(Element listGroup) {
        if (listGroup != null && listGroup.getName().equals("listGroup")) {
            return listGroup.attributeValue("refDataItem");
        }
        return null;
    }

    public ArrayList<Element> collectNodes() {
        if (this.nodes == null) {
            this.nodes = (ArrayList)XMLUtility.selectNodes(this._container, ".//*[local-name()='listColumn']");
        }
        return this.nodes;
    }

    public ArrayList<Element> collectItemInfo() {
        if (this.nodesWithListGroup == null) {
            this.nodesWithListGroup = (ArrayList)XMLUtility.selectNodes(this._container, ".//*[local-name()='listColumn' or local-name()='listGroup']");
        }
        return this.nodesWithListGroup;
    }

    public ArrayList<Element> collectEdgeNodes() {
        List<Element> sortableList = this.selectNodes("listGroup");
        sortableList.add(this._container);
        return (ArrayList)sortableList;
    }

    private int columnIndex(Element column) {
        if (column.getParent() != null) {
            List columns = column.getParent().elements("listColumn");
            return columns.indexOf(column);
        }
        return -1;
    }

    public Element columnBefore(String columnId) {
        if (columnId != null) {
            int columnIndex;
            Element column = this.findLayoutItemByTag(columnId);
            if (column == null) {
                column = this.findItem(columnId);
            }
            if ((columnIndex = this.columnIndex(column)) > 0) {
                List columnList = V5X.selectNodes(this._container, "//V5X//CHILD", "listColumns", "listColumn");
                return (Element)columnList.get(columnIndex - 1);
            }
        }
        return null;
    }

    public void reorderColumn(ActionEnv env, String fromColumnTag, String afterColumnTag) {
        Element afterColumn;
        this.actionEnv = env;
        Element fromColumn = this.findLayoutItemByTag(fromColumnTag);
        if (fromColumn == null && (fromColumn = this.findItem(fromColumnTag)) == null) {
            Element dataItemValue;
            if (fromColumnTag != null && fromColumnTag.length() != -1 && (dataItemValue = this.findRDINodeByStaticTextTitle(this.actionEnv, fromColumnTag, null)) != null) {
                fromColumn = V5SpecHelper.getAncestor(dataItemValue, "listColumn");
            }
            if (fromColumn == null) {
                RAPLogger.info("RAP_INT: Invalid source column " + fromColumnTag, V5List.class);
                return;
            }
        }
        if ((afterColumn = this.findLayoutItemByTag(afterColumnTag)) == null) {
            afterColumn = this.findItem(afterColumnTag);
        }
        if (fromColumn.equals(afterColumn)) {
            return;
        }
        V5ListGroups listGroups = new V5ListGroups(this._container);
        Element clone = (Element)fromColumn.clone();
        if (afterColumn == null) {
            Element fromColumnParent = fromColumn.getParent();
            fromColumn.getParent().remove(fromColumn);
            V5List.insertFirstChildElement(fromColumnParent, clone);
        } else {
            fromColumn.getParent().remove(fromColumn);
            V5List.insertLayoutElementAfter(afterColumn, clone);
        }
        listGroups.reOrder(fromColumnTag, afterColumnTag);
    }

    public int moveColumn(Element fromColumn, Element toColumn) {
        int fromColumnIndex = this.columnIndex(fromColumn);
        int toColumnIndex = 0;
        if (toColumn == null) {
            if (fromColumnIndex != 0) {
                Element fromColumnParent = fromColumn.getParent();
                Element clone = (Element)fromColumn.clone();
                fromColumn.getParent().remove(fromColumn);
                V5ListGroups listGroups = new V5ListGroups(this._container);
                listGroups.deleteColumn(fromColumnIndex);
                V5List.insertFirstChildElement(fromColumnParent, clone);
                listGroups.insertColumn(0);
            }
        } else {
            toColumnIndex = this.columnIndex(toColumn) + 1;
            if (fromColumnIndex != toColumnIndex) {
                Element clone = (Element)fromColumn.clone();
                fromColumn.getParent().remove(fromColumn);
                V5List.insertLayoutElementAfter(toColumn, clone);
                V5ListGroups listGroups = new V5ListGroups(this._container);
                if (toColumnIndex > fromColumnIndex) {
                    --fromColumnIndex;
                    --toColumnIndex;
                }
                listGroups.deleteColumn(fromColumnIndex);
                listGroups.insertColumn(toColumnIndex);
            }
        }
        return toColumnIndex;
    }

    @Override
    public void delete(SelectedCell selectedCell) {
        if (selectedCell.rapLayoutTag != null) {
            V5ListColumn v5ListColumn;
            String rdi;
            Element layoutElement = this.findLayoutItemByTag(selectedCell.rapLayoutTag);
            if (layoutElement != null && "listColumn".equals(layoutElement.getName()) && (rdi = (v5ListColumn = new V5ListColumn(layoutElement)).getDataItemName()) != null) {
                this.removeColumn(layoutElement, v5ListColumn.getDataItemName());
            }
            this.delete(selectedCell.rapLayoutTag);
        } else {
            Element column = this.findItem(selectedCell.nodeName);
            this.removeColumn(column, selectedCell.nodeName);
        }
    }

    private void delete(String layoutTag) {
        Element layoutElement = this.findLayoutItemByTag(layoutTag);
        if (layoutElement == null) {
            return;
        }
        if ("listColumn".equals(layoutElement.getName())) {
            this.removeColumn(layoutElement, layoutTag);
        } else if ("rowCells".equals(layoutElement.getName())) {
            ArrayList<String> elementNames = new ArrayList<String>();
            elementNames.add("listGroup");
            elementNames.add("listOverallGroup");
            Element parentOfDeleted = XMLUtility.removeNodeAndEmptyParentChain(layoutElement, elementNames);
            if ("listOverallGroup".equals(parentOfDeleted.getName())) {
                parentOfDeleted.detach();
            }
        }
    }

    public Element findLayoutItemByTag(String layoutTag) {
        Element xmlAttribute = V5X.selectSingleNode(this._container, "XMLAttribute", "//V5X//ATTR", "name", "rap_layout_tag", "//V5X//ATTR", "value", layoutTag);
        if (xmlAttribute != null) {
            Element listColumn = (Element)xmlAttribute.selectSingleNode("../../..[local-name()='listColumn']");
            if (listColumn != null) {
                return listColumn;
            }
            Element rowCells = (Element)xmlAttribute.selectSingleNode("../../..[local-name()='rowCells']");
            if (rowCells != null) {
                return rowCells;
            }
        }
        return null;
    }

    private void removeColumn(Element listColumn, String rdiOrTag) {
        V5ListColumn v5ListColumn;
        String rdi;
        Element listGroup;
        if (rdiOrTag != null) {
            V5ListGroups listGroups = new V5ListGroups(this._container);
            listGroups.deleteColumn(rdiOrTag);
        }
        Element listColumns = listColumn.getParent();
        listColumn.detach();
        if (listColumns.element("listColumn") == null) {
            Object noDataHandler;
            listColumns.detach();
            Element listOverallGroup = this._container.element("listOverallGroup");
            if (listOverallGroup != null) {
                listOverallGroup.detach();
            }
            if ((noDataHandler = this._container.element("noDataHandler")) != null) {
                noDataHandler.detach();
            }
        }
        if (rdiOrTag != null) {
            List sortingInvolvingThisRDI = V5X.selectNodes(this._container, "sortItem", "//V5X//ATTR", "refDataItem", rdiOrTag);
            for (Element sort : sortingInvolvingThisRDI) {
                Element sortListParent;
                if (V5SpecHelper.findParentContainer(sort) != this._container || !"sortList".equals((sortListParent = sort.getParent()).getName())) continue;
                sort.detach();
                if (sortListParent.elements().size() != 0) continue;
                sortListParent.detach();
            }
        }
        if ((listGroup = this.findListGroup(rdiOrTag)) != null) {
            Element listGroupsNode = listGroup.getParent();
            listGroup.detach();
            if (listGroupsNode.elements().size() == 0) {
                listGroupsNode.detach();
            }
        }
        if ((rdi = (v5ListColumn = new V5ListColumn(listColumn)).getDataItemName()) != null) {
            V5SpecHelper.removeContainedMasterDetail(this._container, rdi);
        }
    }

    public void replaceDataItemRefOfListColumn(Element dataItemElement, Element listColumn, V5Query query) {
        Element dataItemValueElement = (Element)listColumn.selectSingleNode(".//*[local-name()='dataItemValue']");
        String oldDataItemRef = dataItemValueElement.attributeValue("refDataItem");
        List elementsWithRDI = XMLUtility.selectNodes(listColumn, ".//*[@refDataItem=" + V5X.safeValue(oldDataItemRef) + "]");
        HashSet<Element> childContainers = new HashSet<Element>();
        for (Object elementWithRDI : elementsWithRDI) {
            Element parentContainer = V5SpecHelper.findParentContainer((Element)elementWithRDI);
            if (parentContainer.attributeValue("name").equals(this.getID())) {
                elementWithRDI.addAttribute("refDataItem", dataItemElement.attributeValue("name"));
                continue;
            }
            childContainers.add(parentContainer);
        }
        List groupElementsWithRDI = XMLUtility.selectNodes(this._container, ".//*[local-name()='listGroups']//*[@refDataItem=" + V5X.safeValue(oldDataItemRef) + "]");
        for (Element groupElementWithRDI : groupElementsWithRDI) {
            groupElementWithRDI.addAttribute("refDataItem", dataItemElement.attributeValue("name"));
        }
        List overallGroupElementsWithRDI = XMLUtility.selectNodes(this._container, ".//*[local-name()='listOverallGroup']//*[@refDataItem=" + V5X.safeValue(oldDataItemRef) + "]");
        for (Element elementWithRDI : overallGroupElementsWithRDI) {
            elementWithRDI.addAttribute("refDataItem", dataItemElement.attributeValue("name"));
        }
        V5MasterDetailLinkUpdater.updateRefDataItemInDetailDataContainers(this, oldDataItemRef, dataItemElement);
    }

    @Override
    public Element changeDisplayType(ActionEnv env) throws ActionException {
        this.actionEnv = env;
        ChangeDisplayTypeHelper.TargetDisplayType targetType = ChangeDisplayTypeHelper.getTargetDisplayType(env.getActionArguments());
        Element newDataContainerElement = null;
        if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.crosstab) {
            newDataContainerElement = this.convertToCrosstab(env);
        } else if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.chart) {
            Element crosstabElement = this.convertToCrosstab(env);
            V5Crosstab v5Crosstab = new V5Crosstab(crosstabElement);
            newDataContainerElement = v5Crosstab.changeDisplayType(env);
        } else if (targetType == ChangeDisplayTypeHelper.TargetDisplayType.list) {
            return this.getContainerElement();
        }
        if (newDataContainerElement != null) {
            ChangeDisplayTypeRulesProcessor rulesProcessor = new ChangeDisplayTypeRulesProcessor(env);
            rulesProcessor.applyChartConversionRules(this.getContainerElement(), newDataContainerElement);
            ChangeDisplayTypeHelper.stripConversionRulesNodes(newDataContainerElement);
            ChangeDisplayTypeHelper.setDataContainerName(newDataContainerElement, this._container.attributeValue("name"), env.getActionArguments());
            return newDataContainerElement;
        }
        return super.changeDisplayType(env);
    }

    @Override
    public void prepareForVisCoach(ActionEnv actionEnv) throws ActionException {
        Element parentContainer;
        if (this._container.element("masterDetailLinks") == null && (parentContainer = V5SpecHelper.findParentContainer(this._container)) != null && "list".equals(parentContainer.getName())) {
            this.createMasterDetailLinkWithSectionHeader(this._container);
        }
        super.prepareForVisCoach(actionEnv);
    }

    private Element convertToCrosstab(ActionEnv env) throws ActionException {
        Element lastListColumnCrosstabColumns;
        String hun;
        ArrayList<Element> crosstabColumns = new ArrayList<Element>();
        ArrayList<Element> crosstabRows = new ArrayList<Element>();
        ArrayList<Element> crosstabMeasures = new ArrayList<Element>();
        HashMap<String, List<Element>> columnsHUNSet = new HashMap<String, List<Element>>();
        HashMap<String, List<Element>> rowsHUNSet = new HashMap<String, List<Element>>();
        HashMap<Element, String> listColumnHUNMap = new HashMap<Element, String>();
        List listColumnNodes = V5X.selectNodes(this.getContainerElement(), "//V5X//CHILD", "listColumns", "listColumn");
        for (Element currentListColumn : listColumnNodes) {
            Element listColumnRowSpan;
            String rdi = new V5ListColumn(currentListColumn).getDataItemName();
            if (rdi == null) continue;
            Element dataItem = this.getV5Query().findItem(rdi);
            V5QueryItem queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), dataItem);
            boolean isSet = queryItem.confirmIsSet();
            String hun2 = V5Query.getExtendedDataItemProperty(dataItem, "HUN");
            if (hun2 == null) {
                hun2 = queryItem.getProperties()._hun;
            }
            if ((listColumnRowSpan = (Element)currentListColumn.selectSingleNode(V5X.select("listColumnRowSpan"))) != null) {
                rdi = listColumnRowSpan.attributeValue("refDataItem");
                if (rdi == null || rdi.length() <= 0) continue;
                boolean sameHUNInCrosstabRows = hun2 != null && hun2.length() > 0 && rowsHUNSet.keySet().contains(hun2);
                listColumnHUNMap.put(currentListColumn, hun2);
                if (sameHUNInCrosstabRows) {
                    crosstabRows.add(currentListColumn);
                    this.putInMap(rowsHUNSet, hun2, currentListColumn);
                    continue;
                }
                crosstabColumns.add(currentListColumn);
                this.putInMap(columnsHUNSet, hun2, currentListColumn);
                continue;
            }
            if (queryItem.confirmIsNumeric()) {
                crosstabMeasures.add(currentListColumn);
                continue;
            }
            boolean sameHUNInCrosstabColumns = hun2 != null && hun2.length() > 0 && columnsHUNSet.keySet().contains(hun2);
            listColumnHUNMap.put(currentListColumn, hun2);
            if (sameHUNInCrosstabColumns) {
                crosstabColumns.add(currentListColumn);
                this.putInMap(columnsHUNSet, hun2, currentListColumn);
                continue;
            }
            crosstabRows.add(currentListColumn);
            this.putInMap(rowsHUNSet, hun2, currentListColumn);
        }
        if (crosstabColumns.isEmpty() && crosstabRows.isEmpty() && !crosstabMeasures.isEmpty()) {
            for (Element currentListColumn : crosstabMeasures) {
                Element elementWithRDI = (Element)currentListColumn.selectSingleNode(V5X.selectByAttr("refDataItem"));
                String rdi = elementWithRDI.attributeValue("refDataItem");
                Element dataItem = this.getV5Query().findItem(rdi);
                Attribute aggregateAttribute = dataItem.attribute("aggregate");
                if (aggregateAttribute == null) continue;
                dataItem.remove(aggregateAttribute);
            }
        }
        if (crosstabColumns.isEmpty() && !crosstabRows.isEmpty()) {
            Element lastListColumnCrosstabRows = (Element)crosstabRows.get(crosstabRows.size() - 1);
            hun = (String)listColumnHUNMap.get(lastListColumnCrosstabRows);
            if (hun == null || hun.length() == 0) {
                crosstabColumns.add(lastListColumnCrosstabRows);
                crosstabRows.remove(crosstabRows.size() - 1);
            } else if (rowsHUNSet.get(hun) != null && crosstabRows.size() > ((List)rowsHUNSet.get(hun)).size() || crosstabMeasures.size() > 1 && rowsHUNSet.get(hun) != null && crosstabRows.size() == ((List)rowsHUNSet.get(hun)).size()) {
                for (Element listColumn : (List)rowsHUNSet.get(hun)) {
                    crosstabColumns.add(listColumn);
                    crosstabRows.remove(listColumn);
                }
            }
        } else if (!crosstabColumns.isEmpty() && crosstabRows.isEmpty() && columnsHUNSet.get(hun = (String)listColumnHUNMap.get(lastListColumnCrosstabColumns = (Element)crosstabColumns.get(crosstabColumns.size() - 1))) != null && crosstabColumns.size() > ((List)columnsHUNSet.get(hun)).size()) {
            for (Element listColumn : (List)columnsHUNSet.get(hun)) {
                crosstabRows.add(listColumn);
                crosstabColumns.remove(listColumn);
            }
        }
        Element changedLayoutElement = this.createNewCrosstab(env, crosstabColumns, crosstabRows, crosstabMeasures);
        this.copySuppressionToCrosstab(changedLayoutElement);
        Element parent = this.getContainerElement().getParent();
        int index = parent.indexOf((Node)this.getContainerElement());
        parent.content().add(index, changedLayoutElement);
        this.getContainerElement().detach();
        return changedLayoutElement;
    }

    private void putInMap(Map<String, List<Element>> map, String key, Element element) {
        if (key == null || element == null) {
            return;
        }
        List<Element> elementList = map.get(key);
        if (elementList == null) {
            elementList = new ArrayList<Element>();
            map.put(key, elementList);
        }
        elementList.add(element);
    }

    private void copySuppressionToCrosstab(Element crosstabElement) {
        Element listSuppress = this.getContainerElement().element("listSuppress");
        if (listSuppress == null) {
            return;
        }
        Element crosstabSuppress = (Element)listSuppress.clone();
        crosstabSuppress.setQName(new QName("crosstabSuppress", crosstabSuppress.getNamespace()));
        crosstabElement.add(crosstabSuppress);
        String type = null;
        if (crosstabElement.element("crosstabColumns") != null && crosstabElement.element("crosstabRows") != null) {
            type = "rowsAndColumns";
        } else if (crosstabElement.element("crosstabColumns") != null) {
            type = "columns";
        } else if (crosstabElement.element("crosstabRows") != null) {
            type = "rows";
        }
        if (type != null) {
            crosstabSuppress.addAttribute("type", type);
        }
    }

    private Element createNewCrosstab(ActionEnv env, List<Element> crosstabColumns, List<Element> crosstabRows, List<Element> crosstabMeasures) throws ActionException {
        Element crosstabElement = ChangeDisplayTypeHelper.getNewChartElement("crosstab", this.getContainerElement().getNamespace());
        V5Crosstab v5Crosstab = new V5Crosstab(crosstabElement);
        ChangeDisplayTypeHelper.puffChart(crosstabElement);
        crosstabElement.addAttribute("refQuery", this.getContainerElement().attributeValue("refQuery"));
        ChangeDisplayTypeHelper.fixRefQuery(crosstabElement);
        this.updateCrosstabFromList(v5Crosstab, crosstabColumns, "crosstabColumns");
        this.updateCrosstabFromList(v5Crosstab, crosstabRows, "crosstabRows");
        this.updateCrosstabFromList(v5Crosstab, crosstabMeasures, "crosstabCorner");
        Element parentContainer = V5SpecHelper.findParentContainer(this._container);
        if (parentContainer != null && "list".equals(parentContainer.getName())) {
            this.createMasterDetailLinkWithSectionHeader(crosstabElement);
        }
        return crosstabElement;
    }

    public void updateCrosstabFromList(V5Crosstab v5Crosstab, List<Element> listColumns, String crosstabDimension) throws ActionException {
        Element crosstabElement = v5Crosstab.getCrosstabElement();
        int listColumnsSize = listColumns.size();
        if (listColumnsSize == 0) {
            Element crosstabRowsElement;
            Element crosstabColumnsElement;
            if (crosstabDimension.equals("crosstabColumns") && (crosstabColumnsElement = V5X.selectSingleNode(crosstabElement, "//V5X//CHILD", "crosstabColumns")) != null && crosstabColumnsElement.elements().isEmpty()) {
                crosstabColumnsElement.detach();
            }
            if (crosstabDimension.equals("crosstabRows") && (crosstabRowsElement = V5X.selectSingleNode(crosstabElement, "//V5X//CHILD", "crosstabRows")) != null && crosstabRowsElement.elements().isEmpty()) {
                crosstabRowsElement.detach();
            }
            return;
        }
        Element crosstabNodeRoot = null;
        if (crosstabDimension.equals("crosstabColumns") || crosstabDimension.equals("crosstabRows")) {
            crosstabNodeRoot = crosstabElement.element(crosstabDimension);
        } else if (crosstabDimension.equals("crosstabCorner")) {
            if (listColumnsSize == 1) {
                Element firstColumn = listColumns.get(0);
                String rdi = this.getRDIName(firstColumn);
                if (crosstabElement.element("crosstabRows") != null && crosstabElement.element("crosstabColumns") != null) {
                    Element defaultMeasure = DocumentHelper.makeElement((Branch)crosstabElement, (String)"defaultMeasure");
                    defaultMeasure.addAttribute("refDataItem", rdi);
                    Element crosstabCorner = (Element)crosstabElement.selectSingleNode(V5X.select("crosstabCorner"));
                    if (crosstabCorner != null) {
                        Element contents = (Element)crosstabCorner.selectSingleNode(V5X.select("contents"));
                        if (contents != null) {
                            Element dataItemLabel = DocumentHelper.makeElement((Branch)contents, (String)"textItem/dataSource/dataItemLabel");
                            dataItemLabel.addAttribute("refDataItem", rdi);
                            this.copyListColumnTitleTextItemToCrosstabNodeMember(V5X.selectSingleNode(firstColumn, "textItem"), V5X.selectSingleNode(contents, "textItem"), rdi);
                        }
                        this.copyCrosstabFactCellDataFormat(firstColumn, crosstabCorner);
                    }
                } else {
                    crosstabNodeRoot = crosstabElement.element("crosstabRows") == null ? DocumentHelper.makeElement((Branch)crosstabElement, (String)"crosstabRows") : DocumentHelper.makeElement((Branch)crosstabElement, (String)"crosstabColumns");
                }
            } else {
                Element crosstabNode;
                Element crosstabEdge = crosstabElement.element("crosstabRows") == null && crosstabElement.element("crosstabColumns") != null ? crosstabElement.addElement("crosstabRows") : crosstabElement.element("crosstabColumns");
                Element lastNestedColumn = V5SpecHelper.getInnerMostNestedCrosstabNodes(crosstabEdge);
                if (lastNestedColumn != null) {
                    crosstabNode = (Element)lastNestedColumn.selectSingleNode(V5X.select("crosstabNode"));
                    if (crosstabNode != null) {
                        crosstabNodeRoot = DocumentHelper.makeElement((Branch)crosstabNode, (String)"crosstabNestedNodes");
                    }
                } else {
                    crosstabNodeRoot = crosstabEdge != null ? ((crosstabNode = (Element)crosstabEdge.selectSingleNode(V5X.select("crosstabNode"))) != null ? DocumentHelper.makeElement((Branch)crosstabNode, (String)"crosstabNestedNodes") : crosstabEdge) : DocumentHelper.makeElement((Branch)crosstabElement, (String)"crosstabColumns");
                }
            }
        }
        if (crosstabNodeRoot == null) {
            return;
        }
        for (int i = 0; i < listColumnsSize; ++i) {
            Element currentListColumn = listColumns.get(i);
            if (crosstabDimension.equals("crosstabCorner")) {
                Element newNestedColumn = this.createCrosstabNodeFromListColumn(v5Crosstab, currentListColumn, crosstabNodeRoot);
                if (newNestedColumn == null) continue;
                newNestedColumn.detach();
                continue;
            }
            crosstabNodeRoot = this.createCrosstabNodeFromListColumn(v5Crosstab, currentListColumn, crosstabNodeRoot);
            if (i != listColumnsSize - 1) continue;
            crosstabNodeRoot.detach();
        }
    }

    private Element createCrosstabNodeFromListColumn(V5Crosstab v5Crosstab, Element listColumn, Element crosstabNodeRoot) throws ActionException {
        Element crosstabNestedNodes = null;
        if (crosstabNodeRoot != null) {
            Element crosstabNode = crosstabNodeRoot.addElement("crosstabNode");
            Element crosstabNodeMembers = crosstabNode.addElement("crosstabNodeMembers");
            this.createCrosstabNodeMemberFromListColumn(v5Crosstab, listColumn, crosstabNodeMembers);
            crosstabNestedNodes = crosstabNode.addElement("crosstabNestedNodes");
        }
        return crosstabNestedNodes;
    }

    private void createCrosstabNodeMemberFromListColumn(V5Crosstab v5Crosstab, Element listColumn, Element crosstabNodeMembers) throws ActionException {
        Element crosstabNodeMember = crosstabNodeMembers.addElement("crosstabNodeMember");
        crosstabNodeMember.addAttribute("refDataItem", ((Element)listColumn.selectSingleNode(V5X.select("dataItemValue"))).attributeValue("refDataItem"));
        crosstabNodeMember.addAttribute("edgeLocation", v5Crosstab.nextFreeEdge());
        Element crosstabTextItem = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"contents/textItem");
        DocumentHelper.makeElement((Branch)crosstabTextItem, (String)"dataSource/memberCaption");
        Element textItem = V5X.selectSingleNode(listColumn, "//V5X//CHILD", "listColumnTitle", "contents", "textItem", "//V5X//OR", "richTextItem", "//V5X//OR", "HTMLItem");
        if (textItem != null) {
            this.copyListColumnTitleTextItemToCrosstabNodeMember(textItem, crosstabTextItem, crosstabNodeMember.attributeValue("refDataItem"));
        }
        this.copyAttributes(listColumn, crosstabNodeMember);
        XMLUtility.cloneChildNode(crosstabNodeMember, listColumn, "sortList");
        XMLUtility.cloneChildNode(crosstabNodeMember, listColumn, "propertyList");
        Element style = DocumentHelper.makeElement((Branch)crosstabNodeMember, (String)"style");
        Element defaultStyle = DocumentHelper.makeElement((Branch)style, (String)"defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "ml");
        Element dataFormat = V5X.selectSingleNode(listColumn, "//V5X//CHILD", "style", "dataFormat");
        if (dataFormat != null) {
            style.add((Element)dataFormat.clone());
        }
        this.copyFactCellDataFormat(listColumn, crosstabNodeMember);
    }

    private void copyCrosstabFactCellDataFormat(Element listColumn, Element crosstabNodeMember) {
        Element dataFormatOfListColumnBody = V5X.selectSingleNode(listColumn, "//V5X//CHILD", "listColumnBody", "style", "dataFormat");
        Element dataFormatOfListColumn = V5X.selectSingleNode(listColumn, "//V5X//CHILD", "style", "dataFormat");
        Element dataFormat = null;
        if (dataFormatOfListColumnBody != null) {
            dataFormat = (Element)dataFormatOfListColumnBody.clone();
        } else if (dataFormatOfListColumn != null) {
            dataFormat = (Element)dataFormatOfListColumn.clone();
        }
        Element style = DocumentHelper.makeElement((Branch)crosstabNodeMember.getParent(), (String)V5X.getMakeElementPath("crosstabFactCell", "style"));
        if (dataFormat != null && style != null) {
            style.add(dataFormat);
        }
    }

    private void copyFactCellDataFormat(Element listColumn, Element crosstabNodemember) {
        Element dataFormat = V5X.selectSingleNode(listColumn, "//V5X//CHILD", "listColumnBody", "style", "dataFormat");
        if (dataFormat == null) {
            return;
        }
        Element style = DocumentHelper.makeElement((Branch)crosstabNodemember, (String)V5X.getMakeElementPath("factCell", "style"));
        style.add(dataFormat.createCopy());
        if (style.element("defaultStyles") == null) {
            Element defaultStyle = DocumentHelper.makeElement((Branch)style, (String)V5X.getMakeElementPath("defaultStyles", "defaultStyle"));
            defaultStyle.addAttribute("refStyle", "cv");
        }
    }

    private void copyListColumnTitleTextItemToCrosstabNodeMember(Element columnTitleTextItem, Element crosstabTextItem, String rdi) throws ActionException {
        V5QueryItem queryItem = new V5QueryItem(this.actionEnv, this.getV5Query(), this.getV5Query().findItem(rdi));
        boolean isNumeric = queryItem.confirmIsNumeric();
        for (Element child : columnTitleTextItem.elements()) {
            if (child.getName().equals("conditionalDataSources")) {
                if (!isNumeric) continue;
                crosstabTextItem.add(child.createCopy());
                continue;
            }
            if (child.getName().equals("dataSource")) continue;
            crosstabTextItem.add(child.createCopy());
        }
        if (isNumeric) {
            Element dataItemLabel = V5X.selectSingleNode(columnTitleTextItem, "//V5X//CHILD", "dataSource", "dataItemLabel");
            Element memberCaption = V5X.selectSingleNode(crosstabTextItem, "//V5X//CHILD", "dataSource", "memberCaption");
            if (dataItemLabel != null && memberCaption != null) {
                memberCaption.getParent().add(dataItemLabel.createCopy());
                memberCaption.detach();
            }
        }
    }

    private void copyAttributes(Element listColumn, Element crosstabNodeMember) {
        Element xmlAttributes = listColumn.element("listColumnTitle").element("XMLAttributes");
        if (xmlAttributes == null) {
            return;
        }
        Element xmlAttributesCopy = xmlAttributes.createCopy();
        Iterator xmlAttributeIte = xmlAttributesCopy.elements("XMLAttribute").iterator();
        while (xmlAttributeIte.hasNext()) {
            Element xmlAttribute = (Element)xmlAttributeIte.next();
            String name = xmlAttribute.attributeValue("name");
            if (!"rp_sort".equals(name) && !"rap_layout_tag".equals(name) && !"no_data_item_column".equals(name)) continue;
            xmlAttributeIte.remove();
        }
        if (xmlAttributesCopy.elements().size() > 0) {
            crosstabNodeMember.add(xmlAttributesCopy);
        }
    }

    @Override
    public List<Element> getCellStyles(Element layoutItem) {
        ArrayList<Element> styleNodes = new ArrayList<Element>();
        styleNodes.addAll(V5X.selectNodes(layoutItem, "listColumnBody", "style"));
        return styleNodes;
    }

    private void createMasterDetailLinkWithSectionHeader(Element detailContainerElement) {
        Element parentContainer = V5SpecHelper.findParentContainer(this._container);
        if (parentContainer == null) {
            return;
        }
        HashSet<String> rdis = new HashSet<String>();
        while (parentContainer != null && "list".equals(parentContainer.getName())) {
            List listGroupElements = V5X.selectNodes(parentContainer, "//V5X//CHILD", "listGroups", "listGroup");
            for (Element listGroup : listGroupElements) {
                String rdi = listGroup.attributeValue("refDataItem");
                if (rdi == null) continue;
                rdis.add(rdi);
            }
            parentContainer = V5SpecHelper.findParentContainer(parentContainer);
        }
        if (rdis.isEmpty()) {
            return;
        }
        Element masterDetailLinks = DocumentHelper.makeElement((Branch)detailContainerElement, (String)"masterDetailLinks");
        for (String rdi : rdis) {
            if (V5X.selectSingleNode(masterDetailLinks, "dataItemContext", "//V5X//ATTR", "refDataItem", rdi) != null) {
                return;
            }
            Element masterDetailLink = masterDetailLinks.addElement("masterDetailLink");
            DocumentHelper.makeElement((Branch)masterDetailLink, (String)"masterContext/dataItemContext").addAttribute("refDataItem", rdi);
            DocumentHelper.makeElement((Branch)masterDetailLink, (String)"detailContext/dataItemContext").addAttribute("refDataItem", rdi);
        }
    }

    @Override
    public void tagLayoutItems(boolean preserveTags) {
        Element listOverallGroup;
        List tobeTaggedElements = V5X.selectNodes(this._container, "//V5X//CHILD", "listColumns", "listColumn", "listColumnTitle");
        tobeTaggedElements.addAll(V5X.selectNodes(this._container, "//V5X//CHILD", "listColumns", "listColumn", "listColumnBody"));
        Element listGroups = V5X.selectSingleNode(this._container, "//V5X//CHILD", "listGroups");
        if (listGroups != null) {
            tobeTaggedElements.addAll(V5X.selectNodes(listGroups, "//V5X//CHILD", "listGroup", "listFooter", "listRows", "listRow", "rowCells", "rowCell"));
            tobeTaggedElements.addAll(V5X.selectNodes(listGroups, "//V5X//CHILD", "listGroup", "listHeader", "listRows", "listRow", "rowCells", "rowCell"));
        }
        if ((listOverallGroup = V5X.selectSingleNode(this._container, "//V5X//CHILD", "listOverallGroup")) != null) {
            tobeTaggedElements.addAll(V5X.selectNodes(listOverallGroup, "//V5X//CHILD", "listFooter", "listRows", "listRow", "rowCells", "rowCell"));
            tobeTaggedElements.addAll(V5X.selectNodes(listOverallGroup, "//V5X//CHILD", "listHeader", "listRows", "listRow", "rowCells", "rowCell"));
        }
        for (Element element : tobeTaggedElements) {
            String sID;
            String string = sID = "true".equals(System.getProperty("viewerMasters")) ? "" : UUID.randomUUID().toString();
            if (preserveTags && V5SpecHelper.getXMLAttribute(element, "rap_layout_tag") != null) continue;
            V5SpecHelper.setXMLAttribute(element, "rap_layout_tag", sID, "HTML");
        }
        List columns = V5X.selectNodes(this._container, "//V5X//CHILD", "listColumns", "listColumn");
        for (Element column : columns) {
            boolean noDataItemColumn;
            V5ListColumn v5ListColumn = new V5ListColumn(column);
            boolean bl = noDataItemColumn = v5ListColumn.getDataItemName() == null;
            if (column.element("listColumnTitle") != null) {
                this.setNoDataItemColumnTag(column.element("listColumnTitle"), noDataItemColumn);
            }
            if (column.element("listColumnBody") == null) continue;
            this.setNoDataItemColumnTag(column.element("listColumnBody"), noDataItemColumn);
        }
    }

    public Element findRDINodeByStaticTextTitle(ActionEnv env, String staticText, Element listColumn) {
        List staticTitles = null;
        staticTitles = listColumn != null && "listColumn".equals(listColumn.getName()) ? V5X.selectNodes(listColumn, "//V5X//CHILD", "listColumnTitle", "//V5X//ANY", "dataSource", "staticValue") : V5X.selectNodes(this._container, "//V5X//CHILD", "listColumns", "listColumn", "listColumnTitle", "//V5X//ANY", "dataSource", "staticValue");
        if (staticTitles == null) {
            return null;
        }
        for (Element associatedTitle : staticTitles) {
            Element listColumnBody;
            Element parentListColumn;
            if (!associatedTitle.getText().equals(staticText) || (parentListColumn = V5SpecHelper.getAncestor(associatedTitle, "listColumn")) == null || (listColumnBody = V5X.selectSingleNode(parentListColumn, "listColumnBody")) == null) continue;
            return this.findBestRDINode(listColumnBody, env.getLocale());
        }
        return null;
    }

    public boolean isSectionedListHeader() {
        Element listColumn;
        ArrayList<V5DataContainer> containers;
        List columns = V5X.selectNodes(this.getContainerElement(), "//V5X//CHILD", "listColumns", "listColumn");
        return columns.size() == 1 && V5X.selectSingleNode(this.getContainerElement(), "//V5X//CHILD", "listGroups", "listGroup", "listHeader", "listRows") != null && (containers = V5DataContainerFactory.createChildContainers(listColumn = (Element)columns.get(0))).size() > 0;
    }

    @Override
    public V5DataContainer selectContainerForChangeDisplayType() {
        V5DataContainer selected = this;
        if (this.isSectionedListHeader()) {
            ArrayList<V5DataContainer> childContainers = V5DataContainerFactory.createChildContainers(this._container.element("listColumns"));
            while (childContainers.size() > 0) {
                selected = childContainers.get(0);
                childContainers = V5DataContainerFactory.createChildContainers(selected.getContainerElement());
            }
        }
        return selected;
    }

    private void setNoDataItemColumnTag(Element parent, boolean isNoDAtaItemColumnTag) {
        V5SpecHelper.removeXMLAttribute(parent, "no_data_item_column");
        if (isNoDAtaItemColumnTag) {
            V5SpecHelper.setXMLAttribute(parent, "no_data_item_column", "true", "HTML");
        }
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element crosstabNodeMember, String startNodeHUN) throws ActionException {
        return null;
    }
}

