/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5ListGroups;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5Style;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5ListGroup
extends V5DataContainer {
    private Element _v5ListGroup = null;
    private int _groupID = -1;

    public V5ListGroup(Element v5ListGroup, int groupID) {
        this._v5ListGroup = v5ListGroup;
        this._groupID = groupID;
    }

    public static Element startGroupFooterRow(Element listGroup) {
        return DocumentHelper.makeElement((Branch)listGroup, (String)"listFooter/listRows/listRow/rowCells");
    }

    public static Element addGroupFooterRowCell(Element groupFooterRowCells, int colSpan, String dataItemRDI, String dataItemStyle) {
        Element divContents;
        Element newRowCell = groupFooterRowCells.addElement("rowCell");
        if (colSpan > 1) {
            newRowCell.addAttribute("colSpan", Integer.toString(colSpan));
        }
        if ((divContents = DocumentHelper.makeElement((Branch)newRowCell, (String)"contents")) != null) {
            if (dataItemRDI != null) {
                divContents = DocumentHelper.makeElement((Branch)divContents, (String)"textItem/dataSource/dataItemValue");
                divContents.addAttribute("refDataItem", dataItemRDI);
            }
            V5Style style = new V5Style();
            style.setDefaultStyle(newRowCell, dataItemStyle);
        }
        return newRowCell;
    }

    public static void adjustForInsertedColumn(int groupOffsetFromLeft, Element listGroup, int insertionIndex) {
        if (listGroup != null) {
            List listGroupCellLists = listGroup.selectNodes(".//*[local-name()='rowCells']");
            ListIterator iterator = listGroupCellLists.listIterator();
            while (iterator.hasNext()) {
                Element rowCellList = (Element)iterator.next();
                V5ListGroup.adjustRowCellsForInsertedColumn(groupOffsetFromLeft, rowCellList, insertionIndex);
            }
        }
    }

    public static void adjustForDeletedColumn(int groupOffsetFromLeft, Element listGroup, int deletionIndex) {
        if (listGroup != null) {
            List listGroupCellLists = listGroup.selectNodes(".//*[local-name()='rowCells']");
            ListIterator iterator = listGroupCellLists.listIterator();
            while (iterator.hasNext()) {
                Element rowCellList = (Element)iterator.next();
                V5ListGroup.adjustRowCellsForDeletedColumn(groupOffsetFromLeft, rowCellList, deletionIndex);
            }
        }
    }

    private static void adjustRowCellsForInsertedColumn(int groupOffsetFromLeft, Element rowCellElementList, int insertionIndex) {
        if (insertionIndex >= groupOffsetFromLeft) {
            if (groupOffsetFromLeft > 0) {
                insertionIndex -= groupOffsetFromLeft;
            }
            List rowCellList = rowCellElementList.elements("rowCell");
            if (insertionIndex == 0 && groupOffsetFromLeft >= 0) {
                Element firstRowCell = (Element)rowCellList.get(0);
                V5ListGroup.insertFirstChildElement(rowCellElementList, V5ListGroup.createEmptyRowCellFrom(firstRowCell));
            } else {
                ListIterator iterator = rowCellList.listIterator();
                int nCurrentCellColumn = 0;
                while (iterator.hasNext()) {
                    Element rowCell = (Element)iterator.next();
                    int nThisColSpan = 1;
                    Attribute currentColSpan = rowCell.attribute("colSpan");
                    if (currentColSpan != null) {
                        nThisColSpan = Integer.parseInt(currentColSpan.getValue());
                    }
                    if (nCurrentCellColumn + nThisColSpan > insertionIndex) {
                        if (currentColSpan == null) {
                            rowCell.addAttribute("colSpan", Integer.toString(nThisColSpan + 1));
                            break;
                        }
                        currentColSpan.setValue(Integer.toString(nThisColSpan + 1));
                        break;
                    }
                    if (nCurrentCellColumn + nThisColSpan == insertionIndex) {
                        V5ListGroup.insertLayoutElementAfter(rowCell, V5ListGroup.createEmptyRowCellFrom(rowCell));
                        break;
                    }
                    nCurrentCellColumn += nThisColSpan;
                }
            }
        }
    }

    private static void adjustRowCellsForDeletedColumn(int groupOffsetFromLeft, Element rowCellElementList, int deletionIndex) {
        if (deletionIndex >= groupOffsetFromLeft) {
            if (groupOffsetFromLeft > 0) {
                deletionIndex -= groupOffsetFromLeft;
            }
            List rowCellList = rowCellElementList.elements("rowCell");
            ListIterator iterator = rowCellList.listIterator();
            int nCurrentCellColumn = 0;
            while (iterator.hasNext()) {
                Element rowCell = (Element)iterator.next();
                int nThisColSpan = 1;
                Attribute currentColSpan = rowCell.attribute("colSpan");
                if (currentColSpan != null) {
                    nThisColSpan = Integer.parseInt(currentColSpan.getValue());
                }
                if (nCurrentCellColumn + nThisColSpan > deletionIndex) {
                    if (nThisColSpan == 1) {
                        rowCell.getParent().remove(rowCell);
                        break;
                    }
                    currentColSpan.setValue(Integer.toString(nThisColSpan - 1));
                    break;
                }
                nCurrentCellColumn += nThisColSpan;
            }
        }
    }

    private static Element createEmptyRowCellFrom(Element rowCell) {
        Element newRowCellContents;
        Element newRowCell = (Element)rowCell.clone();
        Attribute colSpanAttribute = newRowCell.attribute("colSpan");
        if (colSpanAttribute != null) {
            newRowCell.remove(colSpanAttribute);
        }
        if ((newRowCellContents = newRowCell.element("contents")) != null) {
            newRowCell.remove(newRowCellContents);
        }
        newRowCell.addElement("contents");
        return newRowCell;
    }

    public void reorderGroup(ArrayList<V5ListGroups.ColumnInfo> columnInfoList, ArrayList<V5ListGroups.ColumnInfo> reorderedInfoList) {
        if (this._v5ListGroup != null) {
            List listGroupCellLists = this._v5ListGroup.selectNodes(".//*[local-name()='rowCells']");
            ListIterator iterator = listGroupCellLists.listIterator();
            while (iterator.hasNext()) {
                Element rowCells = (Element)iterator.next();
                this.reorderRowCells(rowCells, columnInfoList, reorderedInfoList);
            }
        }
    }

    public void deleteColumn(ArrayList<V5ListGroups.ColumnInfo> columnInfoList, ArrayList<V5ListGroups.ColumnInfo> reorderedInfoList) {
        if (this._v5ListGroup != null) {
            List listGroupCellLists = this._v5ListGroup.selectNodes(".//*[local-name()='rowCells']");
            ListIterator iterator = listGroupCellLists.listIterator();
            while (iterator.hasNext()) {
                Element rowCells = (Element)iterator.next();
                this.reorderRowCells(rowCells, columnInfoList, reorderedInfoList);
            }
        }
    }

    private void reorderRowCells(Element rowCells, ArrayList<V5ListGroups.ColumnInfo> columnInfoList, ArrayList<V5ListGroups.ColumnInfo> reorderedInfoList) {
        this.bindRowCellsToColumns(rowCells, columnInfoList);
        List rowCellList = rowCells.elements("rowCell");
        for (int i = 0; i < rowCellList.size(); ++i) {
            Element rowCell = (Element)rowCellList.get(i);
            rowCell.detach();
        }
        Element inputRowCell = null;
        int outputRowCellSpan = 1;
        Element outputRowCell = null;
        ListIterator<V5ListGroups.ColumnInfo> ciIter = reorderedInfoList.listIterator();
        while (ciIter.hasNext()) {
            V5ListGroups.ColumnInfo ci = ciIter.next();
            if (ci._rowCell != null) {
                if (ci._rowCell != inputRowCell || ci._rowCellPart == 0) {
                    V5ListGroup.adjustRowCellSpan(outputRowCell, outputRowCellSpan);
                    Element newOutputRowCell = null;
                    newOutputRowCell = ci._rowCellPart == 1 ? V5ListGroup.createEmptyRowCellFrom(ci._rowCell) : (Element)ci._rowCell.clone();
                    rowCells.add(newOutputRowCell);
                    outputRowCell = newOutputRowCell;
                    inputRowCell = ci._rowCell;
                    outputRowCellSpan = 1;
                    continue;
                }
                ++outputRowCellSpan;
                continue;
            }
            inputRowCell = null;
        }
        V5ListGroup.adjustRowCellSpan(outputRowCell, outputRowCellSpan);
    }

    private void bindRowCellsToColumns(Element rowCells, ArrayList<V5ListGroups.ColumnInfo> columnInfoList) {
        List rowCellList = rowCells.elements("rowCell");
        ListIterator rowCellIter = rowCellList.listIterator();
        Element rowCell = null;
        int remainingSpan = 0;
        int currentColSpan = 0;
        ListIterator<V5ListGroups.ColumnInfo> ciIter = columnInfoList.listIterator();
        while (ciIter.hasNext()) {
            V5ListGroups.ColumnInfo ci = ciIter.next();
            if (remainingSpan == 0) {
                rowCell = rowCellIter.hasNext() ? (Element)rowCellIter.next() : null;
                currentColSpan = rowCell != null && rowCell.attribute("colSpan") != null ? Integer.parseInt(rowCell.attributeValue("colSpan")) : 1;
                remainingSpan = currentColSpan;
            }
            if (ci._groupID >= this._groupID) {
                ci._rowCell = rowCell;
                ci._rowCellPart = currentColSpan == remainingSpan ? 0 : 1;
                --remainingSpan;
                continue;
            }
            ci._rowCell = null;
        }
    }

    private static void adjustRowCellSpan(Element rowCell, int rowCellSpan) {
        if (rowCell != null) {
            Attribute colSpan = rowCell.attribute("colSpan");
            if (colSpan != null) {
                colSpan.setValue(Integer.toString(rowCellSpan));
            } else if (rowCellSpan > 1) {
                rowCell.addAttribute("colSpan", Integer.toString(rowCellSpan));
            }
        }
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element crosstabNodeMember, String startNodeHUN) throws ActionException {
        return null;
    }
}

