/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5ListColumn;
import com.cognos.rap.actions.v5spechelpers.V5ListGroup;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class V5ListGroups
extends V5DataContainer {
    private Element _v5ParentList = null;
    private HashMap<String, Integer> _listColumnRDIMap = new HashMap();
    public ArrayList<ColumnInfo> _columnInfoList = new ArrayList();
    HashMap<String, ColumnInfo> _columnInfoMap = new HashMap();

    public V5ListGroups(Element listGroupsParent) {
        this._v5ParentList = listGroupsParent;
        this.refreshListColumnOrder();
        this.loadColumnInfo();
    }

    private void loadColumnInfo() {
        List listColumns = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listColumns", "listColumn");
        ListIterator lcIter = listColumns.listIterator();
        while (lcIter.hasNext()) {
            String bodyTag;
            String headerTag;
            ColumnInfo ci = new ColumnInfo();
            ci._column = (Element)lcIter.next();
            this._columnInfoList.add(ci);
            V5ListColumn v5ListColumn = new V5ListColumn(ci._column);
            String rdi = v5ListColumn.getDataItemName();
            if (rdi != null) {
                this._columnInfoMap.put(rdi, ci);
            }
            if ((headerTag = v5ListColumn.getHeaderLayoutTag()) != null) {
                this._columnInfoMap.put(headerTag, ci);
            }
            if ((bodyTag = v5ListColumn.getBodyLayoutTag()) == null) continue;
            this._columnInfoMap.put(bodyTag, ci);
        }
        List listGroups = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listGroups", "listGroup");
        int nGroupID = 0;
        ListIterator lgIter = listGroups.listIterator();
        while (lgIter.hasNext()) {
            Element thisGroup = (Element)lgIter.next();
            ColumnInfo ci = this._columnInfoMap.get(thisGroup.attributeValue("refDataItem"));
            if (ci != null) {
                ci._groupID = nGroupID;
            }
            ++nGroupID;
        }
    }

    void reOrder(String fromColumnName, String afterColumnName) {
        ColumnInfo ciMove;
        ArrayList reorderedInfoList = (ArrayList)this._columnInfoList.clone();
        int iRemove = reorderedInfoList.indexOf(ciMove = this._columnInfoMap.get(fromColumnName));
        if (iRemove == -1) {
            return;
        }
        reorderedInfoList.remove(iRemove);
        ColumnInfo ciInsertAfter = null;
        int insertionIndex = 0;
        if (afterColumnName != null) {
            ciInsertAfter = this._columnInfoMap.get(afterColumnName);
            insertionIndex = reorderedInfoList.indexOf(ciInsertAfter) + 1;
        }
        reorderedInfoList.add(insertionIndex, ciMove);
        Element listOverallGroup = this._v5ParentList.element("listOverallGroup");
        V5ListGroup v5ListOverallGroup = new V5ListGroup(listOverallGroup, -1);
        v5ListOverallGroup.reorderGroup(this._columnInfoList, reorderedInfoList);
        List listGroups = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listGroups", "listGroup");
        for (int i = 0; i < listGroups.size(); ++i) {
            Element listGroup = (Element)listGroups.get(i);
            V5ListGroup v5ListGroup = new V5ListGroup(listGroup, i);
            v5ListGroup.reorderGroup(this._columnInfoList, reorderedInfoList);
        }
    }

    void deleteColumn(String columnName) {
        ArrayList reorderedInfoList = (ArrayList)this._columnInfoList.clone();
        ColumnInfo ciDelete = this._columnInfoMap.get(columnName);
        int iRemove = reorderedInfoList.indexOf(ciDelete);
        reorderedInfoList.remove(iRemove);
        Element listOverallGroup = this._v5ParentList.element("listOverallGroup");
        V5ListGroup v5ListOverallGroup = new V5ListGroup(listOverallGroup, -1);
        v5ListOverallGroup.deleteColumn(this._columnInfoList, reorderedInfoList);
        List listGroups = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listGroups", "listGroup");
        for (int i = 0; i < listGroups.size(); ++i) {
            Element listGroup = (Element)listGroups.get(i);
            V5ListGroup v5ListGroup = new V5ListGroup(listGroup, i);
            v5ListGroup.deleteColumn(this._columnInfoList, reorderedInfoList);
        }
    }

    public void refreshListColumnOrder() {
        this._listColumnRDIMap.clear();
        List listColumnRDIList = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listColumns", "listColumn", "listColumnBody", "contents", "textItem", "dataSource", "dataItemValue", "//V5X//ATTR_DEFINED", "refDataItem");
        ListIterator li = listColumnRDIList.listIterator();
        int columnIndex = 0;
        while (li.hasNext()) {
            Element rdiNode = (Element)li.next();
            this._listColumnRDIMap.put(rdiNode.attributeValue("refDataItem"), columnIndex++);
        }
    }

    private int getAssociatedColumnIndexForListGroup(Element listGroup) {
        Integer colIdx = this._listColumnRDIMap.get(listGroup.attributeValue("refDataItem"));
        if (colIdx != null) {
            return colIdx;
        }
        return -1;
    }

    public Element findLastGroupedColumnInWellFormedList() throws ActionException {
        try {
            List listColumnRDIList;
            Element lastGroupedColumn;
            List listGroups = this._v5ParentList.selectNodes(".//*[local-name()='listGroup']");
            ListIterator groupsIterator = listGroups.listIterator();
            Element group = null;
            int currentGroupColIndex = -1;
            int thisGroupColIndex = -1;
            while (groupsIterator.hasNext()) {
                group = (Element)groupsIterator.next();
                thisGroupColIndex = this.getAssociatedColumnIndexForListGroup(group);
                if (thisGroupColIndex < 0) continue;
                if (thisGroupColIndex == currentGroupColIndex + 1) {
                    currentGroupColIndex = thisGroupColIndex;
                    continue;
                }
                throw new Exception();
            }
            if (currentGroupColIndex >= 0 && (lastGroupedColumn = (Element)(listColumnRDIList = this._v5ParentList.selectNodes(".//*[local-name()='listColumnBody']//*[local-name()='dataItemValue'][@refDataItem!='']")).get(currentGroupColIndex)) != null) {
                lastGroupedColumn = (Element)lastGroupedColumn.selectSingleNode("ancestor::*[local-name()='listColumn']");
                return lastGroupedColumn;
            }
            return null;
        }
        catch (Exception e) {
            throw new ActionException();
        }
    }

    public void insertColumn(int insertionIndex) {
        Element listOverallGroup = V5X.selectSingleNode(this._v5ParentList, "//V5X//CHILD", "listOverallGroup");
        V5ListGroup.adjustForInsertedColumn(-1, listOverallGroup, insertionIndex);
        List listGroups = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listGroups", "listGroup");
        for (int i = 0; i < listGroups.size(); ++i) {
            Element listGroup = (Element)listGroups.get(i);
            V5ListGroup.adjustForInsertedColumn(this.getAssociatedColumnIndexForListGroup(listGroup), listGroup, insertionIndex);
        }
    }

    public void deleteColumn(int deletionIndex) {
        Element listOverallGroup = V5X.selectSingleNode(this._v5ParentList, "//V5X//CHILD", "listOverallGroup");
        V5ListGroup.adjustForDeletedColumn(-1, listOverallGroup, deletionIndex);
        List listGroups = V5X.selectNodes(this._v5ParentList, "//V5X//CHILD", "listGroups", "listGroup");
        for (int i = 0; i < listGroups.size(); ++i) {
            Element listGroup = (Element)listGroups.get(i);
            V5ListGroup.adjustForDeletedColumn(this.getAssociatedColumnIndexForListGroup(listGroup), listGroup, deletionIndex);
        }
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element crosstabNodeMember, String startNodeHUN) throws ActionException {
        return null;
    }

    public class ColumnInfo {
        public static final int FIRST_PART = 0;
        public static final int SPAN_PART = 1;
        public static final int UNGROUPED = 999;
        public String _columnName = null;
        public Element _column = null;
        public int _groupID = 999;
        public Element _rowCell = null;
        public int _rowCellPart = 0;
    }
}

