/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class V5MasterDetailLinkUpdater {
    public static void updateRefDataItemInContainer(V5DataContainer container, String oldDataItemName, Element newDataItem) {
        Set<Element> childContainers = V5MasterDetailLinkUpdater.updateDataItemRefWithinContainer(container, oldDataItemName, newDataItem.attributeValue("name"));
        for (Element childContainer : childContainers) {
            V5DataContainer v5ChildContainer = V5DataContainerFactory.create(childContainer);
            V5MasterDetailLinkUpdater.updateMasterDetailLinkForContainer(v5ChildContainer, oldDataItemName, newDataItem);
        }
    }

    public static void updateRefDataItemInDetailDataContainers(V5DataContainer masterContainer, String oldDataItemName, Element newDataItem) {
        List masterDetailLinksElements = V5X.selectNodes(masterContainer.getContainerElement(), "//V5X//CHILD", "//V5X//ANYCHILD", "//V5X//ANY", "masterDetailLinks");
        for (Element masterDetailLinks : masterDetailLinksElements) {
            Element containerElement = V5SpecHelper.findParentContainer(masterDetailLinks);
            V5DataContainer v5ChildContainer = V5DataContainerFactory.create(containerElement);
            if (v5ChildContainer == null || !V5MasterDetailLinkUpdater.isMasterDetailLinkedDetailContainer(v5ChildContainer, oldDataItemName)) continue;
            V5MasterDetailLinkUpdater.updateMasterDetailLinkForContainer(v5ChildContainer, oldDataItemName, newDataItem);
        }
    }

    private static boolean isMasterDetailLinkedDetailContainer(V5DataContainer container, String dataItem) {
        List masterDataItemContextElements = V5X.selectNodes(container.getContainerElement(), "//V5X//CHILD", "masterDetailLinks", "masterDetailLink", "masterContext", "dataItemContext");
        for (Element masterDataItemContext : masterDataItemContextElements) {
            if (masterDataItemContext == null || !masterDataItemContext.attributeValue("refDataItem").equals(dataItem)) continue;
            return true;
        }
        return false;
    }

    private static void updateMasterDetailLinkForContainer(V5DataContainer container, String oldMasterDetailItem, Element newDataItem) {
        Element masterDataItemContext = V5X.selectSingleNode(container.getContainerElement(), "//V5X//CHILD", "masterDetailLinks", "masterDetailLink", "masterContext", "dataItemContext", "//V5X//ATTR", "refDataItem", oldMasterDetailItem);
        if (masterDataItemContext == null) {
            return;
        }
        if (masterDataItemContext.attributeValue("refDataItem").equals(newDataItem.attributeValue("name"))) {
            return;
        }
        masterDataItemContext.addAttribute("refDataItem", newDataItem.attributeValue("name"));
        Element detailDataItemContext = masterDataItemContext.getParent().getParent().element("detailContext").element("dataItemContext");
        String oldDataItemName = detailDataItemContext.attributeValue("refDataItem");
        Element addedDataItem = V5MasterDetailLinkUpdater.addToQuery(container.getV5Query(), newDataItem);
        container.getV5Query().getItemList().addDataItem(addedDataItem);
        detailDataItemContext.addAttribute("refDataItem", addedDataItem.attributeValue("name"));
        Element linkedDrillItem = V5SpecHelper.getLinkedDrillItem(container.getContainerElement().getDocument(), container.getV5Query().getQueryName(), oldDataItemName);
        if (linkedDrillItem != null) {
            return;
        }
        Set<Element> childContainers = V5MasterDetailLinkUpdater.updateDataItemRefWithinContainer(container, oldDataItemName, addedDataItem.attributeValue("name"));
        for (Element childContainer : childContainers) {
            V5DataContainer v5ChildContainer = V5DataContainerFactory.create(childContainer);
            if (v5ChildContainer == null || !V5MasterDetailLinkUpdater.isMasterDetailLinkedDetailContainer(v5ChildContainer, oldDataItemName)) continue;
            V5MasterDetailLinkUpdater.updateMasterDetailLinkForContainer(v5ChildContainer, oldDataItemName, newDataItem);
        }
    }

    private static Element addToQuery(V5Query v5Query, Element dataItemToAdd) {
        Element existingDataItem;
        String hun;
        Element munE = V5X.selectSingleNode(dataItemToAdd, "MUN");
        String mun = munE == null ? null : munE.getText();
        Element dunE = V5X.selectSingleNode(dataItemToAdd, "DUN");
        String dun = dunE == null ? null : dunE.getText();
        Element hunE = V5X.selectSingleNode(dataItemToAdd, "HUN");
        String string = hun = hunE == null ? null : hunE.getText();
        if ((mun != null && hun != null || dun != null) && (existingDataItem = v5Query.getItemList().getExistingDataItem(dataItemToAdd.attributeValue("name"), mun, hun, dun)) != null) {
            return existingDataItem;
        }
        Element copy = dataItemToAdd.createCopy();
        copy.addAttribute("name", v5Query.findUniqueItemName(dataItemToAdd.attributeValue("name")));
        v5Query.getItemList().addDataItem(copy);
        return copy;
    }

    private static Set<Element> updateDataItemRefWithinContainer(V5DataContainer container, String oldDataItemName, String newDataItemName) {
        List elementsWithRDI = V5X.selectNodes(container.getContainerElement(), "//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", oldDataItemName);
        HashSet<Element> childContainers = new HashSet<Element>();
        for (Element elementWithRDI : elementsWithRDI) {
            Element containerElement = V5SpecHelper.findParentContainer(elementWithRDI);
            if (containerElement.attributeValue("name").equals(container.getID())) {
                if ("masterContext".equals(elementWithRDI.getParent().getName())) continue;
                elementWithRDI.addAttribute("refDataItem", newDataItemName);
                continue;
            }
            childContainers.add(containerElement);
        }
        return childContainers;
    }
}

