/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class V5PromptPage {
    private Element _parentV5Layout = null;
    public static final String prmtBtnCancel = "cancel";
    public static final String prmtBtnBack = "back";
    public static final String prmtBtnNext = "next";
    public static final String prmtBtnFinish = "finish";
    public static final String prmtBtnOK = "OK";
    public static final String prmtBtnReprompt = "reprompt";
    private static HashSet<String> promptCtrlSet = null;

    public V5PromptPage(Element parentLayout) {
        this._parentV5Layout = parentLayout;
    }

    public static ArrayList<Element> collectPromptControls(Element parentNode) {
        ArrayList<Element> promptControls = null;
        List pageElements = XMLUtility.selectNodes(parentNode, ".//*[@parameter or @type]");
        for (Element pageElement : pageElements) {
            if (!promptCtrlSet.contains(pageElement.getName())) continue;
            if (promptControls == null) {
                promptControls = new ArrayList<Element>();
            }
            promptControls.add(pageElement);
        }
        return promptControls;
    }

    public static boolean isPromptCtrl(String name) {
        return promptCtrlSet.contains(name);
    }

    public boolean addPromptPageWithControls(ArrayList<Element> promptControls, Element targetLayout) {
        Element promptPages = this.addPromptPageWithCustomFooter(promptControls, targetLayout, this.createPromptPageNavigationButtons(), "promptPages");
        return promptPages != null;
    }

    public Element addPromptPageWithCustomFooter(ArrayList<Element> promptControls, Element targetLayout, Element pageFooter, String parentPagesType) {
        Element promptPages = null;
        if (promptControls != null && promptControls.size() > 0) {
            promptPages = DocumentHelper.makeElement((Branch)targetLayout, (String)parentPagesType);
            Element newPromptPage = promptPages.addElement("page");
            Element promptPageContents = DocumentHelper.makeElement((Branch)newPromptPage, (String)"pageBody/contents");
            for (Element promptElement : promptControls) {
                promptElement.detach();
                promptPageContents.add(promptElement);
            }
            String sNewPageName = V5SpecHelper.findUniqueName(promptPages, "./*[local-name()='page']", "promptPage");
            newPromptPage.addAttribute("name", sNewPageName);
            if (pageFooter != null) {
                newPromptPage.add(pageFooter);
            }
        }
        return promptPages;
    }

    public static Element insertNextButton(Element pageElement) {
        Element existingNextButton = V5X.selectSingleNode(pageElement, "promptButton", "//V5X//ATTR", "type", prmtBtnNext);
        if (existingNextButton != null) {
            return null;
        }
        Element existingFinishButton = V5X.selectSingleNode(pageElement, "promptButton", "//V5X//ATTR", "type", prmtBtnFinish);
        if (existingFinishButton == null) {
            existingFinishButton = V5X.selectSingleNode(pageElement, "promptButton", "//V5X//ATTR", "type", prmtBtnOK);
        }
        Element contents = DocumentHelper.makeElement((Branch)pageElement, (String)"pageFooter/contents");
        Element nextButton = V5PromptPage.addPromptButtonElement(contents, prmtBtnNext, null);
        if (existingFinishButton != null) {
            int index = existingFinishButton.getParent().elements().indexOf(existingFinishButton);
            nextButton.detach();
            existingFinishButton.getParent().elements().add(index, nextButton);
        }
        return nextButton;
    }

    public void removeExistingPromptControls(Collection<Element> promptControls) {
        Element promptPages = this._parentV5Layout.element("promptPages");
        if (promptPages == null) {
            return;
        }
        Iterator<Element> controlIte = promptControls.iterator();
        block0: while (controlIte.hasNext()) {
            Element promptControl = controlIte.next();
            if (promptControl.getName().equals("promptButton")) {
                controlIte.remove();
            }
            String parameter = promptControl.attributeValue("parameter");
            List matches = V5X.selectNodes(promptPages, "//V5X//ANYCHILD", "//V5X//ATTR", "parameter", parameter);
            for (Element match : matches) {
                if (!V5PromptPage.isPromptCtrl(match.getName())) continue;
                controlIte.remove();
                continue block0;
            }
        }
    }

    private static Element addPromptButtonElement(Element parent, String sPromptName, Element buttonContent) {
        Element button = parent.addElement("promptButton");
        button.addAttribute("type", sPromptName);
        Element contentElem = button.addElement("contents");
        if (buttonContent != null) {
            contentElem.add(buttonContent);
        }
        Element defaultStyle = DocumentHelper.makeElement((Branch)button, (String)"style/defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "bp");
        return button;
    }

    private Element createPromptPageNavigationButtons() {
        return this.createPromptPageButtons(Arrays.asList(prmtBtnCancel, prmtBtnBack, prmtBtnNext, prmtBtnFinish));
    }

    public Element createPromptPageButtons(List<String> buttons) {
        Element promptPageFooter = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"pageFooter", (Namespace)this._parentV5Layout.getNamespace()));
        Element promptPageFooterContents = promptPageFooter.addElement("contents");
        for (String button : buttons) {
            V5PromptPage.addPromptButtonElement(promptPageFooterContents, button, null);
        }
        Element defaultStyle = DocumentHelper.makeElement((Branch)promptPageFooter, (String)"style/defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "fp");
        return promptPageFooter;
    }

    public Element createPromptPageFooter(List<Object[]> buttons) {
        Element promptPageFooter = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"pageFooter", (Namespace)this._parentV5Layout.getNamespace()));
        Element promptPageFooterContents = promptPageFooter.addElement("contents");
        if (buttons != null) {
            for (Object[] button : buttons) {
                V5PromptPage.addPromptButtonElement(promptPageFooterContents, (String)button[0], (Element)button[1]);
            }
        }
        Element defaultStyle = DocumentHelper.makeElement((Branch)promptPageFooter, (String)"style/defaultStyles/defaultStyle");
        defaultStyle.addAttribute("refStyle", "fp");
        return promptPageFooter;
    }

    static {
        promptCtrlSet = new HashSet();
        promptCtrlSet.add("promptButton");
        promptCtrlSet.add("textBox");
        promptCtrlSet.add("selectWithTree");
        promptCtrlSet.add("selectWithSearch");
        promptCtrlSet.add("generatedPrompt");
        promptCtrlSet.add("selectTime");
        promptCtrlSet.add("selectDate");
        promptCtrlSet.add("selectInterval");
        promptCtrlSet.add("selectValue");
    }
}

