/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.DynamicDataFilterResetter;
import com.cognos.rap.actions.DynamicDiscreteValuesFilter;
import com.cognos.rap.actions.FilterableItemsInfo;
import com.cognos.rap.actions.ItemLabel;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.SortInfo;
import com.cognos.rap.actions.v5spechelpers.QueryItemPropertyManager;
import com.cognos.rap.actions.v5spechelpers.V5ContextSlicer;
import com.cognos.rap.actions.v5spechelpers.V5QueryFilters;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SetExpandCollapse;
import com.cognos.rap.actions.v5spechelpers.V5SetFiltering;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5Translations;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.utility.XMLUtility;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5Query {
    public static final String _BUSINESS_INSIGHT_QUERY_NAME_ = "_BusinessInsight_";
    protected Element querySelection = null;
    private ActionEnv _envOrNull = null;
    private ItemList _itemList = new ItemList();
    private static final Pattern RegExpressionEscapePattern = Pattern.compile("([\\[\\]\\^\\$\\*\\+\\?\\(\\)\\{\\}\\|\\\\.])");
    private HashMap<String, Element> _memberSetInfo = null;
    private V5QueryFilters _v5QueryFilters = null;
    private static final String _detailFilters = "./*[local-name()='detailFilters']/*[local-name()='detailFilter']";
    private static final String _dynamicDataFilterCommon = "/*[local-name()='XMLAttributes']/*[local-name()='XMLAttribute'][@name='RAP_DataFilterID']/../..";
    private static final String _dynamicDetailFiltersXPath = "./*[local-name()='detailFilters']/*[local-name()='detailFilter']/*[local-name()='XMLAttributes']/*[local-name()='XMLAttribute'][@name='RAP_DataFilterID']/../..";
    private static final String _dynamicDataItemFiltersXPath = "./*[local-name()='selection']/*[local-name()='dataItem' or local-name()='dataItemSetExpression' or local-name()='dataItemMemberSet' or local-name()='dataItemMeasure']/*[local-name()='XMLAttributes']/*[local-name()='XMLAttribute'][@name='RAP_DataFilterID']/../..";

    public V5Query(ActionEnv env) {
        this._envOrNull = env;
    }

    public V5Query(ActionEnv env, Element anyReportNode, String queryName) {
        this._envOrNull = env;
        this.focusQuery(anyReportNode, queryName);
    }

    public V5Query() {
    }

    public V5Query(Element anyReportNode, String queryName) {
        this.focusQuery(anyReportNode, queryName);
    }

    public void setEnv(ActionEnv env) {
        this._envOrNull = env;
    }

    public boolean createNew(Element anyReportNode, String queryName) {
        Element queries = anyReportNode.getDocument().getRootElement().element("queries");
        if (queries != null) {
            String valuesQueryName = V5SpecHelper.findUniqueName(queries, ".//*", queryName);
            Element valuesQuery = queries.addElement("query");
            valuesQuery.addAttribute("name", valuesQueryName);
            valuesQuery.addElement("selection");
            Element valuesQuerySource = valuesQuery.addElement("source");
            valuesQuerySource.addElement("model");
            return this.focusQuery(valuesQuery);
        }
        return false;
    }

    public static V5Query findBusinessInsightQuery(Document reportDoc, String locale) {
        Element biQueryElement = V5X.selectSingleNode(reportDoc, "queries", "query", "//V5X//ATTR", "name", _BUSINESS_INSIGHT_QUERY_NAME_ + locale);
        if (biQueryElement == null) {
            biQueryElement = V5X.selectSingleNode(reportDoc, "queries", "query", "//V5X//ATTR", "name", _BUSINESS_INSIGHT_QUERY_NAME_);
        }
        if (biQueryElement != null) {
            V5Query biQuery = new V5Query();
            biQuery.focusQuery(biQueryElement);
            return biQuery;
        }
        return null;
    }

    public static Element findBusinessInsightQueryItem(Element originalElement, String locale) {
        Element biQueryElement = V5X.selectSingleNode(originalElement.getDocument(), "queries", "query", "//V5X//ATTR", "name", _BUSINESS_INSIGHT_QUERY_NAME_ + locale);
        if (biQueryElement == null) {
            biQueryElement = V5X.selectSingleNode(originalElement.getDocument(), "queries", "query", "//V5X//ATTR", "name", _BUSINESS_INSIGHT_QUERY_NAME_);
        }
        if (biQueryElement != null) {
            return V5X.selectSingleNode(biQueryElement, "//V5X//CHILD", "selection", "//V5X//ANYCHILD", "//V5X//ATTR", "name", originalElement.attributeValue("name"));
        }
        return null;
    }

    public String getBestItemLabel(String rdiName, ActionEnv env, boolean localizeLabel) throws ActionException {
        String itemLabel;
        Element dataItem = this.findItem(rdiName);
        if (dataItem == null) {
            return rdiName;
        }
        String string = itemLabel = V5SpecHelper.compareLocales(env.getLocale(), V5SpecHelper.getExpressionLocale(dataItem), true) ? dataItem.attributeValue("label") : null;
        if (itemLabel == null) {
            String localizedlabelProp = "label_" + env.getLocale();
            itemLabel = V5SpecHelper.getXMLAttribute(this.findItem(rdiName), localizedlabelProp);
            if (itemLabel == null) {
                localizedlabelProp = "label_" + env.getLocale().substring(0, 2);
                itemLabel = V5SpecHelper.getXMLAttribute(this.findItem(rdiName), localizedlabelProp);
            }
        }
        if (localizeLabel && itemLabel == null) {
            itemLabel = this.localizeLabel(env, rdiName);
        }
        if (itemLabel == null) {
            itemLabel = dataItem.attributeValue("label");
        }
        return itemLabel != null && !itemLabel.equals("") ? itemLabel : dataItem.attributeValue("name");
    }

    private String localizeLabel(ActionEnv env, String rdiName) throws ActionException {
        if (!V5SpecHelper.compareLocales(env.getLocale(), this.getQueryElement().getDocument().getRootElement().attributeValue("expressionLocale"), false)) {
            QueryItemPropertyManager qipm = new QueryItemPropertyManager(env, this);
            ArrayList<ItemLabel> labels = new ArrayList<ItemLabel>();
            labels.add(new ItemLabel(rdiName));
            qipm.localizeItemLabels(labels);
            String labelProp = "label_" + env.getLocale();
            if (((ItemLabel)labels.get(0)).labelIsCustomized()) {
                V5SpecHelper.setXMLAttribute(this.findItem(rdiName), labelProp, ((ItemLabel)labels.get(0)).getLabel(), "no");
                return ((ItemLabel)labels.get(0)).getLabel();
            }
            V5SpecHelper.setXMLAttribute(this.findItem(rdiName), labelProp, "", "no");
        }
        return null;
    }

    public static V5Query findBusinessInsightQuery(Document reportDoc, String locale, String itemName) {
        V5Query biQuery = V5Query.findBusinessInsightQuery(reportDoc, locale);
        if (biQuery != null && biQuery.findItem(itemName) != null) {
            return biQuery;
        }
        return null;
    }

    public Element getQueryElement() {
        if (this.querySelection != null) {
            return this.querySelection.getParent();
        }
        return null;
    }

    public Element getSlicerRootElement() {
        if (this.querySelection != null) {
            return this.querySelection.getParent().element("slicer");
        }
        return null;
    }

    public boolean focusQuery(Element queryElement) {
        this.querySelection = (Element)queryElement.selectSingleNode(V5X.select("selection"));
        if (this.querySelection != null) {
            this._itemList.clear();
            this._itemList.load();
            return true;
        }
        return false;
    }

    public boolean focusQuery(Element anyReportNode, String queryName) {
        Element queryElement;
        if (anyReportNode != null && queryName != null && (queryElement = V5X.selectSingleNode(anyReportNode.getDocument(), "//V5X//CHILD", "queries", "query", "//V5X//ATTR", "name", queryName)) != null) {
            return this.focusQuery(queryElement);
        }
        return false;
    }

    public V5QueryFilters getFilters(ActionEnv env) {
        if (this._v5QueryFilters == null && this.querySelection != null) {
            this._v5QueryFilters = new V5QueryFilters(env, this);
        }
        return this._v5QueryFilters;
    }

    public String getQueryName() {
        return this.querySelection.getParent().attributeValue("name");
    }

    public Element getQuerySelection() {
        return this.querySelection;
    }

    public static String getItemName(Element dataItemSubtype) {
        return dataItemSubtype.attributeValue("name");
    }

    public String findUniqueItemName(String rootName) {
        return V5SpecHelper.findUniqueName(this.querySelection, ".//*", rootName);
    }

    public void setDimensionalDataItemInfo(Element extendedDataItem, String caption, String mun, String hun, String dun) {
        if (mun != null) {
            Element dmMember = extendedDataItem.addElement("dmMember");
            dmMember.addElement("MUN").setText(mun);
            if (caption != null) {
                dmMember.addElement("itemCaption").addText(caption);
            } else {
                dmMember.addElement("itemCaption");
            }
        }
        Element dmDimension = extendedDataItem.addElement("dmDimension");
        Element dunElement = dmDimension.addElement("DUN");
        if (dun != null) {
            dunElement.setText(dun);
        }
        if (caption != null) {
            dmDimension.addElement("itemCaption").addText(caption);
        } else {
            dmDimension.addElement("itemCaption");
        }
        if (hun != null) {
            Element dmHierarchy = extendedDataItem.addElement("dmHierarchy");
            Element hunElement = dmHierarchy.addElement("HUN");
            hunElement.setText(hun);
            if (caption != null) {
                dmHierarchy.addElement("itemCaption").addText(caption);
            } else {
                dmHierarchy.addElement("itemCaption");
            }
        }
        V5Translations.notifyValuesChanged(this._envOrNull, extendedDataItem.getDocument());
    }

    public static String getExtendedDataItemProperty(Element dataItemSubtype, String propertyName) {
        Element propObject = V5X.selectSingleNode(dataItemSubtype, "//V5X//CHILD", "//V5X//ANYCHILD", propertyName);
        if (propObject != null) {
            return propObject.getText();
        }
        return null;
    }

    public List<Element> getDataItemsInHierarchy(String hun) {
        ArrayList<Element> itemsWithHun = new ArrayList<Element>();
        List hunItems = V5X.selectNodes(this.querySelection, "//V5X//CHILD", "//V5X//ANYCHILD", "dmHierarchy", "HUN");
        for (Element hunItem : hunItems) {
            if (!hun.equals(hunItem.getText())) continue;
            itemsWithHun.add(hunItem.getParent().getParent());
        }
        return itemsWithHun;
    }

    public Element findItem(String itemName) {
        return this._itemList.findItem(itemName);
    }

    public Element findContextSlicer(String contextSliceName) {
        Element slicerRoot = this.getSlicerRootElement();
        if (slicerRoot != null) {
            List contextSlices = slicerRoot.elements("contextSlice");
            for (Element contextSlice : contextSlices) {
                if (!contextSliceName.equals(V5ContextSlicer.getContextSlicerName(contextSlice))) continue;
                return contextSlice;
            }
        }
        return null;
    }

    public Element findContextSlicerByHUN(String hun) {
        Element slicerRoot = this.getSlicerRootElement();
        if (slicerRoot != null) {
            List contextSlices = slicerRoot.elements("contextSlice");
            for (Element contextSlice : contextSlices) {
                if (!hun.equals(this.getContextSlicerHUN(contextSlice))) continue;
                return contextSlice;
            }
        }
        return null;
    }

    public String getContextSlicerHUN(Element contextSlice) {
        Element contextDUN = V5X.selectSingleNode(contextSlice, "//V5X//CHILD", "dmHierarchy", "HUN");
        return contextDUN.getText();
    }

    public void removeContextSlicer(String contextSlicerHUN) {
        Element contextSlicer = this.findContextSlicerByHUN(contextSlicerHUN);
        if (contextSlicer == null) {
            return;
        }
        Element slicerRootElement = contextSlicer.getParent();
        contextSlicer.detach();
        if (slicerRootElement.elements().size() == 0) {
            slicerRootElement.detach();
        }
        Document report = this.querySelection.getDocument();
        List contextTextItemsForQuery = V5X.selectNodes(report, "//V5X//CHILD", "layouts", "layout", "//V5X//ANY", "contextItemText", "//V5X//ATTR", "refQuery", this.getQueryName());
        if (contextTextItemsForQuery != null) {
            for (Element contextItemText : contextTextItemsForQuery) {
                if (!contextSlicerHUN.equals(contextItemText.elementText("HUN"))) continue;
                V5SpecHelper.detachAndCleanupContents(contextItemText);
            }
        }
    }

    public static List<Element> getQueryNodes(Element anyReportNode) {
        Document reportDoc = anyReportNode.getDocument();
        Element queriesElement = reportDoc.getRootElement().element("queries");
        ArrayList<Element> returnList = new ArrayList<Element>();
        if (queriesElement != null) {
            List queries = queriesElement.elements("query");
            for (Element query : queries) {
                if (query.attributeValue("name").startsWith(_BUSINESS_INSIGHT_QUERY_NAME_)) continue;
                returnList.add(query);
            }
        }
        return returnList;
    }

    public ArrayList<Element> findRefDataItems(List<Element> referencers) {
        ArrayList<Element> resultList = new ArrayList<Element>();
        ListIterator<Element> referencersIter = referencers.listIterator();
        while (referencersIter.hasNext()) {
            Element referencer = referencersIter.next();
            Element queryItem = this._itemList.findItem(referencer.attributeValue("refDataItem"));
            if (queryItem == null) continue;
            resultList.add(queryItem);
        }
        return resultList;
    }

    public Element setSorting(Element targetQueryItem, String ascendingTrueOrFalse) {
        Element setSortingElement = null;
        if (V5QueryItem.isHighLevelSetType(targetQueryItem)) {
            setSortingElement = targetQueryItem.element("setSorting");
            if (ascendingTrueOrFalse == null) {
                if (setSortingElement != null) {
                    setSortingElement.detach();
                }
            } else {
                Element dmTuple;
                setSortingElement = DocumentHelper.makeElement((Branch)targetQueryItem, (String)"setSorting");
                Attribute v5ascendingAttr = setSortingElement.attribute("ascending");
                if (v5ascendingAttr == null) {
                    setSortingElement.addAttribute("ascending", ascendingTrueOrFalse);
                } else {
                    v5ascendingAttr.setValue(ascendingTrueOrFalse);
                }
                if ("dataItemMemberSet".equals(targetQueryItem.getName()) && V5X.selectSingleNode(targetQueryItem, "setDefinition", "setExpandMember") != null) {
                    setSortingElement.addAttribute("breakHierarchy", "false");
                }
                if ((dmTuple = setSortingElement.element("dmTuple")) != null) {
                    dmTuple.detach();
                }
            }
        }
        return setSortingElement;
    }

    public void setSorting_ByValue(Element targetQueryItem, SelectedCell selectedCell, String ascendingTrueOrFalse) {
        if (ascendingTrueOrFalse == null) {
            this.setSorting(targetQueryItem, null);
            return;
        }
        Element copyOfOriginalSetSortingElement = null;
        if (targetQueryItem.element("setSorting") != null) {
            copyOfOriginalSetSortingElement = (Element)targetQueryItem.element("setSorting").clone();
        }
        Element updatedSetSortingElement = this.setSorting(targetQueryItem, ascendingTrueOrFalse);
        HashSet<String> uniqueDimensions = new HashSet<String>();
        boolean tuplePartAdded = false;
        if (updatedSetSortingElement != null) {
            tuplePartAdded = this.addTuplePartFromSelection(updatedSetSortingElement, selectedCell);
            uniqueDimensions.add(selectedCell.nodeDimensionUniqueName);
            for (SelectedCell definingCell : selectedCell.definingCells) {
                if (uniqueDimensions.contains(definingCell.nodeDimensionUniqueName)) continue;
                if (this.addTuplePartFromSelection(updatedSetSortingElement, definingCell) && !tuplePartAdded) {
                    tuplePartAdded = true;
                }
                uniqueDimensions.add(selectedCell.nodeDimensionUniqueName);
            }
        }
        if (!tuplePartAdded) {
            if (updatedSetSortingElement != null) {
                updatedSetSortingElement.detach();
            }
            if (copyOfOriginalSetSortingElement != null) {
                targetQueryItem.add(copyOfOriginalSetSortingElement);
            }
        }
    }

    public void initializeSortInfo(SortInfo si, Element dataItemSubtype, V5Translations translations) {
        Element setSorting = dataItemSubtype.element("setSorting");
        boolean ascending = true;
        if ("false".equals(setSorting.attributeValue("ascending"))) {
            ascending = false;
            si.setDescending();
        }
        if (setSorting.element("dmTuple") != null) {
            List tupleParts = setSorting.element("dmTuple").elements();
            for (Element dmTuplePart : tupleParts) {
                Attribute rdiAttr = dmTuplePart.attribute("refDataItem");
                if (rdiAttr != null) {
                    si.addSortByValue(rdiAttr.getValue(), ascending, true);
                    continue;
                }
                si.addSortByValue(translations.getItemCaption(dmTuplePart.element("dmMember")), ascending, false);
            }
        }
    }

    private boolean addTuplePartFromSelection(Element setSortingElement, SelectedCell selectedCell) {
        Element basedOnQueryItem = this.findItem(selectedCell.nodeName);
        if (!V5QueryItem.isHighLevelSortReferenceItemType(basedOnQueryItem) && "memberUniqueName".equals(selectedCell.nodeType)) {
            Element dmTuple = DocumentHelper.makeElement((Branch)setSortingElement, (String)"dmTuple");
            Element dmTuplePart = dmTuple.addElement("dmTuplePart");
            Element dmMember = dmTuplePart.addElement("dmMember");
            Element MUN = dmMember.addElement("MUN");
            MUN.setText(selectedCell.nodeUse);
            Element itemCaption = dmMember.addElement("itemCaption");
            itemCaption.setText(selectedCell.nodeDisplay);
            if (!this.copyQueryItemDimensionInfo(basedOnQueryItem, dmTuplePart)) {
                this.setDimensionalDataItemInfo(dmTuplePart, selectedCell.nodeDisplay, null, selectedCell.nodeHierarchyUniqueName, selectedCell.nodeDimensionUniqueName);
            }
            return true;
        }
        if (basedOnQueryItem != null && (V5QueryItem.isHighLevelSortReferenceItemType(basedOnQueryItem) || V5QueryItem.upgradeIfDataItemCalculatedMeasure(basedOnQueryItem, selectedCell) || V5QueryItem.upgradeIfKnownAggregateItem(basedOnQueryItem, selectedCell))) {
            Element dmTuple = DocumentHelper.makeElement((Branch)setSortingElement, (String)"dmTuple");
            Element dmTuplePartDataItemRef = dmTuple.addElement("dmTuplePartDataItemRef");
            dmTuplePartDataItemRef.addAttribute("refDataItem", selectedCell.nodeName);
            return true;
        }
        return false;
    }

    private boolean copyQueryItemDimensionInfo(Element sourceQueryItem, Element target) {
        if (sourceQueryItem == null) {
            return false;
        }
        Element source_dmDimension = sourceQueryItem.element("dmDimension");
        if (source_dmDimension != null) {
            Element target_dmDimension = target.element("dmDimension");
            if (target_dmDimension != null) {
                target_dmDimension.detach();
            }
            target_dmDimension = (Element)source_dmDimension.clone();
            target.add(target_dmDimension);
            Element source_dmHierarchy = sourceQueryItem.element("dmHierarchy");
            if (source_dmHierarchy != null) {
                Element target_dmHierarchy = target.element("dmHierarchy");
                if (target_dmHierarchy != null) {
                    target_dmHierarchy.detach();
                }
                target_dmHierarchy = (Element)source_dmHierarchy.clone();
                target.add(target_dmHierarchy);
            }
            V5Translations.notifyValuesChanged(this._envOrNull, sourceQueryItem.getDocument());
            return true;
        }
        return false;
    }

    public boolean setQueryItemDimensionInfo(String rdiName, SelectedCell selectedCell, Element target) {
        boolean dimensionInfoSet = false;
        Element queryItem = this.findItem(rdiName);
        if (queryItem != null) {
            dimensionInfoSet = this.copyQueryItemDimensionInfo(queryItem, target);
        }
        if (!dimensionInfoSet) {
            this.setDimensionalDataItemInfo(target, selectedCell.nodeDisplay, null, selectedCell.nodeHierarchyUniqueName, selectedCell.nodeDimensionUniqueName);
            if (selectedCell.nodeHierarchyUniqueName != null) {
                dimensionInfoSet = true;
            }
        }
        return dimensionInfoSet;
    }

    public Element addListTotalDataItem(String itemToBeTotalled) throws ActionException {
        Element item = this._itemList.findItem(itemToBeTotalled);
        return this._itemList.addDataItemListSummary(this.findUniqueItemName(itemToBeTotalled), "aggregate", item.attributeValue("name"));
    }

    public static boolean isSingValue(Element dataItemElement) {
        String nodeName = dataItemElement.getName();
        if ("dataItemMember".equals(nodeName) || "dataItemCalculatedMember".equals(nodeName) || "dataItemCalculatedMeasure".equals(nodeName) || "dataItemTuple".equals(nodeName)) {
            return true;
        }
        return V5Query.isModelItemReference(dataItemElement) && V5Query.isAbsolutelyMeasure(dataItemElement);
    }

    public static boolean isAbsolutelyMeasure(Element dataItemElement) {
        String nodeName = dataItemElement.getName();
        if ("dataItem".equals(nodeName)) {
            String aggregateAttribute = dataItemElement.attributeValue("aggregate");
            if ("none".equals(aggregateAttribute)) {
                return false;
            }
            if (!"automatic".equals(aggregateAttribute)) {
                return true;
            }
            String rollupAggregateAttribute = dataItemElement.attributeValue("rollupAggregate");
            return !"none".equals(rollupAggregateAttribute) && !"automatic".equals(rollupAggregateAttribute);
            {
            }
        }
        return "dataItemMeasure".equals(nodeName) || "dataItemCalculatedMeasure".equals(nodeName);
    }

    public static boolean isModelItemReference(Element dataItemElement) {
        if ("dataItem".equals(dataItemElement.getName())) {
            return dataItemElement.selectSingleNode(".//*[local-name()='expression']").getText().matches("^\\s*\\[.*\\]\\s*$");
        }
        return true;
    }

    public static boolean isLikelyMeasure(Element dataItemElement) {
        String nodeName = dataItemElement.getName();
        if ("dataItem".equals(nodeName)) {
            return !"none".equals(dataItemElement.attributeValue("aggregate"));
        }
        return "dataItemMeasure".equals(nodeName) || "dataItemCalculatedMeasure".equals(nodeName);
    }

    public boolean isAdditionalDynamicFilterItem(String nameToGetValuesFor) {
        Element item = this.findItem(nameToGetValuesFor);
        return item != null && (DynamicDataFilter.extractParamName(item) != null || V5SpecHelper.getXMLAttribute(item, "RAP_FilterableItem") != null);
    }

    private Element prepareDataItemForDynamicFilterUpdate(ActionEnv env, DynamicDataFilter dynamicDataFilter, boolean bAugment) {
        Element existingFilterForID = this.findDynamicDataFilter(dynamicDataFilter.getId());
        if (existingFilterForID == null) {
            existingFilterForID = this.findDynamicDataFilter(dynamicDataFilter.getName());
        }
        String rdiNameToFilter = dynamicDataFilter.getRDIName();
        Element queryItemToFilter = this.findItem(rdiNameToFilter);
        if (existingFilterForID != null) {
            String customRDINameToFilter;
            if (DynamicDataFilter.isInline(existingFilterForID)) {
                env.getRAPReport().setReportModificationSafeForSecondaryRequest(false);
            }
            if (queryItemToFilter == null && (customRDINameToFilter = V5SpecHelper.getXMLAttribute(existingFilterForID, "RAP_DataFilterCustomRDIName")) != null && dynamicDataFilter.getName().equals(DynamicDataFilter.getFilterDescriptorProperty(existingFilterForID, "name"))) {
                dynamicDataFilter.setCustomRDIName(customRDINameToFilter);
                rdiNameToFilter = customRDINameToFilter;
            }
            if (!bAugment && !dynamicDataFilter.isFacet()) {
                while (existingFilterForID != null) {
                    V5Query.removeDynamicDataFilter(existingFilterForID, true, this);
                    existingFilterForID = this.findDynamicDataFilter(dynamicDataFilter.getId());
                }
            }
            queryItemToFilter = this.findItem(rdiNameToFilter);
        } else {
            env.getRAPReport().setReportModificationSafeForSecondaryRequest(false);
        }
        return queryItemToFilter;
    }

    public void updateDynamicDataFilter(ActionEnv env, DynamicDataFilter dynamicDataFilter, boolean postAutoAggregation) throws ActionException {
        if (!dynamicDataFilter.isInitialized()) {
            return;
        }
        boolean bAugment = dynamicDataFilter.isAdditionalPayloadItem() || env != null && env.getActionArg("augment") != null;
        this.setEnv(env);
        Element queryItemToFilter = this.prepareDataItemForDynamicFilterUpdate(env, dynamicDataFilter, bAugment);
        if (queryItemToFilter != null) {
            V5QueryItem queryItem = new V5QueryItem(env, this, queryItemToFilter);
            queryItem.setNumericSubtypesRequired(false);
            if (this.updatePreAuthoredDynamicDataFilter(dynamicDataFilter, queryItem, env)) {
                return;
            }
            if (!V5SpecHelper.isDetailFilteringAvailable(this.getQueryElement().getDocument().getRootElement()) && V5Query.findBusinessInsightQueryItem(queryItemToFilter, env.getLocale()) == null) {
                return;
            }
            boolean isMemberTypeColumn = false;
            if (dynamicDataFilter instanceof DynamicDiscreteValuesFilter) {
                isMemberTypeColumn = ((DynamicDiscreteValuesFilter)dynamicDataFilter).initializeFilterOnMemberTypeColumn(queryItem);
            }
            if (isMemberTypeColumn && V5SpecHelper.useSetFilterForSliders(this.querySelection.getDocument())) {
                dynamicDataFilter.updateV5SetFilter(this, queryItem);
            } else {
                Element detailFilters = DocumentHelper.makeElement((Branch)this.querySelection.getParent(), (String)"detailFilters");
                dynamicDataFilter.generateV5DetailFilter(detailFilters, isMemberTypeColumn, postAutoAggregation);
                if (detailFilters.elements().size() == 0) {
                    detailFilters.detach();
                }
            }
            V5SpecHelper.setXMLAttribute(queryItemToFilter, "RAP_FilterableItem", "true", "no");
        } else if (dynamicDataFilter instanceof DynamicDiscreteValuesFilter && !this.updateAttributeFacetDetailFilter(dynamicDataFilter, dynamicDataFilter.getName())) {
            V5ContextSlicer.updateDynamicSlicerIfApplicable(this, (DynamicDiscreteValuesFilter)dynamicDataFilter);
        }
    }

    public boolean updateAttributeFacetDetailFilter(DynamicDataFilter dynamicDataFilter, String dimension) throws CognosServiceRequestException {
        if (dynamicDataFilter.isFacet() && dynamicDataFilter.isAttributeType()) {
            Element anyDUN;
            Element detailFilters = DocumentHelper.makeElement((Branch)this.querySelection.getParent(), (String)"detailFilters");
            Element detailFilterForID = this.findDynamicDataFilter(dynamicDataFilter.getId());
            Element newDetailFilterAdded = null;
            if (detailFilterForID == null) {
                newDetailFilterAdded = detailFilterForID = detailFilters.addElement("detailFilter");
            }
            if ((anyDUN = V5X.selectSingleNode(this.querySelection, "DUN")) != null) {
                String NS = V5QueryItem.getNameSpace(anyDUN.getParent().getParent());
                String dimName = ".[" + dimension + "]";
                String HUN = "[" + NS + "]" + dimName + dimName;
                JSONObject dimensionInfo = this.getDimensionInfo(dynamicDataFilter.getReportModelPath(), detailFilterForID, HUN);
                if (this.hasAttribute(dimensionInfo, dynamicDataFilter.getAttributeName())) {
                    dynamicDataFilter.generateV5AttributeFilter(HUN, dimensionInfo, detailFilterForID);
                } else if (newDetailFilterAdded != null) {
                    newDetailFilterAdded.detach();
                }
            }
            if (detailFilters.elements().size() == 0) {
                detailFilters.detach();
            }
            return true;
        }
        return false;
    }

    public boolean updatePreAuthoredDynamicDataFilter(DynamicDataFilter dynamicDataFilter, V5QueryItem queryItem, ActionEnv env) {
        if (dynamicDataFilter == null) {
            return false;
        }
        if (dynamicDataFilter.initializeFromPreauthoredFilter(queryItem.getDOM())) {
            dynamicDataFilter.addFilterTags(queryItem.getDOM(), dynamicDataFilter.getClientId(), dynamicDataFilter.generateV5FilterDescriptor(), true, false);
            return true;
        }
        Element biQueryItem = V5Query.findBusinessInsightQueryItem(queryItem.getDOM(), env.getLocale());
        if (biQueryItem != null && dynamicDataFilter.initializeFromPreauthoredFilter(biQueryItem)) {
            String biQueryExpression = biQueryItem.elementText("expression");
            dynamicDataFilter.addFilterTags(queryItem.getDOM(), dynamicDataFilter.getClientId(), dynamicDataFilter.generateV5FilterDescriptor(), false, true);
            Element targetExpression = queryItem.getDOM().element("expression");
            if (targetExpression != null && V5SpecHelper.getXMLAttribute(queryItem.getDOM(), "RAP_OriginalExpression") == null) {
                V5SpecHelper.setXMLAttribute(queryItem.getDOM(), "RAP_OriginalExpression", targetExpression.getText(), "no");
                targetExpression.setText(biQueryExpression);
            }
            return true;
        }
        return false;
    }

    public boolean removeDynamicDataFilter(DynamicDataFilterResetter dynamicDataFilterResetter, boolean removeEmptyDetailFilters) {
        if (dynamicDataFilterResetter.isFacet() && V5ContextSlicer.resetFacet(this, dynamicDataFilterResetter)) {
            return true;
        }
        Element v5DynamicDataFilter = this.findDynamicDataFilter(dynamicDataFilterResetter.getClientId());
        if (v5DynamicDataFilter == null && dynamicDataFilterResetter.isFacet()) {
            v5DynamicDataFilter = dynamicDataFilterResetter.isAttributeType() ? this.findItem(dynamicDataFilterResetter.getQualifiedAttributeName(this)) : this.findItem(dynamicDataFilterResetter.getName());
        }
        if (v5DynamicDataFilter != null) {
            Element facetBase = dynamicDataFilterResetter.isFacet() && dynamicDataFilterResetter.isAttributeType() ? dynamicDataFilterResetter.getFacetBase(this) : v5DynamicDataFilter;
            Element expressionElement = V5X.selectSingleNode(facetBase, "expression");
            if (dynamicDataFilterResetter.isFacet()) {
                V5SetFiltering setFiltering = new V5SetFiltering();
                if (expressionElement != null) {
                    String termToRemove = dynamicDataFilterResetter.isAttributeType() ? dynamicDataFilterResetter.getQualifiedAttributeName(this) : DynamicDataFilter.getRefExplicitMemberName(dynamicDataFilterResetter.getName());
                    setFiltering.addRemoveIntersectTerm(this, facetBase, expressionElement, termToRemove, false);
                    Element linkedSetItem = V5SpecHelper.getLinkedSetItem(this, facetBase);
                    if (linkedSetItem != null) {
                        expressionElement = V5X.selectSingleNode(linkedSetItem, "expression");
                        setFiltering.addRemoveIntersectTerm(this, linkedSetItem, expressionElement, termToRemove, false);
                    }
                } else {
                    setFiltering.clearFacet(this, dynamicDataFilterResetter.getName(), null);
                    Element linkedSetItem = V5SpecHelper.getLinkedSetItem(this, v5DynamicDataFilter);
                    if (linkedSetItem != null) {
                        setFiltering.clearFacet(this, linkedSetItem.attributeValue("name"), dynamicDataFilterResetter.getName());
                    }
                }
                DynamicDataFilter.removeFilterTags(v5DynamicDataFilter);
            } else {
                while (v5DynamicDataFilter != null) {
                    V5Query.removeDynamicDataFilter(v5DynamicDataFilter, removeEmptyDetailFilters, null);
                    v5DynamicDataFilter = this.findDynamicDataFilter(dynamicDataFilterResetter.getClientId());
                }
            }
            return true;
        }
        if (!dynamicDataFilterResetter.isFacet()) {
            return V5ContextSlicer.removeDynamicContextSlicer(this.getQueryElement(), dynamicDataFilterResetter.getClientId());
        }
        return false;
    }

    public static void removeAllDynamicContextSlicer(Element report) {
        List<Element> dynamicSlicers = V5ContextSlicer.findDynamicContextSlicers(report);
        for (Element dynamicSlicer : dynamicSlicers) {
            String clientId = V5ContextSlicer.SliderInfo.getClientId(dynamicSlicer);
            V5ContextSlicer.removeDynamicContextSlicer((Element)dynamicSlicer.selectSingleNode(V5X.selectAncestors("query")), clientId);
        }
    }

    private static void removeDynamicDataFilter(Element v5DynamicDataFilter, boolean removeEmptyDetailFilters, V5Query v5QueryParm) {
        if ("detailFilter".equals(v5DynamicDataFilter.getName())) {
            Element detailFilters = v5DynamicDataFilter.getParent();
            v5DynamicDataFilter.detach();
            if (removeEmptyDetailFilters && detailFilters.elements().size() == 0) {
                detailFilters.detach();
            }
        } else if ("dataItem".equals(v5DynamicDataFilter.getName()) || "dataItemSetExpression".equals(v5DynamicDataFilter.getName())) {
            String originalExpression = V5SpecHelper.getXMLAttribute(v5DynamicDataFilter, "RAP_OriginalExpression");
            if (originalExpression != null) {
                Element dataItemExpression = v5DynamicDataFilter.element("expression");
                dataItemExpression.setText(originalExpression);
            }
            DynamicDataFilter.removeFilterTags(v5DynamicDataFilter);
        } else if ("dataItemMemberSet".equals(v5DynamicDataFilter.getName())) {
            V5SetFiltering setFiltering = new V5SetFiltering();
            V5Query v5Query = v5QueryParm;
            if (v5Query == null) {
                Element query = v5DynamicDataFilter.getParent().getParent();
                v5Query = new V5Query(v5DynamicDataFilter, query.attributeValue("name"));
            }
            setFiltering.clearExistingSetFilters(v5Query, v5DynamicDataFilter.attributeValue("name"));
            Element linkedSetItem = V5SpecHelper.getLinkedSetItem(v5Query, v5DynamicDataFilter);
            if (linkedSetItem != null) {
                setFiltering.clearExistingSetFilters(v5Query, linkedSetItem.attributeValue("name"));
            }
            v5Query.getItemList().clear();
            v5Query.getItemList().load();
        } else if ("contextSlice".equals(v5DynamicDataFilter.getName())) {
            V5ContextSlicer.removeDynamicContextSlicer(v5DynamicDataFilter);
        }
    }

    public static void removeAllDynamicDataFilters(Element report, boolean bRemoveContextSlicers) {
        List<Element> nodes = V5Query.findDynamicDataFilters_AllQueries(report.getDocument());
        if (nodes != null) {
            for (Element node : nodes) {
                V5Query.removeDynamicDataFilter(node, true, null);
            }
        }
        if (bRemoveContextSlicers) {
            V5Query.removeAllDynamicContextSlicer(report);
        }
    }

    public void removeFiltersUsingDataItem(String refDataItem) {
        String regExRef = V5Query.getRegExForExpressionReferences(V5Query.createDataItemReference(refDataItem));
        List filterExpressions = XMLUtility.selectNodes(this.querySelection.getParent(), ".//*[local-name()='detailFilters']/*[local-name()='detailFilter']/*[local-name()='filterExpression']  | .//*[local-name()='summaryFilters']/*[local-name()='summaryFilter']/*[local-name()='filterExpression'] ");
        for (Element filterExpression : filterExpressions) {
            if (V5X.selectSingleNode(filterExpression.getParent(), "XMLAttribute", "//V5X//ATTR", "name", "RAP_DataFilterID") != null || !Pattern.matches(regExRef, filterExpression.getText())) continue;
            filterExpression.getParent().detach();
        }
        List emptyFiltersElements = XMLUtility.selectNodes(this.querySelection.getParent(), ".//*[local-name()='detailFilters' or local-name()='summaryFilters'][not(./*)]");
        for (Element emptyFiltersElement : emptyFiltersElements) {
            emptyFiltersElement.detach();
        }
    }

    public void mergeDataItemsFromQuery(V5Query sourceQuery) {
        if (this.getQueryName().equals(sourceQuery.getQueryName())) {
            return;
        }
        Collection<Element> sourceDataItems = sourceQuery.getItemList().getDataItemElements();
        for (Element sourceDataItem : sourceDataItems) {
            this.getItemList().addDataItem((Element)sourceDataItem.clone());
        }
    }

    public static String createDataItemReference(String refDataItem) {
        return "[" + refDataItem + "]";
    }

    public static String getRegExForExpressionReferences(String ref) {
        return ".*([^\\.]|^)" + V5Query.escapeRegExpression(ref) + "(?=[^\\.\\]]|$).*";
    }

    public static String escapeRegExpression(String input) {
        Matcher match = RegExpressionEscapePattern.matcher(input);
        return match.replaceAll("\\\\$1");
    }

    public static String escapeQueryExpressionReference(String name) {
        return name.replace("]", "]]");
    }

    private static void disableDetailFilter(Element v5DetailFilter) {
        if ("detailFilter".equals(v5DetailFilter.getName())) {
            v5DetailFilter.addAttribute("use", "prohibited");
        }
    }

    public static void disableAllDetailFilters(Element report) {
        List<Element> nodes = V5Query.findDetailFilters_AllQueries(report.getDocument());
        if (nodes != null) {
            for (Element node : nodes) {
                V5Query.disableDetailFilter(node);
            }
        }
    }

    public static List<Element> findDetailFilters_AllQueries(Document report) {
        String reportPrefix = "./*[local-name()='queries']/*[local-name()='query']/";
        ArrayList<Element> dynamicDataFilters = new ArrayList<Element>();
        dynamicDataFilters.addAll(XMLUtility.selectNodes(report.getRootElement(), reportPrefix + _detailFilters));
        return dynamicDataFilters;
    }

    public Element findDynamicDataFilter(String filterId) {
        if (filterId != null) {
            String namedXMLAttributePath = V5X.selectPath("//V5X//SUBSELECT", "//V5X//CHILD", "XMLAttributes", "XMLAttribute", "//V5X//ATTR", "name", "RAP_DataFilterID", "//V5X//AND", "value", filterId);
            String xpath = V5X.selectPath("//V5X//CHILD", "detailFilters", "detailFilter") + namedXMLAttributePath;
            Element nodeMarker = (Element)this.querySelection.getParent().selectSingleNode(xpath);
            if (nodeMarker == null) {
                xpath = V5X.selectPath("//V5X//CHILD", "dataItem", "//V5X//OR", "dataItemSetExpression", "//V5X//OR", "dataItemMemberSet") + namedXMLAttributePath;
                nodeMarker = (Element)this.querySelection.selectSingleNode(xpath);
            }
            if (nodeMarker != null) {
                return nodeMarker.getParent().getParent();
            }
            return V5ContextSlicer.findDynamicContextSlicer(this.getQueryElement(), filterId);
        }
        return null;
    }

    public List<Element> findDynamicDataFilters() {
        ArrayList<Element> dynamicDataFilters = new ArrayList<Element>();
        dynamicDataFilters.addAll(XMLUtility.selectNodes(this.querySelection.getParent(), _dynamicDetailFiltersXPath));
        dynamicDataFilters.addAll(XMLUtility.selectNodes(this.querySelection.getParent(), _dynamicDataItemFiltersXPath));
        return dynamicDataFilters;
    }

    public static List<Element> findDynamicDataFilters_AllQueries(Document report) {
        String reportPrefix = "./*[local-name()='queries']/*[local-name()='query']/";
        ArrayList<Element> dynamicDataFilters = new ArrayList<Element>();
        dynamicDataFilters.addAll(XMLUtility.selectNodes(report.getRootElement(), reportPrefix + _dynamicDetailFiltersXPath));
        dynamicDataFilters.addAll(XMLUtility.selectNodes(report.getRootElement(), reportPrefix + _dynamicDataItemFiltersXPath));
        return dynamicDataFilters;
    }

    public static Element getExpressionElement(Element rootElement) {
        if ("detailFilter".equals(rootElement.getName()) || "summaryFilter".equals(rootElement.getName())) {
            return rootElement.element("filterExpression");
        }
        if ("dataItem".equals(rootElement.getName()) || "dataItemSetExpression".equals(rootElement.getName())) {
            return rootElement.element("expression");
        }
        return null;
    }

    public String getDynamicDataFilterParameterName(String filterId) {
        Element ddf = this.findDynamicDataFilter(filterId);
        if (ddf != null) {
            return V5SpecHelper.getXMLAttribute(ddf, "RAP_DataFilterParam");
        }
        return null;
    }

    public static List<String> findDynamicDataFilterDescriptors_AllQueries(Document report) {
        HashSet<String> uniqueFilterControlIDSet = new HashSet<String>();
        ArrayList<String> filterDescriptors = null;
        List<Element> dynamicDataFilters = V5Query.findDynamicDataFilters_AllQueries(report);
        if (dynamicDataFilters.size() > 0) {
            new ArrayList();
            for (Element df : dynamicDataFilters) {
                String filterControlID = V5SpecHelper.getXMLAttribute(df, "RAP_DataFilterID");
                if (filterControlID == null || uniqueFilterControlIDSet.contains(filterControlID)) continue;
                uniqueFilterControlIDSet.add(filterControlID);
                String descriptor = V5SpecHelper.getXMLAttribute(df, "RAP_DataFilterDescriptor");
                if (descriptor == null) continue;
                if (filterDescriptors == null) {
                    filterDescriptors = new ArrayList<String>();
                }
                filterDescriptors.add(descriptor);
            }
        }
        return filterDescriptors;
    }

    public ItemList getItemList() {
        return this._itemList;
    }

    public void addFilterableItem(ActionEnv env, FilterableItemsInfo filterableItems, Element dataItemOrSubtype, boolean visible, String label, boolean includeMembers) throws ActionException {
        if (includeMembers && "dataItemMember".equals(dataItemOrSubtype.getName())) {
            Element name = (Element)dataItemOrSubtype.selectSingleNode(V5X.select("dmHierarchy") + V5X.subselect("HUN"));
            Element caption = (Element)dataItemOrSubtype.selectSingleNode(V5X.select("dmHierarchy") + V5X.subselect("itemCaption"));
            if (name != null && caption != null) {
                FilterableItemsInfo.FilterableItemInfo info = filterableItems.add(name.getText(), caption.getText(), V5QueryItem.isHighLevelMeasure(dataItemOrSubtype), visible);
                info.setIsModel(true);
            }
        }
        if (!"dataItemMember".equals(dataItemOrSubtype.getName()) && !"dataItemTuple".equals(dataItemOrSubtype.getName())) {
            boolean isRange = false;
            V5QueryItem queryItem = new V5QueryItem(env, this, dataItemOrSubtype);
            if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_USE_GET_PARAMS_REQ_FOR_FILTERITEM")) {
                queryItem.setUseGetParamReqForFiltItem(true);
            }
            if (queryItem.confirmIsNumeric()) {
                if (queryItem.getNumericSubType() == V5QueryItem.NumericSubType.measure || queryItem.getNumericSubType() == V5QueryItem.NumericSubType.calculation || queryItem.getNumericSubType() == V5QueryItem.NumericSubType.calculationOrAggregate) {
                    isRange = true;
                } else {
                    if (queryItem.getNumericSubType() == V5QueryItem.NumericSubType.aggregate) {
                        return;
                    }
                    if (queryItem.getProperties() != null && queryItem.getProperties().getModelItem() == null) {
                        isRange = true;
                    }
                }
            } else if (queryItem.getItemType() == V5QueryItem.ItemType.dateTime) {
                return;
            }
            filterableItems.add(dataItemOrSubtype.attributeValue("name"), label, isRange, visible);
        }
    }

    public Element findMemberSet(Element dataItem) {
        if (this._memberSetInfo == null) {
            List memberSets;
            Element memberSetRoot;
            Element queryRoot;
            this._memberSetInfo = new HashMap();
            if (this.querySelection != null && (queryRoot = this.querySelection.getParent()) != null && (memberSetRoot = queryRoot.element("memberSetStructure")) != null && (memberSets = V5X.selectNodes(memberSetRoot, "memberSet")) != null && memberSets.size() > 0) {
                for (Element memberSet : memberSets) {
                    this._memberSetInfo.put(memberSet.attributeValue("refDataItem"), memberSet);
                }
            }
        }
        return this._memberSetInfo.get(dataItem.attributeValue("name"));
    }

    public static boolean isLowLevelDataItem(Element queryDataItem) {
        boolean isLowLevelDataItem = false;
        if (queryDataItem != null && "dataItem".equals(queryDataItem.getName())) {
            isLowLevelDataItem = true;
        }
        return isLowLevelDataItem;
    }

    public static ArrayList<String> getExpandedMembers(Element queryItem) {
        ArrayList<String> setExpandMembers = new ArrayList<String>();
        if (queryItem == null || !"dataItemMemberSet".equals(queryItem.getName())) {
            return setExpandMembers;
        }
        List setExpandCollapseMemberList = V5X.selectNodes(queryItem, "setExpandMember", "//V5X//OR", "setCollapseMember");
        ListIterator iterator = setExpandCollapseMemberList.listIterator(setExpandCollapseMemberList.size());
        while (iterator.hasPrevious()) {
            Element setExpandCollapseMember = (Element)iterator.previous();
            Element eMUN = V5X.selectSingleNode(setExpandCollapseMember, "//V5X//CHILD", "dmMember", "//V5X//CHILD", "MUN");
            String sMUN = eMUN.getText();
            if (setExpandCollapseMember.getName().equals("setExpandMember")) {
                setExpandMembers.add(sMUN);
                continue;
            }
            setExpandMembers.remove(sMUN);
        }
        return setExpandMembers;
    }

    public JSONArray getLevels(String modelPath, V5QueryItem queryItem) throws CognosServiceRequestException {
        return this.getLevels(modelPath, queryItem.getDOM(), V5QueryItem.getHun(queryItem.getDOM()));
    }

    public JSONArray getLevels(String modelPath, Element queryItem, String hun) throws CognosServiceRequestException {
        JSONObject dimInfo = this.getDimensionInfo(modelPath, queryItem, hun);
        if (dimInfo == null) {
            return null;
        }
        return (JSONArray)dimInfo.get((Object)"levels");
    }

    public JSONArray requestMeasures(String modelPath, String measureDimensionName, boolean refreshMeasures) throws CognosServiceRequestException {
        JSONObject dimInfo;
        if (refreshMeasures) {
            V5SpecHelper.removeXMLAttribute(this.getQueryElement().getDocument().getRootElement(), "RAP_DIMENSION_INFO");
        }
        if ((dimInfo = this.getDimensionInfo(modelPath, this.getQueryElement().getDocument().getRootElement(), this.getMeasureDUN(measureDimensionName))) == null) {
            return null;
        }
        return (JSONArray)dimInfo.get((Object)"measures");
    }

    public JSONObject requestMeasure(String modelPath, String measureDimensionName, String measureName) throws CognosServiceRequestException {
        JSONArray measures = this.requestMeasures(modelPath, measureDimensionName, false);
        if (measures != null) {
            for (int i = 0; i < measures.size(); ++i) {
                JSONObject measure = (JSONObject)measures.get(i);
                String thisMeasureName = (String)measure.get((Object)"name");
                if (!measureName.equals(thisMeasureName)) continue;
                return measure;
            }
        }
        return null;
    }

    public String getMeasureDUN(String dimensionName) {
        List measures = V5X.selectNodes(this.getQueryElement(), "//V5X//CHILD", "selection", "dataItemMeasure", "//V5X//OR", "dataItemCalculatedMeasure");
        for (Element measure : measures) {
            if (!dimensionName.equals(V5QueryItem.getDimensionName(measure))) continue;
            return V5QueryItem.getDun(measure);
        }
        return null;
    }

    public boolean hasAttribute(JSONObject dimensionInfo, String attributeName) {
        if (dimensionInfo == null || Boolean.FALSE.equals(dimensionInfo.get((Object)"exists"))) {
            return false;
        }
        JSONObject attributes = (JSONObject)dimensionInfo.get((Object)"attributes");
        return attributes != null && attributes.get((Object)attributeName) != null;
    }

    public static JSONArray getLevels(JSONObject dimensionInfo) {
        if (dimensionInfo == null) {
            return null;
        }
        return (JSONArray)dimensionInfo.get((Object)"levels");
    }

    public static boolean isString(JSONObject dimensionInfo, String attributeName) {
        if (dimensionInfo != null && dimensionInfo.get((Object)"attributes") != null) {
            JSONObject attributes = (JSONObject)dimensionInfo.get((Object)"attributes");
            Boolean isString = (Boolean)attributes.get((Object)attributeName);
            return isString == null ? true : isString;
        }
        return true;
    }

    public JSONObject getDimensionInfo(String modelPath, Element queryItem, String hun) throws CognosServiceRequestException {
        List attributes;
        if (hun == null || "".equals(hun)) {
            return null;
        }
        String unknownHunProp = V5SpecHelper.getXMLAttribute(queryItem.getDocument(), "RAP_UNKNOWN_HUNS");
        JSONObject unknownHuns = null;
        if (unknownHunProp != null) {
            try {
                unknownHuns = JSONObject.parse((String)unknownHunProp);
                if (unknownHuns.get((Object)hun) != null) {
                    JSONObject dimensionDoesNotExist = new JSONObject();
                    dimensionDoesNotExist.put((Object)"exists", (Object)Boolean.FALSE);
                    return dimensionDoesNotExist;
                }
            }
            catch (Exception dimensionDoesNotExist) {
                // empty catch block
            }
        }
        JSONObject rapDimensionInfo = null;
        String dimensionInfoJSON = V5SpecHelper.getXMLAttribute(queryItem, "RAP_DIMENSION_INFO");
        if ("".equals(dimensionInfoJSON)) {
            return null;
        }
        if (dimensionInfoJSON != null) {
            try {
                rapDimensionInfo = JSONObject.parse((String)dimensionInfoJSON);
                return rapDimensionInfo;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._envOrNull == null) {
            return null;
        }
        ActionEnv env = this._envOrNull;
        String requestString = this._genMaRequestLevelsString(env.getLocale(), modelPath, hun);
        if (requestString == null) {
            return null;
        }
        rapDimensionInfo = new JSONObject();
        Element maResponse = env.getRapServiceRequestManager().executeMAQuery(requestString, null);
        rapDimensionInfo.put((Object)"exists", (Object)(maResponse == null ? Boolean.FALSE : Boolean.TRUE));
        if (maResponse == null) {
            if (unknownHuns == null) {
                unknownHuns = new JSONObject();
            }
            unknownHuns.put((Object)hun, (Object)"0");
            V5SpecHelper.setXMLAttribute(queryItem.getDocument(), "RAP_UNKNOWN_HUNS", unknownHuns.toString());
            return rapDimensionInfo;
        }
        List levels = V5X.selectNodes(maResponse, "level");
        if (levels.size() > 0) {
            JSONArray rapLevels = new JSONArray();
            rapDimensionInfo.put((Object)"levels", (Object)rapLevels);
            for (Object level : levels) {
                JSONObject levelobj = new JSONObject();
                levelobj.put((Object)"_ref", (Object)level.attributeValue("_ref"));
                rapLevels.add((Object)levelobj);
            }
        } else {
            rapDimensionInfo.put((Object)"parentChild", (Object)Boolean.TRUE);
        }
        List measures = V5X.selectNodes(maResponse, "measure");
        if (measures.size() > 0) {
            JSONArray rapMeasures = new JSONArray();
            rapDimensionInfo.put((Object)"measures", (Object)rapMeasures);
            for (Element measure : measures) {
                JSONObject measureobj = new JSONObject();
                measureobj.put((Object)"name", (Object)measure.attributeValue("name"));
                measureobj.put((Object)"_ref", (Object)measure.attributeValue("_ref"));
                rapMeasures.add((Object)measureobj);
            }
        }
        if ((attributes = V5X.selectNodes(maResponse, "queryItem")).size() > 0) {
            JSONObject rapAttributes = new JSONObject();
            rapDimensionInfo.put((Object)"attributes", (Object)rapAttributes);
            for (Element attribute : attributes) {
                Boolean isString = "60".equals(attribute.attributeValue("datatype")) ? Boolean.TRUE : Boolean.FALSE;
                rapAttributes.put((Object)attribute.attributeValue("name"), (Object)isString);
            }
        }
        V5SpecHelper.setXMLAttribute(queryItem, "RAP_DIMENSION_INFO", rapDimensionInfo.toString(), "no");
        return rapDimensionInfo;
    }

    public ArrayList<Element> getPUNs(String modelPath, ArrayList<String> munList) throws CognosServiceRequestException {
        if (this._envOrNull == null) {
            return null;
        }
        ActionEnv env = this._envOrNull;
        String requestString = this._genMaRequestPunQueryString(env.getLocale(), modelPath, munList);
        if (requestString == null) {
            return null;
        }
        ArrayList<Element> maResponses = env.getRapServiceRequestManager().executeMAQuerySet(requestString, null);
        return maResponses;
    }

    public JSONObject getPUNS_JSON(String modelPath, ArrayList<String> munList) throws CognosServiceRequestException {
        Element maResponse;
        Element member;
        ArrayList<Element> maResponses = this.getPUNs(modelPath, munList);
        if (maResponses == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        Iterator<Element> iterator = maResponses.iterator();
        while (iterator.hasNext() && (member = (maResponse = iterator.next()).element("member")) != null) {
            String mun = member.attributeValue("memberUniqueName");
            String pun = member.attributeValue("parentUniqueName");
            if (mun == null || pun == null) continue;
            JSONArray munArray = null;
            munArray = jsonObject.containsKey((Object)pun) ? (JSONArray)jsonObject.get((Object)pun) : new JSONArray();
            munArray.add((Object)mun);
            jsonObject.put((Object)pun, (Object)munArray);
        }
        return jsonObject;
    }

    private String _genMaRequestPunQueryString(String locale, String modelPath, List<String> munList) {
        if (locale == null || modelPath == null || munList == null || munList.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<metadataRequest connection=\"" + modelPath + "\">");
        for (String memberUniqueName : munList) {
            sb.append("<Metadata authoringLocale=\"" + locale + "\" xml:lang=\"" + locale + "\" " + "start_at=\"" + memberUniqueName + "\" " + "Depth=\"1\" >" + "<Properties>" + "<Property name=\"*/@memberUniqueName\"/>" + "<Property name=\"*/@parentUniqueName\"/>" + "</Properties>" + "</Metadata>");
        }
        sb.append("</metadataRequest>");
        return sb.toString();
    }

    private String _genMaRequestLevelsString(String locale, String modelPath, String startAt) {
        if (locale == null || modelPath == null || startAt == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<metadataRequest connection=\"" + modelPath + "\">");
        sb.append("<Metadata authoringLocale=\"" + locale + "\" xml:lang=\"" + locale + "\" " + "start_at=\"" + startAt + "\" " + "Depth=\"3\" >" + "<Properties>" + "<Property name=\"*/@name\"/>" + "<Property name=\"*/@_path\"/>" + "<Property name=\"*/@_ref\"/>" + "<Property name=\"*/@parentChild\"/>" + "<Property name=\"./dimension\"/>" + "<Property name=\"./hierarchy\"/>" + "<Property name=\"./level\"/>" + "<Property name=\"*/@_IntrinsicPropertiesOff\"/>" + "<Property name=\"./queryItem\"/>" + "<Property name=\"queryItem/@datatype\"/>" + "<Property name=\"*/@memberUniqueName\"/>" + "<Property name=\"*/@parentUniqueName\"/>" + "<Property name=\"./measure\"/>" + "<Property name=\"measure/@datatype\"/>" + "<Property name=\"measure/@currency\"/>" + "<Property name=\"measure/@isHierarchical\"/>" + "<Property name=\"measure/@regularAggregate\"/>" + "<Property name=\"./folder\"/>" + "<Property name=\"./measureFolder\"/>" + "</Properties>" + "</Metadata>");
        sb.append("</metadataRequest>");
        return sb.toString();
    }

    public void revertToRegularSet() {
        List dataItemMemberSetList = XMLUtility.selectNodes(this.getQuerySelection(), V5X.select("dataItemMemberSet"));
        if (dataItemMemberSetList.size() > 0) {
            this.getFilters(this._envOrNull).clearSetAndDetailFilters();
            for (Element dataItemSet : dataItemMemberSetList) {
                V5SetFiltering.dataItemMemberSetToRegularSet(dataItemSet);
                V5SpecHelper.removeXMLAttribute(dataItemSet, V5SetExpandCollapse.EXPANDED_MEMBER_INFO_ATTR);
            }
        }
    }

    public void revertToRegularSet(String rdiName) {
        Element dataItemSet = this.findItem(rdiName);
        if (dataItemSet != null && "dataItemMemberSet".equals(dataItemSet.getName())) {
            V5SpecHelper.removeXMLAttribute(dataItemSet, V5SetExpandCollapse.EXPANDED_MEMBER_INFO_ATTR);
            this.getFilters(this._envOrNull).clearExistingFilters(rdiName);
        }
    }

    public static boolean isHierarchySet(Element relatedQueryItem) {
        Element eSetHierarchyMembers = V5X.selectSingleNode(relatedQueryItem, "setHierarchyMembers");
        return eSetHierarchyMembers != null || "dataItemHierarchySet".equals(relatedQueryItem.getName());
    }

    public static boolean isRootMembersOnlyHierarchySet(Element relatedQueryItem) {
        if ("dataItemHierarchySet".equals(relatedQueryItem.getName())) {
            return "true".equals(relatedQueryItem.attributeValue("rootMembersOnly"));
        }
        if (!"dataItemMemberSet".equals(relatedQueryItem.getName())) {
            return false;
        }
        Element eSetHierarchyMembers = V5X.selectSingleNode(relatedQueryItem, "setHierarchyMembers");
        if (eSetHierarchyMembers != null) {
            return "true".equals(eSetHierarchyMembers.attributeValue("rootMembersOnly"));
        }
        return false;
    }

    public void clearDetailFilters(String rdiName) {
        V5QueryFilters filters = this.getFilters(this._envOrNull);
        filters.clearExistingDetailFilters(rdiName);
    }

    public static boolean isRSDrillParent(Element relatedQueryItem) {
        return "true".equals(V5SpecHelper.getXMLAttribute(relatedQueryItem, "RS_drillparent"));
    }

    public static boolean isDrilledOn(Element relatedQueryItem) {
        return V5SpecHelper.getXMLAttribute(relatedQueryItem, "RAP_DrillResetItem") != null || V5SpecHelper.getXMLAttribute(relatedQueryItem, "RAP_DrillResetExpression") != null;
    }

    public static void getSetExceptMembers(Element queryItem, List<String> setExceptMembersList, HashMap<String, Element> getExceptMembersMap) {
        if (queryItem == null) {
            return;
        }
        List eSetExceptMembersList = V5X.selectNodes(queryItem, "setExceptMembers");
        if (eSetExceptMembersList.size() > 0) {
            for (int i = 0; i < eSetExceptMembersList.size(); ++i) {
                Element e = (Element)eSetExceptMembersList.get(i);
                String sMUN = V5X.selectSingleNode(e, "//V5X//CHILD", "dmMembers", "//V5X//CHILD", "dmMember", "//V5X//CHILD", "MUN").getText();
                getExceptMembersMap.put(sMUN, e);
                setExceptMembersList.add(sMUN);
            }
        }
    }

    public Element getItem(String dataItemType, String sMUN) {
        return (Element)this.querySelection.selectSingleNode(V5X.subselect(dataItemType) + "[.//*[local-name()='" + "MUN" + "'][string()='" + sMUN + "']]");
    }

    public class ItemList {
        private HashMap<String, Element> _queryItemCache = new HashMap();

        public void collectFilterableItems(ActionEnv env, FilterableItemsInfo filterableItems, boolean includeMembers) throws ActionException {
            Collection<Element> dataItemsAndSubtypes = this._queryItemCache.values();
            for (Element dataItemOrSubtype : dataItemsAndSubtypes) {
                String paramName = DynamicDataFilter.extractParamName(dataItemOrSubtype);
                if (paramName == null && V5SpecHelper.getXMLAttribute(dataItemOrSubtype, "RAP_FilterableItem") == null) continue;
                V5Query.this.addFilterableItem(env, filterableItems, dataItemOrSubtype, true, dataItemOrSubtype.attributeValue("label"), includeMembers);
            }
            V5Translations v5Translations = new V5Translations(env.getLocale());
            for (Element contextSlice : V5ContextSlicer.findContextSlicers(V5Query.this.getQueryElement())) {
                String hun = V5ContextSlicer.getContextSlicerHUN(contextSlice);
                String label = v5Translations.getTranslatedCaptionForMUNorHUN(contextSlice.getDocument(), hun);
                V5ContextSlicer.addFilterableItemForSliders(env, filterableItems, contextSlice, label);
            }
        }

        public void load() {
            if (V5Query.this.querySelection != null) {
                List dataItemList = V5Query.this.querySelection.selectNodes(".//*[starts-with(local-name(), 'dataItem')] ");
                ListIterator dataItemIter = dataItemList.listIterator();
                while (dataItemIter.hasNext()) {
                    Element dataItem = (Element)dataItemIter.next();
                    this._queryItemCache.put(dataItem.attributeValue("name"), dataItem);
                }
            }
        }

        public void clear() {
            this._queryItemCache.clear();
        }

        public Element findItem(String itemName) {
            if (itemName != null) {
                return this._queryItemCache.get(itemName);
            }
            return null;
        }

        public Element addDataItem(String name, String expressionText) throws ActionException {
            try {
                Element dataItem = this.add("dataItem", name);
                Element expression = dataItem.addElement("expression");
                expression.setText(expressionText);
                return dataItem;
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }

        public Element addCalculation(String tag, String name, String expressionText, String dun, String hun) throws ActionException {
            Element existingItem = this.findItem(name);
            if (existingItem != null && tag.equals(existingItem.getName()) && expressionText.equals(existingItem.elementText("expression"))) {
                return existingItem;
            }
            Element addedDataItem = null;
            if ("dataItem".equals(tag) || dun == null) {
                addedDataItem = this.addDataItem(name, expressionText);
            } else {
                addedDataItem = this.add(tag, name);
                Element expression = addedDataItem.addElement("expression");
                expression.setText(expressionText);
                V5Query.this.setDimensionalDataItemInfo(addedDataItem, null, null, hun, dun);
            }
            if (addedDataItem != null) {
                int solveOrder = this.getHighestSolveOrder() + 1;
                addedDataItem.addAttribute("solveOrder", Integer.toString(solveOrder));
            }
            return addedDataItem;
        }

        public int getHighestSolveOrder() {
            int highest = 0;
            for (Element item : this.getDataItemElements()) {
                int solveOrder;
                Attribute solveOrderAttr = item.attribute("solveOrder");
                if (solveOrderAttr == null || (solveOrder = Integer.parseInt(solveOrderAttr.getValue())) <= highest) continue;
                highest = solveOrder;
            }
            return highest;
        }

        public Element addDataItemListSummary(String name, String aggregateMethod, String refDataItem) throws ActionException {
            try {
                Element dataItemListSummary = this.add("dataItemListSummary", name);
                dataItemListSummary.addAttribute("aggregateMethod", aggregateMethod);
                dataItemListSummary.addAttribute("refDataItem", refDataItem);
                return dataItemListSummary;
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }

        public Element addDataItemChildrenSet(String caption, String mun, String hun, String dun) throws ActionException {
            Element existingItem;
            String childrenSetName = "children(" + caption + ")";
            String expression = "children(" + mun + ")";
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                expression = mun;
            }
            if ((existingItem = this.getExistingDataItem(childrenSetName, mun, hun, dun)) != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                Element dataItemChildrenSet = this.add("dataItemChildrenSet", childrenSetName);
                dataItemChildrenSet.addAttribute("label", caption);
                V5Query.this.setDimensionalDataItemInfo(dataItemChildrenSet, childrenSetName, mun, hun, dun);
                return dataItemChildrenSet;
            }
            return this.addDataItem(childrenSetName, expression);
        }

        public Element addDataItemRootMembers(String caption, String mun, String hun, String dun) throws ActionException {
            String setName = "root(" + caption + ")";
            String expression = hun != null ? "rootMembers(" + hun + ")" : mun;
            Element existingItem = this.getExistingDataItem(setName, mun, hun, dun);
            if (existingItem != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                Element dataItemSetExpression = this.add("dataItemSetExpression", setName);
                dataItemSetExpression.addAttribute("label", caption);
                Element expr = dataItemSetExpression.addElement("expression");
                expr.setText(expression);
                V5Query.this.setDimensionalDataItemInfo(dataItemSetExpression, setName, null, hun, dun);
                return dataItemSetExpression;
            }
            return this.addDataItem(setName, expression);
        }

        public Element addDataItemParent(String caption, String mun, String hun, String dun) throws ActionException {
            String setName = "parent(" + caption + ")";
            String expression = "parent(" + mun + ")";
            Element existingItem = this.getExistingDataItem(setName, mun, hun, dun);
            if (existingItem != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                Element dataItemSetExpression = this.add("dataItemSetExpression", setName);
                dataItemSetExpression.addAttribute("label", caption);
                Element expr = dataItemSetExpression.addElement("expression");
                expr.setText(expression);
                V5Query.this.setDimensionalDataItemInfo(dataItemSetExpression, setName, null, hun, dun);
                return dataItemSetExpression;
            }
            return this.addDataItem(setName, expression);
        }

        public Element addDataItemMeasure(String itemName, String mun, String dun) {
            Element existingItem = this.getExistingDataItem(itemName, mun, null, dun);
            if (existingItem != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0) {
                Element dataItemMeasure = this.add("dataItemMeasure", itemName);
                V5Query.this.setDimensionalDataItemInfo(dataItemMeasure, itemName, mun, null, dun);
                this.addDataItem(dataItemMeasure);
                return dataItemMeasure;
            }
            return null;
        }

        public Element addDataItemSetExpression(String itemName, String expressionText, String hun, String dun) {
            Element existingItem = this.getExistingDataItem(itemName, null, hun, dun);
            if (existingItem != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0) {
                Element dataItemSetExpression = this.add("dataItemSetExpression", itemName);
                V5Query.this.setDimensionalDataItemInfo(dataItemSetExpression, itemName, null, hun, dun);
                Element expression = dataItemSetExpression.addElement("expression");
                expression.setText(expressionText);
                this.addDataItem(dataItemSetExpression);
                return dataItemSetExpression;
            }
            return null;
        }

        public Element addDataItemSet(String itemName, boolean asDataItemMemberSet, String[] muns, String[] captions, String hun, String dun) {
            Element existingItem = this.getExistingDataItem(itemName, null, hun, dun);
            if (existingItem != null) {
                return existingItem;
            }
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                Element dataItemSet;
                Element setParentNode = dataItemSet = asDataItemMemberSet ? this.add("dataItemMemberSet", itemName) : this.add("dataItemSet", itemName);
                if (asDataItemMemberSet) {
                    setParentNode = dataItemSet.addElement("setDefinition").addElement("setExplicitMembers");
                }
                V5Query.this.setDimensionalDataItemInfo(dataItemSet, itemName, null, hun, dun);
                Element dmMembers = setParentNode.addElement("dmMembers");
                for (int i = 0; i < muns.length; ++i) {
                    Element dmMember = dmMembers.addElement("dmMember");
                    Element mun = dmMember.addElement("MUN");
                    Element caption = dmMember.addElement("itemCaption");
                    mun.setText(muns[i]);
                    if (captions.length <= i || captions[i] == null) continue;
                    caption.setText(captions[i]);
                }
                this.addDataItem(dataItemSet);
                return dataItemSet;
            }
            return null;
        }

        public Element addDataItemMember(String name, String mun, String hun, String dun) throws ActionException {
            Element existingDataItem = this.getExistingDataItem(name, mun, hun, dun);
            if (existingDataItem != null && ("dataItemMember".equals(existingDataItem.getName()) || "dataItem".equals(existingDataItem.getName()))) {
                return existingDataItem;
            }
            String uniqueName = name;
            int n = 0;
            do {
                uniqueName = n == 0 ? name : name + n;
                ++n;
                existingDataItem = this.getExistingDataItem(uniqueName, mun, hun, dun);
                if (existingDataItem == null || !"dataItemMember".equals(existingDataItem.getName()) && !"dataItem".equals(existingDataItem.getName())) continue;
                return existingDataItem;
            } while (this.findItem(uniqueName) != null);
            Element dataItemMember = null;
            if (dun != null && dun.length() > 0 && hun != null && hun.length() > 0) {
                dataItemMember = this.add("dataItemMember", uniqueName);
                V5Query.this.setDimensionalDataItemInfo(dataItemMember, name, mun, hun, dun);
            } else {
                dataItemMember = this.addDataItem(uniqueName, mun);
            }
            return dataItemMember;
        }

        public Element getExistingDataItem(String name, String mun, String hun, String dun) {
            Element existingDataItem = this.findItem(name);
            if (existingDataItem == null) {
                return null;
            }
            Element expressionElement = existingDataItem.element("expression");
            if (expressionElement == null) {
                Element munElement = V5X.selectSingleNode(existingDataItem, "//V5X//CHILD", "dmMember", "MUN");
                Element hunElement = V5X.selectSingleNode(existingDataItem, "//V5X//CHILD", "dmHierarchy", "HUN");
                Element dunElement = V5X.selectSingleNode(existingDataItem, "//V5X//CHILD", "dmDimension", "DUN");
                if (this.isMatchingElement(munElement, mun) && this.isMatchingElement(dunElement, dun) && this.isMatchingElement(hunElement, hun)) {
                    return existingDataItem;
                }
            } else if (expressionElement.getText().equals(mun)) {
                return existingDataItem;
            }
            return null;
        }

        public boolean addDataItem(Element dataItem) {
            if (this._queryItemCache.get(dataItem.attributeValue("name")) == null) {
                V5Query.this.querySelection.add(dataItem);
                this._queryItemCache.put(dataItem.attributeValue("name"), dataItem);
                return true;
            }
            return false;
        }

        public boolean removeDataItem(Element dataItem) {
            boolean removed = V5Query.this.querySelection.remove(dataItem);
            if (removed) {
                this._queryItemCache.remove(dataItem.attributeValue("name"));
            }
            return removed;
        }

        public Collection<Element> getDataItemElements() {
            return this._queryItemCache.values();
        }

        private Element add(String itemType, String itemName) {
            Element dataItem = V5Query.this.querySelection.addElement(itemType);
            String uniqueName = V5Query.this.findUniqueItemName(itemName);
            dataItem.addAttribute("name", uniqueName);
            this._queryItemCache.put(uniqueName, dataItem);
            return dataItem;
        }

        private boolean isMatchingElement(Element element, String text) {
            if (text == null) {
                return element == null || element.getText() == null;
            }
            return element == null ? false : text.equals(element.getText());
        }
    }
}

