/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.CCLDbTypesInfo;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SetFiltering;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPMessageManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class V5QueryFilters {
    public static final String RAP_FormattedNumber = "RAP_FormattedNumber";
    public static final String RAP_FormattedEndNumber = "RAP_FormattedEndNumber";
    public static final String RAP_filterLocale = "RAP_filterLocale";
    private V5Query _v5Query = null;
    private V5SetFiltering _v5SetFiltering = null;
    private ActionEnv _env = null;

    public V5QueryFilters(ActionEnv env, V5Query query) {
        this._env = env;
        this._v5Query = query;
        this._v5SetFiltering = new V5SetFiltering(env);
    }

    public List<Element> findFilterDefinitionRDINodes() {
        if (this._v5Query.getQueryElement() != null) {
            return V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "//V5X//OR", "summaryFilters", "detailFilter", "//V5X//OR", "summaryFilter", "filterDefinition", "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refDataItem");
        }
        return new ArrayList<Element>();
    }

    public Element setFilterMembersOrValues(ArrayList<SelectedCell> selectedCells, boolean include) throws ActionException {
        SelectedCell firstSelectedCell = selectedCells.get(0);
        if (this._v5Query.findItem(firstSelectedCell.nodeName) == null) {
            return null;
        }
        Element filterIn = this._v5SetFiltering.addUpdateSetFilters(this._v5Query, selectedCells, include);
        if (filterIn != null) {
            return filterIn;
        }
        if (include) {
            this.clearExistingFilters(firstSelectedCell.nodeName);
        }
        Element queryElement = this._v5Query.getQueryElement();
        Element detailFilter = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"detailFilter", (Namespace)queryElement.getNamespace()));
        Element filterDef = detailFilter.addElement("filterDefinition");
        if ("memberUniqueName".equals(firstSelectedCell.nodeType)) {
            if (selectedCells.size() == 1 && selectedCells.get((int)0).nodeDisplay.length() == 0) {
                filterIn = filterDef.addElement("filterNulls");
                filterIn.addAttribute("dataType", "decimal");
                detailFilter.addAttribute("postAutoAggregation", "true");
            } else {
                filterIn = filterDef.addElement("filterInMembers");
                Element dmMembers = filterIn.addElement("dmMembers");
                for (SelectedCell cell : selectedCells) {
                    Element dmMember = dmMembers.addElement("dmMember");
                    Element MUN = dmMember.addElement("MUN");
                    MUN.setText(cell.nodeUse);
                    Element itemCaption = dmMember.addElement("itemCaption");
                    itemCaption.setText(cell.nodeDisplay);
                }
                this._v5Query.setQueryItemDimensionInfo(firstSelectedCell.nodeName, firstSelectedCell, filterIn);
            }
        } else {
            if (selectedCells.size() == 1 && selectedCells.get((int)0).nodeUse.length() == 0) {
                filterIn = filterDef.addElement("filterNulls");
                detailFilter.addAttribute("postAutoAggregation", "true");
            } else {
                filterIn = filterDef.addElement("filterInValues");
                Element filterValues = filterIn.addElement("filterValues");
                for (SelectedCell cell : selectedCells) {
                    Element value = filterValues.addElement("filterValue");
                    value.setText(cell.nodeUse);
                }
            }
            try {
                if (this.confirmIsNumeric(firstSelectedCell)) {
                    filterIn.addAttribute("dataType", "decimal");
                } else {
                    filterIn.addAttribute("dataType", "string");
                }
            }
            catch (ActionException e) {
                filterIn.addAttribute("dataType", "string");
            }
        }
        filterIn.addAttribute("refDataItem", firstSelectedCell.nodeName);
        if (!include) {
            filterIn.addAttribute("not", "true");
        }
        DocumentHelper.makeElement((Branch)this._v5Query.getQueryElement(), (String)"detailFilters").add(detailFilter);
        return filterIn;
    }

    public Element setFilterOut(ArrayList<SelectedCell> selectedCells) throws ActionException {
        return this.setFilterMembersOrValues(selectedCells, false);
    }

    private boolean confirmIsNumeric(SelectedCell selectedCell) throws ActionException {
        if (selectedCell.isRelationalNumericType()) {
            return true;
        }
        if (selectedCell.isOLAPMeasure()) {
            return true;
        }
        if (selectedCell.nodeUse.matches("\\d")) {
            V5QueryItem queryItem = new V5QueryItem(this._env, this._v5Query, this._v5Query.findItem(selectedCell.nodeName));
            return queryItem.confirmIsNumeric();
        }
        return false;
    }

    public Element setFilterBetween(ArrayList<SelectedCell> selectedCells, char decimalSeparator, char signCharacter) throws ActionException {
        SelectedCell firstSelectedCell = selectedCells.get(0);
        Element queryElement = this._v5Query.getQueryElement();
        Element detailFilter = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"detailFilter", (Namespace)queryElement.getNamespace()));
        Element filterDef = detailFilter.addElement("filterDefinition");
        Element filterRange = filterDef.addElement("filterRange");
        filterRange.addAttribute("refDataItem", firstSelectedCell.nodeName);
        boolean isDateTime = CCLDbTypesInfo.isDateTimeFormat(firstSelectedCell.nodeUse);
        if (!isDateTime) {
            detailFilter.addAttribute("postAutoAggregation", "true");
        }
        if (isDateTime || this.confirmIsNumeric(firstSelectedCell)) {
            filterRange.addAttribute("dataType", isDateTime ? "dateTime" : "decimal");
            for (int i = 0; i < selectedCells.size(); i += 2) {
                SelectedCell cellFrom = selectedCells.get(i);
                SelectedCell cellTo = selectedCells.get(i + 1);
                Range range = this.buildRange(cellFrom, cellTo, decimalSeparator, signCharacter);
                Element filterFrom = filterRange.addElement("filterFrom");
                filterFrom.setText(range.getMinText());
                Element filterTo = filterRange.addElement("filterTo");
                filterTo.setText(range.getMaxText());
            }
        } else {
            throw new ActionException(RAPMessageManager.convert("RAP_RANGEFILTER_DATATYPE_UNSUPPORTED", this._env.getLocale()));
        }
        DocumentHelper.makeElement((Branch)queryElement, (String)"detailFilters").add(detailFilter);
        return filterRange;
    }

    public Element setFilterNotBetween(ArrayList<SelectedCell> selectedCells, char decimalSeparator, char signCharacter) throws ActionException {
        Element filterElement = this.setFilterBetween(selectedCells, decimalSeparator, signCharacter);
        if (filterElement != null) {
            filterElement.addAttribute("not", "true");
        }
        return filterElement;
    }

    public Element setFilterCompare(SelectedCell firstSelectedCell, String compareType, char decimalSeparator, char signCharacter) throws ActionException {
        try {
            RangeEndPoint endpoint = this.buildCompareRange(firstSelectedCell, decimalSeparator, signCharacter);
            Element existingFilter = this.findExistingCompareFilter(firstSelectedCell.nodeName, compareType, endpoint.getText());
            if (existingFilter != null) {
                return existingFilter;
            }
            Element queryElement = this._v5Query.getQueryElement();
            Element detailFilter = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"detailFilter", (Namespace)queryElement.getNamespace()));
            Element filterDef = detailFilter.addElement("filterDefinition");
            Element filterCompare = filterDef.addElement("filterCompare");
            filterCompare.addAttribute("refDataItem", firstSelectedCell.nodeName);
            filterCompare.addAttribute("operator", compareType);
            boolean isDateTime = CCLDbTypesInfo.isDateTimeFormat(firstSelectedCell.nodeUse);
            if (!isDateTime) {
                detailFilter.addAttribute("postAutoAggregation", "true");
            }
            if (isDateTime || this.confirmIsNumeric(firstSelectedCell)) {
                filterCompare.addAttribute("dataType", isDateTime ? "dateTime" : "decimal");
                Element filterValue = filterCompare.addElement("filterValue");
                filterValue.setText(endpoint.getText());
                DocumentHelper.makeElement((Branch)this._v5Query.getQueryElement(), (String)"detailFilters").add(detailFilter);
                return filterCompare;
            }
        }
        catch (Exception e) {
            throw new ActionException(RAPMessageManager.convert("RAP_RANGEFILTER_DATATYPE_UNSUPPORTED", this._env.getLocale()));
        }
        return null;
    }

    private Element findExistingCompareFilter(String rdiName, String compareType, String textValue) {
        List compareFiltersForRdi = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "detailFilter", "filterDefinition", "filterCompare", "//V5X//ATTR", "refDataItem", rdiName, "//V5X//AND", "operator", compareType);
        for (Element filterCompare : compareFiltersForRdi) {
            if (!textValue.equals(filterCompare.elementText("filterValue"))) continue;
            return filterCompare;
        }
        return null;
    }

    private Range buildRange(SelectedCell cellFrom, SelectedCell cellTo, char decimalSeparator, char signCharacter) {
        if (cellFrom.isOLAPMeasure()) {
            return new Range(cellFrom.nodeDisplay, cellTo.nodeDisplay, decimalSeparator, signCharacter);
        }
        return new Range(cellFrom.nodeUse, cellTo.nodeUse);
    }

    private RangeEndPoint buildCompareRange(SelectedCell endPoint, char decimalSeparator, char signCharacter) {
        if (endPoint.isOLAPMeasure()) {
            return new RangeEndPoint(endPoint.nodeDisplay, decimalSeparator, signCharacter);
        }
        return new RangeEndPoint(endPoint.nodeUse);
    }

    public void clearExistingFilters() {
        this._v5SetFiltering.clearExistingSetFilters(this._v5Query);
        this.clearSetAndDetailFilters();
    }

    public void clearSetAndDetailFilters() {
        for (Element filterDefRDINode : this.findFilterDefinitionRDINodes()) {
            this.clearExistingFilters(filterDefRDINode.attributeValue("refDataItem"));
        }
    }

    public void clearExistingFilters(String rdiName) {
        this._v5SetFiltering.clearExistingSetFilters(this._v5Query, rdiName);
        this.clearExistingDetailFilters(rdiName);
    }

    public void clearExistingDetailFilters(String rdiName) {
        List existingFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "detailFilter", "filterDefinition", "//V5X//CHILDATTR", "refDataItem", rdiName);
        if (existingFilters.size() == 0) {
            existingFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "summaryFilters", "summaryFilter", "filterDefinition", "//V5X//CHILDATTR", "refDataItem", rdiName);
        }
        if (existingFilters.size() > 0) {
            for (Element existingFilter : existingFilters) {
                Element detailFilterElement = existingFilter.getParent().getParent();
                if ("prohibited".equals(detailFilterElement.attributeValue("use"))) continue;
                detailFilterElement.detach();
            }
            this.clearEmptyFilterNodes();
        }
    }

    public void clearExistingFiltersUsingReportInfoFilterJSON(String rdiName, String jsonDetails) {
        try {
            JSONObject details;
            String jsonDets = jsonDetails;
            JSONArray detailsArray = JSONArray.parse((String)jsonDetails);
            if (detailsArray.size() == 0) {
                this.clearExistingFilters(rdiName);
            }
            if ((details = (JSONObject)detailsArray.get(0)).get((Object)"in") != null) {
                JSONArray inList = (JSONArray)details.get((Object)"in");
                this.clearExistingFilters(rdiName, (ArrayList<String>)inList);
            } else if (details.get((Object)"notIn") != null) {
                JSONArray notInList = (JSONArray)details.get((Object)"notIn");
                this.clearExistingFilters(rdiName, (ArrayList<String>)notInList);
            } else if (details.get((Object)"range") != null) {
                this.clearExistingRange(rdiName, (JSONArray)details.get((Object)"range"), false);
            } else if (details.get((Object)"notRange") != null) {
                this.clearExistingRange(rdiName, (JSONArray)details.get((Object)"notRange"), true);
            } else {
                this.clearExistingCompareFilter(rdiName, details);
            }
        }
        catch (Exception e) {
            this.clearExistingFilters(rdiName);
        }
    }

    private void clearExistingCompareFilter(String rdiName, JSONObject compareDetails) {
        String operatorType = null;
        String[] operatorTypes = new String[]{"lessThan", "lessThanEqual", "greaterThan", "greaterThanEqual", "contains", "beginsWith", "endsWith", "isMatchesSQLPatternFilter"};
        for (int op = 0; op < operatorTypes.length; ++op) {
            if (compareDetails.get((Object)operatorTypes[op]) == null) continue;
            operatorType = operatorTypes[op];
            break;
        }
        if (operatorType != null) {
            List existingCompareFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "detailFilter", "filterDefinition", "filterCompare", "//V5X//OR", "filterStringCompare", "//V5X//ATTR", "operator", operatorType, "//V5X//AND", "refDataItem", rdiName);
            for (Element existingCompareFilter : existingCompareFilters) {
                String matchValue = V5SpecHelper.getXMLAttribute(existingCompareFilter, RAP_FormattedNumber);
                if (matchValue == null) {
                    matchValue = existingCompareFilter.elementText("filterValue");
                }
                if (matchValue == null || !matchValue.equals(compareDetails.get((Object)operatorType))) continue;
                existingCompareFilter.getParent().getParent().detach();
                this.clearEmptyFilterNodes();
                break;
            }
        }
    }

    private void clearExistingRange(String rdiName, JSONArray rangeDetails, boolean notRange) {
        block0: for (int i = 0; i < rangeDetails.size(); ++i) {
            JSONObject range = (JSONObject)rangeDetails.get(0);
            List existingRangeFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "detailFilter", "filterDefinition", "filterRange");
            for (Element existingRangeFilter : existingRangeFilters) {
                String matchTo;
                boolean notAttrExists = existingRangeFilter.attributeValue("not") != null;
                if (notRange != notAttrExists) continue;
                String matchFrom = V5SpecHelper.getXMLAttribute(existingRangeFilter, RAP_FormattedNumber);
                if (matchFrom == null) {
                    matchFrom = existingRangeFilter.elementText("filterFrom");
                }
                if ((matchTo = V5SpecHelper.getXMLAttribute(existingRangeFilter, RAP_FormattedEndNumber)) == null) {
                    matchTo = existingRangeFilter.elementText("filterTo");
                }
                if (matchFrom == null || matchTo == null || !matchFrom.equals(range.get((Object)"from")) || !matchTo.equals(range.get((Object)"to"))) continue;
                existingRangeFilter.getParent().getParent().detach();
                this.clearEmptyFilterNodes();
                continue block0;
            }
        }
    }

    public void clearExistingFilters(String rdiName, ArrayList<String> captionList) {
        this._v5SetFiltering.clearExistingSetFilters(this._v5Query, rdiName, captionList);
        List existingFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "detailFilters", "detailFilter", "filterDefinition", "//V5X//CHILDATTR", "refDataItem", rdiName);
        if (existingFilters.size() == 0) {
            existingFilters = V5X.selectNodes(this._v5Query.getQueryElement(), "//V5X//CHILD", "summaryFilters", "summaryFilter", "filterDefinition", "//V5X//CHILDATTR", "refDataItem", rdiName);
        }
        if (existingFilters.size() > 0) {
            for (Element existingFilter : existingFilters) {
                Element detailFilterElement = existingFilter.getParent().getParent();
                if (existingFilters.size() < 2 || captionList.size() < 1) {
                    detailFilterElement.detach();
                    continue;
                }
                List memberCaptions = V5X.selectNodes(detailFilterElement, "filterDefinition", "filterInMembers", "dmMember", "itemCaption");
                if (memberCaptions.size() < 1) {
                    memberCaptions = V5X.selectNodes(detailFilterElement, "filterDefinition", "filterInValues", "filterValues", "filterValue");
                }
                if (memberCaptions.size() <= 0) continue;
                boolean bMatch = true;
                for (int i = 0; i < captionList.size(); ++i) {
                    boolean bFind = false;
                    for (Element memberCaption : memberCaptions) {
                        if (!captionList.get(i).equals(memberCaption.getText())) continue;
                        bFind = true;
                    }
                    bMatch &= bFind;
                }
                if (!bMatch || memberCaptions.size() != captionList.size()) continue;
                detailFilterElement.detach();
            }
            this.clearEmptyFilterNodes();
        }
    }

    private void clearEmptyFilterNodes() {
        Element summaryFiltersElement;
        Element detailFiltersElement = this._v5Query.getQueryElement().element("detailFilters");
        if (detailFiltersElement != null && detailFiltersElement.elements().size() == 0) {
            detailFiltersElement.detach();
        }
        if ((summaryFiltersElement = this._v5Query.getQueryElement().element("summaryFilters")) != null && summaryFiltersElement.elements().size() == 0) {
            summaryFiltersElement.detach();
        }
    }

    public static boolean isRangeFilter(Element filter) {
        Element filterDefinition = V5X.selectSingleNode(filter, "filterDefinition");
        if (filterDefinition != null) {
            return filterDefinition.element("filterRange") != null || filterDefinition.element("filterCompare") != null;
        }
        Element filterExpression = V5X.selectSingleNode(filter, "filterExpression");
        if (filterExpression != null) {
            String filterExp = filterExpression.getText().toUpperCase();
            filterExp = filterExp.replaceAll("]]", "");
            filterExp = filterExp.replaceAll("''", "");
            filterExp = filterExp.replaceAll("\"\"", "");
            filterExp = filterExp.replaceAll("->", "");
            filterExp = filterExp.replaceAll("['\"].*['\"]", "");
            String regExFindRangeSyntax = ".*\\[.*\\].*(<|>|IN_RANGE|BETWEEN).*";
            return Pattern.matches(regExFindRangeSyntax, filterExp);
        }
        return false;
    }

    public static void disableRangeFilters(Element queryOrDocument) {
        List filtersList = null;
        filtersList = "query".equals(queryOrDocument.getName()) ? V5X.selectNodes(queryOrDocument, "detailFilter", "//V5X//OR", "summaryFilter") : V5X.selectNodes(queryOrDocument, "queries", "query", "detailFilter", "//V5X//OR", "summaryFilter");
        if (filtersList != null) {
            for (Element filter : filtersList) {
                if (!V5QueryFilters.isRangeFilter(filter)) continue;
                filter.addAttribute("use", "prohibited");
            }
        }
    }

    public static void disableFilters(Element queryOrDocument) {
        V5SetFiltering.disableSetFilters(queryOrDocument);
        List filtersList = null;
        filtersList = "query".equals(queryOrDocument.getName()) ? V5X.selectNodes(queryOrDocument, "detailFilter", "//V5X//OR", "summaryFilter") : V5X.selectNodes(queryOrDocument, "queries", "query", "detailFilter", "//V5X//OR", "summaryFilter");
        if (filtersList != null) {
            for (Element filter : filtersList) {
                filter.addAttribute("use", "prohibited");
            }
        }
    }

    public static void updateLocaleBasedFilters(String thisLocale, Element document) {
        V5SetFiltering.updateLocaleBasedFilters(thisLocale, document);
        List filtersList = V5X.selectNodes(document, "//V5X//CHILD", "queries", "query", "detailFilters", "detailFilter");
        for (Element filter : filtersList) {
            String filterLocale;
            Element filterXMLAttributes = V5X.selectSingleNode(filter, "XMLAttributes");
            if (filterXMLAttributes == null || (filterLocale = V5SpecHelper.getXMLAttribute(filterXMLAttributes.getParent(), RAP_filterLocale)) == null) continue;
            if (thisLocale.contains(filterLocale)) {
                Attribute useAttr = filter.attribute("use");
                if (useAttr == null) continue;
                filter.remove(useAttr);
                continue;
            }
            filter.addAttribute("use", "prohibited");
        }
    }

    public static String getItemName(Element filterElement) {
        String itemName = filterElement.attributeValue("refDataItem");
        return itemName != null ? itemName : V5SetFiltering.getItemName(filterElement);
    }

    public static boolean isMemberFilter(Element filterElement) {
        return "filterInMembers".equals(filterElement.getName()) || V5SetFiltering.isMemberFilter(filterElement);
    }

    public static boolean isExcludeFilter(Element filterElement) {
        return "true".equals(filterElement.attributeValue("not")) || V5SetFiltering.isExcludeFilter(filterElement);
    }

    class RangeEndPoint {
        String _endPointStr = null;

        public RangeEndPoint(String endPoint) {
            this._endPointStr = endPoint;
        }

        public RangeEndPoint(String endPoint, char decimalSeparator, char signCharacter) {
            this._endPointStr = this.displayValueToUseValue(endPoint, decimalSeparator, signCharacter);
        }

        String getText() {
            return this._endPointStr;
        }

        private String displayValueToUseValue(String displayValue, char decimalSeparator, char signCharacter) {
            StringBuilder outStr = new StringBuilder();
            for (int i = 0; i < displayValue.length(); ++i) {
                char c = displayValue.charAt(i);
                if (!Character.isDigit(c) && c != decimalSeparator && c != signCharacter) continue;
                outStr.append(c);
            }
            return outStr.toString();
        }
    }

    class Range {
        String _fromStr = null;
        String _toStr = null;
        Double _from = null;
        Double _to = null;
        boolean _isDateTime = false;

        public Range(String from, String to) {
            this._fromStr = from;
            this._toStr = to;
            this._isDateTime = CCLDbTypesInfo.isDateTimeFormat(from);
            if (!this._isDateTime) {
                this._from = Double.valueOf(from);
                this._to = Double.valueOf(to);
            }
        }

        public Range(String from, String to, char decimalSeparator, char signCharacter) {
            this._fromStr = this.displayValueToUseValue(from, decimalSeparator, signCharacter);
            this._toStr = this.displayValueToUseValue(to, decimalSeparator, signCharacter);
            this._isDateTime = CCLDbTypesInfo.isDateTimeFormat(this._fromStr);
            if (!this._isDateTime) {
                this._from = Double.valueOf(this._fromStr);
                this._to = Double.valueOf(this._toStr);
            }
        }

        String getMinText() {
            if (this._isDateTime) {
                return this._fromStr.compareTo(this._toStr) < 0 ? this._fromStr : this._toStr;
            }
            return this._from < this._to ? this._fromStr : this._toStr;
        }

        String getMaxText() {
            if (this._isDateTime) {
                return this._fromStr.compareTo(this._toStr) > 0 ? this._fromStr : this._toStr;
            }
            return this._from > this._to ? this._fromStr : this._toStr;
        }

        private String displayValueToUseValue(String displayValue, char decimalSeparator, char signCharacter) {
            StringBuilder outStr = new StringBuilder();
            for (int i = 0; i < displayValue.length(); ++i) {
                char c = displayValue.charAt(i);
                if (!Character.isDigit(c) && c != decimalSeparator && c != signCharacter) continue;
                outStr.append(c);
            }
            return outStr.toString();
        }
    }

    public static class Type {
        public static final String in = "in";
        public static final String not = "not";
        public static final String between = "between";
        public static final String notBetween = "notBetween";
        public static final String remove = "remove";
        public static final String removeAll = "removeAll";
        public static final String removeAllForWidget = "removeAllForWidget";
    }
}

