/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.QueryItemProperties;
import com.cognos.rap.actions.v5spechelpers.QueryItemPropertyManager;
import com.cognos.rap.actions.v5spechelpers.V5ItemUpgrader;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class V5QueryItem {
    private static HashSet<String> _queryItemSetTypes = new HashSet();
    private ItemType _itemType = ItemType.unknown;
    private NumericSubType _numericSubType = NumericSubType.unknown;
    private ActionEnv _env = null;
    private V5Query _v5Query = null;
    private Element _dataItemOrSubType = null;
    private QueryItemProperties _QueryItemProperties = null;
    private String _queryItemExpression = null;
    private boolean _evaluateSpecOnly = false;
    private boolean __numericSubtypesRequired = true;
    private boolean _useGetParamRequest_adv = false;
    private static final String _knownAggregateFormPrefixPattern = "^\\s*.*(CURRENTMEASURE|\\[.*\\])\\s*WITHIN\\s*(SET|DETAIL)\\s*\\[";
    private static final String _knownAggregateFormPattern = "^\\s*.*(CURRENTMEASURE|\\[.*\\])\\s*WITHIN\\s*(SET|DETAIL)\\s*\\[.*$";

    public V5QueryItem(ActionEnv env, V5Query v5Query, Element dataItemOrSubtype) {
        this._env = env;
        this._v5Query = v5Query;
        this._v5Query.setEnv(env);
        this._dataItemOrSubType = dataItemOrSubtype;
        this.initialize();
    }

    private void initialize() {
        Element exprNode;
        if (this._dataItemOrSubType != null && (exprNode = (Element)this._dataItemOrSubType.selectSingleNode(".//*[local-name()='expression']")) != null) {
            this._queryItemExpression = exprNode.getText();
        }
        this._QueryItemProperties = new QueryItemProperties();
        this.evaluateHighLevelSpecTypes();
    }

    public void setEvaluateSpecOnly(boolean flag) {
        this._evaluateSpecOnly = flag;
    }

    public void setNumericSubtypesRequired(boolean flag) {
        this.__numericSubtypesRequired = flag;
    }

    public void setUseGetParamReqForFiltItem(boolean flag) {
        this._useGetParamRequest_adv = flag;
    }

    public ItemType getItemType() {
        if (this._itemType == ItemType.unknown) {
            this.evaluateHighLevelSpecTypes();
            if (this._QueryItemProperties != null) {
                if (this._QueryItemProperties.isConfirmedNumeric()) {
                    this._itemType = ItemType.numeric;
                } else if (this._QueryItemProperties.isConfirmedDateTime()) {
                    this._itemType = ItemType.dateTime;
                }
            }
        }
        return this._itemType;
    }

    public static String itemTypeToNumericFlagValue(ItemType itemType) {
        switch (itemType) {
            case numeric: {
                return "true";
            }
            case string: 
            case member: 
            case set: {
                return "false";
            }
        }
        return "unknown";
    }

    public static String IsSingleMember(ItemType itemType) {
        switch (itemType) {
            case member: {
                return "true";
            }
            case numeric: {
                return "false";
            }
        }
        return "unknown";
    }

    public NumericSubType getNumericSubType() {
        if (this.getItemType() == ItemType.unknown || this._numericSubType == NumericSubType.unknown) {
            this.evaluateHighLevelSpecTypes();
        }
        if (this._numericSubType == NumericSubType.unknown && this.getProperties() != null && this.getProperties().getUsage() != null) {
            if (this.getProperties().isUsageData()) {
                this._numericSubType = NumericSubType.dataValues;
            } else if (this.getProperties().isUsageFact()) {
                this._numericSubType = NumericSubType.measure;
            } else if (this.getProperties().isUsageCalculationOrAggregate()) {
                this._numericSubType = NumericSubType.calculationOrAggregate;
            }
        }
        if (this.getItemType() != ItemType.numeric) {
            return NumericSubType.unknown;
        }
        return this._numericSubType;
    }

    public Element getDOM() {
        return this._dataItemOrSubType;
    }

    public QueryItemProperties.Dimensionality getDimensionality() {
        if (this._QueryItemProperties != null) {
            return this._QueryItemProperties.getDimensionality();
        }
        return QueryItemProperties.Dimensionality.unknown;
    }

    public ActionEnv getEnv() {
        return this._env;
    }

    public V5Query getQuery() {
        return this._v5Query;
    }

    public boolean confirmIsNumeric() throws ActionException {
        if (this.evaluateHighLevelSpecTypes()) {
            return this.getItemType() == ItemType.numeric;
        }
        boolean queryItemProperties = this.loadQueryItemProperties();
        if (queryItemProperties) {
            if (this._QueryItemProperties.isConfirmedNumeric()) {
                if (this._QueryItemProperties.hasUsage() || !this.__numericSubtypesRequired) {
                    return true;
                }
            } else if (this._QueryItemProperties.isConfirmedNonNumeric()) {
                return false;
            }
        }
        return this.requestIsNumeric();
    }

    public boolean requestIsNumeric() throws ActionException {
        if (!this._evaluateSpecOnly && this.getEnv().hasCognosServiceInterface()) {
            V5ItemUpgrader upgrader = new V5ItemUpgrader(this);
            if (this.__numericSubtypesRequired) {
                if (this._useGetParamRequest_adv) {
                    if (upgrader.createNumeric_GetParametersMethod(this.getEnv(), this._QueryItemProperties)) {
                        this._itemType = ItemType.numeric;
                        return true;
                    }
                } else if (upgrader.createNumeric_ReportMethod(this.getEnv(), this._QueryItemProperties)) {
                    this._itemType = ItemType.numeric;
                    return true;
                }
            } else if (upgrader.createNumeric_GetParametersMethod(this.getEnv(), this._QueryItemProperties)) {
                this._itemType = ItemType.numeric;
                return true;
            }
        }
        return false;
    }

    public boolean confirmIsSet() throws ActionException {
        if (this.evaluateHighLevelSpecTypes()) {
            return this.getItemType() == ItemType.set;
        }
        if (this.isKnownAggregateForm()) {
            return false;
        }
        boolean queryItemProperties = this.loadQueryItemProperties();
        if (queryItemProperties && (this._QueryItemProperties.isConfirmedNumeric() || this._QueryItemProperties.isConfirmedBasicValue() || this._QueryItemProperties.isConfirmedDateTime())) {
            return false;
        }
        return this.requestIsSet();
    }

    public boolean confirmIsSetOrMember() throws ActionException {
        if (this.confirmIsSet()) {
            return true;
        }
        return this._itemType == ItemType.member || this._itemType == ItemType.memberOrSingleMemberSet;
    }

    public boolean requestIsSet() throws ActionException {
        V5ItemUpgrader upgrader;
        if ((!this._evaluateSpecOnly && this.getEnv().hasCognosServiceInterface() || this._QueryItemProperties != null && this._QueryItemProperties.isConfirmedSet()) && (upgrader = new V5ItemUpgrader(this)).createSet(this.getEnv(), this._QueryItemProperties)) {
            this._itemType = ItemType.set;
            return true;
        }
        return false;
    }

    private boolean loadQueryItemProperties() throws ActionException {
        boolean queryItemPropertiesLoaded = this._QueryItemProperties.loadJSONXMLAttribute(this._dataItemOrSubType);
        if (!queryItemPropertiesLoaded && this.getEnv().hasCognosServiceInterface()) {
            QueryItemPropertyManager queryItemPropertyManager = new QueryItemPropertyManager(this.getEnv(), this.getQuery());
            queryItemPropertyManager.apply(this._evaluateSpecOnly);
            queryItemPropertiesLoaded = this._QueryItemProperties.loadJSONXMLAttribute(this._dataItemOrSubType);
        }
        return queryItemPropertiesLoaded;
    }

    public void setItemType(ItemType itemType) {
        this._itemType = itemType;
    }

    public ItemType evaluate() throws ActionException {
        if (this.evaluateHighLevelSpecTypes()) {
            return this.getItemType();
        }
        if (this._queryItemExpression != null) {
            if (this.isKnownAggregateForm()) {
                this._itemType = ItemType.numeric;
                this._numericSubType = NumericSubType.aggregate;
            }
            if (this.getEnv().hasCognosServiceInterface() && !this.confirmIsNumeric()) {
                this.confirmIsSet();
            }
            return this._itemType;
        }
        return ItemType.unknown;
    }

    public static boolean isHighLevelSetType(Element item) {
        return item != null && _queryItemSetTypes.contains(item.getName());
    }

    public static boolean isHighLevelMeasure(Element queryItem) {
        return "dataItemMeasure".equals(queryItem.getName()) || "dataItemCalculatedMeasure".equals(queryItem.getName());
    }

    public static boolean isHighLevelSortReferenceItemType(Element basedOnQueryItem) {
        return basedOnQueryItem != null && ("dataItemMeasure".equals(basedOnQueryItem.getName()) || "dataItemDimensionalEdgeSummary".equals(basedOnQueryItem.getName()) || "dataItemCalculatedMember".equals(basedOnQueryItem.getName()) || "dataItemCalculatedMeasure".equals(basedOnQueryItem.getName()));
    }

    public boolean evaluateHighLevelSpecTypes() {
        if (V5QueryItem.isHighLevelMeasure(this._dataItemOrSubType)) {
            this._itemType = ItemType.numeric;
            this._numericSubType = NumericSubType.measure;
            this._QueryItemProperties.initialize(this._dataItemOrSubType);
        } else if ("dataItemMember".equals(this._dataItemOrSubType.getName())) {
            this._itemType = ItemType.member;
            this._QueryItemProperties.initialize(this._dataItemOrSubType);
        } else if (V5QueryItem.isHighLevelSetType(this._dataItemOrSubType)) {
            this._itemType = ItemType.set;
            this._QueryItemProperties.initialize(this._dataItemOrSubType);
        } else if ("dataItemCalculatedMember".equals(this._dataItemOrSubType.getName())) {
            this._itemType = ItemType.numeric;
            this._QueryItemProperties.initialize(this._dataItemOrSubType);
            this._numericSubType = this.isKnownAggregateForm() ? NumericSubType.aggregate : NumericSubType.calculationOrAggregate;
        } else if ("dataItemEdgeSummary".equals(this._dataItemOrSubType.getName()) || "dataItemListSummary".equals(this._dataItemOrSubType.getName()) || "dataItemDimensionalEdgeSummary".equals(this._dataItemOrSubType.getName())) {
            this._itemType = ItemType.numeric;
            this._numericSubType = NumericSubType.aggregate;
            this._QueryItemProperties.initialize(this._dataItemOrSubType);
        } else {
            return false;
        }
        return true;
    }

    public QueryItemProperties getProperties() {
        return this._QueryItemProperties;
    }

    public String getQueryItemExpression() {
        return this._queryItemExpression;
    }

    private static boolean isKnownAggregateForm(Element queryItem) {
        String expression;
        return queryItem != null && (expression = queryItem.elementText("expression")) != null && expression.toUpperCase().matches(_knownAggregateFormPattern);
    }

    public boolean isKnownAggregateForm() {
        return V5QueryItem.isKnownAggregateForm(this._dataItemOrSubType);
    }

    public static boolean upgradeIfDataItemCalculatedMeasure(Element dataItem, SelectedCell selectedCell) {
        if ("measure".equals(selectedCell.nodeUsage) && selectedCell.nodeDimensionUniqueName != null) {
            Attribute attr2;
            dataItem.setQName(DocumentHelper.createQName((String)"dataItemCalculatedMeasure", (Namespace)dataItem.getNamespace()));
            Attribute attr1 = dataItem.attribute("aggregate");
            if (attr1 != null) {
                dataItem.remove(attr1);
            }
            if ((attr2 = dataItem.attribute("rollupAggregate")) != null) {
                dataItem.remove(attr2);
            }
            Element dmDimension = dataItem.addElement("dmDimension");
            Element dun = dmDimension.addElement("DUN");
            dun.setText(selectedCell.nodeDimensionUniqueName);
            dmDimension.addElement("itemCaption");
            return true;
        }
        return false;
    }

    public boolean isKnownAggregateForm(String itemName) {
        String expression;
        return this._queryItemExpression != null && (expression = this._queryItemExpression.toUpperCase()).matches(_knownAggregateFormPrefixPattern + itemName.toUpperCase() + "\\].*$");
    }

    public static boolean upgradeIfKnownAggregateItem(Element dataItem, SelectedCell selectedCell) {
        if (!"measure".equals(selectedCell.nodeUsage)) {
            return V5QueryItem.upgradeIfKnownAggregateItem(dataItem, selectedCell.nodeHierarchyUniqueName, selectedCell.nodeDimensionUniqueName);
        }
        return false;
    }

    public static boolean upgradeIfKnownAggregateItem(Element dataItem, String hierarchyUniqueName, String dimensionUniqueName) {
        String aggregateType;
        String knownAggregateItem;
        if ("dataItem".equals(dataItem.getName()) && dimensionUniqueName != null && hierarchyUniqueName != null && (knownAggregateItem = V5QueryItem.getKnownAggregateRDI(dataItem)) != null && (aggregateType = V5QueryItem.getKnownAggregateType(dataItem)) != null) {
            dataItem.setQName(DocumentHelper.createQName((String)"dataItemDimensionalEdgeSummary", (Namespace)dataItem.getNamespace()));
            dataItem.addAttribute("refDataItem", knownAggregateItem);
            dataItem.addAttribute("aggregateMethod", aggregateType);
            Element dmDimension = dataItem.addElement("dmDimension");
            Element dmHierarchy = dataItem.addElement("dmHierarchy");
            Element hun = dmHierarchy.addElement("HUN");
            hun.setText(hierarchyUniqueName);
            Element dun = dmDimension.addElement("DUN");
            dun.setText(dimensionUniqueName);
            dmDimension.addElement("itemCaption");
            dmHierarchy.addElement("itemCaption");
            dataItem.element("expression").detach();
            return true;
        }
        return false;
    }

    public static boolean upgradeIfKnownAggregateItem(Element dataItem, V5Query query) {
        String aggregateOfRDI;
        if ("dataItem".equals(dataItem.getName()) && (aggregateOfRDI = V5QueryItem.getKnownAggregateRDI(dataItem)) != null) {
            Element aggregateOfItem = query.findItem(aggregateOfRDI);
            Element hun = V5X.selectSingleNode(aggregateOfItem, "//V5X//CHILD", "dmHierarchy", "HUN");
            Element dun = V5X.selectSingleNode(aggregateOfItem, "//V5X//CHILD", "dmDimension", "DUN");
            if (hun != null && dun != null) {
                return V5QueryItem.upgradeIfKnownAggregateItem(dataItem, hun.getText(), dun.getText());
            }
        }
        return false;
    }

    public static String getKnownAggregateRDI(Element dataItem) {
        String rdiName;
        Element querySelection;
        Element rdiItem;
        int endOfPattern;
        int lastRBrac;
        Pattern pattern1;
        Matcher cmwdMatcher;
        String expression = dataItem.elementText("expression");
        if (expression != null && V5QueryItem.getKnownAggregateType(dataItem) != null && (cmwdMatcher = (pattern1 = Pattern.compile(_knownAggregateFormPrefixPattern)).matcher(expression.toUpperCase())).find() && (lastRBrac = (expression = expression.substring(endOfPattern = cmwdMatcher.end())).lastIndexOf("]")) > 1 && (rdiItem = V5X.selectSingleNode(querySelection = dataItem.getParent(), "//V5X//CHILD", "//V5X//CHILDATTR", "name", rdiName = expression.substring(0, lastRBrac))) != null) {
            return rdiName;
        }
        return null;
    }

    public static String getKnownAggregateType(Element dataItem) {
        String expression;
        String pattern1Str;
        Pattern pattern1;
        Matcher cmwdMatcher;
        String origExpression;
        if (V5QueryItem.isKnownAggregateForm(dataItem) && (origExpression = dataItem.elementText("expression")) != null && (cmwdMatcher = (pattern1 = Pattern.compile(pattern1Str = "^\\s*(total|aggregate|summary|minimum|maximum|average)")).matcher(expression = origExpression.toLowerCase())).find() && cmwdMatcher.start() == 0) {
            int endOfPattern = cmwdMatcher.end();
            return expression.substring(0, endOfPattern).trim();
        }
        return null;
    }

    public static boolean isKnownMunForm(String expression) {
        String[] munSide;
        if (expression != null && (munSide = expression.split("->")).length == 2) {
            if (munSide[1].startsWith(":")) {
                munSide[1] = munSide[1].substring(1);
            }
            if (V5QueryItem.isModelItemForm(munSide[0]) && munSide[1].length() > 1) {
                return V5QueryItem.isModelItemForm(munSide[1], 1);
            }
        }
        return false;
    }

    public boolean isKnownMunForm() {
        return V5QueryItem.isKnownMunForm(this._queryItemExpression);
    }

    public static boolean canExpand(ItemType itemType) {
        return itemType == ItemType.member || itemType == ItemType.set;
    }

    public static String getHun(Element dataItem) {
        String sHUN = null;
        Element hun = V5X.selectSingleNode(dataItem, "//V5X//CHILD", "dmHierarchy", "HUN");
        sHUN = hun != null ? hun.getText() : V5SpecHelper.getXMLAttribute(dataItem, "RAP_HUN");
        return sHUN;
    }

    public static String getDun(Element dataItem) {
        String sDUN = null;
        Element dun = V5X.selectSingleNode(dataItem, "//V5X//CHILD", "dmDimension", "DUN");
        if (dun != null) {
            sDUN = dun.getText();
        }
        return sDUN;
    }

    public static String getDimensionName(Element extendedDataItem) {
        String[] parts;
        String sDUN = null;
        Element dun = V5X.selectSingleNode(extendedDataItem, "//V5X//CHILD", "dmDimension", "DUN");
        if (dun != null && (parts = (sDUN = dun.getText()).split("\\]\\.\\[")).length == 2) {
            return parts[1].substring(0, parts[1].length() - 1);
        }
        return null;
    }

    public static String getNameSpace(Element dataItem) {
        String[] parts;
        String sDUN = null;
        Element dun = V5X.selectSingleNode(dataItem, "//V5X//CHILD", "dmDimension", "DUN");
        if (dun != null && (parts = (sDUN = dun.getText()).split("\\]\\.\\[")).length == 2) {
            return parts[0].substring(1);
        }
        return null;
    }

    public static boolean isModelItemForm(String dataItemExpression) {
        return V5QueryItem.isModelItemForm(dataItemExpression, 3);
    }

    private static boolean isModelItemForm(String dataItemExpression, int minParts) {
        String[] parts;
        if (dataItemExpression != null && dataItemExpression.startsWith("[") && dataItemExpression.endsWith("]") && (parts = dataItemExpression.substring(0, dataItemExpression.length() - 1).split("\\]\\.\\[")).length >= minParts) {
            for (int i = 0; i < parts.length; ++i) {
                String thisPart = parts[i].replaceAll("\\]\\]", "");
                if (!thisPart.contains("]")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNameLocalizable(Element item) {
        String dataItemExpression;
        if (V5QueryItem.isHighLevelSetType(item) || V5QueryItem.isHighLevelMeasure(item) || "dataItemMember".equals(item.getName())) {
            return true;
        }
        if ("dataItem".equals(item.getName()) && (dataItemExpression = item.elementText("expression").trim()) != null && dataItemExpression.startsWith("[") && dataItemExpression.endsWith("]")) {
            if (V5QueryItem.isModelItemForm(dataItemExpression, 3)) {
                return true;
            }
            if (V5QueryItem.isKnownMunForm(dataItemExpression)) {
                return true;
            }
        }
        return false;
    }

    static {
        _queryItemSetTypes = new HashSet();
        _queryItemSetTypes.add("dataItemSet");
        _queryItemSetTypes.add("dataItemSetExpression");
        _queryItemSetTypes.add("dataItemSetExpression");
        _queryItemSetTypes.add("dataItemChildrenSet");
        _queryItemSetTypes.add("dataItemLevelSet");
        _queryItemSetTypes.add("dataItemHierarchySet");
        _queryItemSetTypes.add("dataItemNamedSet");
        _queryItemSetTypes.add("dataItemMemberSet");
    }

    public static enum NumericSubType {
        unknown,
        dataValues,
        measure,
        nonMeasure,
        calculationOrAggregate,
        calculation,
        aggregate;

    }

    public static enum ItemType {
        unknown,
        string,
        member,
        memberOrSingleMemberSet,
        set,
        numeric,
        dateTime;

    }
}

