/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class V5RSXChart
extends V5DataContainer {
    public static HashSet<String> _comboElements = new HashSet();
    public static HashSet<String> _ordinalElement;
    public static HashSet<String> _legendElement;

    public abstract Element getChartElement();

    public Collection<Element> getNodeMembersForDataItem(String refDataItem) {
        return XMLUtility.selectNodes(this.getChartElement(), ".//*[local-name()='chartNodeMember'][@refDataItem='" + refDataItem + "']");
    }

    public List<Element> insertObject(List<DimensionalOperations.DataItemRef> dataItemRefs, Element targetElement, V5Query v5Query) {
        return this.createNodeUnion(dataItemRefs, targetElement, v5Query);
    }

    public List<Element> createNodeUnion(List<DimensionalOperations.DataItemRef> dataItemRefs, Element targetElement, V5Query v5Query) {
        ArrayList<Element> addedNodeMemberElements = new ArrayList<Element>();
        Element chartNodes = targetElement.getParent();
        for (DimensionalOperations.DataItemRef dataItemRef : dataItemRefs) {
            Element chartNode = chartNodes.addElement("chartNode");
            Element chartNodeMembers = chartNode.addElement("chartNodeMembers");
            Element chartNodeMember = chartNodeMembers.addElement("chartNodeMember");
            addedNodeMemberElements.add(chartNodeMember);
            Element memberCaption = DocumentHelper.makeElement((Branch)chartNodeMember, (String)"chartContents/chartTextItem/dataSource/memberCaption");
            chartNodeMember.addAttribute("refDataItem", dataItemRef.getRefDataItemName());
        }
        return addedNodeMemberElements;
    }

    public Collection<Element> doDeleteOnEdge(Element nodeToDelete, V5Query query) {
        ArrayList<Element> deleteElements = new ArrayList<Element>();
        Element originalParentElement = null;
        boolean oneComboPiece = this.getChartElement().selectNodes(".//*[local-name()='combinationChartTypes']/* | .//*[local-name()='threeDCombinationChartTypes']/*").size() == 1;
        Element parentElement = nodeToDelete.getParent();
        boolean bContinue = true;
        while (bContinue) {
            boolean empty;
            nodeToDelete.detach();
            deleteElements.add(nodeToDelete);
            Element nestedNodesElement = (Element)parentElement.selectSingleNode("./*[local-name()='chartNestedNodes']");
            if (nestedNodesElement != null) {
                List chartNodes = XMLUtility.selectNodes(nestedNodesElement, "./*[local-name()='chartNode']");
                Element chartNodesElement = nestedNodesElement.getParent().getParent();
                int insertBefore = chartNodesElement.elements().indexOf(nestedNodesElement.getParent());
                chartNodesElement.elements().addAll(insertBefore, chartNodes);
                chartNodesElement.remove(nestedNodesElement.getParent());
                break;
            }
            originalParentElement = parentElement;
            boolean comboPiece = _comboElements.contains(parentElement.getName());
            boolean bl = empty = originalParentElement.selectNodes("*").size() == 0 || "bar".equals(originalParentElement.getName()) && originalParentElement.selectSingleNode("./*[local-name()='chartNodes']") == null;
            if (V5RSXChart.isChart(originalParentElement.getName()) || !empty || comboPiece && oneComboPiece || _ordinalElement.contains(parentElement.getName()) || _legendElement.contains(parentElement.getName()) || comboPiece) {
                bContinue = false;
            }
            nodeToDelete = parentElement;
            parentElement = parentElement.getParent();
        }
        this.fixComboIndex();
        return deleteElements;
    }

    public static boolean isChart(String name) {
        return name.endsWith("Chart");
    }

    private void fixComboIndex() {
        Element comboTypesRoot = (Element)this.getChartElement().selectSingleNode(".//*[local-name()='combinationChartTypes'] | .//*[local-name()='threeDCombinationChartTypes']");
        if (comboTypesRoot != null) {
            int comboElements = comboTypesRoot.selectNodes("*").size();
            List comboIndices = XMLUtility.selectNodes(this.getChartElement(), ".//*[@comboIndex!='0']");
            for (Element comboIndexElement : comboIndices) {
                if (Integer.parseInt(comboIndexElement.attributeValue("comboIndex")) < comboElements) continue;
                comboIndexElement.addAttribute("comboIndex", "0");
            }
        }
    }

    static {
        _comboElements.add("bar");
        _comboElements.add("line");
        _comboElements.add("area");
        _comboElements.add("threeDBar");
        _comboElements.add("threeDLine");
        _comboElements.add("threeDArea");
        _ordinalElement = new HashSet();
        _ordinalElement.add("commonClusters");
        _ordinalElement.add("paretoBarClusters");
        _ordinalElement.add("marimekkoBarClusters");
        _ordinalElement.add("radialClusters");
        _ordinalElement.add("progressiveBars");
        _ordinalElement.add("pies");
        _ordinalElement.add("gauges");
        _ordinalElement.add("pointClusters");
        _ordinalElement.add("winLossBars");
        _ordinalElement.add("v2_commonAxis");
        _legendElement = new HashSet();
        _legendElement.add("combinationChartTypes");
        _legendElement.add("threeDCombinationChartTypes");
        _legendElement.add("pieSlices");
        _legendElement.add("indicators");
        _legendElement.add("paretoBars");
        _legendElement.add("marimekkoBars");
        _legendElement.add("points");
    }
}

