/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public abstract class V5RSXCrosstab
extends V5DataContainer {
    public static final String K_sCrosstabMemberLabelCell = "ml";
    public static final String K_sCrosstabMemberValueCell = "mv";
    public static final String K_sCrosstabCalculatedMemberLabelCell = "cl";
    public static final String K_sCrosstabCalculatedMemberValueCell = "cv";
    public static final String K_sCrosstabInnerTotalLabelCell = "il";
    public static final String K_sCrosstabInnerTotalValueCell = "iv";
    public static final String K_sCrosstabOuterTotalLabelCell = "ol";
    public static final String K_sCrosstabOuterTotalValueCell = "ov";

    public abstract Element getCrosstabElement();

    public Element getNodeMemberElementByRefDataItem(String refDataItem) {
        return (Element)this.getCrosstabElement().selectSingleNode(".//*[@refDataItem='" + refDataItem + "']");
    }

    public Collection<Element> insertObject(List<DimensionalOperations.DataItemRef> dataItemRefs, Element targetElement, V5Query v5Query, boolean insertBefore, boolean createCrosstabNode) {
        return this.union(dataItemRefs, targetElement, v5Query, insertBefore, createCrosstabNode);
    }

    private Collection<Element> union(List<DimensionalOperations.DataItemRef> refdataItems, Element targetElement, V5Query v5Query, boolean before, boolean createCrosstabNode) {
        List<Element> nodes = this.createRootNodes(refdataItems, v5Query, createCrosstabNode);
        Element targetNodeElement = targetElement;
        while (!"crosstabNode".equals(targetNodeElement.getName())) {
            targetNodeElement = targetNodeElement.getParent();
        }
        this.unionNodes(nodes, targetNodeElement, before);
        return nodes;
    }

    private List<Element> createRootNodes(List<DimensionalOperations.DataItemRef> refdataItems, V5Query v5query, boolean createCrosstabNode) {
        List<Element> newMembers = this.createNodeMembers(refdataItems);
        boolean doNotNest = false;
        for (int i = 0; i < newMembers.size(); ++i) {
            Element crosstabNodeMember = newMembers.get(i);
            Element dataItemElement = v5query.findItem(crosstabNodeMember.attributeValue("refDataItem"));
            if (!V5Query.isSingValue(dataItemElement) && !V5Query.isLikelyMeasure(dataItemElement)) continue;
            doNotNest = true;
            break;
        }
        if (doNotNest) {
            return this.createNodesForMembers(newMembers, createCrosstabNode);
        }
        Element rootNode = null;
        for (int i = newMembers.size() - 1; i >= 0; --i) {
            Element member = newMembers.get(i);
            Element nodeElement = this.createNode(member);
            if (rootNode != null) {
                Element nestedNodesElement = (Element)nodeElement.selectSingleNode("crosstabNestedNodes");
                nestedNodesElement.add(rootNode);
            }
            rootNode = nodeElement;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        result.add(rootNode);
        return result;
    }

    private List<Element> createNodeMembers(List<DimensionalOperations.DataItemRef> dataItemRefs) {
        ArrayList<Element> crosstabNodeMemberElements = new ArrayList<Element>();
        for (int i = 0; i < dataItemRefs.size(); ++i) {
            Element nodeMember = this.createNodeMemberForDataItemRef(dataItemRefs.get(i));
            if (nodeMember == null) continue;
            crosstabNodeMemberElements.add(nodeMember);
        }
        return crosstabNodeMemberElements;
    }

    private Element createNodeMemberForDataItemRef(DimensionalOperations.DataItemRef dataItemRef) {
        if (dataItemRef.isDrillParent()) {
            return this.createNodeMember(dataItemRef.getRefDataItemName(), K_sCrosstabOuterTotalLabelCell, K_sCrosstabOuterTotalLabelCell);
        }
        return this.createNodeMember(dataItemRef.getRefDataItemName(), null, null);
    }

    private Element createNodeMember(String refDataItemName, String defaultStyle, String factCellStyle) {
        Element crosstabNodeMemberElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"crosstabNodeMember", (Namespace)this.getCrosstabElement().getNamespace()));
        crosstabNodeMemberElement.addAttribute("refDataItem", refDataItemName);
        if (defaultStyle == null || defaultStyle.length() == 0) {
            defaultStyle = K_sCrosstabMemberLabelCell;
        }
        V5Style.appendStyleElement(crosstabNodeMemberElement, defaultStyle);
        V5Style.appendContentsElement(crosstabNodeMemberElement);
        Element factCellElement = this.appendFactCellElement(crosstabNodeMemberElement);
        if (factCellStyle != null && factCellStyle.length() > 0) {
            V5Style.appendStyleElement(factCellElement, factCellStyle);
        }
        return crosstabNodeMemberElement;
    }

    public Collection<Element> removeObject(Element nodeToDelete, boolean removeQueryRefs) {
        String nodeName = nodeToDelete.getName();
        if ("crosstabNode".equals(nodeName)) {
            return this.removeNode(nodeToDelete);
        }
        return new ArrayList<Element>();
    }

    public Collection<Element> removeNode(Element nodeToDelete) {
        Element nodeParent = nodeToDelete.getParent();
        nodeParent.remove(nodeToDelete);
        if (nodeParent.elements().size() == 0) {
            nodeParent.getParent().remove(nodeParent);
        }
        ArrayList<Element> removed = new ArrayList<Element>();
        removed.add(nodeToDelete);
        return removed;
    }

    private void unionNodes(List<Element> nodeElements, Element refNode, boolean before) {
        Element refNodeParent = refNode.getParent();
        int refIndex = refNodeParent.indexOf((Node)refNode);
        refIndex = before ? refIndex : refIndex + 1;
        List nodeList = refNode.getParent().content();
        for (int i = 0; i < nodeElements.size(); ++i) {
            nodeList.add(refIndex++, nodeElements.get(i));
        }
    }

    private List<Element> createNodesForMembers(List<Element> nodeMemberElements, boolean createCrosstabNode) {
        ArrayList<Element> nodeElements = new ArrayList<Element>();
        if (createCrosstabNode) {
            for (int i = 0; i < nodeMemberElements.size(); ++i) {
                nodeElements.add(this.createNode(nodeMemberElements.get(i)));
            }
        } else {
            Element nodeElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"crosstabNode", (Namespace)this.getCrosstabElement().getNamespace()));
            nodeElement.addElement("crosstabNestedNodes");
            Element membersElement = nodeElement.addElement("crosstabNodeMembers");
            for (int i = 0; i < nodeMemberElements.size(); ++i) {
                membersElement.add(nodeMemberElements.get(0));
            }
            nodeElements.add(nodeElement);
        }
        return nodeElements;
    }

    private Element createNode(Element nodeMember) {
        Element nodeElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"crosstabNode", (Namespace)this.getCrosstabElement().getNamespace()));
        nodeElement.addElement("crosstabNestedNodes");
        Element membersElement = nodeElement.addElement("crosstabNodeMembers");
        membersElement.add(nodeMember);
        return nodeElement;
    }

    private Element appendFactCellElement(Element parent) {
        return parent.addElement("factCell");
    }
}

