/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SetFiltering;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class V5SetExpandCollapse
extends V5SetFiltering {
    public static String EXPANDED_MEMBER_INFO_ATTR = "expandedMemberInfo";
    private ActionEnv m_env = null;
    private V5Query m_v5Query = null;
    private RAPReport m_rapReport = null;
    private String m_modelPath = null;

    public Element doSetExpandCollapse(V5DataContainer dataContainer, ArrayList<SelectedCell> selectedCells, Element pun, String userSpecifiedExpandOrCollapse) throws ActionException {
        boolean isToCollapse = false;
        this.m_v5Query = dataContainer.getV5Query();
        this.m_v5Query.setEnv(this.getEnv());
        Element originalSetItem = this.findFilterableSetItem(this.m_v5Query, selectedCells);
        if (originalSetItem == null && selectedCells != null) {
            originalSetItem = this.convertSelectedLayoutMemberToMemberSet(dataContainer, selectedCells.get(0));
        }
        if (originalSetItem != null) {
            Element dataItemMemberSet = this.prepareDataItemMemberSet(originalSetItem, false);
            if (dataItemMemberSet != null) {
                Element setSortingElement = V5X.selectSingleNode(dataItemMemberSet, "//V5X//CHILD", "setSorting");
                if (setSortingElement != null && (setSortingElement.attributeValue("breakHierarchy") == null || "".equals(setSortingElement.attributeValue("breakHierarchy")))) {
                    setSortingElement.addAttribute("breakHierarchy", "false");
                }
                boolean bl = isToCollapse = !"ExpandMember".equals(userSpecifiedExpandOrCollapse) && this.collapseExpandedMember(dataItemMemberSet, selectedCells, userSpecifiedExpandOrCollapse);
                if (!isToCollapse) {
                    this.completeDefinitionForSetExpandCollapseMember(dataItemMemberSet.element("setDefinition"), selectedCells, "setExpandMember");
                    if (pun != null) {
                        this.addExpandedMemberInfo(dataItemMemberSet, pun.getText(), selectedCells.get((int)0).nodeUse);
                    }
                    this.clearDetailFilters(selectedCells.get((int)0).nodeName);
                }
                this.updateIndentation(dataContainer, dataItemMemberSet.attributeValue("name"), isToCollapse);
                return dataItemMemberSet;
            }
            return null;
        }
        return null;
    }

    public Element convertSelectedLayoutMemberToMemberSet(V5DataContainer dataContainer, SelectedCell cell) {
        if (cell == null) {
            return null;
        }
        Element queryItemBeingExpanded = this.m_v5Query.findItem(cell.nodeName);
        if (queryItemBeingExpanded != null && "dataItemMember".equals(queryItemBeingExpanded.getName())) {
            String mun = V5X.selectSingleNode(queryItemBeingExpanded, "//V5X//CHILD", "dmMember").elementText("MUN");
            String caption = V5X.selectSingleNode(queryItemBeingExpanded, "//V5X//CHILD", "dmMember").elementText("itemCaption");
            String newItemName = this.m_v5Query.findUniqueItemName(queryItemBeingExpanded.attributeValue("name"));
            if (mun != null) {
                Element setItem = this.m_v5Query.getItemList().addDataItemSet(newItemName, true, new String[]{mun}, new String[]{caption}, V5QueryItem.getHun(queryItemBeingExpanded), V5QueryItem.getDun(queryItemBeingExpanded));
                if (setItem != queryItemBeingExpanded) {
                    List<Element> referencesToItem = dataContainer.selectNodes("//V5X//CHILDATTR", "refDataItem", queryItemBeingExpanded.attributeValue("name"));
                    for (Element referenceToItem : referencesToItem) {
                        referenceToItem.addAttribute("refDataItem", newItemName);
                    }
                }
                return setItem;
            }
        }
        return null;
    }

    private void clearDetailFilters(String nodeName) {
        this.m_v5Query.clearDetailFilters(nodeName);
    }

    public void addExpandedMemberInfo(Element dataItemMemberSet, String parent, String child) throws ActionException {
        try {
            JSONArray children;
            JSONObject parentChildrenInfo;
            String sExpandedMemberInfo = V5SpecHelper.getXMLAttribute(dataItemMemberSet, EXPANDED_MEMBER_INFO_ATTR);
            if (sExpandedMemberInfo == null || sExpandedMemberInfo.length() == 0) {
                parentChildrenInfo = new JSONObject();
                children = new JSONArray();
            } else {
                parentChildrenInfo = JSONObject.parse((String)sExpandedMemberInfo);
                children = (JSONArray)parentChildrenInfo.get((Object)parent);
                if (children == null) {
                    children = new JSONArray();
                }
            }
            children.add((Object)child);
            parentChildrenInfo.put((Object)parent, (Object)children);
            V5SpecHelper.setXMLAttribute(dataItemMemberSet, EXPANDED_MEMBER_INFO_ATTR, parentChildrenInfo.serialize(), null);
        }
        catch (IOException e) {
            ActionException exception = new ActionException();
            throw exception;
        }
    }

    public static boolean alwaysCanExpandCollapse(Element relatedQueryItem) {
        return V5Query.isHierarchySet(relatedQueryItem) && !V5Query.isRootMembersOnlyHierarchySet(relatedQueryItem) || "dataItemSetExpression".equals(relatedQueryItem.getName()) || V5X.selectSingleNode(relatedQueryItem, "setExpression") != null;
    }

    private void updateIndentation(V5DataContainer dataContainer, String itemName, boolean isToCollapse) {
        Element crosstabNodeMember = V5X.selectSingleNode(dataContainer.getContainerElement(), "//V5X//ANYCHILD", "crosstabNodeMember", "//V5X//ATTR", "refDataItem", itemName);
        if (crosstabNodeMember != null && !isToCollapse) {
            this.addIndentation(crosstabNodeMember);
        }
    }

    private void addIndentation(Element parent) {
        if (parent == null) {
            return;
        }
        Element indentationElement = V5X.selectSingleNode(parent, "//V5X//CHILD", "indentation");
        if (indentationElement == null) {
            indentationElement = parent.addElement("indentation");
            indentationElement.addAttribute("type", "relative");
            indentationElement.addAttribute("indentationLength", "20");
        }
    }

    public boolean collapseExpandedMember(Element checkDataItemMemberSet, ArrayList<SelectedCell> selectedCells, String expandCollapseType) throws ActionException {
        ArrayList<String> expandedMembers = V5Query.getExpandedMembers(checkDataItemMemberSet);
        String selectedCellMUN = selectedCells.get((int)0).nodeUse;
        if (checkDataItemMemberSet != null && "dataItemMemberSet".equals(checkDataItemMemberSet.getName())) {
            if (expandedMembers != null) {
                for (Element dmMember : V5X.selectNodes(checkDataItemMemberSet, "setExpandMember", "//V5X//CHILD", "dmMember")) {
                    if (!dmMember.elementText("MUN").equals(selectedCellMUN) || !expandedMembers.contains(selectedCellMUN)) continue;
                    HashMap<String, Element> expandedMemberToSetFilterMap = this.getPUNToSetFilterMap(checkDataItemMemberSet);
                    this.removeExpandedDescendants(selectedCellMUN, checkDataItemMemberSet, expandedMembers, expandedMemberToSetFilterMap);
                    this.removeSetFilter(checkDataItemMemberSet, selectedCellMUN, expandedMemberToSetFilterMap);
                    return this.completeDefinitionForSetExpandCollapseMember(checkDataItemMemberSet.element("setDefinition"), selectedCells, "setCollapseMember") != null;
                }
            }
            if ("CollapseMember".equals(expandCollapseType)) {
                this.completeDefinitionForSetExpandCollapseMember(checkDataItemMemberSet.element("setDefinition"), selectedCells, "setCollapseMember");
                return true;
            }
        }
        return false;
    }

    private void removeSetFilter(Element dataItemMemberSet, String expandedMemberMUN, HashMap<String, Element> expandedMemberToSetFilterMap) {
        if (expandedMemberToSetFilterMap != null && expandedMemberToSetFilterMap.containsKey(expandedMemberMUN)) {
            this.removeSetTerm(dataItemMemberSet, expandedMemberToSetFilterMap.get(expandedMemberMUN));
        }
    }

    private HashMap<String, Element> getPUNToSetFilterMap(Element dataItemMemberSet) throws CognosServiceRequestException {
        Element maResponse;
        Element member;
        ArrayList<String> setExceptMemberMUNs = new ArrayList<String>();
        HashMap<String, Element> setExceptMemberMUNToElementMap = new HashMap<String, Element>();
        V5Query.getSetExceptMembers(dataItemMemberSet, setExceptMemberMUNs, setExceptMemberMUNToElementMap);
        if (setExceptMemberMUNs.size() == 0) {
            return null;
        }
        ArrayList<Element> maResponses = this.m_v5Query.getPUNs(this.getModelPath(), setExceptMemberMUNs);
        if (maResponses == null) {
            return null;
        }
        HashMap<String, Element> parentToSetFilterMap = new HashMap<String, Element>();
        Iterator<Element> iterator = maResponses.iterator();
        while (iterator.hasNext() && (member = (maResponse = iterator.next()).element("member")) != null) {
            String mun = member.attributeValue("memberUniqueName");
            String pun = member.attributeValue("parentUniqueName");
            Element setExceptMemberElement = setExceptMemberMUNToElementMap.get(mun);
            if (mun == null || pun == null || setExceptMemberElement == null) continue;
            parentToSetFilterMap.put(pun, setExceptMemberElement);
        }
        return parentToSetFilterMap;
    }

    public void removeExpandedDescendants(String expandedMember, Element dataItemMemberSet, ArrayList<String> expandedMembers, HashMap<String, Element> expandedMembersWithFilters) throws ActionException {
        try {
            JSONObject parentChildrenJSON = this.getParentChildrenJSON(expandedMember, dataItemMemberSet, expandedMembers);
            if (parentChildrenJSON == null) {
                return;
            }
            List<String> descendants = this.getDescendants(expandedMember, parentChildrenJSON);
            if (descendants == null) {
                return;
            }
            for (Element dmMember : V5X.selectNodes(dataItemMemberSet, "setExpandMember", "//V5X//CHILD", "dmMember")) {
                String dmMemberMUN = dmMember.elementText("MUN");
                if (!descendants.contains(dmMemberMUN)) continue;
                this.removeSetFilter(dataItemMemberSet, dmMemberMUN, expandedMembersWithFilters);
                this.removeSetTerm(dataItemMemberSet, dmMember.getParent());
            }
            V5SpecHelper.setXMLAttribute(dataItemMemberSet, EXPANDED_MEMBER_INFO_ATTR, parentChildrenJSON.serialize(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeAllExpandedAndCollapsedNodes(Element dataItemMemberSet) {
        if (!"dataItemMemberSet".equals(dataItemMemberSet.getName())) {
            return;
        }
        List allExpandedMembers = V5X.selectNodes(dataItemMemberSet, "setExpandMember", "//V5X//OR", "setCollapseMember");
        if (allExpandedMembers == null || allExpandedMembers.size() == 0) {
            return;
        }
        for (Element expandedMember : allExpandedMembers) {
            this.removeSetTerm(dataItemMemberSet, expandedMember);
        }
        V5SpecHelper.removeXMLAttribute(dataItemMemberSet, EXPANDED_MEMBER_INFO_ATTR);
    }

    private JSONObject getParentChildrenJSON(String expandedMemberMUN, Element dataItemMemberSet, ArrayList<String> expandedMembers) throws IOException, CognosServiceRequestException {
        String sExpandedMemberInfo = V5SpecHelper.getXMLAttribute(dataItemMemberSet, EXPANDED_MEMBER_INFO_ATTR);
        JSONObject parentChildrenJSON = null;
        if (sExpandedMemberInfo != null && sExpandedMemberInfo.length() > 0) {
            parentChildrenJSON = JSONObject.parse((String)sExpandedMemberInfo);
        }
        if (!(this.m_rapReport == null || parentChildrenJSON != null && parentChildrenJSON.containsKey((Object)expandedMemberMUN))) {
            parentChildrenJSON = this.m_v5Query.getPUNS_JSON(this.getModelPath(), expandedMembers);
        }
        return parentChildrenJSON;
    }

    private List<String> getDescendants(String parentMUN, JSONObject parentChildrenJSON) {
        ArrayList<String> descendants = new ArrayList<String>();
        this.addDescendantsToList(parentMUN, descendants, parentChildrenJSON);
        return descendants;
    }

    private void addDescendantsToList(String parent, List<String> descendants, JSONObject parentChildInfoList) {
        if (parentChildInfoList.containsKey((Object)parent)) {
            JSONArray children = (JSONArray)parentChildInfoList.get((Object)parent);
            for (String child : children) {
                descendants.add(child);
                this.addDescendantsToList(child, descendants, parentChildInfoList);
            }
            parentChildInfoList.remove((Object)parent);
        }
    }

    public Element completeDefinitionForSetExpandCollapseMember(Element setDefinition, ArrayList<SelectedCell> selectedCells, String expandCollapseStr) {
        Element originalSetStructure = this.findFirstChild(setDefinition);
        if (originalSetStructure == null) {
            return null;
        }
        originalSetStructure.detach();
        Element expandMembers = setDefinition.addElement(expandCollapseStr);
        Element baseSet = expandMembers.addElement("baseSet");
        baseSet.add(originalSetStructure);
        this.addFirstMemberFromSelections(expandMembers, selectedCells);
        return expandMembers;
    }

    private void addFirstMemberFromSelections(Element parent, ArrayList<SelectedCell> selectedCells) {
        SelectedCell cell = selectedCells.get(0);
        Element dmMember = parent.addElement("dmMember");
        Element MUN = dmMember.addElement("MUN");
        MUN.setText(cell.nodeUse);
        Element itemCaption = dmMember.addElement("itemCaption");
        itemCaption.setText(cell.nodeDisplay);
    }

    public void setEnv(ActionEnv env) {
        this.m_env = env;
    }

    private ActionEnv getEnv() {
        return this.m_env;
    }

    public void setRAPReport(RAPReport rapReport) {
        this.m_rapReport = rapReport;
    }

    public void setModelPath(String m_modelPath) {
        this.m_modelPath = m_modelPath;
    }

    public String getModelPath() {
        return this.m_modelPath;
    }

    public void setV5Query(V5Query v5query) {
        this.m_v5Query = v5query;
    }
}

