/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.DataContainerInfo;
import com.cognos.rap.actions.DynamicDataFilter;
import com.cognos.rap.actions.FilterInfo;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class V5SetFiltering {
    public static final String RAP_Intersect_Descriptor = "RAP_INTERSECT_DESCRIPTOR";
    public static final String RAP_setFilterItem = "RAP_setFilterItem";
    public static final String RAP_basedOnItem = "RAP_basedOnItem";
    public static final String RAP_useProhibited = "RAP_useProhibited";
    private static HashMap<String, String> _setKeyItem = new HashMap();
    private static HashMap<String, String> _convertedSetType;
    public static final String setFilteringEnabled = "setFilteringEnabled";
    private boolean _setFilteringEnabled = false;
    private ActionEnv _env = null;
    private String _listSeparator = ",";
    private boolean _filterInitialSet = false;

    public V5SetFiltering() {
        this.initialize();
    }

    public V5SetFiltering(ActionEnv env) {
        this._env = env;
        if (V5SetFiltering.isSetFilteringArgumentDefined(env)) {
            this.initialize();
        }
    }

    public void setFilterInitialSet(boolean flag) {
        this._filterInitialSet = flag;
    }

    public static boolean isSetFilteringArgumentDefined(ActionEnv env) {
        if (env == null) {
            return false;
        }
        String setFilteringEnabledValue = env.getActionArg(setFilteringEnabled);
        return setFilteringEnabledValue != null && "true".equals(setFilteringEnabledValue);
    }

    private void initialize() {
        this._setFilteringEnabled = true;
    }

    public void setListSeparator(String separator) {
        this._listSeparator = separator;
    }

    public Element addUpdateAttributeFilters(V5Query query, ArrayList<SelectedCell> selectedCells, String attributeName, String attributeDataItemName, JSONObject dimensionInfo) throws ActionException {
        Element originalSetItem = this.findFilterableSetItem(query, selectedCells);
        if (originalSetItem != null) {
            if (V5SpecHelper.getXMLAttribute(originalSetItem, "RAP_AttributeOf") != null) {
                attributeDataItemName = originalSetItem.attributeValue("name");
                String attributeExpression = this.createAttributeFilterExpression(V5QueryItem.getHun(originalSetItem), dimensionInfo, attributeName, selectedCells);
                Element attributeItem = query.findItem(attributeDataItemName);
                Element expressionElement = attributeItem.element("expression");
                expressionElement.setText(attributeExpression);
                return attributeItem;
            }
            Element dataItemMemberSet = this.prepareDataItemMemberSet(originalSetItem, true);
            if (dataItemMemberSet != null) {
                String attributeExpression = this.createAttributeFilterExpression(V5QueryItem.getHun(dataItemMemberSet), dimensionInfo, attributeName, selectedCells);
                Element attributeItem = query.findItem(attributeDataItemName);
                if (attributeItem == null) {
                    attributeItem = query.getItemList().addDataItemSetExpression(attributeDataItemName, attributeExpression, V5QueryItem.getHun(dataItemMemberSet), V5QueryItem.getDun(dataItemMemberSet));
                    V5SpecHelper.setXMLAttribute(attributeItem, "RAP_AttributeOf", dataItemMemberSet.attributeValue("name"), "no");
                } else {
                    Element expressionElement = V5X.selectSingleNode(attributeItem, "expression");
                    if (expressionElement != null) {
                        expressionElement.setText(attributeExpression);
                    }
                }
                this.completeDefinitionForAttributeFilter(query, dataItemMemberSet.element("setDefinition"), dataItemMemberSet, attributeDataItemName);
                return attributeItem;
            }
        }
        return null;
    }

    public Element addUpdateLinkedSet_AttributeFilters(V5Query query, Element linkedSetItem, String attributeDataItemName, JSONObject dimensionInfo) {
        Element dataItemMemberSet = this.prepareDataItemMemberSet(linkedSetItem, true);
        if (dataItemMemberSet != null) {
            this.completeDefinitionForAttributeFilter(query, dataItemMemberSet.element("setDefinition"), dataItemMemberSet, attributeDataItemName);
        }
        return dataItemMemberSet;
    }

    private String createAttributeFilterExpression(String hunOrlun, String attributeName, ArrayList<SelectedCell> selectedCells, boolean isString) {
        String attributeTerm = ".[" + attributeName + "]";
        String attributeMPUN = hunOrlun + attributeTerm;
        String expression = "filter(" + hunOrlun + this._listSeparator;
        expression = expression + (isString ? "lower(" + attributeMPUN + ")" : attributeMPUN);
        expression = expression + " in (";
        for (int i = 0; i < selectedCells.size(); ++i) {
            SelectedCell cell = selectedCells.get(i);
            expression = expression + (i == 0 ? "" : this._listSeparator);
            expression = expression + (isString ? "lower('" : "'");
            expression = expression + V5SpecHelper.getV5SafeFilterValue(cell.nodeUse);
            expression = expression + (isString ? "')" : "'");
        }
        expression = expression + "))";
        return expression;
    }

    protected String createAttributeFilterExpression(String hun, JSONObject dimensionInfo, String attributeName, ArrayList<SelectedCell> selectedCells) {
        JSONArray levels = V5Query.getLevels(dimensionInfo);
        boolean isString = V5Query.isString(dimensionInfo, attributeName);
        if (levels == null || levels.size() == 0) {
            return this.createAttributeFilterExpression(hun, attributeName, selectedCells, isString);
        }
        if (levels.size() == 1) {
            JSONObject level0 = (JSONObject)levels.get(0);
            return this.createAttributeFilterExpression((String)level0.get((Object)"_ref"), attributeName, selectedCells, isString);
        }
        String expression = "";
        for (int lvl = 0; lvl < levels.size(); ++lvl) {
            String joiner = lvl == 0 ? "union(" : this._listSeparator + " union(";
            joiner = lvl == levels.size() - 1 ? this._listSeparator : joiner;
            JSONObject levelN = (JSONObject)levels.get(lvl);
            expression = expression + joiner + this.createAttributeFilterExpression((String)levelN.get((Object)"_ref"), attributeName, selectedCells, isString);
        }
        for (int cb = levels.size() - 1; cb > 0; --cb) {
            expression = expression + ")";
        }
        return "hierarchize(" + expression + ")";
    }

    public Element addUpdateSetFilters(V5Query query, ArrayList<SelectedCell> selectedCells, boolean include) throws ActionException {
        Element originalSetItem = this.findFilterableSetItem(query, selectedCells);
        if (originalSetItem != null) {
            Element dataItemMemberSet = this.prepareDataItemMemberSet(originalSetItem, include);
            if (dataItemMemberSet != null) {
                if (include) {
                    if (this.selectedCellsAreRelational(selectedCells)) {
                        this.completeDefinitionForIncludedMembersByValue(dataItemMemberSet.element("setDefinition"), selectedCells);
                    } else {
                        this.completeDefinitionForSetExplicitMembers(query, dataItemMemberSet, dataItemMemberSet.element("setDefinition"), selectedCells);
                    }
                } else {
                    this.completeDefinitionForSetExceptMembers(dataItemMemberSet.element("setDefinition"), selectedCells);
                }
                V5SpecHelper.setXMLAttribute(dataItemMemberSet, RAP_setFilterItem, "true", "no");
            }
            return dataItemMemberSet;
        }
        return null;
    }

    private boolean selectedCellsAreRelational(ArrayList<SelectedCell> selectedCells) {
        boolean relationalBaseSet = false;
        for (int i = 0; i < selectedCells.size(); ++i) {
            SelectedCell cell = selectedCells.get(i);
            if (!cell.nodeUse.equals(cell.nodeDisplay)) continue;
            return true;
        }
        return false;
    }

    private Element completeDefinitionForSetExplicitMembers(V5Query query, Element dataItemMemberSet, Element setDefinition, ArrayList<SelectedCell> selectedCells) {
        String refExplicitMembers = V5SpecHelper.getXMLAttribute(dataItemMemberSet, "RAP_REF_EXPLICITMEMBERS");
        if (refExplicitMembers == null && query.findItem(refExplicitMembers = DynamicDataFilter.getRefExplicitMemberName(dataItemMemberSet.attributeValue("name"))) == null) {
            refExplicitMembers = null;
        }
        Element explicitMembers = null;
        Element setDefinitionOrBaseSet = this._filterInitialSet ? this.findInitialSet(setDefinition) : setDefinition;
        Element setToReplace = this.findFirstChild(setDefinitionOrBaseSet);
        if (refExplicitMembers == null) {
            if (setToReplace != null) {
                if ("setExpression".equals(setToReplace.getName()) && this.isIntersectedAttributeFilter(dataItemMemberSet)) {
                    explicitMembers = this.createRefExplicitMembers(query, dataItemMemberSet, setToReplace);
                    this.addRemoveIntersectTerm(query, dataItemMemberSet, setToReplace.element("expression"), explicitMembers.attributeValue("name"), true);
                } else {
                    setToReplace.detach();
                    explicitMembers = setDefinitionOrBaseSet.addElement("setExplicitMembers");
                }
            }
        } else {
            explicitMembers = query.findItem(refExplicitMembers);
            if ("dataItemMemberSet".equals(explicitMembers.getName())) {
                explicitMembers = V5X.selectSingleNode(explicitMembers, "setExplicitMembers");
            }
            if (explicitMembers != null && explicitMembers.element("dmMembers") != null) {
                explicitMembers.element("dmMembers").detach();
            }
            this.addRemoveIntersectTerm(query, dataItemMemberSet, setToReplace.element("expression"), refExplicitMembers, true);
        }
        this.addMembersFromSelections(explicitMembers, selectedCells);
        return explicitMembers;
    }

    private Element createRefExplicitMembers(V5Query query, Element dataItemMemberSet, Element setExplicitMembers) {
        Element dataItemSet;
        Element existingRefExplicitMembers = query.findItem(DynamicDataFilter.getRefExplicitMemberName(dataItemMemberSet.attributeValue("name")));
        if (existingRefExplicitMembers != null) {
            query.getItemList().removeDataItem(existingRefExplicitMembers);
        }
        if ((dataItemSet = (Element)setExplicitMembers.clone()).element("expression") != null) {
            dataItemSet.element("expression").detach();
        }
        dataItemSet.setQName(DocumentHelper.createQName((String)"dataItemSet", (Namespace)dataItemMemberSet.getNamespace()));
        dataItemSet.addAttribute("name", DynamicDataFilter.getRefExplicitMemberName(dataItemMemberSet.attributeValue("name")));
        String hun = V5QueryItem.getHun(dataItemMemberSet);
        String dun = V5QueryItem.getDun(dataItemMemberSet);
        query.getItemList().addDataItem(dataItemSet);
        query.setDimensionalDataItemInfo(dataItemSet, null, null, hun, dun);
        V5SpecHelper.setXMLAttribute(dataItemMemberSet, "RAP_REF_EXPLICITMEMBERS", dataItemSet.attributeValue("name"), "no");
        return dataItemSet;
    }

    private boolean isIntersectedAttributeFilter(Element dataItemMemberSet) {
        return V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_Intersect_Descriptor) != null;
    }

    private Element completeDefinitionForIncludedMembersByValue(Element setDefinition, ArrayList<SelectedCell> selectedCells) {
        Element setDefinitionOrBaseSet = this._filterInitialSet ? this.findInitialSet(setDefinition) : setDefinition;
        Element setToReplace = this.findFirstChild(setDefinitionOrBaseSet);
        if (setToReplace != null) {
            setToReplace.detach();
        }
        Element explicitSetExpression = setDefinitionOrBaseSet.addElement("setExpression");
        Element explicitSet = explicitSetExpression.addElement("expression");
        String hun = setDefinition.getParent().element("dmHierarchy").elementText("HUN");
        String expression = "filter(" + hun + this._listSeparator + " caption(currentMember(" + hun + ")) in (";
        for (int i = 0; i < selectedCells.size(); ++i) {
            SelectedCell cell = selectedCells.get(i);
            if (!cell.nodeUse.equals(cell.nodeDisplay)) continue;
            expression = expression + (i == 0 ? "'" : this._listSeparator + "'");
            expression = expression + V5SpecHelper.getV5SafeFilterValue(cell.nodeUse);
            expression = expression + "'";
        }
        expression = expression + "))";
        explicitSet.setText(expression);
        return explicitSet;
    }

    private Element completeDefinitionForAttributeFilter(V5Query query, Element setDefinition, Element dataItemMemberSet, String attributeDataItemName) {
        Element setDefinitionOrBaseSet = this._filterInitialSet ? this.findInitialSet(setDefinition) : setDefinition;
        Element baseSetContent = this.findFirstChild(setDefinitionOrBaseSet);
        Element expressionElement = null;
        if ("setExpression".equals(baseSetContent.getName())) {
            expressionElement = baseSetContent.element("expression");
            this.addRemoveIntersectTerm(query, dataItemMemberSet, expressionElement, attributeDataItemName, true);
        } else {
            baseSetContent.detach();
            Element explicitSetExpression = setDefinitionOrBaseSet.addElement("setExpression");
            expressionElement = explicitSetExpression.addElement("expression");
            if ("setExplicitMembers".equals(baseSetContent.getName())) {
                Element refExplicitMembers = this.createRefExplicitMembers(query, dataItemMemberSet, baseSetContent);
                this.addRemoveIntersectTerm(query, dataItemMemberSet, expressionElement, refExplicitMembers.attributeValue("name"), true);
            }
            this.addRemoveIntersectTerm(query, dataItemMemberSet, expressionElement, attributeDataItemName, true);
        }
        return expressionElement;
    }

    public boolean addRemoveIntersectTerm(V5Query query, Element dataItem, Element expressionElement, String contributor, boolean addTerm) {
        String intersectDescriptor = V5SpecHelper.getXMLAttribute(dataItem, RAP_Intersect_Descriptor);
        if (expressionElement == null) {
            return false;
        }
        JSONObject descriptorJSON = null;
        try {
            descriptorJSON = intersectDescriptor == null ? this.createIntersectDescriptor(query, expressionElement.getText()) : JSONObject.parse((String)intersectDescriptor);
        }
        catch (Exception e) {
            descriptorJSON = new JSONObject();
        }
        if (descriptorJSON == null) {
            return false;
        }
        JSONObject intersectObj = (JSONObject)descriptorJSON.get((Object)"intersect");
        if (intersectObj == null) {
            intersectObj = new JSONObject();
            descriptorJSON.put((Object)"intersect", (Object)intersectObj);
        }
        if (addTerm) {
            intersectObj.put((Object)contributor, (Object)("[" + contributor + "]"));
        } else {
            intersectObj.remove((Object)contributor);
        }
        String outputExpression = this.intersectDescriptorToExpression(intersectObj);
        if (!"".equals(outputExpression)) {
            expressionElement.setText(outputExpression);
            V5SpecHelper.setXMLAttribute(dataItem, RAP_Intersect_Descriptor, descriptorJSON.toString(), "no");
        } else {
            Element unfilteredSet = this.createExpandToLevelSetExpression(query, "_UNFILTERED_" + dataItem.attributeValue("name"), dataItem, 1);
            if (unfilteredSet != null) {
                expressionElement.setText("[" + unfilteredSet.attributeValue("name") + "]");
                V5SpecHelper.setXMLAttribute(dataItem, RAP_Intersect_Descriptor, "", "no");
            }
        }
        return true;
    }

    private JSONObject createIntersectDescriptor(V5Query query, String intersectDescriptorString) {
        if (intersectDescriptorString == null) {
            return null;
        }
        JSONObject descriptorJSON = new JSONObject();
        JSONObject intersectJSON = new JSONObject();
        descriptorJSON.put((Object)"intersect", (Object)intersectJSON);
        for (Element queryItem : query.getItemList().getDataItemElements()) {
            String itemName = queryItem.attributeValue("name");
            if (intersectDescriptorString.contains("].[" + itemName + "]") || !intersectDescriptorString.contains("[" + itemName + "]")) continue;
            intersectDescriptorString = intersectDescriptorString.replaceFirst("\\[" + itemName + "\\]", "");
            intersectJSON.put((Object)itemName, (Object)("[" + itemName + "]"));
        }
        return descriptorJSON;
    }

    private Element createExpandToLevelSetExpression(V5Query query, String dataItemName, Element dataItemSet, int depth) {
        if (query.findItem(dataItemName) != null) {
            return query.findItem(dataItemName);
        }
        String hun = V5QueryItem.getHun(dataItemSet);
        if (hun == null) {
            return null;
        }
        String expandTo = hun;
        if (depth == 0) {
            expandTo = "rootMembers(" + hun + ")";
        } else if (depth > 0) {
            expandTo = "descendants(rootMembers(" + hun + ")" + this._listSeparator + Integer.toString(depth) + this._listSeparator + "self beforewithmember)";
        }
        return query.getItemList().addDataItemSetExpression(dataItemName, expandTo, hun, V5QueryItem.getDun(dataItemSet));
    }

    private String intersectDescriptorToExpression(JSONObject intersectObj) {
        String outputExpression = "";
        Object[] intersects = intersectObj.values().toArray();
        if (intersects.length == 1) {
            outputExpression = (String)intersects[0];
        } else {
            int i;
            for (i = 0; i < intersects.length; ++i) {
                outputExpression = outputExpression + (i > 0 ? this._listSeparator : "");
                outputExpression = outputExpression + (i < intersects.length - 1 ? "intersect(" : "");
                outputExpression = outputExpression + intersects[i];
            }
            for (i = 0; i < intersects.length - 1; ++i) {
                outputExpression = outputExpression + ")";
            }
        }
        return outputExpression;
    }

    private Element findInitialSet(Element setDefinitionOrDataItemMemberSet) {
        Element baseSet;
        Element parentNode = setDefinitionOrDataItemMemberSet;
        if ("dataItemMemberSet".equals(parentNode.getName())) {
            parentNode = parentNode.element("setDefinition");
        }
        while (parentNode != null && (baseSet = V5X.selectSingleNode(parentNode, "baseSet")) != null) {
            parentNode = baseSet;
        }
        return parentNode;
    }

    private Element completeDefinitionForSetExceptMembers(Element setDefinition, ArrayList<SelectedCell> selectedCells) {
        Element originalSetStructure = this.findFirstChild(setDefinition);
        if (originalSetStructure == null) {
            return null;
        }
        originalSetStructure.detach();
        Element exceptMembers = setDefinition.addElement("setExceptMembers");
        Element baseSet = exceptMembers.addElement("baseSet");
        baseSet.add(originalSetStructure);
        this.addMembersFromSelections(exceptMembers, selectedCells);
        return exceptMembers;
    }

    private void addMembersFromSelections(Element parent, ArrayList<SelectedCell> selectedCells) {
        if (parent != null) {
            Element dmMembers = parent.addElement("dmMembers");
            for (SelectedCell cell : selectedCells) {
                Element dmMember = dmMembers.addElement("dmMember");
                Element MUN = dmMember.addElement("MUN");
                MUN.setText(cell.nodeUse);
                Element itemCaption = dmMember.addElement("itemCaption");
                itemCaption.setText(cell.nodeDisplay);
            }
        }
    }

    protected Element prepareDataItemMemberSet(Element originalSetItemPassedIn, boolean include) {
        Element currentSetItem = originalSetItemPassedIn;
        if ("dataItemMemberSet".equals(currentSetItem.getName())) {
            if (include && BasedOnItem.get(currentSetItem) == null) {
                String basedOnItemName = BasedOnItem.create(currentSetItem);
                V5SpecHelper.setXMLAttribute(currentSetItem, RAP_basedOnItem, basedOnItemName, "no");
            }
            return originalSetItemPassedIn;
        }
        if (!this.upgradeRegularSetToDataItemMemberSet(currentSetItem, include)) {
            return null;
        }
        return currentSetItem;
    }

    private boolean upgradeRegularSetToDataItemMemberSet(Element currentSetItem, boolean include) {
        if (this.canConvertSet(currentSetItem)) {
            Attribute rootMembersOnly;
            String basedOnItemName = null;
            if (include || BasedOnItem.getReferencers(currentSetItem).size() > 0) {
                basedOnItemName = BasedOnItem.create(currentSetItem);
            }
            Element setDefinition = currentSetItem.addElement("setDefinition");
            boolean removeOldKey = !"dmHierarchy".equals(_setKeyItem.get(currentSetItem.getName()));
            Element newSet = this.toggleRegularSetBaseSet(currentSetItem, removeOldKey);
            setDefinition.add(newSet);
            currentSetItem.setQName(DocumentHelper.createQName((String)"dataItemMemberSet", (Namespace)currentSetItem.getNamespace()));
            if (basedOnItemName != null) {
                V5SpecHelper.setXMLAttribute(currentSetItem, RAP_basedOnItem, basedOnItemName, "no");
            }
            if ((rootMembersOnly = currentSetItem.attribute("rootMembersOnly")) != null) {
                currentSetItem.remove(rootMembersOnly);
            }
            return true;
        }
        return false;
    }

    private Element toggleRegularSetBaseSet(Element previousParent, boolean removeOldKey) {
        Element setKeyItem = previousParent.element(_setKeyItem.get(previousParent.getName()));
        if (setKeyItem != null) {
            String newSetType = _convertedSetType.get(previousParent.getName());
            Element newSet = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)newSetType, (Namespace)previousParent.getNamespace()));
            if (!"setHierarchyMembers".equals(newSet.getName())) {
                newSet.add((Element)setKeyItem.clone());
            } else if ("dataItemHierarchySet".equals(previousParent.getName())) {
                newSet.addAttribute("rootMembersOnly", previousParent.attributeValue("rootMembersOnly"));
            }
            if (removeOldKey) {
                setKeyItem.detach();
            }
            return newSet;
        }
        return null;
    }

    private boolean canConvertSet(Element setItem) {
        String setKeyItem = _setKeyItem.get(setItem.getName());
        return setKeyItem != null && setItem.element(setKeyItem) != null && _convertedSetType.get(setItem.getName()) != null;
    }

    public void clearExistingSetFilters(V5Query v5Query) {
        for (Element setFilter : V5SetFiltering.getSetFilters(v5Query)) {
            this.clearExistingSetFilters(v5Query, setFilter.attributeValue("name"));
        }
    }

    public boolean clearExistingSetFilters(V5Query v5Query, String rdiName) {
        Element checkDataItemMemberSet = v5Query.findItem(rdiName);
        if (checkDataItemMemberSet != null && "dataItemMemberSet".equals(checkDataItemMemberSet.getName()) && !V5SetFiltering.isDisabled(checkDataItemMemberSet)) {
            V5SetFiltering.dataItemMemberSetToRegularSet(checkDataItemMemberSet);
            return true;
        }
        return false;
    }

    public boolean clearExistingSetFilters(V5Query v5Query, String rdiName, ArrayList<String> captionList) {
        Element checkDataItemMemberSet = v5Query.findItem(rdiName);
        if (checkDataItemMemberSet != null && "dataItemMemberSet".equals(checkDataItemMemberSet.getName())) {
            for (Element dmMembers : V5X.selectNodes(checkDataItemMemberSet, "dmMembers")) {
                List captionsFound = dmMembers.elements("dmMember");
                boolean allCaptionsMatch = true;
                int i = 0;
                for (Element captionFound : captionsFound) {
                    if (i != captionList.size() && captionFound.elementText("itemCaption").equals(captionList.get(i++))) continue;
                    allCaptionsMatch = false;
                    break;
                }
                if (!allCaptionsMatch || "setExplicitMembers".equals(dmMembers.getParent().getName()) && V5SpecHelper.getXMLAttribute(checkDataItemMemberSet, RAP_basedOnItem) == null) continue;
                return this.removeSetTerm(checkDataItemMemberSet, dmMembers.getParent());
            }
        }
        return false;
    }

    public static Element dataItemMemberSetToRegularSet(Element dataItemMemberSet) {
        Element clone = BasedOnItem.get(dataItemMemberSet);
        if (clone != null) {
            V5SetFiltering.transferSetSorting(dataItemMemberSet, clone);
            String name = dataItemMemberSet.attributeValue("name");
            dataItemMemberSet.detach();
            BasedOnItem.renameBasedOnDataItem(clone, name);
            return clone;
        }
        V5SetFiltering.setDefinitionToRegularSet(dataItemMemberSet);
        return dataItemMemberSet;
    }

    private static boolean setDefinitionToRegularSet(Element dataItemMemberSet) {
        if (V5SetFiltering.setDefinitionToRegularSet(dataItemMemberSet, "setLevelMembers", "dmLevel", "dataItemLevelSet") || V5SetFiltering.setDefinitionToRegularSet(dataItemMemberSet, "setExpression", "expression", "dataItemSetExpression") || V5SetFiltering.setDefinitionToRegularSet(dataItemMemberSet, "setChildrenMembers", "dmMember", "dataItemChildrenSet") || V5SetFiltering.setDefinitionToRegularSet(dataItemMemberSet, "setExplicitMembers", "dmMembers", "dataItemSet")) {
            V5SpecHelper.removeXMLAttribute(dataItemMemberSet, RAP_setFilterItem);
            V5SpecHelper.removeXMLAttribute(dataItemMemberSet, RAP_basedOnItem);
            V5SpecHelper.removeXMLAttribute(dataItemMemberSet, "RAP_filterLocale");
            return true;
        }
        return false;
    }

    private static boolean setDefinitionToRegularSet(Element dataItemMemberSet, String sourceSetType, String setKeyItemName, String outputSetType) {
        Element setKeyItem;
        Element setDefinitionEl = dataItemMemberSet.element("setDefinition");
        Element baseSetOrSet = V5X.selectSingleNode(setDefinitionEl, sourceSetType);
        if (baseSetOrSet != null && (setKeyItem = baseSetOrSet.element(setKeyItemName)) != null) {
            baseSetOrSet.detach();
            setKeyItem.detach();
            setDefinitionEl.detach();
            dataItemMemberSet.setQName(DocumentHelper.createQName((String)outputSetType, (Namespace)dataItemMemberSet.getNamespace()));
            dataItemMemberSet.add(setKeyItem);
            return true;
        }
        return false;
    }

    protected boolean removeSetTerm(Element dataItemMemberSet, Element setTermBeingRemoved) {
        Element parentOfTerm = setTermBeingRemoved.getParent();
        if ("setExplicitMembers".equals(setTermBeingRemoved.getName())) {
            return this.removeSetExplicitMembersTerm(dataItemMemberSet, parentOfTerm, setTermBeingRemoved);
        }
        Element graduatedChildSet = this.graduateBaseSet(setTermBeingRemoved);
        if (graduatedChildSet != null) {
            parentOfTerm.add(graduatedChildSet);
        }
        return true;
    }

    private boolean removeSetExplicitMembersTerm(Element dataItemMemberSet, Element parentOfTerm, Element setExplicitMembers) {
        if ("setDefinition".equals(parentOfTerm.getName())) {
            Element cloneDataItemMemberSet = V5SetFiltering.dataItemMemberSetToRegularSet(dataItemMemberSet);
            if (cloneDataItemMemberSet != null) {
                V5SpecHelper.removeXMLAttribute(cloneDataItemMemberSet, RAP_setFilterItem);
                V5SpecHelper.removeXMLAttribute(cloneDataItemMemberSet, RAP_basedOnItem);
                V5SpecHelper.removeXMLAttribute(cloneDataItemMemberSet, "RAP_filterLocale");
            }
            return true;
        }
        Element basedOnItem = BasedOnItem.get(dataItemMemberSet);
        if (basedOnItem != null) {
            Element newSet = this.toggleRegularSetBaseSet(basedOnItem, false);
            setExplicitMembers.detach();
            parentOfTerm.add(newSet);
            return true;
        }
        return false;
    }

    private Element graduateBaseSet(Element setTermBeingRemoved) {
        Element childBaseSet = setTermBeingRemoved.element("baseSet");
        if (childBaseSet != null) {
            Element childSet = this.findFirstChild(childBaseSet);
            if (childSet != null) {
                childSet.detach();
                setTermBeingRemoved.detach();
            }
            return childSet;
        }
        return null;
    }

    protected Element findFirstChild(Element parent) {
        if (parent == null) {
            return null;
        }
        List childrenOfSetDef = parent.elements();
        if (childrenOfSetDef.size() > 0) {
            return (Element)childrenOfSetDef.get(0);
        }
        return null;
    }

    public Element findFilterableSetItem(V5Query query, ArrayList<SelectedCell> cells) throws ActionException {
        V5QueryItem qi;
        if (cells.size() == 0 || !"memberUniqueName".equals(cells.get((int)0).nodeType)) {
            return null;
        }
        Element dataItemOrSubtype = query.findItem(cells.get((int)0).nodeName);
        if (dataItemOrSubtype == null) {
            return null;
        }
        if ("dataItemMemberSet".equals(dataItemOrSubtype.getName())) {
            return dataItemOrSubtype;
        }
        if (!this._setFilteringEnabled) {
            return null;
        }
        if (V5QueryItem.isHighLevelSetType(dataItemOrSubtype)) {
            return dataItemOrSubtype;
        }
        if (this._env != null && (qi = new V5QueryItem(this._env, query, dataItemOrSubtype)).confirmIsSet() && V5QueryItem.isHighLevelSetType(dataItemOrSubtype)) {
            return dataItemOrSubtype;
        }
        return null;
    }

    private static void transferSetSorting(Element sourceItem, Element targetItem) {
        Element sourceSorting = sourceItem.element("setSorting");
        Element targetSorting = targetItem.element("setSorting");
        if (targetSorting != null) {
            targetSorting.detach();
        }
        if (sourceSorting != null) {
            sourceSorting.detach();
            targetItem.add(sourceSorting);
        }
    }

    private static List<Element> getSetFilters(V5Query v5Query) {
        String xpath = V5X.selectPath("//V5X//CHILD", "dataItemMemberSet");
        return XMLUtility.selectNodes(v5Query.getQuerySelection(), xpath);
    }

    public static void collectFilterValueInfo(ActionEnv env, V5Query v5Query, DataContainerInfo containerInfo, V5DataContainer container) throws ActionException {
        for (Element dataItemMemberSet : V5SetFiltering.getSetFilters(v5Query)) {
            if (V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_useProhibited) != null) continue;
            String basedOnItem = V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_basedOnItem);
            String itemName = dataItemMemberSet.attributeValue("name");
            String label = container != null ? container.getBestItemLabel(itemName, env) : itemName;
            List dataItemMemberSetTerms = V5X.selectNodes(dataItemMemberSet, "setDefinition", "setExceptMembers", "//V5X//OR", "setExplicitMembers");
            for (Element dataItemMemberSetTerm : dataItemMemberSetTerms) {
                if ("setExplicitMembers".equals(dataItemMemberSetTerm.getName()) && basedOnItem != null) {
                    boolean isDynamicFilter;
                    boolean bl = isDynamicFilter = V5SpecHelper.getXMLAttribute(dataItemMemberSet, "RAP_DataFilterDescriptor") != null;
                    if (!isDynamicFilter) {
                        Element linkedSetItem = V5SpecHelper.getLinkedSetItem(v5Query, dataItemMemberSet);
                        boolean bl2 = isDynamicFilter = linkedSetItem != null && V5SpecHelper.getXMLAttribute(linkedSetItem, "RAP_DataFilterID") != null;
                    }
                    if (isDynamicFilter) continue;
                    FilterInfo fi = new FilterInfo(dataItemMemberSetTerm, label, env.getLocale());
                    containerInfo.addFilterInfo(fi);
                    continue;
                }
                if ("setExplicitMembers".equals(dataItemMemberSetTerm.getName())) continue;
                FilterInfo fi = new FilterInfo(dataItemMemberSetTerm, label, env.getLocale());
                containerInfo.addFilterInfo(fi);
            }
        }
    }

    private static Element getRapFilter_DataItemMemberSet(Element filterMembersElement) {
        Element parentMemberSet;
        if (filterMembersElement != null && ("setExplicitMembers".equals(filterMembersElement.getName()) || "setExceptMembers".equals(filterMembersElement.getName())) && (parentMemberSet = V5SpecHelper.getAncestor(filterMembersElement, "dataItemMemberSet")) != null && V5SpecHelper.getXMLAttribute(parentMemberSet, RAP_setFilterItem) != null) {
            return parentMemberSet;
        }
        return null;
    }

    public static String getItemName(Element setExplicitOrSetExceptMembers) {
        Element dataItemMemberSet = V5SetFiltering.getRapFilter_DataItemMemberSet(setExplicitOrSetExceptMembers);
        if (dataItemMemberSet != null) {
            return dataItemMemberSet.attributeValue("name");
        }
        return null;
    }

    public static boolean isMemberFilter(Element filterElement) {
        return V5SetFiltering.getRapFilter_DataItemMemberSet(filterElement) != null;
    }

    public static boolean isExcludeFilter(Element filterElement) {
        return filterElement != null && "setExceptMembers".equals(filterElement.getName()) && V5SetFiltering.isMemberFilter(filterElement);
    }

    public static void disableSetFilter(Element dataItemMemberSetToDisable) {
        if (V5SpecHelper.getXMLAttribute(dataItemMemberSetToDisable, RAP_setFilterItem) != null && !V5SetFiltering.isDisabled(dataItemMemberSetToDisable)) {
            String finalUnfilteredName = dataItemMemberSetToDisable.attributeValue("name");
            Element basedOnItem = BasedOnItem.get(dataItemMemberSetToDisable);
            if (basedOnItem == null) {
                Element dataItemMemberSetCopy = (Element)dataItemMemberSetToDisable.clone();
                basedOnItem = V5SetFiltering.dataItemMemberSetToRegularSet(dataItemMemberSetCopy);
                if (basedOnItem.getParent() == null) {
                    dataItemMemberSetToDisable.getParent().add(basedOnItem);
                }
            } else {
                BasedOnItem.renameBasedOnDataItem(basedOnItem, finalUnfilteredName);
            }
            String disabledFilterName = V5SpecHelper.findUniqueName(dataItemMemberSetToDisable.getParent(), ".//*", dataItemMemberSetToDisable.attributeValue("name") + "_" + "use" + "prohibited");
            V5SpecHelper.renameGlobalXMLAttribute(dataItemMemberSetToDisable, RAP_setFilterItem, disabledFilterName);
            V5SpecHelper.renameGlobalXMLAttribute(dataItemMemberSetToDisable, "RAP_filterLocale", disabledFilterName);
            dataItemMemberSetToDisable.addAttribute("name", disabledFilterName);
            V5SpecHelper.setXMLAttribute(dataItemMemberSetToDisable, RAP_basedOnItem, finalUnfilteredName, "no");
            V5SpecHelper.setXMLAttribute(dataItemMemberSetToDisable, RAP_useProhibited, finalUnfilteredName, "no");
            basedOnItem.addAttribute("name", finalUnfilteredName);
        }
    }

    public static boolean isDisabled(Element dataItemMemberSet) {
        return V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_useProhibited) != null;
    }

    public static void enableSetFilter(Element dataItemMemberSetToEnable) {
        if (V5SpecHelper.getXMLAttribute(dataItemMemberSetToEnable, RAP_setFilterItem) != null && V5SetFiltering.isDisabled(dataItemMemberSetToEnable)) {
            String filteredName = V5SpecHelper.getXMLAttribute(dataItemMemberSetToEnable, RAP_useProhibited);
            String basedOnName = V5SpecHelper.getXMLAttribute(dataItemMemberSetToEnable, RAP_basedOnItem);
            if (basedOnName.equals(filteredName)) {
                String newBasedOnName = V5SpecHelper.findUniqueName(dataItemMemberSetToEnable.getParent(), ".//*", filteredName);
                Element basedOnItem = BasedOnItem.get(dataItemMemberSetToEnable);
                BasedOnItem.renameBasedOnDataItem(basedOnItem, newBasedOnName);
                basedOnItem.addAttribute("name", newBasedOnName);
            }
            V5SpecHelper.renameGlobalXMLAttribute(dataItemMemberSetToEnable, RAP_setFilterItem, filteredName);
            V5SpecHelper.renameGlobalXMLAttribute(dataItemMemberSetToEnable, "RAP_filterLocale", filteredName);
            dataItemMemberSetToEnable.addAttribute("name", filteredName);
            V5SpecHelper.removeXMLAttribute(dataItemMemberSetToEnable, RAP_useProhibited);
        }
    }

    public static void disableSetFilters(Element queryOrDocument) {
        List filtersList = null;
        filtersList = "query".equals(queryOrDocument.getName()) ? V5X.selectNodes(queryOrDocument, "dataItemMemberSet") : V5X.selectNodes(queryOrDocument, "queries", "query", "dataItemMemberSet");
        if (filtersList != null) {
            for (Element filter : filtersList) {
                V5SetFiltering.disableSetFilter(filter);
            }
        }
    }

    public static void updateLocaleBasedFilters(String thisLocale, Element document) {
        String filterLocale;
        List dataItemMemberSets = V5X.selectNodes(document, "//V5X//CHILD", "queries", "query", "selection", "dataItemMemberSet");
        for (Element dataItemMemberSet : dataItemMemberSets) {
            if (V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_setFilterItem) == null || (filterLocale = V5SpecHelper.getXMLAttribute(dataItemMemberSet, "RAP_filterLocale")) == null || thisLocale.contains(filterLocale)) continue;
            V5SetFiltering.disableSetFilter(dataItemMemberSet);
        }
        for (Element dataItemMemberSet : dataItemMemberSets) {
            if (V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_setFilterItem) == null || (filterLocale = V5SpecHelper.getXMLAttribute(dataItemMemberSet, "RAP_filterLocale")) == null || !thisLocale.contains(filterLocale)) continue;
            V5SetFiltering.enableSetFilter(dataItemMemberSet);
        }
    }

    public static List<Element> findDataItemMemberSetsWithBasedOnItems(Element query) {
        ArrayList<Element> itemsWithBasedOnItems = new ArrayList<Element>();
        List dataItemMemberSets = V5X.selectNodes(query, "//V5X//CHILD", "selection", "dataItemMemberSet");
        for (Element dataItemMemberSet : dataItemMemberSets) {
            String basedOnItemName = V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_basedOnItem);
            if (basedOnItemName == null) continue;
            itemsWithBasedOnItems.add(dataItemMemberSet);
        }
        return itemsWithBasedOnItems;
    }

    public void refreshBasedOnItemContents(Element report, boolean preserveInitialSet) {
        List queries = V5X.selectNodes(report, "//V5X//CHILD", "queries", "query");
        for (Element query : queries) {
            for (Element dataItemMemberSet : V5SetFiltering.findDataItemMemberSetsWithBasedOnItems(query)) {
                Element setToReplace;
                String basedOnItemName;
                V5Query v5Query = new V5Query(query, query.attributeValue("name"));
                Element basedOnDataItem = v5Query.findItem(basedOnItemName = V5SpecHelper.getXMLAttribute(dataItemMemberSet, RAP_basedOnItem));
                if (basedOnDataItem == null) continue;
                Element preserveInitialSetElement = preserveInitialSet ? this.findOrCreateBasedOnItemInitialSet(basedOnDataItem) : null;
                basedOnDataItem.detach();
                Element newBasedOnItem = (Element)dataItemMemberSet.clone();
                if (preserveInitialSetElement != null && (setToReplace = this.findFirstChild(this.findInitialSet(newBasedOnItem))) != null) {
                    setToReplace.getParent().add(preserveInitialSetElement);
                    setToReplace.detach();
                }
                DynamicDataFilter.removeFilterTags(newBasedOnItem);
                V5SpecHelper.removeXMLAttribute(newBasedOnItem, RAP_basedOnItem);
                V5SpecHelper.removeXMLAttribute(newBasedOnItem, "RAP_FilterableItem");
                dataItemMemberSet.getParent().add(newBasedOnItem);
                newBasedOnItem.addAttribute("name", basedOnItemName);
            }
        }
    }

    private Element findOrCreateBasedOnItemInitialSet(Element basedOnDataItem) {
        Element returnInitialSet = null;
        if ("dataItemMemberSet".equals(basedOnDataItem.getName())) {
            returnInitialSet = this.findFirstChild(this.findInitialSet(basedOnDataItem));
            if (returnInitialSet != null) {
                returnInitialSet = (Element)returnInitialSet.clone();
            }
        } else {
            return this.toggleRegularSetBaseSet(basedOnDataItem, false);
        }
        return returnInitialSet;
    }

    public boolean clearFacet(V5Query v5Query, String rdiName, String baseItem) {
        Element dataItemMemberSet = v5Query.findItem(rdiName);
        if (dataItemMemberSet == null || V5SetFiltering.isDisabled(dataItemMemberSet) || !"dataItemMemberSet".equals(dataItemMemberSet.getName())) {
            return false;
        }
        Element initialSet = this.findInitialSet(dataItemMemberSet);
        if ((initialSet = this.findFirstChild(initialSet)) != null) {
            Element initialSetParent = initialSet.getParent();
            initialSet.detach();
            boolean hideTotals = "none".equals(V5SpecHelper.getXMLAttribute(dataItemMemberSet, "ShowTotals"));
            boolean bl = hideTotals ? hideTotals : (hideTotals = V5X.selectSingleNode(dataItemMemberSet.getDocument(), "//V5X//CHILD", "layouts", "layout", "//V5X//ANY", "chartNodeMember", "//V5X//ATTR", "refDataItem", rdiName) != null);
            if (hideTotals) {
                this.createAdvancedNoRollupInitialSet(v5Query, initialSetParent, V5QueryItem.getHun(dataItemMemberSet), baseItem);
            } else {
                initialSetParent.addElement("setHierarchyMembers");
            }
            return true;
        }
        return false;
    }

    private void createAdvancedNoRollupInitialSet(V5Query v5Query, Element initialSetParent, String hun, String baseItemName) {
        String expressionItem = baseItemName != null && v5Query.findItem(baseItemName) != null ? "[" + V5Query.escapeQueryExpressionReference(baseItemName) + "]" : hun;
        String listSep = V5SpecHelper.getListSeparator(initialSetParent.getDocument());
        String advancedNoRollupExpression = "filter(" + expressionItem + listSep + " count( 1 within set intersect(children(currentMember(" + hun + ")) " + listSep + expressionItem + ") ) = 0)";
        Element expression = initialSetParent.addElement("setExpression").addElement("expression");
        expression.setText(advancedNoRollupExpression);
    }

    public void refreshSetFiltersAfterBUA(Document dom) {
        List dataItemSets = V5X.selectNodes(dom, "dataItemSet");
        for (Element dataItemSet : dataItemSets) {
            String matchValue = V5SpecHelper.getXMLAttribute(dataItemSet, RAP_basedOnItem);
            if (matchValue == null) continue;
            this.upgradeRegularSetToDataItemMemberSet(dataItemSet, false);
        }
    }

    static {
        _setKeyItem.put("dataItemLevelSet", "dmLevel");
        _setKeyItem.put("setLevelMembers", "dmLevel");
        _setKeyItem.put("dataItemChildrenSet", "dmMember");
        _setKeyItem.put("setChildrenMembers", "dmMember");
        _setKeyItem.put("dataItemSetExpression", "expression");
        _setKeyItem.put("setExplicitMembers", "expression");
        _setKeyItem.put("dataItemSet", "dmMembers");
        _setKeyItem.put("setExplicitMembers", "dmMembers");
        _setKeyItem.put("dataItemHierarchySet", "dmHierarchy");
        _setKeyItem.put("setHierarchyMembers", "dmHierarchy");
        _convertedSetType = new HashMap();
        _convertedSetType.put("dataItemLevelSet", "setLevelMembers");
        _convertedSetType.put("setLevelMembers", "dataItemLevelSet");
        _convertedSetType.put("dataItemHierarchySet", "setHierarchyMembers");
        _convertedSetType.put("setHierarchyMembers", "dataItemHierarchySet");
        _convertedSetType.put("dataItemChildrenSet", "setChildrenMembers");
        _convertedSetType.put("setChildrenMembers", "dataItemChildrenSet");
        _convertedSetType.put("dataItemSetExpression", "setExpression");
        _convertedSetType.put("setExpression", "dataItemSetExpression");
        _convertedSetType.put("dataItemSet", "setExplicitMembers");
        _convertedSetType.put("setExplicitMembers", "dataItemSet");
    }

    protected static class BasedOnItem {
        protected BasedOnItem() {
        }

        protected static String create(Element currentSetItem) {
            Element cloneSetItem = (Element)currentSetItem.clone();
            currentSetItem.getParent().add(cloneSetItem);
            String cloneName = V5SpecHelper.findUniqueName(currentSetItem.getParent(), ".//*", currentSetItem.attributeValue("name"));
            BasedOnItem.renameBasedOnDataItem(cloneSetItem, cloneName);
            cloneSetItem.addAttribute("name", cloneName);
            return cloneName;
        }

        protected static Element get(Element dataItemMemberSet) {
            String cloneName = V5SpecHelper.getXMLAttribute(dataItemMemberSet, V5SetFiltering.RAP_basedOnItem);
            if (cloneName != null) {
                return V5X.selectSingleNode(dataItemMemberSet.getParent(), "//V5X//CHILDATTR", "name", cloneName);
            }
            return null;
        }

        protected static List<Element> getReferencers(Element dataItem) {
            ArrayList<Element> referencers = new ArrayList<Element>();
            String referenceName = dataItem.attributeValue("name");
            List basedOnReferencers = V5X.selectNodes(dataItem.getParent(), "//V5X//CHILD", "dataItemMemberSet", "XMLAttributes", "XMLAttribute", "//V5X//ATTR", "name", V5SetFiltering.RAP_basedOnItem);
            for (Element basedOnReferencer : basedOnReferencers) {
                if (!referenceName.equals(basedOnReferencer.attributeValue("value"))) continue;
                referencers.add(basedOnReferencer);
            }
            return referencers;
        }

        protected static void renameBasedOnDataItem(Element basedOnDataItem, String newName) {
            if (basedOnDataItem != null) {
                for (Element basedOnReferencer : BasedOnItem.getReferencers(basedOnDataItem)) {
                    basedOnReferencer.addAttribute("value", newName);
                }
                basedOnDataItem.addAttribute("name", newName);
            }
        }
    }
}

