/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.rap.actions.v5infoactionset.GetInfo;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5Crosstab;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5DataContainerFactory;
import com.cognos.rap.actions.v5spechelpers.V5DrillUpDownWithBehaviors;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5RSXChart;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class V5SpecHelper {
    public static final String QueryExpressionPattern = " *[local-name()='selection']//*[local-name()='expression']  | ./*[local-name()='detailFilters']/*[local-name()='detailFilter']/*[local-name()='filterExpression'] | ./*[local-name()='summaryFilters']/*[local-name()='summaryFilter']/*[local-name()='filterExpression'] | ./*[local-name()='slicer']/*[local-name()='slicerMemberSet']";
    public static final String RAP_CHART_MATRIX_CELL_QUERY = "RAP_ChartMatrixCellQuery";
    private static final HashMap<String, HashSet<String>> queryElementsForGlobalXMLAttributes = new HashMap();
    private static final Pattern MUNLHS;
    private static final Pattern ModelItemPart;

    public static String findUniqueName(Element parent, String xPathScope, String rootName) {
        List matchingNameDataItems;
        String returnName = rootName;
        if (parent.selectSingleNode(xPathScope + "[@name=" + V5X.safeValue(rootName) + "]") != null && (matchingNameDataItems = parent.selectNodes(xPathScope + "[starts-with(@name," + V5X.safeValue(rootName) + ")]")) != null) {
            HashSet<String> matchingNameSet = new HashSet<String>();
            ListIterator iterator = matchingNameDataItems.listIterator();
            while (iterator.hasNext()) {
                Element matchingNameDataItem = (Element)iterator.next();
                matchingNameSet.add(matchingNameDataItem.attributeValue("name"));
            }
            int n = 1;
            while (matchingNameSet.contains(returnName)) {
                returnName = rootName + n++;
            }
        }
        return returnName;
    }

    public static List<Element> findLayoutElementsFromActionArguments(Document v5Spec, Element actionArgs) {
        List<Element> v5ContainerElementList = new ArrayList<Element>();
        HashSet<Element> vizContainers = null;
        if (v5Spec != null) {
            List argIdList = null;
            if (actionArgs != null) {
                argIdList = XMLUtility.selectNodes(actionArgs, ".//*[local-name()='id']");
            }
            if (argIdList != null && argIdList.size() > 0) {
                v5ContainerElementList = V5SpecHelper.findLayoutElementsFromIdList(v5Spec.getRootElement(), argIdList);
            } else {
                Element layouts = V5X.selectSingleNode(v5Spec.getRootElement(), "//V5X//CHILD", "layouts");
                if (layouts != null) {
                    List layoutNodes = V5X.selectNodes(layouts, "//V5X//CHILD", "layout", "reportPages", "page", "//V5X//OR", "pageSet", "//V5X//ANY", "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refQuery");
                    for (Element layoutNode : layoutNodes) {
                        if (layoutNode.attributeValue("name") == null) {
                            if (!V5SpecHelper.shouldHaveName(layoutNode)) continue;
                            layoutNode.addAttribute("name", V5SpecHelper.findUniqueName(layouts, ".//*", "unnamed"));
                            v5ContainerElementList.add(layoutNode);
                            continue;
                        }
                        if ("vizDataSet".equals(layoutNode.getName())) {
                            Element containerToAdd;
                            if ((vizContainers = vizContainers == null ? new HashSet<Element>() : vizContainers).contains(containerToAdd = V5SpecHelper.findParentContainer(layoutNode))) continue;
                            vizContainers.add(containerToAdd);
                            v5ContainerElementList.add(containerToAdd);
                            continue;
                        }
                        v5ContainerElementList.add(layoutNode);
                    }
                }
            }
        }
        return v5ContainerElementList;
    }

    public static boolean shouldHaveName(Element element) {
        String name = element.getName();
        return name.equals("list") || name.equals("repeater") || name.equals("repeaterTable") || name.equals("crosstab") || name.endsWith("Chart");
    }

    public static List<Element> findLayoutElementsFromIdList(Element v5SpecNode, List<Element> argIdList) {
        StringBuilder xPath = new StringBuilder(".//*[local-name()='layouts']//*[");
        for (int i = 0; i < argIdList.size(); ++i) {
            Element argId = argIdList.get(i);
            if (i > 0) {
                xPath.append(" or ");
            }
            xPath.append("@name=").append(V5X.safeValue(argId.getText()));
        }
        xPath.append("]");
        return XMLUtility.selectNodes(v5SpecNode, xPath.toString());
    }

    public static void deleteNodes(V5DataContainer dataContainer, List nodesToDelete, boolean removeQueryRefs, V5Query query) throws ActionException {
        for (int i = 0; i < nodesToDelete.size(); ++i) {
            Element nodeToDelete = (Element)nodesToDelete.get(i);
            V5SpecHelper.deleteNode(dataContainer, nodeToDelete, removeQueryRefs, query);
        }
    }

    public static void deleteNode(V5DataContainer container, Element nodeToDelete, boolean removeQueryRefs, V5Query query) throws ActionException {
        Collection<Element> deletedElements = null;
        if (container instanceof V5Crosstab) {
            deletedElements = ((V5Crosstab)container).removeObject(nodeToDelete, removeQueryRefs);
        } else if (container instanceof V5Chart) {
            deletedElements = ((V5Chart)container).doDeleteOnEdge(nodeToDelete, query);
        }
        if (deletedElements == null) {
            throw new ActionException();
        }
        for (Element element : deletedElements) {
        }
    }

    public static String getMdTableValue(JSONObject ctxEntry, String ctxProp, JSONObject mdTable, String mdProp) {
        JSONObject mdTableEntry;
        Long mdTableKey = (Long)ctxEntry.get((Object)ctxProp);
        if (mdTableKey != null && (mdTableEntry = (JSONObject)mdTable.get((Object)mdTableKey.toString())) != null) {
            return mdTableEntry.get((Object)mdProp).toString();
        }
        return null;
    }

    public static boolean hasDetailFilters(Element report) {
        return V5Query.findDetailFilters_AllQueries(report.getDocument()).size() > 0;
    }

    public static void disableAllDetailFilters(Element report) {
        V5Query.disableAllDetailFilters(report);
    }

    public static void removeAllDynamicDataFilters(Element report) {
        V5Query.removeAllDynamicDataFilters(report, false);
    }

    public static boolean hasDynamicDataFilters(Element report) {
        return V5Query.findDynamicDataFilters_AllQueries(report.getDocument()).size() > 0;
    }

    public static void setXMLAttribute(Document doc, String attrName, String attrValue) {
        V5SpecHelper.setXMLAttribute(doc.getRootElement(), attrName, attrValue, "no");
    }

    private static String getGlobalXMLAttributeName(Element parent, String attrName) {
        return V5SpecHelper.getGlobalXMLAttributeName(parent, attrName, null);
    }

    private static String getGlobalXMLAttributeName(Element parent, String attrName, String newParentName) {
        String parentName = parent.getName();
        HashSet<String> queryAttributesForGlobalXMLAttributes = queryElementsForGlobalXMLAttributes.get(parentName);
        if (queryAttributesForGlobalXMLAttributes != null && queryAttributesForGlobalXMLAttributes.contains(attrName)) {
            Element query;
            Element element = query = parent.getParent() != null ? parent.getParent().getParent() : null;
            if (query != null) {
                JSONObject attr = new JSONObject();
                attr.put((Object)"attr", (Object)attrName);
                attr.put((Object)"query", (Object)query.attributeValue("name"));
                if (newParentName == null) {
                    attr.put((Object)"item", (Object)parent.attributeValue("name"));
                } else {
                    attr.put((Object)"item", (Object)newParentName);
                }
                String jsonPath = attr.toString();
                return XMLUtility.xmlencode(jsonPath);
            }
        }
        return null;
    }

    public static void setXMLAttribute(Element parent, String inAttrName, String attrValue, String renderOption) {
        Element xmlAttribute;
        String attrName = V5SpecHelper.getGlobalXMLAttributeName(parent, inAttrName);
        if (attrName != null) {
            parent = parent.getDocument().getRootElement();
        } else {
            attrName = inAttrName;
        }
        Element xmlAttributes = parent.element("XMLAttributes");
        if (xmlAttributes == null) {
            xmlAttributes = parent.addElement("XMLAttributes");
        }
        if ((xmlAttribute = V5X.selectSingleNode(xmlAttributes, "//V5X//CHILD", "XMLAttribute", "//V5X//ATTR", "name", attrName)) == null) {
            xmlAttribute = xmlAttributes.addElement("XMLAttribute");
        }
        xmlAttribute.addAttribute("name", attrName);
        xmlAttribute.addAttribute("value", attrValue);
        if (renderOption != null) {
            xmlAttribute.addAttribute("output", renderOption);
        }
    }

    public static void removeXMLAttribute(Element inParent, String inAttrName) {
        boolean useGlobal = false;
        Element parent = inParent;
        String attrName = V5SpecHelper.getGlobalXMLAttributeName(parent, inAttrName);
        if (attrName != null) {
            useGlobal = true;
            parent = parent.getDocument().getRootElement();
        } else {
            attrName = inAttrName;
        }
        Element xmlAttribute = (Element)parent.selectSingleNode(V5X.select("XMLAttributes") + V5X.subselect("XMLAttribute", "name", attrName));
        if (xmlAttribute == null && useGlobal) {
            xmlAttribute = (Element)inParent.selectSingleNode(V5X.select("XMLAttributes") + V5X.subselect("XMLAttribute", "name", inAttrName));
        }
        if (xmlAttribute != null) {
            Element xmlAttributes = xmlAttribute.getParent();
            xmlAttribute.detach();
            if (xmlAttributes.elements("XMLAttribute").size() == 0) {
                xmlAttributes.detach();
            }
        }
    }

    public static void removeXMLAttribute(Document doc, String attrName) {
        V5SpecHelper.removeXMLAttribute(doc.getRootElement(), attrName);
    }

    public static String getXMLAttribute(Element parent, String attrName) {
        return V5SpecHelper.getXMLAttribute(parent, attrName, false);
    }

    public static String getXMLAttribute(Element inParent, String inAttrName, boolean bStartsWith) {
        if (inParent == null) {
            return null;
        }
        Element parent = inParent;
        boolean useGlobal = false;
        String attrName = V5SpecHelper.getGlobalXMLAttributeName(parent, inAttrName);
        if (attrName != null) {
            useGlobal = true;
            parent = parent.getDocument().getRootElement();
        } else {
            attrName = inAttrName;
        }
        Element xmlAttribute = V5X.selectSingleNode(parent, "//V5X//CHILD", "XMLAttributes", "XMLAttribute", bStartsWith ? "//V5X//ATTR_STARTSWITH" : "//V5X//ATTR", "name", attrName);
        if (xmlAttribute == null && useGlobal) {
            xmlAttribute = V5X.selectSingleNode(inParent, "//V5X//CHILD", "XMLAttributes", "XMLAttribute", bStartsWith ? "//V5X//ATTR_STARTSWITH" : "//V5X//ATTR", "name", inAttrName);
        }
        if (xmlAttribute != null) {
            return xmlAttribute.attributeValue("value");
        }
        return null;
    }

    public static void renameGlobalXMLAttribute(Element inParent, String inAttrName, String newParentName) {
        String attrName = V5SpecHelper.getGlobalXMLAttributeName(inParent, inAttrName);
        if (attrName != null) {
            Element parent = inParent.getDocument().getRootElement();
            Element xmlAttribute = V5X.selectSingleNode(parent, "//V5X//CHILD", "XMLAttributes", "XMLAttribute", "//V5X//ATTR", "name", attrName);
            if (xmlAttribute != null) {
                String attrNewName = V5SpecHelper.getGlobalXMLAttributeName(inParent, inAttrName, newParentName);
                xmlAttribute.addAttribute("name", attrNewName);
            }
        }
    }

    public static String getXMLAttribute(Document doc, String attrName) {
        return V5SpecHelper.getXMLAttribute(doc.getRootElement(), attrName);
    }

    public static void deReferenceDataItems(Element reportSpec, V5Query query, Element node) {
        List elementsWithRDI = XMLUtility.selectNodes(node, ".//*[@refDataItem]");
        for (Element element : elementsWithRDI) {
            String rdi = element.attributeValue("refDataItem");
            V5SpecHelper.defReferenceDataItemAndConditionalStyles(reportSpec, query, rdi);
        }
    }

    public static void defReferenceDataItemAndConditionalStyles(Element reportSpec, V5Query query, String rdi) {
        if (!V5SpecHelper.isDataItemReferencedInLayout(reportSpec, query.getQueryName(), rdi)) {
            V5SpecHelper.removeStylesForDataItem(reportSpec, query.getQueryName(), rdi);
        }
        V5SpecHelper.removeDataItemIfUnused(reportSpec, query, rdi);
    }

    public static boolean isDataItemReferencedInLayout(Element reportSpec, String queryName, String rdi) {
        List elementsWithRDI = XMLUtility.selectNodes(reportSpec, ".//*[@refDataItem='" + rdi + "'][ancestor::*[local-name()='layouts']]");
        for (Element elementWithRDI : elementsWithRDI) {
            List elementsWithRefQuery = XMLUtility.selectNodes(elementWithRDI, "ancestor-or-self::*[@refQuery]");
            for (Element elementWithRefQuery : elementsWithRefQuery) {
                if (!queryName.equals(elementWithRefQuery.attributeValue("refQuery"))) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeStylesForDataItem(Element reportSpec, String queryName, String dataItem) {
        ArrayList<String> deadStyles = new ArrayList<String>();
        List conditionalDataItems = XMLUtility.selectNodes(reportSpec, ".//*[local-name()='conditionalDataItem'][@refQuery='" + queryName + "'][@refDataItem='" + dataItem + "']");
        for (Element contditionalDataItem : conditionalDataItems) {
            deadStyles.add(contditionalDataItem.getParent().attributeValue("name"));
            contditionalDataItem.getParent().detach();
        }
        V5SpecHelper.removeNodes(reportSpec, ".//*[local-name()='namedConditionalStyles'][not(*)]");
        V5SpecHelper.removeDeadStyleRefs(reportSpec, deadStyles);
    }

    public static void removeDeadStyleRefs(Element reportSpec, Collection<String> deadStyles) {
        for (String deadStyle : deadStyles) {
            V5SpecHelper.removeNodes(reportSpec, ".//*[@refConditionalStyle='" + deadStyle + "']");
        }
        V5SpecHelper.removeNodes(reportSpec, ".//*[local-name()='conditionalStyleRefs'][not(*)]");
    }

    public static void removeDataItemIfUnused(Element reportSpec, V5Query query, String dataItemName) {
        if (!V5SpecHelper.isDataItemReferencedOutsideDrillBehavior(reportSpec, query.getQueryName(), dataItemName)) {
            V5SpecHelper.removeDataItem(reportSpec, query, dataItemName);
        }
    }

    public static boolean isDataItemReferencedOutsideDrillBehavior(Element reportSpec, String queryName, String dataItemName) {
        List elementsWithRDI = XMLUtility.selectNodes(reportSpec, ".//*[@refDataItem='" + dataItemName + "'][not(ancestor::drillBehavior | ancestor::drillSetsBehavior)]");
        for (Element elementWithRDI : elementsWithRDI) {
            List elementsWithRefQuery = XMLUtility.selectNodes(elementWithRDI, "ancestor-or-self::*[@refQuery]");
            for (Element elementWithRefQuery : elementsWithRefQuery) {
                if (!queryName.equals(elementWithRefQuery.attributeValue("refQuery"))) continue;
                return true;
            }
        }
        return V5SpecHelper.isDataItemReferencedInQueries(reportSpec, queryName, dataItemName);
    }

    public static boolean isDataItemReferencedInQueries(Element reportSpec, String queryName, String dataItemName) {
        String re;
        Element queryElement;
        String refUnQualified = "[" + V5Query.escapeQueryExpressionReference(dataItemName) + "]";
        String refQualified = "[" + V5Query.escapeQueryExpressionReference(queryName) + "]." + refUnQualified;
        Element element = queryElement = queryName == null ? null : V5X.selectSingleNode(reportSpec, "//V5X//CHILD", "queries", "query", "//V5X//ATTR", "name", queryName);
        if (queryElement != null) {
            if (V5X.selectSingleNode(queryElement, "dmTuplePartDataItemRef", "//V5X//ATTR", "refDataItem", dataItemName) != null) {
                return true;
            }
            re = V5Query.getRegExForExpressionReferences(refUnQualified);
            List expressionNodes = XMLUtility.selectNodes(queryElement, QueryExpressionPattern);
            for (Element expressionNode : expressionNodes) {
                if (!expressionNode.getText().matches(re)) continue;
                return true;
            }
        }
        re = V5Query.getRegExForExpressionReferences(refQualified);
        List expressionElements = XMLUtility.selectNodes(reportSpec, ".//*[local-name()='expression'] | .//*[local-name()='filterExpression'] | .//*[local-name()='reportExpression'] | .//*[local-name()='reportCondition']");
        for (Element expressionElement : expressionElements) {
            if (!expressionElement.getText().matches(re)) continue;
            return true;
        }
        return false;
    }

    public static Element removeDataItem(Element reportSpec, V5Query query, String dataItemName) {
        Element dataItemElement = query.findItem(dataItemName);
        if (dataItemElement != null) {
            dataItemElement.detach();
            V5SpecHelper.removeNodes(query.getQuerySelection().getParent(), "./*[local-name()='dimensionInfo']//*[local-name()='level'][not(./*[local-name()='keys']/*[local-name()='key'][2])][./*[local-name()='keys']/*[local-name()='key'][@refDataItem=" + V5X.safeValue(dataItemName) + "]]");
            V5SpecHelper.removeNodes(query.getQuerySelection().getParent(), V5X.selectPath("//V5X//CHILD", "dimensionInfo", "//V5X//ANY", "//V5X//ANYCHILD", "//V5X//ATTR", "refDataItem", dataItemName));
            V5SpecHelper.removeNodes(query.getQuerySelection().getParent(), "./*[local-name()='dimensionInfo']//*[local-name()='levelRef'][@refLevel][not(@refLevel=ancestor::*[local-name()='dimensionInfo']//*[local-name()='level']/@name)]");
            V5SpecHelper.fixContainers(query.getQuerySelection().getParent().getParent());
            Set<String> refs = V5SpecHelper.getDataItemReferences(dataItemElement);
            for (String ref : refs) {
                V5SpecHelper.removeDataItemIfUnused(reportSpec, query, ref);
            }
        }
        return dataItemElement;
    }

    public static Set<String> getDataItemReferences(Element dataItemElement) {
        Set<String> refs = null;
        Element expressionElement = (Element)dataItemElement.selectSingleNode(".//*[local-name()='expression']");
        if (expressionElement != null) {
            refs = V5SpecHelper.getDataItemReferencesInExpression(expressionElement.getText());
        }
        if (refs == null) {
            refs = new HashSet<String>();
        }
        List dmTuplePartDataItemRefs = XMLUtility.selectNodes(dataItemElement, ".//*[local-name()='dmTuplePartDataItemRef'][@refDataItem]");
        for (Element dmTuplePartDataItemRef : dmTuplePartDataItemRefs) {
            refs.add(dmTuplePartDataItemRef.attributeValue("refDataItem"));
        }
        return refs;
    }

    public static Set<String> getDataItemReferencesInExpression(String expression) {
        HashSet<String> refs = new HashSet<String>();
        String re = "(?=[^\\.]|^)\\[(.*?[^\\]])\\](?=[^\\.\\]]|$)";
        Matcher matcher = Pattern.compile(re).matcher(expression);
        while (matcher.find()) {
            String match = matcher.group();
            refs.add(match.substring(1, match.length() - 1));
        }
        return refs;
    }

    public static void fixContainers(Element queriesElement) {
        V5SpecHelper.removeNodes(queriesElement, "*[local-name()='query']/*[local-name()='detailFilters'][not(*[local-name()='detailFilter'])]  | *[local-name()='query']/*[local-name()='summaryFilters'][not(*[local-name()='summaryFilter'])]");
        V5SpecHelper.removeNodes(queriesElement, ".//*[local-name()='dimensionInfo']/*[local-name()='dimensions'][not(*[local-name()='dimension'])]");
        V5SpecHelper.removeNodes(queriesElement, ".//*[local-name()='dimensionInfo']/*[local-name()='factList'][not(*[local-name()='fact'])]");
        V5SpecHelper.removeNodes(queriesElement, "*[local-name()='query']/*[local-name()='memberSetStructure']//*[local-name()='memberSets'][not(*[local-name()='memberSet'])]");
        V5SpecHelper.removeNodes(queriesElement, "*[local-name()='query']/*[local-name()='slicer'][not(*[local-name()='slicerMemberSet'] or *[local-name()='contextSlice'])]");
    }

    public static void removeNodes(Element reportSpec, String xpath) {
        List matchingNodes = XMLUtility.selectNodes(reportSpec, xpath);
        for (Element matchingNode : matchingNodes) {
            matchingNode.detach();
        }
    }

    public static void removeNode(Element reportSpec, String xpath) {
        Node matchingNode = reportSpec.selectSingleNode(xpath);
        matchingNode.detach();
    }

    public static void removeLeafNodesByName(Element parent, String nodeName) {
        V5SpecHelper.removeNodes(parent, V5X.select(nodeName) + "[not(./*)]");
    }

    public static Element shallowCopy(Element source) {
        Element copy = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)source.getName(), (Namespace)source.getNamespace()));
        V5SpecHelper.copyAttributes(source, copy);
        return copy;
    }

    public static void copyAttributes(Element source, Element target) {
        List attributes = source.attributes();
        for (Attribute attr : attributes) {
            target.addAttribute(attr.getName(), attr.getValue());
        }
    }

    public static Element createNewQuery(V5Query query) {
        Element queriesElement = (Element)query.getQuerySelection().getDocument().selectSingleNode(V5X.select("queries"));
        Element newQueryElement = queriesElement.addElement("query");
        newQueryElement.addAttribute("name", V5SpecHelper.findUniqueName(query.getQueryElement().getDocument().getRootElement(), ".//*", "Query2"));
        Element sourceElement = (Element)query.getQuerySelection().getParent().selectSingleNode(V5X.selectImmediateChildren("source"));
        newQueryElement.add((Element)sourceElement.clone());
        DocumentHelper.makeElement((Branch)newQueryElement, (String)"selection");
        return newQueryElement;
    }

    public static Element getInnerMostNestedCrosstabNodes(Element crosstabEdge) {
        if (crosstabEdge != null) {
            return (Element)crosstabEdge.selectSingleNode(V5X.select("crosstabNestedNodes") + "[not(" + V5X.select("crosstabNestedNodes") + ")]");
        }
        return null;
    }

    public static void tagQueryAsAddByChangeDisplayTypeAction(V5Query query) {
        Element report = query.getQueryElement().getDocument().getRootElement();
        V5SpecHelper.setXMLAttribute(report, query.getQueryName(), RAP_CHART_MATRIX_CELL_QUERY, null);
    }

    public static void deleteQueryAddedByChangeDisplayTypeAction(Element nodeInReport, String queryName) {
        Element query;
        Node elementReferenceQuery;
        Element reportNode = nodeInReport.getDocument().getRootElement();
        String value = V5SpecHelper.getXMLAttribute(reportNode, queryName);
        if (RAP_CHART_MATRIX_CELL_QUERY.equals(value) && (elementReferenceQuery = reportNode.getDocument().selectSingleNode(V5X.selectByAttr("refQuery", queryName))) == null && (query = (Element)reportNode.getDocument().selectSingleNode(V5X.select("query", "name", queryName))) != null) {
            query.detach();
            V5SpecHelper.removeXMLAttribute(reportNode, queryName);
        }
    }

    public static void detachAndCleanupContents(Element nodeToDetach) {
        Element currentNode = nodeToDetach;
        boolean alwaysDetach = true;
        while (currentNode != null) {
            Element parentNode = currentNode.getParent();
            if (!alwaysDetach && currentNode.elements().size() > 0) break;
            currentNode.detach();
            alwaysDetach = "contents".equals(currentNode.getName());
            currentNode = parentNode;
        }
    }

    public static V5DataContainer getDefaultDataContainer(Document report) throws ActionException {
        Element actionArgs = DocumentHelper.createElement((String)"Action");
        actionArgs.addElement("include").addElement("displayTypeId");
        RAPReport rapReport = new RAPReport(report);
        GetInfo getInfo = new GetInfo();
        ReportInfo reportInfo = getInfo.getInfo(rapReport, actionArgs);
        if (reportInfo.getNumberOfDataContainer() == 1) {
            String layoutId = reportInfo.getDataContainerIds().iterator().next();
            return V5DataContainerFactory.create(report.getRootElement(), layoutId);
        }
        return null;
    }

    public static List<Element> getLayoutComponentsByQuery(Element report, String queryName) {
        List elements = V5X.selectNodes(report, "layouts", "//V5X//ANY", "//V5X//CHILDATTR", "refQuery", queryName);
        HashSet<Element> existingLayoutElements = new HashSet<Element>();
        ArrayList<Element> layoutElements = new ArrayList<Element>();
        if (elements.size() > 0) {
            for (Element element : elements) {
                String name = element.getName();
                if ("list".equals(name) || "crosstab".equals(name) || V5RSXChart.isChart(name)) {
                    layoutElements.add(element);
                    continue;
                }
                if (!"vizDataSet".equals(name)) continue;
                Element parentViz = V5SpecHelper.getAncestor(element, "viz");
                if (!existingLayoutElements.contains(parentViz)) {
                    existingLayoutElements.add(parentViz);
                }
                layoutElements.add(parentViz);
            }
        }
        return layoutElements;
    }

    public static List<Element> getListLayoutComponentByQuery(Element report, String queryName) {
        List elements = V5X.selectNodes(report, "layouts", "//V5X//ANY", "list", "//V5X//ATTR", "refQuery", queryName);
        return elements;
    }

    public static HashSet<String> getQueriesInLayout(Element report) {
        HashSet<String> refQueryNames = new HashSet<String>();
        List layoutElements = V5X.selectNodes(report, "layouts", "//V5X//ANYCHILD", "//V5X//ATTR_DEFINED", "refQuery");
        for (Element layoutElement : layoutElements) {
            refQueryNames.add(layoutElement.attributeValue("refQuery"));
        }
        return refQueryNames;
    }

    public static String setCSSValue(String cssString, String name, String value) {
        String separator = ":";
        StringBuilder result = new StringBuilder();
        if (cssString == null || cssString.length() == 0) {
            V5SpecHelper.appendCSSNVPair(result, name, value);
        } else {
            result.append(V5SpecHelper.stripCSSAttribute(cssString, name));
            V5SpecHelper.appendCSSNVPair(result, name, value);
        }
        return result.toString();
    }

    public static String stripCSSAttribute(String cssString, String name) {
        if (cssString == null || name == null || name.length() == 0) {
            return null;
        }
        int indexOfName = cssString.indexOf(name);
        if (cssString.indexOf(name) == -1) {
            return cssString;
        }
        int indexOfSparator = cssString.indexOf(59, indexOfName + 1);
        String result = cssString.substring(0, indexOfName);
        if (indexOfSparator > 0) {
            result = result + cssString.substring(indexOfSparator + 1, cssString.length());
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Map<String, String> getCSSProperties(String sCSSValue) {
        StringTokenizer stringTokens = new StringTokenizer(sCSSValue, ";");
        HashMap<String, String> cssPropertiesMap = new HashMap<String, String>();
        while (stringTokens.hasMoreTokens()) {
            String cssPropertyAndValue = stringTokens.nextToken();
            String[] parms = cssPropertyAndValue.split(":");
            cssPropertiesMap.put(parms[0], parms[1]);
        }
        return cssPropertiesMap;
    }

    public static Element getLinkedDrillItem(Document report, String queryName, String refDataItem) {
        return V5X.selectSingleNode(report.getRootElement(), "linkedDrillItem", "//V5X//ATTR", "refQuery", queryName, "//V5X//ATTR", "refDataItem", refDataItem);
    }

    public static void updateRDIOfLinkedDrillItem(String queryName, Element rdiElement, String newRefDataItem) {
        Element linkedDrillItem = V5SpecHelper.getLinkedDrillItem(rdiElement.getDocument(), queryName, rdiElement.attributeValue("refDataItem"));
        if (linkedDrillItem != null) {
            linkedDrillItem.addAttribute("refDataItem", newRefDataItem);
        }
    }

    private static void appendCSSNVPair(StringBuilder stringBuilder, String name, String value) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(name);
        stringBuilder.append(":");
        stringBuilder.append(value);
    }

    public static void addSortItem(Element sortList, String refDataItem, String sortOrder) {
        for (Element sortItem : sortList.elements()) {
            if (!refDataItem.equals(sortItem.attributeValue("refDataItem"))) continue;
            if (sortOrder != null) {
                sortItem.addAttribute("sortOrder", sortOrder);
            } else {
                Attribute attr = sortItem.attribute("sortOrder");
                if (attr != null) {
                    sortItem.remove(attr);
                }
            }
            return;
        }
        Element newSortItem = sortList.addElement("sortItem");
        newSortItem.addAttribute("refDataItem", refDataItem);
        if (sortOrder != null) {
            newSortItem.addAttribute("sortOrder", sortOrder);
        }
    }

    public static Element getAncestor(Element sourceElement, String ancestorNodeName) {
        if (sourceElement != null) {
            for (Element searchElement = sourceElement.getParent(); searchElement != null; searchElement = searchElement.getParent()) {
                if (!searchElement.getName().equals(ancestorNodeName)) continue;
                return searchElement;
            }
        }
        return null;
    }

    public static Element getAncestor(Element sourceElement, Collection<String> ancestorNodeNames) {
        if (sourceElement != null) {
            for (Element searchElement = sourceElement.getParent(); searchElement != null; searchElement = searchElement.getParent()) {
                if (!ancestorNodeNames.contains(searchElement.getName())) continue;
                return searchElement;
            }
        }
        return null;
    }

    public static List<Element> getAncestors(Element sourceElement, String ancestorNodeName) {
        List elAncestors = XMLUtility.selectNodes(sourceElement, "ancestor::*[local-name()='" + ancestorNodeName + "']");
        return elAncestors;
    }

    public static String getV5SafeFilterValue(String value) {
        int rsize = value.length() * 2;
        StringBuffer sbuf = new StringBuffer(rsize);
        block3: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("''");
                    continue block3;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static void resetCustomizedLabels(V5DataContainer container, Element layoutNode, String itemName) {
        V5SpecHelper.resetCustomizedLabels(container, layoutNode, itemName, null);
    }

    public static void resetCustomizedLabels(V5DataContainer container, String itemName, String refVariable) {
        if (container != null) {
            Element cdsParent = container.findItemLabelByRDI(itemName);
            V5SpecHelper.resetCustomizedLabels(container, cdsParent, itemName, refVariable);
        }
    }

    public static void resetCustomizedLabels(V5DataContainer container, Element cdsParent, String itemName, String refVariable) {
        if (cdsParent != null) {
            List localizedDataSources = refVariable == null ? cdsParent.elements("conditionalDataSources") : V5X.selectNodes(cdsParent, "conditionalDataSources", "//V5X//ATTR", "refVariable", refVariable);
            for (Element dataSources : localizedDataSources) {
                dataSources.detach();
            }
            Element staticTextLabel = V5X.selectSingleNode(cdsParent, "dataSource", "staticValue");
            if (staticTextLabel != null) {
                Element dataSourceNode = staticTextLabel.getParent();
                if (container.getType().equals("crosstab")) {
                    dataSourceNode.addElement("memberCaption");
                } else {
                    Element dataItemLabel = dataSourceNode.addElement("dataItemLabel");
                    dataItemLabel.addAttribute("refDataItem", itemName);
                }
                staticTextLabel.detach();
            }
            V5SpecHelper.removeXMLAttribute(cdsParent.getParent().getParent(), "rp_name");
        }
    }

    public static void setDrillUpDownFlag(Document report) {
        Element drillBehaviorNode = V5X.selectSingleNode(report, "//V5X//CHILD", "drillBehavior");
        if (drillBehaviorNode == null) {
            drillBehaviorNode = report.getRootElement().addElement("drillBehavior");
            drillBehaviorNode.addAttribute("modelBasedDrillThru", "false");
        }
        drillBehaviorNode.addAttribute("drillUpDown", "true");
    }

    public static Element findParentContainer(Element element) {
        for (Element check = element.getParent(); check != null; check = check.getParent()) {
            if (check.attributeValue("refQuery") != null && V5DataContainerFactory.isDataContainer(check)) {
                return check;
            }
            if ("viz".equals(check.getName())) {
                return check;
            }
            if (!"page".equals(check.getName())) continue;
            return null;
        }
        return null;
    }

    public static void removeContainedMasterDetail(Element dataContainer, String rdi) {
        List nodes = V5X.selectNodes(dataContainer, "masterDetailLinks", "masterContext", "//V5X//CHILD", "dataItemContext", "//V5X//ATTR", "refDataItem", rdi);
        for (Element node : nodes) {
            Element masterDetailLink = V5SpecHelper.getAncestor(node, "masterDetailLink");
            Element masterDetailLinks = masterDetailLink.getParent();
            masterDetailLink.detach();
            if (masterDetailLinks.elements().size() != 0 || masterDetailLinks.getParent() == null) continue;
            masterDetailLinks.detach();
        }
    }

    public static boolean isDetailFilteringAvailable(Element report) {
        return !"true".equals(report.attributeValue("ignoreFilterContext")) || V5X.selectSingleNode(report, "//V5X//CHILD", "queries", "query", "memberSetStructure") == null;
    }

    public static Element getLastPromptPage(Element layoutElement) {
        List pages;
        Element lastPromptPage = null;
        Element promptPages = layoutElement.element("promptPages");
        if (promptPages != null && (pages = promptPages.elements("page")).size() > 0) {
            lastPromptPage = (Element)pages.get(pages.size() - 1);
        }
        return lastPromptPage;
    }

    public static boolean ifInnerMostDetailContainerWithSameQuery(String masterQueryName, Element detailContainer) {
        return masterQueryName != null && masterQueryName.equals(detailContainer.attributeValue("refQuery")) && V5X.selectNodes(detailContainer, "//V5X//CHILD", "//V5X//ANYCHILD", "//V5X//ANY", "masterDetailLinks", "//V5X//CHILD", "masterDetailLink").isEmpty();
    }

    public static V5Query cloneQueryAndRedirectContainer(Element container, V5Query v5Query) {
        Element clonedQuery = v5Query.getQueryElement().createCopy();
        String newQueryName = V5SpecHelper.findUniqueName(v5Query.getQueryElement().getParent(), ".//*", "Query");
        clonedQuery.addAttribute("name", newQueryName);
        v5Query.getQueryElement().getParent().add(clonedQuery);
        List elementsWithRefQuery = V5X.selectNodes(container, "//V5X//ANYCHILD", "//V5X//ATTR", "refQuery", v5Query.getQueryName());
        for (Element elementWithRefQuery : elementsWithRefQuery) {
            elementWithRefQuery.addAttribute("refQuery", newQueryName);
        }
        if (container.attribute("refQuery") != null) {
            container.addAttribute("refQuery", newQueryName);
        }
        return new V5Query(clonedQuery, newQueryName);
    }

    public static boolean compareLocales(String locale1, String locale2, boolean languageComponentOnly) {
        if (locale1 == null || locale2 == null) {
            return true;
        }
        if (!languageComponentOnly) {
            return locale1.equals(locale2);
        }
        String language1 = locale1.substring(0, 2);
        String language2 = locale2.substring(0, 2);
        return language1.equals(language2);
    }

    public static String getListSeparator(Document doc) {
        String eListSeparator = V5SpecHelper.getXMLAttribute(doc.getRootElement(), "listSeparator");
        return eListSeparator;
    }

    public static boolean useSetFilterForSliders(Document doc) {
        return V5SpecHelper.getXMLAttribute(doc.getRootElement(), "DesktopV5ReportGenerator") != null || "true".equals(V5SpecHelper.getXMLAttribute(doc.getRootElement(), "RAP_SetFilterSlidersEnabled"));
    }

    public static Element getLinkedSetItem(V5Query query, Element setElement) {
        String elementName;
        String linkedElementName = null;
        linkedElementName = V5SpecHelper.getXMLAttribute(query.getQueryElement().getDocument().getRootElement(), "DesktopV5ReportGenerator") != null ? ((elementName = setElement.attributeValue("name")).startsWith("_NOROLLLUP_") ? elementName.substring("_NOROLLLUP_".length()) : "_NOROLLLUP_" + elementName) : V5SpecHelper.getXMLAttribute(setElement, "RAP_LinkedSetItem");
        if (linkedElementName != null) {
            return query.findItem(linkedElementName);
        }
        return null;
    }

    public static boolean isNoRollupItem(V5Query query, String rdiName) {
        if (rdiName != null && query != null && V5SpecHelper.getXMLAttribute(query.getQueryElement().getDocument().getRootElement(), "DesktopV5ReportGenerator") != null) {
            return rdiName.startsWith("_NOROLLLUP_");
        }
        return false;
    }

    public static boolean isMeasureSetItem(boolean isMeasure, boolean checkANSFormOnly, String itemName, V5Query v5Query, ActionEnv env) throws ActionException {
        if (isMeasure) {
            V5QueryItem queryItem;
            Element dataItem;
            if (V5DrillUpDownWithBehaviors.getRootMemberSet(v5Query.getQueryElement().getDocument().getRootElement(), v5Query.getQueryName(), itemName) != null) {
                return true;
            }
            if (!checkANSFormOnly && (dataItem = v5Query.findItem(itemName)) != null && env != null && env.hasCognosServiceInterface() && !(queryItem = new V5QueryItem(env, v5Query, dataItem)).requestIsNumeric()) {
                return true;
            }
        }
        return false;
    }

    public static String getExpressionLocale(Element anyReportNode) {
        return anyReportNode.getDocument().getRootElement().attributeValue("expressionLocale");
    }

    public static boolean isTwoPartTM1MunForm(String s) {
        return s.matches("^\\[[^\\]]*\\]\\.\\[[^\\]]*\\]$");
    }

    private static String extractModelItemSubString(String validModelItem, int groupToFind) {
        String restOfResult;
        if (groupToFind < 1) {
            return null;
        }
        Matcher mun = MUNLHS.matcher(validModelItem);
        if (mun.find() && mun.start() == 0) {
            validModelItem = validModelItem.substring(0, mun.end() - 2);
        }
        Matcher m = ModelItemPart.matcher(validModelItem);
        int lastGroupFound = 0;
        int idx = 0;
        for (lastGroupFound = 0; lastGroupFound < groupToFind && m.find(); ++lastGroupFound) {
            idx = m.start();
        }
        String result = validModelItem.substring(0, idx + 2);
        if (lastGroupFound == groupToFind) {
            return result;
        }
        if (lastGroupFound == groupToFind - 1 && validModelItem.length() > idx + 2 && (restOfResult = validModelItem.substring(idx + 2)).matches("^\\.\\[.*\\]")) {
            return validModelItem;
        }
        return null;
    }

    public static String getDUN(String dunOrMore) {
        return V5SpecHelper.extractModelItemSubString(dunOrMore, 2);
    }

    public static String getHUN(String hunOrMore) {
        return V5SpecHelper.extractModelItemSubString(hunOrMore, 3);
    }

    public static String escapeQueryReferenceTerm(String rdi) {
        if (rdi != null) {
            rdi = V5SpecHelper.escapeSquareBrackets(rdi);
            rdi = V5SpecHelper.escapeSingleQuote(rdi);
        }
        return rdi;
    }

    private static String escapeSquareBrackets(String str) {
        if (str != null) {
            str = str.replaceAll("]", "]]");
        }
        return str;
    }

    private static String escapeSingleQuote(String str) {
        if (str != null) {
            str = str.replaceAll("'", "''");
        }
        return str;
    }

    static {
        HashSet<String> queryAttributesForGlobalXMLAttributes = new HashSet<String>();
        queryAttributesForGlobalXMLAttributes.add("RAP_setFilterItem");
        queryAttributesForGlobalXMLAttributes.add("RAP_basedOnItem");
        queryAttributesForGlobalXMLAttributes.add("RAP_filterLocale");
        queryElementsForGlobalXMLAttributes.put("dataItemMemberSet", queryAttributesForGlobalXMLAttributes);
        queryElementsForGlobalXMLAttributes.put("dataItemSet", queryAttributesForGlobalXMLAttributes);
        MUNLHS = Pattern.compile("\\[.*[^\\]]\\]->");
        ModelItemPart = Pattern.compile("[^\\]]\\]\\.\\[");
    }
}

