/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.utility.RAPLogger;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONObject;
import org.dom4j.Document;
import org.dom4j.Element;

public class V5Translations {
    private String _locale = null;
    boolean _translationsLoaded = false;
    private JSONObject _translations = new JSONObject();

    public V5Translations(String locale) {
        this._locale = locale;
    }

    public void put(String value, String translatedValue) {
        this._translations.put((Object)value, (Object)translatedValue);
    }

    public boolean hasTranslation(String value) {
        return this._translations.containsKey((Object)value);
    }

    public void saveTranslations(Document reportDocument) {
        if (this._translations != null) {
            String existingValue = V5SpecHelper.getXMLAttribute(reportDocument.getRootElement(), "RAP_LocalizedItemCaptions_" + this._locale);
            String newValue = XTSExt.web64encode((String)this._translations.toString(), (boolean)true);
            if (!newValue.equals(existingValue)) {
                V5SpecHelper.setXMLAttribute(reportDocument.getRootElement(), "RAP_LocalizedItemCaptions_" + this._locale, XTSExt.web64encode((String)this._translations.toString(), (boolean)true), "no");
            }
        }
        if (V5SpecHelper.compareLocales(this._locale, V5SpecHelper.getExpressionLocale(reportDocument.getRootElement()), true)) {
            V5SpecHelper.removeXMLAttribute(reportDocument, "RAP_NonNativeLocaleEdits");
        }
    }

    public void loadTranslations(Document document) {
        try {
            this._translationsLoaded = true;
            String translationValueStr = V5SpecHelper.getXMLAttribute(document.getRootElement(), "RAP_LocalizedItemCaptions_" + this._locale);
            if (translationValueStr != null) {
                this._translations = JSONObject.parse((String)XTSExt.web64decode((String)translationValueStr, (boolean)true));
            }
        }
        catch (Exception e) {
            RAPLogger.info("Translations for locale " + this._locale + " failed to load: " + e.getMessage(), V5Translations.class);
        }
    }

    public String getItemCaption(Element dmElementOrItemCaptionElement) {
        Element dmElement = "itemCaption".equals(dmElementOrItemCaptionElement.getName()) ? dmElementOrItemCaptionElement.getParent() : dmElementOrItemCaptionElement;
        String returnCaption = null;
        if (!this._translationsLoaded) {
            this.loadTranslations(dmElement.getDocument());
        }
        if (this._translations.size() > 0) {
            String key = dmElement.elementText("MUN");
            key = key == null ? dmElement.elementText("HUN") : key;
            returnCaption = (String)this._translations.get((Object)key);
        }
        return returnCaption == null ? dmElement.elementText("itemCaption") : returnCaption;
    }

    public String getTranslatedCaptionForMUNorHUN(Document report, String HUNorMUN) {
        String returnCaption = null;
        if (!this._translationsLoaded) {
            this.loadTranslations(report);
        }
        if (this._translations.size() > 0) {
            returnCaption = (String)this._translations.get((Object)HUNorMUN);
        }
        return returnCaption;
    }

    public static void notifyValuesChanged(ActionEnv env, Document doc) {
        if (env != null && !V5SpecHelper.compareLocales(env.getLocale(), V5SpecHelper.getExpressionLocale(doc.getRootElement()), true)) {
            V5SpecHelper.setXMLAttribute(doc, "RAP_NonNativeLocaleEdits", "true");
        }
    }
}

