/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.v5spechelpers.V5X;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5Variables {
    Element _report = null;
    Element _reportVariables = null;
    public static final String defaultLocaleVariableName = "locale";

    public V5Variables(Element reportNode) {
        this._report = reportNode;
    }

    private Element findVariable(String sVariableName) {
        return V5X.selectSingleNode(this._reportVariables, "//V5X//CHILD", "reportVariable", "//V5X//ATTR", "name", sVariableName);
    }

    private void initialize() {
        this._reportVariables = DocumentHelper.makeElement((Branch)this._report, (String)"reportVariables");
    }

    public Element addLocaleVariable(String sVariableName) {
        this.initialize();
        Element variable = this.findVariable(sVariableName);
        if (variable != null) {
            if (!defaultLocaleVariableName.equals(variable.attributeValue("type"))) {
                return null;
            }
        } else {
            variable = this._reportVariables.addElement("reportVariable");
            variable.addAttribute("name", sVariableName);
            variable.addAttribute("type", defaultLocaleVariableName);
            Element re = variable.addElement("reportExpression");
            re.addText("ReportLocale()");
        }
        return variable;
    }

    public void addStringVariable(String name, String expression, String[] values) {
        this.initialize();
        Element existingVariable = V5X.selectSingleNode(this._reportVariables, "//V5X//CHILD", "reportVariable", "//V5X//ATTR", "name", name);
        if (existingVariable == null) {
            existingVariable = this._reportVariables.addElement("reportVariable");
            existingVariable.addAttribute("name", name);
            existingVariable.addAttribute("type", "string");
            Element reportExpression = existingVariable.addElement("reportExpression");
            reportExpression.setText(expression);
            if (values.length > 0) {
                Element variableValues = existingVariable.addElement("variableValues");
                for (String value : values) {
                    Element variableValue = variableValues.addElement("variableValue");
                    variableValue.addAttribute("value", value);
                }
            }
        }
    }

    public void addVariableValue(Element eVariable, String sValue) {
        Element eVariableValues = DocumentHelper.makeElement((Branch)eVariable, (String)"variableValues");
        Element eThisValue = (Element)eVariableValues.selectSingleNode(".//*[local-name()='variableValue'][@value='" + sValue + "']");
        if (eThisValue == null) {
            eThisValue = eVariableValues.addElement("variableValue");
            eThisValue.addAttribute("value", sValue);
        }
    }

    public List<String> findLocaleVariables() {
        ArrayList<String> returnValues = null;
        if (this._reportVariables == null) {
            this._reportVariables = this._report.element("reportVariables");
            if (this._reportVariables == null) {
                return null;
            }
        }
        List reportVariableExpressions = V5X.selectNodes(this._reportVariables, "//V5X//CHILD", "reportVariable", "reportExpression");
        for (Element reportVariableExpression : reportVariableExpressions) {
            if (!reportVariableExpression.getText().equals("ReportLocale()")) continue;
            if (returnValues == null) {
                returnValues = new ArrayList<String>();
            }
            returnValues.add(reportVariableExpression.getParent().attributeValue("name"));
        }
        return returnValues;
    }
}

