/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.SelectedCell;
import com.cognos.rap.actions.v5spechelpers.DimensionalOperations;
import com.cognos.rap.actions.v5spechelpers.V5Chart;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5SpecHelper;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.XMLUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5VizChart
extends V5Chart {
    private ActionEnv actionEnv = null;
    private List<V5VizDataSet> _vizDataSets = new ArrayList<V5VizDataSet>();
    private int _focusDataSet = 0;
    private List<Element> _layoutItems = null;
    private List<Element> _nestedLocationWithSameHUN = null;

    public V5VizChart(Element chartDataContainer) {
        super(chartDataContainer);
        for (Element vizDataSetElement : this.selectNodes("vizDataSet")) {
            this._vizDataSets.add(new V5VizDataSet(vizDataSetElement));
        }
    }

    public void setSize(String width, String height) {
        this.setVizPropertyIntegerValue("width", width);
        this.setVizPropertyIntegerValue("height", height);
    }

    @Override
    public Element getChartElement() {
        return this._container;
    }

    private void setVizPropertyIntegerValue(String propName, String propValue) {
        Element existingProp = this.selectSingleNode("//V5X//CHILD", "vizPropertyValues", "vizPropertyIntegerValue", "//V5X//ATTR", "name", propName);
        if (propValue == null) {
            if (existingProp != null) {
                Element parentPropertyValues = existingProp.getParent();
                existingProp.detach();
                if (parentPropertyValues.elements().size() == 0) {
                    parentPropertyValues.detach();
                }
            }
        } else {
            if (existingProp == null) {
                existingProp = DocumentHelper.makeElement((Branch)this._container, (String)"vizPropertyValues").addElement("vizPropertyIntegerValue");
                existingProp.addAttribute("name", propName);
            }
            existingProp.setText(propValue.replaceFirst("(?i)px;?", ""));
        }
    }

    @Override
    public List<Element> findPotentialChartSummaryNodes(Element layoutNode, String itemName) {
        Element edgeNode = V5SpecHelper.getAncestor(layoutNode, "vizCategoryEdge");
        if (edgeNode == null) {
            return null;
        }
        return V5X.selectNodes(edgeNode, "vizCategoryDataItem", "//V5X//EXCEPT_ATTR", "refDataItem", itemName);
    }

    @Override
    public void focusFirstDomain() {
        this._focusDataSet = 0;
    }

    @Override
    public boolean focusNextDomain() {
        if (this._focusDataSet < this.getVizDataSetCount() - 1) {
            ++this._focusDataSet;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNextDomain() {
        return this._focusDataSet + 1 < this.getVizDataSetCount();
    }

    public int getVizDataSetCount() {
        return this._vizDataSets.size();
    }

    @Override
    public void removeSortByLabel(String columnName) throws ActionException {
        for (int i = 0; i < this.getVizDataSetCount(); ++i) {
            Element setSorting;
            Element dataItem;
            Element sortList;
            V5VizDataSet vizDataSet = this._vizDataSets.get(i);
            Element nodeMember = vizDataSet.findItem(columnName);
            if (nodeMember != null && (sortList = nodeMember.element("sortList")) != null) {
                sortList.detach();
            }
            if ((dataItem = vizDataSet.getV5Query().findItem(columnName)) == null || (setSorting = dataItem.element("setSorting")) == null || setSorting.elements().size() != 0) continue;
            setSorting.detach();
        }
    }

    @Override
    public String getRefQuery() {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).getRefQuery() : null;
    }

    @Override
    public V5Query getV5Query() {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).getV5Query() : new V5Query();
    }

    @Override
    public List<Element> selectNodesInCurrentDomain(String ... pathElements) {
        Element focusDataSetElement = this.getFocusVizDataSetElement();
        return focusDataSetElement != null ? V5DataContainer.selectNodes(this._container, focusDataSetElement, pathElements) : new ArrayList<Element>();
    }

    Element getFocusVizDataSetElement() {
        if (this._vizDataSets.size() > this._focusDataSet) {
            return this._vizDataSets.get(this._focusDataSet).getVizDataSetElement();
        }
        return null;
    }

    @Override
    public Element getDefaultMeasure() {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).getDefaultMeasure() : null;
    }

    @Override
    public void setChartPalette(Element v5ChartPalette) {
    }

    @Override
    public void applyV2Palettes(List<Element> paletteItemsElements, Element v2_paletteEntriesElement, String v2_paletteEntryName, Element oldPaletteElement) {
    }

    @Override
    public Element findAxis(String refDataItem) {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).findAxis(refDataItem) : null;
    }

    public String getAxisEdgeName(String refDataItem) {
        Element axis = this.findAxis(refDataItem);
        if (axis != null) {
            if ("seriesEdge".equals(axis.attributeValue("refEdge"))) {
                return "series";
            }
            if ("categoriesEdge".equals(axis.attributeValue("refEdge"))) {
                return "categories";
            }
        }
        return null;
    }

    public void suppress(List<SelectedCell> selectedCells) {
    }

    @Override
    public Element findOppositeAxis(String refDataItem) {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).findOppositeAxis(refDataItem) : null;
    }

    @Override
    public List<Element> axisNodeMembers(Element axis) {
        return V5X.selectNodes(axis, "vizCategoryDataItem");
    }

    @Override
    public List<Element> collectNodes() {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).collectNodes() : null;
    }

    @Override
    public List<Element> collectEdgeNodes() {
        return this.selectNodes("vizCategoryDataItem");
    }

    @Override
    public Element findItem(String refDataItem) {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).findItem(refDataItem) : null;
    }

    @Override
    public Element findItemLabelByRDI(String dataItemName) {
        Element item = this.findItem(dataItemName);
        return item != null ? this.findItemLabel(item) : null;
    }

    @Override
    public String getBestItemLabel(Element collectedParent, String rdiName, ActionEnv env, boolean requestLocalizedLabelsIfNeeded) throws ActionException {
        Element labelNode;
        String label = null;
        Element element = labelNode = collectedParent != null ? this.findItemLabel(collectedParent) : this.findItemLabelByRDI(rdiName);
        if (labelNode != null && "vizLabel".equals(labelNode.getName())) {
            Element localizedLabel = V5X.selectSingleNode(labelNode, "//V5X//CHILD", "localizedText", "localeText", "//V5X//ATTR", "locale", env.getLocale());
            label = localizedLabel != null ? localizedLabel.getText() : labelNode.elementText("defaultText");
        }
        return label != null ? label : rdiName;
    }

    @Override
    public Element findItemLabel(Element chartMemberOrMeasure) {
        Element vizLabelNodeParent = chartMemberOrMeasure;
        vizLabelNodeParent = "vizCategoryDataItem".equals(chartMemberOrMeasure.getName()) ? (chartMemberOrMeasure.getParent() == null ? null : chartMemberOrMeasure.getParent().getParent()) : chartMemberOrMeasure;
        Element vizLabelNode = vizLabelNodeParent.element("vizLabel");
        return vizLabelNode == null ? chartMemberOrMeasure : vizLabelNode;
    }

    @Override
    public boolean isLeafNode(Element thisNodeMember) {
        return true;
    }

    @Override
    public Element changeDisplayType(ActionEnv env) throws ActionException {
        return null;
    }

    @Override
    public Collection<Element> getLayoutSortItems() {
        return this._vizDataSets.size() > this._focusDataSet ? this._vizDataSets.get(this._focusDataSet).getLayoutSortItems() : null;
    }

    @Override
    public void setDefaultMeasure(String rdi) {
    }

    @Override
    public void setDataFormatStyleOnDefaultMeasure(Element dataFormat) {
    }

    private String getNodeNameOfDefaultChartMeasure() {
        return "vizDefaultMeasure";
    }

    @Override
    public void removeDefaultMeasure() {
    }

    @Override
    public Element getDefaultMeasureDataFormat() {
        return null;
    }

    private Element convertToCrosstab() {
        return null;
    }

    private void mergeAxes() {
    }

    @Override
    public void swapEdges() {
        if (this._vizDataSets.size() > this._focusDataSet) {
            this._vizDataSets.get(this._focusDataSet).swapEdges();
        }
    }

    @Override
    public List<Element> getNestedLocationWithSameHUN(V5Query v5Query, Element chartNodeMember, String startNodeHUN) throws ActionException {
        if (this._nestedLocationWithSameHUN != null) {
            return this._nestedLocationWithSameHUN;
        }
        this._nestedLocationWithSameHUN = new ArrayList<Element>();
        return this._nestedLocationWithSameHUN;
    }

    public List<Element> collectInnerMostEdgeNodes() {
        return this.selectNodes("vizCategoryLevels", "vizCategoryLevel", "//V5X//FUNCTION", "last", "vizCategoryField", "vizCategoryDataItems", "vizCategoryDataItem");
    }

    public static boolean updateLayoutForBUADrill(Element nodeToDrillOn, ArrayList<DimensionalOperations.DataItemRef> dataItemRefList) {
        if ("vizCategoryDataItem".equals(nodeToDrillOn.getName())) {
            Element parent = nodeToDrillOn.getParent();
            List replaceNodes = XMLUtility.selectNodes(nodeToDrillOn, "../*");
            if (V5VizChart.createNodeUnion(dataItemRefList, parent) != null) {
                if (replaceNodes != null && replaceNodes.size() > 0) {
                    for (Element replaceNode : replaceNodes) {
                        replaceNode.detach();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static List<Element> createNodeUnion(List<DimensionalOperations.DataItemRef> dataItemRefs, Element targetElement) {
        ArrayList<Element> addedNodes = null;
        if (dataItemRefs != null && dataItemRefs.size() > 0) {
            addedNodes = new ArrayList<Element>();
            for (DimensionalOperations.DataItemRef dataItemRef : dataItemRefs) {
                Element newVizCategoryDataItem = targetElement.addElement("vizCategoryDataItem");
                newVizCategoryDataItem.addAttribute("refDataItem", dataItemRef.getRefDataItemName());
                addedNodes.add(newVizCategoryDataItem);
            }
        }
        return addedNodes;
    }

    class V5VizDataSet {
        private Element _vizDataSetElement = null;
        private V5Query _v5Query = null;
        private List<Element> _layoutItems = null;

        V5VizDataSet(Element vizDataSetElement) {
            this._vizDataSetElement = vizDataSetElement;
        }

        protected List<Element> collectNodes() {
            if (this._layoutItems == null) {
                this._layoutItems = V5X.selectNodes(this._vizDataSetElement, "vizCategoryDataItem", "//V5X//OR", "vizValue");
                Element measureItem = this.getDefaultMeasure();
                if (measureItem != null) {
                    this._layoutItems.add(measureItem);
                }
            }
            return this._layoutItems;
        }

        protected Element findAxis(String refDataItem) {
            Element chartNodeMember = V5X.selectSingleNode(this._vizDataSetElement, "vizCategoryDataItem", "//V5X//ATTR", "refDataItem", refDataItem);
            if (chartNodeMember == null) {
                return null;
            }
            Element axisRoot = V5SpecHelper.getAncestor(chartNodeMember, "vizCategoryEdge");
            return axisRoot;
        }

        protected Element findOppositeAxis(String refDataItem) {
            String thisAxisEdgeName = V5VizChart.this.getAxisEdgeName(refDataItem);
            String oppositeAxisEdgeName = null;
            if ("series".equals(thisAxisEdgeName)) {
                oppositeAxisEdgeName = "categories";
            } else if ("categories".equals(thisAxisEdgeName)) {
                oppositeAxisEdgeName = "series";
            }
            if (oppositeAxisEdgeName != null) {
                List<Element> nodes = this.collectNodes();
                for (Element node : nodes) {
                    if (!oppositeAxisEdgeName.equals(V5VizChart.this.getAxisEdgeName(node.attributeValue("refDataItem")))) continue;
                    return this.findAxis(node.attributeValue("refDataItem"));
                }
            }
            return null;
        }

        protected Element findItem(String refDataItem) {
            Element defaultMeasureItem;
            String dataSetXML = this._vizDataSetElement.asXML();
            Element layoutItem = V5X.selectSingleNode(this._vizDataSetElement, "vizCategoryDataItem", "//V5X//OR", "vizValue", "//V5X//ATTR", "refDataItem", refDataItem);
            if (layoutItem == null && (defaultMeasureItem = V5X.selectSingleNode(this._vizDataSetElement, "//V5X//CHILD", "vizDefaultMeasure")) != null && refDataItem.equals(defaultMeasureItem.attributeValue("refDataItem"))) {
                return defaultMeasureItem;
            }
            return layoutItem;
        }

        protected String getRefQuery() {
            return this._vizDataSetElement.attributeValue("refQuery");
        }

        public V5Query getV5Query() {
            if (this._v5Query == null && this.getRefQuery() != null) {
                this._v5Query = new V5Query();
                this._v5Query.focusQuery(this._vizDataSetElement, this.getRefQuery());
            }
            return this._v5Query;
        }

        protected Element getDefaultMeasure() {
            return this._vizDataSetElement.element("vizDefaultMeasure");
        }

        protected Collection<Element> getLayoutSortItems() {
            return V5X.selectNodes(this._vizDataSetElement, "vizCategoryDataItem", "//V5X//CHILD", "sortList", "//V5X//CHILD", "sortItem");
        }

        private Element findVizCategoryDataItems(Element parentVizCategoryEdge, int n) {
            List categoryDataItemsBlocks = V5X.selectNodes(parentVizCategoryEdge, "vizCategoryDataItems");
            if (categoryDataItemsBlocks.size() > n) {
                return (Element)categoryDataItemsBlocks.get(n);
            }
            return null;
        }

        protected Element getVizDataSetElement() {
            return this._vizDataSetElement;
        }

        public void swapEdges() {
            List categoryEdges = V5X.selectNodes(this._vizDataSetElement, "vizCategoryEdge");
            if (categoryEdges != null && categoryEdges.size() > 0) {
                Element swap1Edge = null;
                Element vizCategoryDataItems1 = null;
                Element vizCategoryDataItems2 = null;
                for (Element edge : categoryEdges) {
                    if (vizCategoryDataItems1 == null) {
                        vizCategoryDataItems1 = this.findVizCategoryDataItems(edge, 0);
                        swap1Edge = edge;
                        continue;
                    }
                    vizCategoryDataItems2 = this.findVizCategoryDataItems(edge, 0);
                    if (vizCategoryDataItems2 == null) continue;
                    break;
                }
                if (vizCategoryDataItems1 != null) {
                    if (vizCategoryDataItems2 == null) {
                        vizCategoryDataItems2 = this.findVizCategoryDataItems(swap1Edge, 1);
                    }
                    if (vizCategoryDataItems2 != null) {
                        Element swap1Parent = vizCategoryDataItems1.getParent();
                        Element swap2Parent = vizCategoryDataItems2.getParent();
                        Element swap1VizLabel = swap1Parent.element("vizLabel");
                        Element swap2VizLabel = swap2Parent.element("vizLabel");
                        swap1Parent.add(vizCategoryDataItems2.detach());
                        swap2Parent.add(vizCategoryDataItems1.detach());
                        if (swap1VizLabel != null) {
                            swap2Parent.add(swap1VizLabel.detach());
                        }
                        if (swap2VizLabel != null) {
                            swap1Parent.add(swap2VizLabel.detach());
                        }
                    }
                }
            }
        }
    }
}

