/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.v5spechelpers;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class V5X {
    public static final String V5X_PATH_PREFIX = "//V5X//";
    public static final String ANY = "//V5X//ANY";
    public static final String CHILD = "//V5X//CHILD";
    public static final String PREDICATE = "//V5X//PREDICATE";
    public static final String ATTR = "//V5X//ATTR";
    public static final String ATTR_UNDEFINED = "//V5X//ATTR_UNDEFINED";
    public static final String ATTR_DEFINED = "//V5X//ATTR_DEFINED";
    public static final String AND = "//V5X//AND";
    public static final String OR = "//V5X//OR";
    public static final String CHILDATTR = "//V5X//CHILDATTR";
    public static final String ANYCHILD = "//V5X//ANYCHILD";
    public static final String SUBSELECT = "//V5X//SUBSELECT";
    public static final String ATTR_STARTSWITH = "//V5X//ATTR_STARTSWITH";
    public static final String EXCEPT_ATTR = "//V5X//EXCEPT_ATTR";
    public static final String PREDICATE_STRING = "string";
    public static final String EXCEPT_TAG = "//V5X//EXCEPT_TAG";
    public static final String EXCEPT_ANCESTOR = "//V5X//EXCEPT_ANCESTOR";
    public static final String ATTR_IFNONEMPTY = "//V5X//ATTR_IFNONEMPTY";
    public static final String FUNCTION = "//V5X//FUNCTION";

    public static String select(String tagName) {
        return ".//*[local-name()='" + tagName + "']";
    }

    public static String selectAllExcept(String tagName, String attrName, String attrValue) {
        return ".//*[not(local-name()='" + tagName + "')]" + V5X.safeAttr(attrName, attrValue);
    }

    public static String select(String tagName, String attrName, String attrValue) {
        return ".//*[local-name()='" + tagName + "']" + V5X.safeAttr(attrName, attrValue);
    }

    public static String subselect(String tagName) {
        return "//*[local-name()='" + tagName + "']";
    }

    public static String subselect(String tagName, String attrName, String attrValue) {
        return "//*[local-name()='" + tagName + "']" + V5X.safeAttr(attrName, attrValue);
    }

    public static String selectImmediateChildren(String tagName) {
        return "./*[local-name()='" + tagName + "']";
    }

    public static String subselectImmediateChildren(String tagName) {
        return "/*[local-name()='" + tagName + "']";
    }

    public static String selectAncestors(String tagName) {
        return "ancestor::*[local-name()='" + tagName + "']";
    }

    public static String selectSelf(String tagName) {
        return "self::*[local-name()='" + tagName + "']";
    }

    public static String selectPrecedingSibling(String tagName) {
        return "preceding-sibling::*[local-name()='" + tagName + "']";
    }

    public static String selectFollowingSibling(String tagName) {
        return "following-sibling::*[local-name()='" + tagName + "']";
    }

    public static String selectDirectParent() {
        return "./parent::*";
    }

    public static String selectByName(String attrValue) {
        return ".//*[@name=" + V5X.safeValue(attrValue) + "]";
    }

    public static String selectByRdi(String attrValue) {
        return ".//*[@refDataItem=" + V5X.safeValue(attrValue) + "]";
    }

    public static String subselectByName(String attrValue) {
        return "//*[@name=" + V5X.safeValue(attrValue) + "]";
    }

    public static String subselectByRdi(String attrValue) {
        return "//*[@refDataItem=" + V5X.safeValue(attrValue) + "]";
    }

    public static String selectIfDefined(String attr) {
        return ".//*[@" + attr + "!='']";
    }

    public static String subselectIfDefined(String attr) {
        return "//*[@" + attr + "!='']";
    }

    public static String selectByAttr(String attrName) {
        return ".//*[@" + attrName + "!='']";
    }

    public static String selectByAttr(String attrName, String attrValue) {
        return ".//*[@" + attrName + "=" + V5X.safeValue(attrValue) + "]";
    }

    public static String selectPath(String ... pathElements) {
        StringBuilder xPath = new StringBuilder();
        int i = -1;
        if (SUBSELECT.equals(pathElements[0])) {
            ++i;
        } else {
            xPath.append(".");
        }
        String separator = "//";
        boolean processingAttr = false;
        while (++i < pathElements.length) {
            if (pathElements[i].startsWith(V5X_PATH_PREFIX)) {
                if (CHILDATTR.equals(pathElements[i])) {
                    xPath.append(separator);
                    xPath.append("*");
                    xPath.append("[@" + pathElements[++i] + "=");
                    xPath.append(V5X.safeValue(pathElements[++i]));
                    xPath.append("]");
                    processingAttr = true;
                    continue;
                }
                if (ATTR.equals(pathElements[i])) {
                    xPath.append("[@" + pathElements[++i] + "=");
                    xPath.append(V5X.safeValue(pathElements[++i]));
                    xPath.append("]");
                    processingAttr = true;
                    continue;
                }
                if (ANYCHILD.equals(pathElements[i])) {
                    xPath.append(separator);
                    xPath.append("*");
                    continue;
                }
                if (CHILD.equals(pathElements[i])) {
                    separator = "/";
                    continue;
                }
                if (PREDICATE.equals(pathElements[i])) {
                    xPath.append("[");
                    xPath.append(pathElements[++i]);
                    xPath.append("()=\"");
                    xPath.append(pathElements[++i]);
                    xPath.append("\"]");
                    continue;
                }
                if (ANY.equals(pathElements[i])) {
                    separator = "//";
                    continue;
                }
                if (AND.equals(pathElements[i]) || OR.equals(pathElements[i])) {
                    xPath.deleteCharAt(xPath.length() - 1);
                    boolean bAddClosingBracket = false;
                    if (xPath.charAt(xPath.length() - 1) == ')') {
                        xPath.deleteCharAt(xPath.length() - 1);
                        bAddClosingBracket = true;
                    }
                    if (AND.equals(pathElements[i])) {
                        xPath.append(" and ");
                    } else {
                        xPath.append(" or ");
                    }
                    if (processingAttr) {
                        xPath.append("@" + pathElements[++i] + "=");
                        xPath.append(V5X.safeValue(pathElements[++i]));
                        if (bAddClosingBracket) {
                            xPath.append(")]");
                            continue;
                        }
                        xPath.append("]");
                        continue;
                    }
                    xPath.append("local-name()='");
                    xPath.append(pathElements[++i]);
                    if (bAddClosingBracket) {
                        xPath.append("')]");
                        continue;
                    }
                    xPath.append("']");
                    continue;
                }
                if (ATTR_DEFINED.equals(pathElements[i])) {
                    xPath.append("[@" + pathElements[++i] + "]");
                    continue;
                }
                if (ATTR_UNDEFINED.equals(pathElements[i])) {
                    xPath.append("[not(@" + pathElements[++i] + ")]");
                    continue;
                }
                if (ATTR_STARTSWITH.equals(pathElements[i])) {
                    xPath.append("[starts-with(@");
                    xPath.append(pathElements[++i] + "," + V5X.safeValue(pathElements[++i]));
                    xPath.append(")]");
                    continue;
                }
                if (EXCEPT_ATTR.equals(pathElements[i])) {
                    xPath.append("[not(@");
                    xPath.append(pathElements[++i] + "=" + V5X.safeValue(pathElements[++i]));
                    xPath.append(")]");
                    continue;
                }
                if (EXCEPT_TAG.equals(pathElements[i])) {
                    xPath.append("[not(local-name()='");
                    xPath.append(pathElements[++i]);
                    xPath.append("')]");
                    continue;
                }
                if (EXCEPT_ANCESTOR.equals(pathElements[i])) {
                    xPath.append("[not(ancestor::*[local-name()='");
                    xPath.append(pathElements[++i]);
                    xPath.append("'])]");
                    continue;
                }
                if (ATTR_IFNONEMPTY.equals(pathElements[i])) {
                    xPath.append("[@");
                    xPath.append(pathElements[++i]);
                    xPath.append("!='']");
                    continue;
                }
                if (FUNCTION.equals(pathElements[i])) {
                    xPath.append("[");
                    xPath.append(pathElements[++i]);
                    xPath.append("()]");
                    continue;
                }
                return null;
            }
            processingAttr = false;
            xPath.append(separator);
            xPath.append("*[local-name()='");
            xPath.append(pathElements[i]);
            xPath.append("']");
        }
        return xPath.toString();
    }

    public static List selectNodes(Document doc, String ... pathElements) {
        return V5X.selectNodes(doc.getRootElement(), pathElements);
    }

    public static List selectNodes(Element e, String ... pathElements) {
        String path = V5X.selectPath(pathElements);
        return e == null ? null : e.selectNodes(path);
    }

    public static Element selectSingleNode(Document doc, String ... pathElements) {
        return V5X.selectSingleNode(doc.getRootElement(), pathElements);
    }

    public static Element selectSingleNode(Element e, String ... pathElements) {
        return e == null ? null : (Element)e.selectSingleNode(V5X.selectPath(pathElements));
    }

    public static String safeAttr(String attrName, String attrValue) {
        return "[@" + attrName + "=" + V5X.safeValue(attrValue) + "]";
    }

    public static String safeValue(String input) {
        if (input == null || input.indexOf(39) == -1) {
            return '\'' + input + '\'';
        }
        if (input.length() == 1) {
            return "\"'\"";
        }
        StringBuilder result = new StringBuilder("concat(");
        String[] fragments = input.split("'");
        for (int i = 0; i < fragments.length; ++i) {
            if (i == 0 && fragments[i].length() == 0) {
                result.append("\"'\",");
                continue;
            }
            result.append('\'');
            result.append(fragments[i]);
            result.append('\'');
            if (i >= fragments.length - 1) continue;
            result.append(",\"'\",");
        }
        if ('\'' == input.charAt(input.length() - 1)) {
            result.append(",\"'\"");
        }
        result.append(')');
        return result.toString();
    }

    public static String selectStartsWithName(String tagName) {
        return ".//*[starts-with(local-name(), '" + tagName + "')]";
    }

    public static String selectContainsName(String tagName) {
        return ".//*[contains(local-name(), '" + tagName + "')]";
    }

    public static String getMakeElementPath(String ... elementNames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elementNames.length; ++i) {
            sb.append("/");
            sb.append(elementNames[i]);
        }
        return sb.substring(1);
    }
}

