/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.utility.RAPLogger;
import com.ibm.aurora.v5viscoach.V5VisCoach;
import com.ibm.aurora.visCoach.core.IVariationsInitializationHandle;
import com.ibm.aurora.visCoach.core.TemplateGroupRec;
import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.output.OutputManager;
import com.ibm.aurora.visCoach.core.output.VariationGroupRec;
import com.ibm.aurora.visCoach.core.output.variationMatchRec;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.dom4j.Element;

public class RecommenderInfo {
    private V5VisCoach _v5VisCoach = null;
    private Element _actionArgs = null;
    private String _locale = null;
    private IVariationsInitializationHandle _v5VisCoachHandle = null;
    private OutputManager _outputManager = null;

    public RecommenderInfo(IVariationsInitializationHandle v5VisCoachHandle, OutputManager outputManager, V5VisCoach v5VisCoach, Element actionArgs, String locale) {
        this._v5VisCoachHandle = v5VisCoachHandle;
        this._outputManager = outputManager;
        this._actionArgs = actionArgs;
        this._locale = locale;
        this._v5VisCoach = v5VisCoach;
    }

    public String generateJSONDisplayTypes() {
        JSONArray recommendedDisplayTypes = new JSONArray();
        if (this.getDisplayGroupId() == null) {
            try {
                List visTypeGroupeRecs = this._v5VisCoach.getRankedTemplateGroups(this._v5VisCoachHandle, this._locale);
                for (TemplateGroupRec visTypeGroupRec : visTypeGroupeRecs) {
                    recommendedDisplayTypes.add((Object)this.buildJSONVariationGroups(visTypeGroupRec));
                }
            }
            catch (VisCoachException vce) {
                RAPLogger.error(vce, RecommenderInfo.class);
            }
        }
        return recommendedDisplayTypes.toString();
    }

    private JSONObject buildJSONVariationGroups(TemplateGroupRec visTypeGroupRec) {
        JSONObject variationGroups = new JSONObject();
        if (visTypeGroupRec != null) {
            variationGroups.put((Object)"name", (Object)visTypeGroupRec.name);
            variationGroups.put((Object)"title", visTypeGroupRec.properties.get("label"));
            variationGroups.put((Object)"groupId", (Object)visTypeGroupRec.name);
            variationGroups.put((Object)"templateId", (Object)visTypeGroupRec.bestMatchInGroup.templateId);
            variationGroups.put((Object)"iconClass", visTypeGroupRec.properties.get("iconClass"));
        }
        return variationGroups;
    }

    public String generateJSONDisplayVariations() {
        JSONArray variationGroupsArr = new JSONArray();
        try {
            List v5Variations = this._v5VisCoach.getVariationsFromGroup(this._v5VisCoachHandle, this._outputManager, this.getDisplayGroupId(), this._locale);
            for (VariationGroupRec v5Variation : v5Variations) {
                JSONObject variationGroupsObj = new JSONObject();
                JSONArray fielsdArr = new JSONArray();
                for (String fieldName : v5Variation.fields) {
                    fielsdArr.add((Object)fieldName);
                }
                variationGroupsObj.put((Object)"fields", (Object)fielsdArr);
                JSONArray variationArr = new JSONArray();
                for (variationMatchRec variation : v5Variation.variations) {
                    JSONObject variationObj = new JSONObject();
                    JSONObject scoreObj = new JSONObject();
                    scoreObj.put((Object)"value", (Object)String.valueOf(variation.score));
                    JSONArray scoreDescArray = new JSONArray();
                    scoreObj.put((Object)"descriptions", (Object)scoreDescArray);
                    for (String description : variation.scoreDescriptions) {
                        scoreDescArray.add((Object)description);
                    }
                    variationObj.put((Object)"score", (Object)scoreObj);
                    JSONArray fieldValuesArray = new JSONArray();
                    for (String fieldValue : variation.fieldValues) {
                        fieldValuesArray.add((Object)fieldValue);
                    }
                    variationObj.put((Object)"fieldValues", (Object)fieldValuesArray);
                    variationObj.put((Object)"variationId", (Object)variation.variationId);
                    variationObj.put((Object)"templateId", (Object)variation.templateId);
                    variationArr.add((Object)variationObj);
                }
                variationGroupsObj.put((Object)"variations", (Object)variationArr);
                variationGroupsObj.put((Object)"title", v5Variation.properties.get("title"));
                variationGroupsObj.put((Object)"name", (Object)v5Variation.name);
                variationGroupsObj.put((Object)"icon", v5Variation.properties.get("icon"));
                variationGroupsArr.add((Object)variationGroupsObj);
            }
        }
        catch (VisCoachException vce) {
            RAPLogger.error(vce, RecommenderInfo.class);
        }
        return variationGroupsArr.toString();
    }

    private String getDisplayGroupId() {
        String groupId = this._actionArgs.elementText("groupId");
        if (groupId == null || groupId.compareTo("undefined") == 0 || groupId.compareTo("") == 0) {
            return null;
        }
        return groupId;
    }
}

