/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.viscoachhelpers.ViewerRAREProviderFactory;
import com.cognos.rap.actions.viscoachhelpers.ViewerVisualizationEntry;
import com.cognos.rap.actions.viscoachhelpers.VisCoachModeUtil;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IRAREProvider;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.RAREPerProviderSingletonFixture;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.vcv5lib.VCV5Lib;
import com.ibm.aurora.rare.vcv5lib.output.V5OutputManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class RecommenderInfoV2 {
    private Element _actionArgs = null;
    private IVariationsInitializationHandle _v5VisCoachHandle = null;
    private V5OutputManager v5OutputManager = null;
    private int visCoachMode = 3;

    public RecommenderInfoV2(IVariationsInitializationHandle v5VisCoachHandle, V5OutputManager v5OutputManager, VCV5Lib vcv5Lib, Element actionArgs, String locale, int visCoachMode) {
        this._v5VisCoachHandle = v5VisCoachHandle;
        this._actionArgs = actionArgs;
        this.v5OutputManager = v5OutputManager;
        this.visCoachMode = visCoachMode;
    }

    public IRAREProvider getIRAREProvider() {
        return ViewerRAREProviderFactory.getRAREProvider(VisCoachModeUtil.getVisCoachMode(this.visCoachMode));
    }

    public String generateJSONDisplayTypes() {
        JSONArray recommendedDisplayTypes = new JSONArray();
        if (this.getDisplayGroupId() == null) {
            try {
                IRARE rareObj = RAREPerProviderSingletonFixture.getRare((IRAREProvider)this.getIRAREProvider());
                List rankedVisualizationTypes = rareObj.getRanked(this._v5VisCoachHandle, "vistype", null, null, false);
                HashSet<String> usedGroups = new HashSet<String>();
                for (IClassificationEntry rankedVisualizationType : rankedVisualizationTypes) {
                    JSONObject variationGroups = this.buildJSONVariationGroups(rareObj, rankedVisualizationType, usedGroups);
                    if (variationGroups.size() <= 0) continue;
                    recommendedDisplayTypes.add((Object)variationGroups);
                }
            }
            catch (Exception e) {
                RAPLogger.error(e, RecommenderInfoV2.class);
                e.printStackTrace();
            }
        }
        return recommendedDisplayTypes.toString();
    }

    private JSONObject buildJSONVariationGroups(IRARE rareObj, IClassificationEntry rankedVisType, Set<String> usedGroups) {
        JSONObject variationGroups = new JSONObject();
        if (rankedVisType != null) {
            try {
                IClassificationEntry rankedVisualization;
                Set groupName;
                Map<String, Set<String>> visTypeMap = RecommenderInfoV2.getVisTypeMap(rankedVisType);
                List rankedVisualizations = rareObj.getRanked(this._v5VisCoachHandle, "visualization", visTypeMap, null, false);
                if (!rankedVisualizations.isEmpty() && !usedGroups.contains(RecommenderInfoV2.getSingleStringValue(groupName = (Set)(rankedVisualization = (IClassificationEntry)rankedVisualizations.get(0)).getAttributes().get("group")))) {
                    usedGroups.add(RecommenderInfoV2.getSingleStringValue(groupName));
                    HashMap<String, Set> groupMap = new HashMap<String, Set>();
                    groupMap.put("name", groupName);
                    List groupEntries = rareObj.getRanked(this._v5VisCoachHandle, "group", groupMap, null, false);
                    if (!groupEntries.isEmpty()) {
                        IClassificationEntry groupEntry = (IClassificationEntry)groupEntries.get(0);
                        Map groupAttributes = groupEntry.getAttributes();
                        variationGroups.put((Object)"name", (Object)this.v5OutputManager.localizeString(RecommenderInfoV2.getSingleStringValue((Set)groupAttributes.get("name"))));
                        variationGroups.put((Object)"title", (Object)this.v5OutputManager.localizeString(RecommenderInfoV2.getSingleStringValue((Set)groupAttributes.get("label"))));
                        variationGroups.put((Object)"templateId", (Object)rareObj.serializeCLassificationEntry(rankedVisualization));
                        variationGroups.put((Object)"groupId", (Object)groupEntry.getName());
                        variationGroups.put((Object)"iconClass", (Object)this.v5OutputManager.localizeString(RecommenderInfoV2.getSingleStringValue((Set)groupAttributes.get("iconClass"))));
                    }
                }
            }
            catch (RAREException e) {
                RAPLogger.error(e, RecommenderInfoV2.class);
                e.printStackTrace();
            }
        }
        return variationGroups;
    }

    public static Map<String, Set<String>> getVisTypeMap(IClassificationEntry rankedVisType) {
        HashMap<String, Set<String>> visTypeMap = new HashMap<String, Set<String>>();
        Map rankedVisTypeAttibutes = rankedVisType.getAttributes();
        HashSet<String> visTypeName = new HashSet<String>();
        visTypeName.add(RecommenderInfoV2.getSingleStringValue((Set)rankedVisTypeAttibutes.get("group")));
        visTypeMap.put("group", visTypeName);
        return visTypeMap;
    }

    private static String getSingleStringValue(Set<String> singleElementSet) {
        return singleElementSet.toArray()[0].toString();
    }

    public String generateJSONDisplayVariations() {
        JSONArray variationGroupsArr = new JSONArray();
        try {
            IRARE rareObj = RAREPerProviderSingletonFixture.getRare((IRAREProvider)this.getIRAREProvider());
            HashMap groupMap = new HashMap();
            HashSet<String> groupName = new HashSet<String>();
            groupName.add(this.getDisplayGroupId());
            groupMap.put("group", groupName);
            List rankedVisualizations = rareObj.getRanked(this._v5VisCoachHandle, "visualization", groupMap, null, true);
            ArrayList<ViewerVisualizationEntry> visEntries = new ArrayList<ViewerVisualizationEntry>();
            HashMap<String, ViewerVisualizationEntry> visEntryMap = new HashMap<String, ViewerVisualizationEntry>();
            for (IClassificationEntry rankedVisualization : rankedVisualizations) {
                String groupId = RecommenderInfoV2.getSingleStringValue((Set)rankedVisualization.getAttributes().get("group"));
                if (this.getDisplayGroupId().compareToIgnoreCase(groupId) != 0) continue;
                ViewerVisualizationEntry vVisualizationEntry = new ViewerVisualizationEntry(rankedVisualization, rareObj, this._v5VisCoachHandle);
                if (visEntryMap.containsKey(vVisualizationEntry.getVisualizationEntryName())) {
                    ViewerVisualizationEntry previouslyLoadedVisEntry = (ViewerVisualizationEntry)visEntryMap.get(vVisualizationEntry.getVisualizationEntryName());
                    previouslyLoadedVisEntry.addVariation(rankedVisualization, rareObj, this._v5VisCoachHandle);
                    continue;
                }
                vVisualizationEntry.addVariation(rankedVisualization, rareObj, this._v5VisCoachHandle);
                visEntryMap.put(vVisualizationEntry.getVisualizationEntryName(), vVisualizationEntry);
                visEntries.add(vVisualizationEntry);
            }
            for (ViewerVisualizationEntry vve : visEntries) {
                variationGroupsArr.add((Object)vve.getJSONVariationGroups());
            }
        }
        catch (Exception e) {
            RAPLogger.error(e, RecommenderInfoV2.class);
            e.printStackTrace();
        }
        return variationGroupsArr.toString();
    }

    private String getDisplayGroupId() {
        String groupId = this._actionArgs.elementText("groupId");
        if (groupId == null || groupId.compareTo("undefined") == 0 || groupId.compareTo("") == 0) {
            return null;
        }
        return groupId;
    }
}

