/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.QueryItemPropertyManager;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.viscoachhelpers.SmartMetaDataProcessor;
import com.cognos.rap.actions.viscoachhelpers.ViewerRAREUtility;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.core.model.SimpleDataItem;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.Element;

public class SMDDataItem
extends SimpleDataItem {
    private String m_dataItemName = null;
    private String m_dataItemSemanticName = null;

    SMDDataItem(String dataItemSemanticName, String dataItemName, String localizedDIName, IDataContainer dc) {
        super(dc, localizedDIName);
        this.m_dataItemName = dataItemName;
        this.m_dataItemSemanticName = dataItemSemanticName;
    }

    void populate(QueryItemPropertyManager.ContextSummaryRecord csr, V5Query query, Element dataItemElement, ActionEnv env, boolean isRootNode, boolean hasDIMeasure, String conditionalElementStr) {
        this.addDataItemProperties(query, dataItemElement, env, isRootNode, hasDIMeasure, conditionalElementStr);
        this.setPropertyDataType(query, env, dataItemElement);
        this.collectDataValues(csr, dataItemElement);
    }

    public String getDataItemSemanticName() {
        return this.m_dataItemSemanticName;
    }

    public String getDataItemName() {
        return this.m_dataItemName;
    }

    private void collectDataValues(QueryItemPropertyManager.ContextSummaryRecord csr, Element dataItemElement) {
        if (dataItemElement == null) {
            return;
        }
        IDataType dType = this.getDataType();
        String rdiValue = csr.getCDPropValue("r");
        ArrayList<String> columnValues = csr.getCDValues(this.m_dataItemName, rdiValue);
        for (int i = 0; i < columnValues.size(); ++i) {
            IValue dValue = dType.newValue();
            if (BaseDataType.DOUBLE == dType.getBaseType() && !ViewerRAREUtility.isFakeMeasure(dataItemElement)) {
                ((DoubleValue)dValue).set((double)i);
            } else if (BaseDataType.STRING == dType.getBaseType()) {
                ((StringValue)dValue).set(columnValues.get(i));
            }
            this.addValue(dValue);
        }
    }

    private void setPropertyDataType(V5Query query, ActionEnv env, Element dataItemElement) {
        if (ViewerRAREUtility.isMeasure(query, env, dataItemElement)) {
            this.setDataType((IDataType)DataTypes.getDoubleType());
        } else {
            this.setDataType((IDataType)DataTypes.getStringType((int)255));
        }
    }

    private void addDataItemProperties(V5Query query, Element dataItemElement, ActionEnv env, boolean isRootNode, boolean hasDIMeasure, String conditionalElementStr) {
        if (isRootNode) {
            this.addPropertyHasMeasure(hasDIMeasure);
            this.addPropertyIsEdge(true);
        } else {
            this.addPropertyIsEdge(false);
        }
        if (ViewerRAREUtility.isMeasure(query, env, dataItemElement)) {
            this.addPropertyIsMeasure(true);
        } else {
            this.addPropertyIsMeasure(false);
        }
        if (conditionalElementStr != null) {
            this.addPropertyConditionalElementStr(conditionalElementStr);
        }
        this.addPropertyQueryName(query);
        this.addPropertySummary(query, env, dataItemElement);
        this.addPropertyNbrCategories(env);
        this.addPropertyLabel();
        this.addPropertyCaption(query, env);
    }

    private void addPropertyConditionalElementStr(String conditionalElementStr) {
        StringValue conditionalElementStrValue = new StringValue();
        conditionalElementStrValue.set(conditionalElementStr);
        this.setProperty("conditionalElementStr", (IValue)conditionalElementStrValue);
    }

    public void addPropertyIsMeasure(boolean isMeasure) {
        BooleanValue valueIsMeasure = new BooleanValue();
        valueIsMeasure.set(isMeasure);
        this.setProperty("isMeasure", (IValue)valueIsMeasure);
    }

    private void addPropertyIsEdge(boolean isEdge) {
        BooleanValue valueIsEdge = new BooleanValue();
        valueIsEdge.set(isEdge);
        this.setProperty("isEdge", (IValue)valueIsEdge);
    }

    private void addPropertyHasMeasure(boolean hasDIMeasure) {
        BooleanValue valueHasMeasure = new BooleanValue();
        valueHasMeasure.set(hasDIMeasure);
        this.setProperty("hasMeasure", (IValue)valueHasMeasure);
    }

    private void addPropertyQueryName(V5Query query) {
        StringValue valueQuery = new StringValue();
        valueQuery.set(query.getQueryName());
        this.setProperty("queryName", (IValue)valueQuery);
    }

    private void addPropertySummary(V5Query query, ActionEnv env, Element dataItemElement) {
        BooleanValue isSummary = new BooleanValue();
        if (dataItemElement == null) {
            return;
        }
        if (ViewerRAREUtility.isSummary(query, env, dataItemElement)) {
            isSummary.set(true);
        } else {
            isSummary.set(false);
        }
        this.setProperty("isSummary", (IValue)isSummary);
    }

    private void addPropertyNbrCategories(ActionEnv env) {
        IntegerValue numCategories = new IntegerValue();
        JSONObject dataItemInfo = this.getDataItemInfo(env.getActionArg("di"));
        if (dataItemInfo == null) {
            numCategories.set(0);
        } else {
            Object diObjCount = dataItemInfo.get((Object)this.m_dataItemName);
            if (diObjCount == null) {
                numCategories.set(0);
            } else {
                numCategories.set(Integer.parseInt(diObjCount.toString()));
            }
        }
        this.setProperty("numCategories", (IValue)numCategories);
    }

    public void updatePropertyNbrCategories(int nbrCat) {
        IntegerValue numCategories = new IntegerValue();
        numCategories.set(nbrCat);
        this.setProperty("numCategories", (IValue)numCategories);
    }

    private void addPropertyCaption(V5Query query, ActionEnv env) {
        try {
            StringValue sCaption = new StringValue();
            sCaption.set(query.getBestItemLabel(this.m_dataItemName, env, true));
            this.setProperty("caption", (IValue)sCaption);
        }
        catch (ActionException e) {
            RAPLogger.error(e, SmartMetaDataProcessor.class);
        }
    }

    private void addPropertyLabel() {
        StringValue sLabel = new StringValue();
        sLabel.set(this.m_dataItemName);
        this.setProperty("label", (IValue)sLabel);
    }

    private JSONObject getDataItemInfo(String dataItemInfo) {
        if (dataItemInfo == null) {
            return null;
        }
        try {
            return JSONObject.parse((String)dataItemInfo);
        }
        catch (IOException e) {
            RAPLogger.error(e, SmartMetaDataProcessor.class);
            return null;
        }
    }
}

