/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.QueryItemPropertyManager;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.actions.viscoachhelpers.SMDDataItem;
import com.cognos.rap.actions.viscoachhelpers.SmartMetaDataProcessor;
import com.cognos.rap.actions.viscoachhelpers.ViewerRAREUtility;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.cognos.aurora.api.model.ECardinality;
import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class SMDDataItemLoader {
    private V5Query m_query = null;
    private ActionEnv m_env = null;
    private IDataContainer m_dc = null;
    private boolean m_hasUnionEdge = false;
    private IAssociativeModel m_model = null;
    private V5DataContainer m_v5Container = null;
    private QueryItemPropertyManager m_queryItemPropertyManager = null;
    private HashSet<String> _addedDataItems = null;
    private Map<String, String> _calcDINameToCalcRefDIName = new HashMap<String, String>();
    private static final String[][] _ChartContainerEdgeElements = new String[][]{{"pieChart", "pies"}, {"pieChart", "pieSlices"}, {"radarChart", "radialClusters"}, {"radarChart", "points"}, {"paretoChart", "paretoBars"}, {"paretoChart", "paretoBarClusters"}, {"marimekkoChart", "marimekkoBars"}, {"marimekkoChart", "marimekkoBarClusters"}, {"scatterChart", "points"}, {"scatterChart", "pointClusters"}, {"winLossChart", "winLossBars"}, {"threeDCombinationChart", "threeDCombinationChartTypes", "threeDBar"}, {"threeDCombinationChart", "threeDCombinationChartTypes", "threeDLine"}, {"threeDCombinationChart", "threeDCombinationChartTypes", "threeDArea"}, {"threeDCombinationChart", "commonClusters"}, {"gaugeChart", "gauges"}, {"gaugeChart", "indicators"}, {"progressiveChart", "progressiveBars"}, {"bubbleChart", "points"}, {"bubbleChart", "pointClusters"}, {"polarChart", "points"}, {"polarChart", "pointClusters"}, {"threeDScatterChart", "points"}, {"threeDScatterChart", "pointClusters"}, {"combinationChart", "combinationChartTypes", "bar"}, {"combinationChart", "combinationChartTypes", "line"}, {"combinationChart", "combinationChartTypes", "area"}, {"combinationChart", "commonClusters"}, {"metricsChart", "combinationChartTypes", "bar"}, {"metricsChart", "combinationChartTypes", "line"}, {"metricsChart", "combinationChartTypes", "area"}, {"metricsChart", "commonClusters"}, {"v2_combinationChart", "v2_commonAxis"}, {"v2_combinationChart", "v2_topLeftAxis", "v2_combinationChartTypes", "v2_bar"}, {"v2_combinationChart", "v2_topLeftAxis", "v2_combinationChartTypes", "v2_line"}, {"v2_combinationChart", "v2_topLeftAxis", "v2_combinationChartTypes", "v2_area"}, {"v2_combinationChart", "v2_topRightAxis", "v2_combinationChartTypes", "v2_bar"}, {"v2_combinationChart", "v2_topRightAxis", "v2_combinationChartTypes", "v2_line"}, {"v2_combinationChart", "v2_topRightAxis", "v2_combinationChartTypes", "v2_area"}, {"v2_combinationChart", "v2_bottomLeftAxis", "v2_combinationChartTypes", "v2_bar"}, {"v2_combinationChart", "v2_bottomLeftAxis", "v2_combinationChartTypes", "v2_line"}, {"v2_combinationChart", "v2_bottomLeftAxis", "v2_combinationChartTypes", "v2_area"}, {"v2_combinationChart", "v2_bottomRightAxis", "v2_combinationChartTypes", "v2_bar"}, {"v2_combinationChart", "v2_bottomRightAxis", "v2_combinationChartTypes", "v2_line"}, {"v2_combinationChart", "v2_bottomRightAxis", "v2_combinationChartTypes", "v2_area"}, {"v2_scatterChart", "v2_category"}, {"v2_scatterChart", "v2_series"}, {"v2_pieChart", "v2_pieSlices"}, {"v2_pieChart", "v2_category"}, {"v2_gaugeChart", "v2_category"}, {"v2_gaugeChart", "v2_gaugeAxes", "v2_gaugeAxis", "v2_gaugeNeedle"}, {"v2_bubbleChart", "v2_category"}, {"v2_bubbleChart", "v2_series"}, {"v2_paretoChart", "v2_paretoBars"}, {"v2_paretoChart", "v2_commonAxis"}, {"v2_progressiveChart", "v2_progressiveAxis"}, {"v2_progressiveChart", "v2_series"}, {"v2_bulletChart", "v2_category"}, {"v2_bulletChart", "v2_series"}};

    public SMDDataItemLoader(IAssociativeModel model, V5DataContainer container, ActionEnv env) {
        this.m_env = env;
        this.m_v5Container = container;
        this.m_model = model;
        this.m_dc = model.getRootContainer();
        this.m_query = this.m_v5Container.getV5Query();
        this.m_hasUnionEdge = this.hasUnionEdge();
        this.m_queryItemPropertyManager = this.getQueryItemPropertyManager();
    }

    public IDataContainer run() {
        this._addedDataItems = new HashSet();
        if (this.hasDataItemHierarchyInfo()) {
            this.loadDataItemsAsRegularHierarchy(null);
        } else if (this.isCrosstab()) {
            this.loadCrosstabDataItems();
        } else if (this.isChart()) {
            this.loadChartDataItems();
        } else {
            this.loadDataItemsAsRegularHierarchy(null);
        }
        return this.m_dc;
    }

    public void loadChartDataItems() {
        if (this.m_hasUnionEdge) {
            Element containerElement = this.m_v5Container.getContainerElement();
            if (containerElement != null) {
                for (int i = 0; i < _ChartContainerEdgeElements.length; ++i) {
                    this.loadChartDataAxis(containerElement, _ChartContainerEdgeElements[i]);
                }
            }
            this.addDefaultMeasureNode();
        } else {
            this.loadDataItemsAsRegularHierarchy(null);
        }
    }

    private void loadChartDataAxis(Element containerElement, String[] elementNames) {
        Element currentElement = this.getElementFromElementPath(containerElement, elementNames);
        if (currentElement == null) {
            return;
        }
        Element chartNodesElement = currentElement.element("chartNodes");
        List<Element> chartNodeElements = this.getImmediateChildren(chartNodesElement, "chartNode");
        Collection<Element> diElements = this.getDataItemElements(currentElement, "chartNodeMember");
        boolean isAllCalcRefResolved = this.mapCalcDataItems(diElements);
        if (this.hasUnionEdgeInNodeElement(chartNodeElements) || !isAllCalcRefResolved) {
            INode rootNode = this.createRootEdgeDataItem(chartNodesElement);
            this.loadDataItemsAsEdge(rootNode, chartNodeElements);
        } else {
            this.loadDataItemsAsRegularHierarchy(diElements);
        }
    }

    public void loadCrosstabDataItems() {
        Element crosstabColumnsNodeElement;
        Element containerElement = this.m_v5Container.getContainerElement();
        Element crosstabRowsNodeElement = containerElement.element("crosstabRows");
        if (crosstabRowsNodeElement != null) {
            List<Element> crosstabRowsNodeElements = this.getImmediateChildren(crosstabRowsNodeElement, "crosstabNode");
            List layoutElements = V5X.selectNodes(crosstabRowsNodeElement, "crosstabNodeMember");
            boolean isAllCalcRefResolved = this.mapCalcDataItems(layoutElements);
            if (this.hasUnionEdgeInNodeElement(crosstabRowsNodeElements) || !isAllCalcRefResolved) {
                INode rowRootNode = this.createRootEdgeDataItem(crosstabRowsNodeElement);
                this.loadDataItemsAsEdge(rowRootNode, crosstabRowsNodeElements);
            } else {
                this.loadDataItemsAsRegularHierarchy(layoutElements);
            }
        }
        if ((crosstabColumnsNodeElement = containerElement.element("crosstabColumns")) != null) {
            List<Element> crosstabColumnsNodeElements = this.getImmediateChildren(crosstabColumnsNodeElement, "crosstabNode");
            List layoutElements = V5X.selectNodes(crosstabColumnsNodeElement, "crosstabNodeMember");
            boolean isAllCalcRefResolved = this.mapCalcDataItems(layoutElements);
            if (this.hasUnionEdgeInNodeElement(crosstabColumnsNodeElements) || !isAllCalcRefResolved) {
                INode columnRootNode = this.createRootEdgeDataItem(crosstabColumnsNodeElement);
                this.loadDataItemsAsEdge(columnRootNode, crosstabColumnsNodeElements);
            } else {
                this.loadDataItemsAsRegularHierarchy(layoutElements);
            }
        }
        this.addDefaultMeasureNode();
    }

    protected boolean mapCalcDataItems(Collection<Element> dataItemElements) {
        boolean resolved = true;
        HashMap<String, ArrayList<String>> HUNToNonCalcDINamesMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> HUNToCalcDINamesMap = new HashMap<String, ArrayList<String>>();
        if (dataItemElements == null) {
            dataItemElements = this.m_query.getItemList().getDataItemElements();
        }
        for (Element element : dataItemElements) {
            QueryItemPropertyManager.ContextSummaryRecord csr;
            String name;
            Element dataItemElementInQuery = this.getDataItemElementInQuery(element);
            String dataItemName = dataItemElementInQuery.attributeValue("name");
            String dataItemLabel = dataItemElementInQuery.attributeValue("label");
            String string = name = dataItemLabel == null ? dataItemName : dataItemLabel;
            if (dataItemName == null || this.m_v5Container.findItem(dataItemName) == null || (csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), dataItemName)) == null) continue;
            String HUN = csr.getHun();
            if (this.isCalculation(dataItemElementInQuery)) {
                ArrayList<String> calcDINames = (ArrayList<String>)HUNToCalcDINamesMap.get(HUN);
                if (null == calcDINames) {
                    calcDINames = new ArrayList<String>();
                    HUNToCalcDINamesMap.put(HUN, calcDINames);
                }
                calcDINames.add(name);
                continue;
            }
            ArrayList<String> NonCalcDINames = (ArrayList<String>)HUNToNonCalcDINamesMap.get(HUN);
            if (null == NonCalcDINames) {
                NonCalcDINames = new ArrayList<String>();
                HUNToNonCalcDINamesMap.put(HUN, NonCalcDINames);
            }
            NonCalcDINames.add(name);
        }
        for (Map.Entry entry : HUNToCalcDINamesMap.entrySet()) {
            String entryHUN = (String)entry.getKey();
            List calcDINames = (List)entry.getValue();
            List nonCalcDINames = (List)HUNToNonCalcDINamesMap.get(entryHUN);
            if (nonCalcDINames == null || nonCalcDINames.size() != 1) {
                if (!resolved) continue;
                resolved = false;
                continue;
            }
            for (String calcDIName : calcDINames) {
                this._calcDINameToCalcRefDIName.put(calcDIName, (String)nonCalcDINames.get(0));
            }
        }
        return resolved;
    }

    private void addDefaultMeasureNode() {
        String rdiName;
        Element defaultMeasureElement = this.m_v5Container.getDefaultMeasure();
        if (defaultMeasureElement != null && (rdiName = defaultMeasureElement.attributeValue("refDataItem")) != null && !this._addedDataItems.contains(rdiName)) {
            QueryItemPropertyManager.ContextSummaryRecord csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), rdiName);
            this.addDataItem(rdiName, csr, false, false, null);
        }
    }

    private void loadDataItemsAsEdge(INode rootNode, List<Element> xNodeElements) {
        for (Element xNodeElement : xNodeElements) {
            this.loadNodeElement(rootNode, xNodeElement);
        }
    }

    private boolean hasUnionEdge() {
        boolean hasUE = false;
        Element containerElement = this.m_v5Container.getContainerElement();
        if (this.isCrosstab()) {
            hasUE = this.hasUnionEdgeInContainerElement(containerElement, "crosstabRows", "crosstabNode");
            if (!hasUE) {
                hasUE = this.hasUnionEdgeInContainerElement(containerElement, "crosstabColumns", "crosstabNode");
            }
        } else if (this.isChart()) {
            for (int i = 0; i < _ChartContainerEdgeElements.length && !hasUE; ++i) {
                hasUE = hasUE || this.hasUnionEdgeInChart(containerElement, _ChartContainerEdgeElements[i]);
            }
        }
        return hasUE;
    }

    private boolean hasUnionEdgeInChart(Element containerElement, String[] elementNames) {
        Element currentElement = this.getElementFromElementPath(containerElement, elementNames);
        if (currentElement == null) {
            return false;
        }
        return this.hasUnionEdgeInContainerElement(currentElement, "chartNodes", "chartNode");
    }

    private Element getElementFromElementPath(Element root, String[] elementNames) {
        if (root.getName().equals(elementNames[0])) {
            Element currentElement = root;
            for (int i = 1; i < elementNames.length; ++i) {
                if ((currentElement = currentElement.element(elementNames[i])) != null) continue;
                return null;
            }
            return currentElement;
        }
        return null;
    }

    private boolean hasUnionEdgeInContainerElement(Element containerElement, String element1, String element2) {
        List<Element> crosstabRowsNodeElements;
        if (containerElement == null) {
            return false;
        }
        boolean hasUE = false;
        Element crosstabRowsNodeElement = containerElement.element(element1);
        if (crosstabRowsNodeElement != null && this.hasUnionEdgeInNodeElement(crosstabRowsNodeElements = this.getImmediateChildren(crosstabRowsNodeElement, element2))) {
            hasUE = true;
        }
        return hasUE;
    }

    private boolean hasUnionEdgeInNodeElement(List<Element> xNodeList) {
        boolean hasEdge;
        block3: {
            block2: {
                hasEdge = false;
                if (xNodeList.size() <= 1) break block2;
                if (this.nbrOfMeasures(xNodeList) == this.countNodeMembersInNodeList(xNodeList) || !this.hasTwoOrMoreAtomicCategories(xNodeList)) break block3;
                hasEdge = true;
                break block3;
            }
            for (Element xNode : xNodeList) {
                Element xNestedNodesElement;
                List<Element> xSubNodeList;
                if (this.countNodeMembersInNode(xNode) > 1) {
                    hasEdge = true;
                    break;
                }
                List<Element> xNestedNodes = this.getImmediateChildren(xNode, this.isChart() ? "chartNestedNodes" : "crosstabNestedNodes");
                if (xNestedNodes == null || (xSubNodeList = this.getImmediateChildren(xNestedNodesElement = xNestedNodes.get(0), this.isChart() ? "chartNode" : "crosstabNode")) == null || !this.hasUnionEdgeInNodeElement(xSubNodeList)) continue;
                hasEdge = true;
                break;
            }
        }
        return hasEdge;
    }

    private int countNodeMembersInNodeList(List<Element> xNodeList) {
        int numNodeElements = 0;
        for (Element xNode : xNodeList) {
            numNodeElements += this.countNodeMembersInNode(xNode);
        }
        return numNodeElements;
    }

    private int countNodeMembersInNode(Element xNode) {
        List<Element> xNodeMemberList;
        int numNodeElements = 0;
        Element nodeMemberElements = xNode.element(this.isChart() ? "chartNodeMembers" : "crosstabNodeMembers");
        if (nodeMemberElements != null && (xNodeMemberList = this.getImmediateChildren(nodeMemberElements, this.isChart() ? "chartNodeMember" : "crosstabNodeMember")) != null) {
            numNodeElements += xNodeMemberList.size();
        }
        return numNodeElements;
    }

    private boolean hasTwoOrMoreAtomicCategories(List<Element> xNodeList) {
        int nbrOfAtomicCategories = 0;
        for (Element xNodeElement : xNodeList) {
            String xNodeMembersName = this.isCrosstab() ? "crosstabNodeMembers" : "chartNodeMembers";
            Element xNodeMembers = xNodeElement.element(xNodeMembersName);
            String xNodeMemberName = this.isCrosstab() ? "crosstabNodeMember" : "chartNodeMember";
            List xNodeMemberList = xNodeMembers.elements(xNodeMemberName);
            for (Element xNodeMember : xNodeMemberList) {
                Element dataItemElement = this.m_query.findItem(xNodeMember.attributeValue("refDataItem"));
                if (!this.isCalculation(dataItemElement) && !ViewerRAREUtility.isSummary(this.m_query, this.m_env, dataItemElement)) {
                    ++nbrOfAtomicCategories;
                }
                if (nbrOfAtomicCategories <= true) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDataItemHierarchyInfo() {
        boolean missingDIHInfo = true;
        Collection<Element> dataItemElements = this.m_query.getItemList().getDataItemElements();
        for (Element dataItemElement : dataItemElements) {
            String dataItemName = dataItemElement.attributeValue("name");
            QueryItemPropertyManager.ContextSummaryRecord csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), dataItemName);
            if (csr == null || csr.getHun() == null || csr.getFirstMun() == null) continue;
            missingDIHInfo = true;
            break;
        }
        return !missingDIHInfo;
    }

    private INode createRootEdgeDataItem(Element crosstabNodeElement) {
        String rdiName = "";
        QueryItemPropertyManager.ContextSummaryRecord csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), rdiName);
        return this.addDataItem(rdiName, csr, true, this.hasDataItemMeasure(crosstabNodeElement), null);
    }

    private boolean hasDataItemMeasure(Element xNodeElement) {
        boolean hasDataItemMeasure = false;
        String nodeMemberName = this.isCrosstab() ? "crosstabNodeMember" : "chartNodeMember";
        List childElements = V5X.selectNodes(xNodeElement, nodeMemberName);
        for (Element nodeMember : childElements) {
            if (!this.isNumericDataItem(nodeMember.attributeValue("refDataItem"))) continue;
            hasDataItemMeasure = true;
            break;
        }
        return hasDataItemMeasure;
    }

    private int nbrOfMeasures(List<Element> xNodeList) {
        int measureCount = 0;
        for (Element xNodeElement : xNodeList) {
            String xNodeMembersName;
            Element xNodeMembers = xNodeElement.element(xNodeMembersName = this.isCrosstab() ? "crosstabNodeMembers" : "chartNodeMembers");
            if (xNodeMembers == null) {
                return measureCount;
            }
            String xNodeMemberName = this.isCrosstab() ? "crosstabNodeMember" : "chartNodeMember";
            List xNodeMemberList = xNodeMembers.elements(xNodeMemberName);
            for (Element xNodeMember : xNodeMemberList) {
                if (!this.isMeasure(xNodeMember)) continue;
                ++measureCount;
            }
        }
        return measureCount;
    }

    private boolean isMeasure(Element xNodeMember) {
        boolean isMeasure = false;
        if (xNodeMember != null && this.isNumericDataItem(xNodeMember.attributeValue("refDataItem"))) {
            isMeasure = true;
        }
        return isMeasure;
    }

    private boolean isNumericDataItem(String dataItemLabel) {
        try {
            V5QueryItem queryItem = new V5QueryItem(this.m_env, this.m_query, this.m_query.findItem(dataItemLabel));
            return queryItem.confirmIsNumeric() && queryItem.getNumericSubType() != V5QueryItem.NumericSubType.dataValues;
        }
        catch (ActionException ae) {
            RAPLogger.error(ae, SMDDataItem.class);
            return false;
        }
    }

    private List<Element> getImmediateChildren(Element nodeElement, String elementName) {
        ArrayList<Element> childrenElements = new ArrayList<Element>();
        List nodeChildElements = nodeElement.elements();
        for (Element childElement : nodeChildElements) {
            if (childElement.getName().compareTo(elementName) != 0) continue;
            childrenElements.add(childElement);
        }
        return childrenElements.size() > 0 ? childrenElements : null;
    }

    private void loadNodeElement(INode parentNode, Element nodeElement) {
        Element nodeMembersElement = nodeElement.element(this.isChart() ? "chartNodeMembers" : "crosstabNodeMembers");
        if (nodeMembersElement != null) {
            List nodeMemberElements = nodeMembersElement.elements();
            for (Element nodeMemberElement : nodeMemberElements) {
                String conditionalElementStr = this.getConditionalElementString(nodeMemberElement);
                String dataItemLabel = nodeMemberElement.attributeValue("refDataItem");
                QueryItemPropertyManager.ContextSummaryRecord csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), dataItemLabel);
                if (csr == null) continue;
                INode childINode = this.addDataItem(dataItemLabel, csr, false, false, conditionalElementStr);
                this.m_model.createEdge(parentNode, childINode, "", ECardinality.OneMany, true);
                Element nestedNodeElement = nodeElement.element(this.isChart() ? "chartNestedNodes" : "crosstabNestedNodes");
                if (nestedNodeElement == null) continue;
                List<Element> nodeSubElements = this.getImmediateChildren(nestedNodeElement, this.isChart() ? "chartNode" : "crosstabNode");
                for (Element nodeSubElement : nodeSubElements) {
                    this.loadNodeElement(childINode, nodeSubElement);
                }
            }
        }
    }

    private INode addDataItem(String rdiName, QueryItemPropertyManager.ContextSummaryRecord csr, boolean isRootNode, boolean hasDIMeasure, String conditionalElementStr) {
        INode smdINode = null;
        String localizedRDIName = rdiName;
        try {
            localizedRDIName = this.m_query.getBestItemLabel(rdiName, this.m_env, true);
        }
        catch (ActionException e) {
            RAPLogger.error(e, SMDDataItem.class);
        }
        SMDDataItem smdDataItem = new SMDDataItem(rdiName, rdiName, localizedRDIName, this.m_dc);
        Element dataItemElement = this.m_query.findItem(rdiName);
        smdDataItem.populate(csr, this.m_query, dataItemElement, this.m_env, isRootNode, hasDIMeasure, conditionalElementStr);
        if (smdDataItem.getDataType().isNumeric()) {
            Element defaultMeasure = this.m_v5Container.getDefaultMeasure();
            if ((defaultMeasure == null || !defaultMeasure.attributeValue("refDataItem").equals(rdiName)) && this.dataItemHasExpression(rdiName) && this.isMeasureExpressionSafeContainerType()) {
                smdDataItem.updatePropertyNbrCategories(99);
            } else {
                smdDataItem.updatePropertyNbrCategories(1);
            }
        }
        INode conceptNode = null;
        if (smdDataItem.getDataType().isNumeric()) {
            smdINode = this.m_model.createNode(ENodeType.METRIC, this.m_model.getConceptInventory().getGenericMetric(), (IDataItem)smdDataItem, 0.0f);
            conceptNode = this.m_model.createNode(ENodeType.ATTRIBUTE, this.m_model.getConceptInventory().getConcept("cIdentifier"), null, 0.0f);
        } else {
            smdINode = this.m_model.createNode(ENodeType.CATEGORY, this.m_model.getConceptInventory().getGenericCategory(), null, 0.0f);
            conceptNode = this.m_model.createNode(ENodeType.ATTRIBUTE, this.m_model.getConceptInventory().getConcept("cIdentifier"), (IDataItem)smdDataItem, 0.0f);
        }
        this.m_dc.addNode(smdINode);
        this.m_dc.addNode(conceptNode);
        this.m_dc.addDataItem((IDataItem)smdDataItem);
        this.m_model.createEdge(smdINode, conceptNode, "", ECardinality.OneOne, false);
        return smdINode;
    }

    private Collection<Element> getDataItemElements(Element xNodeElement, String nodeMember) {
        if (xNodeElement == null) {
            return null;
        }
        List xNodeMembers = V5X.selectNodes(xNodeElement, nodeMember);
        ArrayList<Element> diElements = new ArrayList<Element>();
        for (Element xNodeMember : xNodeMembers) {
            diElements.add(this.m_query.getItemList().findItem(xNodeMember.attributeValue("refDataItem")));
        }
        return diElements;
    }

    private String getConditionalElementString(Element dataItemElement) {
        String conditionalElementStr = null;
        Element conditionalElement = V5X.selectSingleNode(dataItemElement, "conditionalDataSources");
        if (conditionalElement != null) {
            conditionalElementStr = conditionalElement.asXML().replaceAll(" xmlns=\"[^\"]*\"", "");
        }
        return conditionalElementStr;
    }

    private void loadDataItemsAsRegularHierarchy(Collection<Element> dataItemElements) {
        if (dataItemElements == null) {
            dataItemElements = this.m_query.getItemList().getDataItemElements();
        }
        HashMap<String, String> diHUNAndCatNodeIDMap = new HashMap<String, String>();
        HashMap<String, String> diHUNAndConceptNodeIdMap = new HashMap<String, String>();
        for (Element dataItemElement : dataItemElements) {
            QueryItemPropertyManager.ContextSummaryRecord csr;
            String conditionalElementStr = this.getConditionalElementString(dataItemElement);
            Element dataItemElementInQuery = this.getDataItemElementInQuery(dataItemElement);
            String dataItemName = dataItemElementInQuery.attributeValue("name");
            if (dataItemName == null || this.m_v5Container.findItem(dataItemName) == null || (csr = this.m_queryItemPropertyManager.getContextSummaryRecord(this.m_query.getQueryName(), dataItemName)) == null || this._addedDataItems.contains(dataItemName)) continue;
            this.loadDataItemForDecoration(diHUNAndCatNodeIDMap, diHUNAndConceptNodeIdMap, dataItemElementInQuery, dataItemName, csr, conditionalElementStr);
            this._addedDataItems.add(dataItemName);
        }
    }

    private Element getDataItemElementInQuery(Element dataItemElement) {
        Element dataItemElementInQuery = dataItemElement;
        String refDIName = dataItemElement.attributeValue("refDataItem");
        if (refDIName != null) {
            dataItemElementInQuery = this.m_query.findItem(refDIName);
        }
        return dataItemElementInQuery;
    }

    private void loadDataItemForDecoration(Map<String, String> diHUNAndCatNodeIDMap, Map<String, String> diHUNAndConceptNodeIdMap, Element dataItemElement, String dataItemName, QueryItemPropertyManager.ContextSummaryRecord csr, String conditionalElementStr) {
        String sDataItemSemanticName = this.getMemberNameFromMUN(csr);
        if (sDataItemSemanticName == null || sDataItemSemanticName.isEmpty()) {
            sDataItemSemanticName = dataItemName;
        }
        String localizedRDIName = dataItemName;
        try {
            localizedRDIName = this.m_query.getBestItemLabel(dataItemName, this.m_env, true);
        }
        catch (ActionException e) {
            RAPLogger.error(e, SMDDataItem.class);
        }
        SMDDataItem smdDataItem = new SMDDataItem(sDataItemSemanticName, dataItemName, localizedRDIName, this.m_dc);
        smdDataItem.populate(csr, this.m_query, dataItemElement, this.m_env, false, false, conditionalElementStr);
        if (smdDataItem.getDataType().isNumeric()) {
            Element defaultMeasure = this.m_v5Container.getDefaultMeasure();
            if (this.isCalculation(dataItemElement)) {
                String calcRef = this._calcDINameToCalcRefDIName.get(dataItemName);
                StringValue valueCalcRef = new StringValue();
                valueCalcRef.set(calcRef);
                smdDataItem.setProperty("calcRef", (IValue)valueCalcRef);
            } else if ((defaultMeasure == null || !defaultMeasure.attributeValue("refDataItem").equals(dataItemName)) && this.dataItemHasExpression(dataItemName) && this.isMeasureExpressionSafeContainerType()) {
                smdDataItem.updatePropertyNbrCategories(99);
            } else {
                smdDataItem.updatePropertyNbrCategories(1);
            }
        }
        INode categoryNode = null;
        INode conceptNode = null;
        if (smdDataItem.getDataType().isNumeric()) {
            categoryNode = this.m_model.createNode(ENodeType.METRIC, this.m_model.getConceptInventory().getGenericMetric(), (IDataItem)smdDataItem, 0.0f);
            conceptNode = this.m_model.createNode(ENodeType.ATTRIBUTE, this.m_model.getConceptInventory().getConcept("cIdentifier"), null, 0.0f);
        } else {
            categoryNode = this.m_model.createNode(ENodeType.CATEGORY, this.m_model.getConceptInventory().getGenericCategory(), null, 0.0f);
            conceptNode = this.m_model.createNode(ENodeType.ATTRIBUTE, this.m_model.getConceptInventory().getConcept("cIdentifier"), (IDataItem)smdDataItem, 0.0f);
        }
        this.m_dc.addNode(categoryNode);
        this.m_dc.addNode(conceptNode);
        this.m_dc.addDataItem((IDataItem)smdDataItem);
        this.m_model.createEdge(categoryNode, conceptNode, "", ECardinality.OneOne, false);
        if (csr.getHun() != null) {
            if (diHUNAndConceptNodeIdMap.containsKey(csr.getHun()) && !smdDataItem.getDataType().isNumeric()) {
                INode conceptNodeContainingDIWithSameHUN = this.m_model.findNode(diHUNAndConceptNodeIdMap.get(csr.getHun()));
                INode categoryNodeOfDIWithSameHUN = this.m_model.findNode(diHUNAndCatNodeIDMap.get(csr.getHun()));
                if (conceptNode.getDataItem().getProperty("numCategories").intValue() < conceptNodeContainingDIWithSameHUN.getDataItem().getProperty("numCategories").intValue()) {
                    this.m_model.createEdge(categoryNode, categoryNodeOfDIWithSameHUN, "", ECardinality.OneMany, true);
                } else {
                    this.m_model.createEdge(categoryNodeOfDIWithSameHUN, categoryNode, "", ECardinality.OneMany, true);
                }
            }
            diHUNAndConceptNodeIdMap.put(csr.getHun(), conceptNode.getId());
            diHUNAndCatNodeIDMap.put(csr.getHun(), categoryNode.getId());
        }
    }

    private boolean dataItemHasExpression(String dataItem) {
        Element expressionElement;
        boolean hasExpression = false;
        Element dataItemElemInQuery = this.m_query.findItem(dataItem);
        if (dataItemElemInQuery != null && (expressionElement = dataItemElemInQuery.element("expression")) != null) {
            String expression = expressionElement.getText();
            if (expression.startsWith("[") && !expression.contains("],[")) {
                if (!expression.contains("].[")) {
                    hasExpression = this.dataItemHasExpression(expression.substring(1, expression.indexOf(93)));
                }
            } else {
                hasExpression = true;
            }
        }
        return hasExpression;
    }

    private boolean isCalculation(Element dataItemElement) {
        return dataItemElement.getName().compareTo("dataItemCalculatedMember") == 0 || dataItemElement.attributeValue("aggregate") != null && dataItemElement.attributeValue("aggregate").compareTo("calculated") == 0;
    }

    private String getMemberNameFromMUN(QueryItemPropertyManager.ContextSummaryRecord csr) {
        int squareBraketIdx;
        String sMemberName = csr.getFirstMun();
        if (sMemberName == null) {
            return null;
        }
        int arrowIdx = sMemberName.indexOf("->:");
        if (arrowIdx >= 0) {
            sMemberName = sMemberName.substring(0, arrowIdx);
        }
        if ((squareBraketIdx = sMemberName.lastIndexOf(91) + 1) > 1) {
            sMemberName = sMemberName.substring(sMemberName.lastIndexOf(91) + 1);
        }
        if ((squareBraketIdx = sMemberName.indexOf(93)) > 1) {
            sMemberName = sMemberName.substring(0, squareBraketIdx);
        }
        return sMemberName;
    }

    private QueryItemPropertyManager getQueryItemPropertyManager() {
        QueryItemPropertyManager queryItemPropertyManager = new QueryItemPropertyManager(this.m_env, this.m_query);
        try {
            queryItemPropertyManager.apply(false);
        }
        catch (ActionException ae) {
            RAPLogger.error(ae, SmartMetaDataProcessor.class);
        }
        return queryItemPropertyManager;
    }

    private boolean isChart() {
        return this.m_v5Container.getContainerElement().getName().contains("Chart");
    }

    private boolean isCrosstab() {
        return this.m_v5Container.getContainerElement().getName().startsWith("crosstab");
    }

    private boolean isMeasureExpressionSafeContainerType() {
        return this.isCrosstab() || this.isChart() && !this.m_v5Container.getContainerElement().getName().contains("scatter") && !this.m_v5Container.getContainerElement().getName().contains("bubble");
    }
}

