/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.V5DataContainer;
import com.cognos.rap.actions.viscoachhelpers.SMDDataItemLoader;
import com.cognos.rap.actions.viscoachhelpers.SMDLoader;
import com.cognos.rap.actions.viscoachhelpers.VisCoachModelTransformer;
import com.cognos.rap.utility.RAPLogger;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.dom4j.Document;

public class SmartMetaDataProcessor {
    protected IAssociativeModel m_model = null;
    protected ActionEnv m_cachedEnv = null;
    protected String m_cachedSMDModelStr = null;
    protected V5DataContainer m_cachedContainer = null;
    protected boolean m_debugEnabled = false;

    public SmartMetaDataProcessor(boolean debugEnabled) {
        this.m_debugEnabled = debugEnabled;
        this.getSMDInst();
    }

    public ISmartMetadata getSMDInst() {
        return SMDLoader.getSMD();
    }

    public IAssociativeModel getModel() {
        return this.m_model;
    }

    public String run(V5DataContainer container, ActionEnv env) {
        if (this.m_cachedContainer == container && this.m_cachedEnv == env && this.m_cachedSMDModelStr != null) {
            return this.m_cachedSMDModelStr;
        }
        this.populateSMDDataContainer(container, env);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("CONTENT_LOCALE_NAME", env.getLocale());
        Document activities = SMDLoader.getSMD().decorate(this.m_model, params);
        VisCoachModelTransformer vmt = new VisCoachModelTransformer(this.m_model);
        String smdModelStr = vmt.process().asXML();
        if (this.m_debugEnabled) {
            this.dump(activities.asXML(), "smdActivities.xml");
            this.dump(smdModelStr, "smdOutput.xml");
        }
        this.m_cachedContainer = container;
        this.m_cachedEnv = env;
        this.m_cachedSMDModelStr = smdModelStr;
        return smdModelStr;
    }

    public IDataContainer populateSMDDataContainer(V5DataContainer container, ActionEnv env) {
        this.m_model = SMDLoader.getSMD().createModel();
        SMDDataItemLoader smdDataItemLoader = new SMDDataItemLoader(this.m_model, container, env);
        return smdDataItemLoader.run();
    }

    public void dump(String smdModel, String fileName) {
        BufferedWriter out = null;
        try {
            OutputStreamWriter ostream = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF8");
            out = new BufferedWriter(ostream);
            out.write(smdModel);
            out.close();
        }
        catch (IOException ioe) {
            RAPLogger.error(ioe, SmartMetaDataProcessor.class);
        }
    }
}

