/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.ActionEnv;
import com.cognos.rap.actions.v5spechelpers.V5Query;
import com.cognos.rap.actions.v5spechelpers.V5QueryItem;
import com.cognos.rap.actions.viscoachhelpers.SMDDataItem;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import java.util.List;
import org.dom4j.Element;

public class ViewerRAREUtility {
    static boolean isCalculation(Element dataItemElement) {
        return dataItemElement.getName().compareTo("dataItemCalculatedMember") == 0 || dataItemElement.attributeValue("aggregate") != null && dataItemElement.attributeValue("aggregate").compareTo("calculated") == 0;
    }

    static boolean isNumericDataItem(ActionEnv env, V5Query query, Element dataItemElement) {
        if (dataItemElement == null) {
            return false;
        }
        String dataItemName = dataItemElement.attributeValue("name");
        if (dataItemName == null || dataItemName.equals("")) {
            return false;
        }
        try {
            V5QueryItem queryItem = new V5QueryItem(env, query, query.findItem(dataItemName));
            return queryItem.confirmIsNumeric() && queryItem.getNumericSubType() != V5QueryItem.NumericSubType.dataValues;
        }
        catch (ActionException ae) {
            RAPLogger.error(ae, SMDDataItem.class);
            return false;
        }
    }

    static boolean isFakeMeasure(Element dataItemElement) {
        String rollUpAggregate = dataItemElement.attributeValue("rollupAggregate");
        return rollUpAggregate != null && (rollUpAggregate.compareTo("countDistinct") == 0 || rollUpAggregate.compareTo("count") == 0);
    }

    static boolean isMeasure(V5Query query, ActionEnv env, Element dataItemElement) {
        return ViewerRAREUtility.isNumericDataItem(env, query, dataItemElement) && !ViewerRAREUtility.isFakeMeasure(dataItemElement);
    }

    static boolean hasSummaryFunction(Element dataItemElemInQuery) {
        String expressionText;
        boolean hasSummaryFunction = false;
        Element expressionElement = dataItemElemInQuery.element("expression");
        if (expressionElement != null && ((expressionText = expressionElement.getText()).contains("aggregate(") || expressionText.contains("total("))) {
            hasSummaryFunction = true;
        }
        return hasSummaryFunction;
    }

    static boolean isDataItemSummary(V5Query query, Element dataItemElement) {
        boolean isDataItemSummary = false;
        String dataItemTagName = dataItemElement.getName();
        if (dataItemTagName.equals("dataItemMember")) {
            String hun = query.getContextSlicerHUN(dataItemElement);
            List<Element> elements = query.getDataItemsInHierarchy(hun);
            for (Element element : elements) {
                if (!element.getName().equals("dataItemChildrenSet")) continue;
                isDataItemSummary = true;
                break;
            }
        }
        return isDataItemSummary;
    }

    static boolean isSummary(V5Query query, ActionEnv env, Element dataItemElement) {
        boolean isSummary = false;
        if (!ViewerRAREUtility.isCalculation(dataItemElement) && !ViewerRAREUtility.isMeasure(query, env, dataItemElement) && (ViewerRAREUtility.isDataItemSummary(query, dataItemElement) || dataItemElement.getName().contains("Summary") || ViewerRAREUtility.hasSummaryFunction(dataItemElement))) {
            isSummary = true;
        }
        return isSummary;
    }
}

