/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.rap.actions.viscoachhelpers.ViewerVariationEntry;
import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ViewerVisualizationEntry {
    protected String m_visualizationEntryIcon;
    protected String m_visualizationEntryName;
    protected String m_visualizationEntryGroupId;
    protected String m_visualizationEntryDescription;
    protected List<ViewerVariationEntry> m_variationEntries = new ArrayList<ViewerVariationEntry>();
    protected String m_visualizationEntryTitle;
    protected StringBuilder m_visualizationEntryFields;

    ViewerVisualizationEntry(IClassificationEntry classificationEntry, IRARE rareObj, IVariationsInitializationHandle v5VisCoachHandle) throws RAREException {
        this.m_visualizationEntryFields = rareObj.resolve(v5VisCoachHandle, classificationEntry, "uiInfoFields");
        this.m_visualizationEntryIcon = rareObj.resolve(v5VisCoachHandle, classificationEntry, "icon").toString();
        this.m_visualizationEntryTitle = rareObj.resolve(v5VisCoachHandle, classificationEntry, "title").toString();
        this.m_visualizationEntryName = rareObj.resolve(v5VisCoachHandle, classificationEntry, "variation").toString();
        this.m_visualizationEntryDescription = rareObj.resolve(v5VisCoachHandle, classificationEntry, "description").toString();
        this.m_visualizationEntryGroupId = this.m_visualizationEntryName;
    }

    public void addVariation(IClassificationEntry classificationEntry, IRARE rareObj, IVariationsInitializationHandle v5VisCoachHandle) throws RAREException {
        ViewerVariationEntry vVariationEntry = new ViewerVariationEntry();
        vVariationEntry.setScore(String.valueOf(classificationEntry.getScore()));
        vVariationEntry.setScoreDescriptions(classificationEntry.getScoreDescriptions());
        vVariationEntry.setTemplateId(rareObj.serializeCLassificationEntry(classificationEntry));
        vVariationEntry.setFieldValues(rareObj.resolve(v5VisCoachHandle, classificationEntry, "uiInfoValues"));
        this.m_variationEntries.add(vVariationEntry);
    }

    public JSONObject getJSONVariationGroups() throws DocumentException {
        JSONObject variationGroupsObj = new JSONObject();
        JSONArray variationArr = new JSONArray();
        JSONArray fielsdArr = new JSONArray();
        this.loadUiInfoEntries(fielsdArr, this.m_visualizationEntryFields);
        variationGroupsObj.put((Object)"fields", (Object)fielsdArr);
        for (ViewerVariationEntry variationEntry : this.m_variationEntries) {
            JSONObject variationObj = new JSONObject();
            JSONObject scoreObj = new JSONObject();
            scoreObj.put((Object)"value", (Object)variationEntry.getScore());
            JSONArray scoreDescArray = new JSONArray();
            scoreObj.put((Object)"descriptions", (Object)scoreDescArray);
            List<String> scoreDescriptions = variationEntry.getScoreDescriptions();
            for (String description : scoreDescriptions) {
                scoreDescArray.add((Object)description);
            }
            variationObj.put((Object)"score", (Object)scoreObj);
            JSONArray fieldValuesArray = new JSONArray();
            StringBuilder fieldValues = variationEntry.getFieldValues();
            this.loadUiInfoEntries(fieldValuesArray, fieldValues);
            variationObj.put((Object)"fieldValues", (Object)fieldValuesArray);
            variationObj.put((Object)"templateId", (Object)variationEntry.getTemplateId());
            variationArr.add((Object)variationObj);
        }
        variationGroupsObj.put((Object)"variations", (Object)variationArr);
        variationGroupsObj.put((Object)"title", (Object)this.m_visualizationEntryTitle);
        variationGroupsObj.put((Object)"name", (Object)this.m_visualizationEntryName);
        variationGroupsObj.put((Object)"icon", (Object)this.m_visualizationEntryIcon);
        variationGroupsObj.put((Object)"groupId", (Object)this.m_visualizationEntryGroupId);
        variationGroupsObj.put((Object)"description", (Object)this.m_visualizationEntryDescription);
        return variationGroupsObj;
    }

    private void loadUiInfoEntries(JSONArray fielsdArr, StringBuilder fields) throws DocumentException {
        Document fieldsDoc = DocumentHelper.parseText((String)fields.toString());
        Element fieldsRoot = fieldsDoc.getRootElement();
        Iterator ite = fieldsRoot.elementIterator();
        while (ite.hasNext()) {
            Element child = (Element)ite.next();
            fielsdArr.add((Object)child.getTextTrim());
        }
    }

    public String getVisualizationEntryName() {
        return this.m_visualizationEntryName;
    }
}

