/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import org.apache.log4j.Level;

public class VisCoachLogger
implements ILogger {
    private LogTypedLogger _logger = LogTypedLogger.getInstance((String)"Trace.VIEWER.VISCOACH", LogTraceIndication.class);

    public void beginSection(Object message) {
        this._logger.info("Begin section: " + message);
    }

    public void endSection(Object message) {
        this._logger.info("End section: " + message);
    }

    public void debug(Object message) {
        this._logger.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this._logger.debug(message, t);
    }

    public void error(Object message) {
        this._logger.error(message);
    }

    public void error(Object message, Throwable t) {
        this._logger.error(message, t);
    }

    public ELogLevel getLevel() {
        return this.convertIPFToRARELevel(this._logger.getLevel());
    }

    public void info(Object message) {
        this._logger.info(message);
    }

    public void info(Object message, Throwable t) {
        this._logger.info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(ELogLevel.DEBUG);
    }

    public boolean isEnabledFor(ELogLevel level) {
        return this.convertIPFToRARELevel(this._logger.getLevel()).compareTo((Enum)level) >= 0;
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(ELogLevel.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(ELogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(ELogLevel.WARN);
    }

    public void log(ELogLevel level, Object message) {
        this._logger.log(this.convertRAREToIPFLevel(level), message);
    }

    public void log(ELogLevel level, Object message, Throwable t) {
        this._logger.log(this.convertRAREToIPFLevel(level), message, t);
    }

    public void warn(Object message) {
        this._logger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this._logger.warn(message, t);
    }

    private ELogLevel convertIPFToRARELevel(Level ipfLeveL) {
        if (ipfLeveL == Level.DEBUG) {
            return ELogLevel.DEBUG;
        }
        if (ipfLeveL == Level.INFO) {
            return ELogLevel.INFO;
        }
        if (ipfLeveL == Level.WARN) {
            return ELogLevel.WARN;
        }
        if (ipfLeveL == Level.ERROR) {
            return ELogLevel.ERROR;
        }
        return ELogLevel.OFF;
    }

    private Level convertRAREToIPFLevel(ELogLevel rareLeveL) {
        if (rareLeveL == ELogLevel.DEBUG) {
            return Level.DEBUG;
        }
        if (rareLeveL == ELogLevel.INFO) {
            return Level.INFO;
        }
        if (rareLeveL == ELogLevel.WARN) {
            return Level.WARN;
        }
        if (rareLeveL == ELogLevel.ERROR) {
            return Level.ERROR;
        }
        return Level.OFF;
    }
}

