/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.actions.viscoachhelpers;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataContainer;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Element;

public class VisCoachModelTransformer {
    private final String HAS_MEASURE = "hasMeasure";
    private final String IS_EDGE = "isEdge";
    private final String IS_MEASURE = "isMeasure";
    private final String IS_SUMMARY = "isSummary";
    private final String NUM_CATEGORIES = "numCategories";
    private final String QUERY_NAME = "queryName";
    private final String LABEL = "label";
    private final String CAPTION = "caption";
    private final String CALC_REF = "calcRef";
    private final String CONDITIONAL_ELEMENT_STR = "conditionalElementStr";
    private final IAssociativeModel mModel;

    public VisCoachModelTransformer(IAssociativeModel model) {
        this.mModel = model;
    }

    public Document process() {
        Document doc = DOM4JUtil.createDocument((String)"UTF8");
        this.processContainer(this.mModel.getRootContainer(), doc.addElement("dataContainer"));
        return doc;
    }

    private void processNode(Element elem, INode node) {
        if (node.isMetric()) {
            ArrayList<INode> partNodes = new ArrayList<INode>();
            for (IEdge e : node.getOutEdges(new String[0])) {
                if (!e.isWholePart() || !e.getEnd().isMetric()) continue;
                partNodes.add(e.getEnd());
            }
            IDataItem dataItem = node.getDataItem();
            Element dataItemElem = elem.addElement("dataItem");
            Element conceptsElem = dataItemElem.addElement("concepts");
            this.processDataItem(dataItemElem, dataItem);
            this.processConcept(conceptsElem, node.getConcept(), node.getConfidenceLevel());
            for (INode part : partNodes) {
                this.processNode(dataItemElem, part);
            }
        } else if (node.isCategory()) {
            ArrayList<INode> attributeNodes = new ArrayList<INode>();
            ArrayList<INode> partNodes = new ArrayList<INode>();
            for (IEdge e : node.getOutEdges(new String[0])) {
                if (e.isWholePart() && (e.getEnd().isMetric() || e.getEnd().isCategory())) {
                    partNodes.add(e.getEnd());
                    continue;
                }
                if (!e.getEnd().isAttribute()) continue;
                attributeNodes.add(e.getEnd());
            }
            for (INode attrNode : attributeNodes) {
                if (null == attrNode.getDataItem()) continue;
                IDataItem dataItem = attrNode.getDataItem();
                Element dataItemElem = elem.addElement("dataItem");
                Element conceptsElem = dataItemElem.addElement("concepts");
                this.processDataItem(dataItemElem, dataItem);
                this.processConcept(conceptsElem, node.getConcept(), node.getConfidenceLevel());
                this.processConcept(conceptsElem, attrNode.getConcept(), attrNode.getConfidenceLevel());
                for (INode part : partNodes) {
                    this.processNode(dataItemElem, part);
                }
            }
        } else {
            throw new RuntimeException("Unexpected node type: " + node.getType());
        }
    }

    private void processDataItem(Element dataItemElem, IDataItem dataItem) {
        dataItemElem.addAttribute("name", dataItem.getName());
        dataItemElem.addAttribute("type", dataItem.getDataType().toString());
        this.addDataItemProperties(dataItem, dataItemElem);
        IDataItemStats stats = dataItem.getStats();
        dataItemElem.addAttribute("numValues", Long.toString(stats.count()));
        dataItemElem.addAttribute("numDistinctValues", Long.toString(stats.distinctCount()));
        dataItemElem.addAttribute("nullable", Boolean.toString(stats.isNullable()));
    }

    private void processConcept(Element conceptsElem, IConcept concept, float confidence) {
        Element conceptElem;
        if (concept.isAttribute()) {
            conceptElem = conceptsElem.addElement("attribute");
        } else if (concept.isMetric()) {
            conceptElem = conceptsElem.addElement("metric");
        } else if (concept.isCategory()) {
            conceptElem = conceptsElem.addElement("category");
        } else {
            throw new RuntimeException("Unsupported concept type: " + concept.getName());
        }
        conceptElem.addAttribute("name", concept.getName());
        conceptElem.addAttribute("confidence", Float.toString(confidence));
        for (String isA : concept.getIsAs()) {
            conceptElem.addElement("isA").setText(isA);
        }
        for (String propName : concept.getPropertyNames()) {
            if ("signifiedByLabel".equals(propName)) continue;
            conceptElem.addElement("prop").addAttribute("name", propName).addAttribute("value", concept.getProperty(propName));
        }
    }

    private void processContainer(IDataContainer container, Element containerElem) {
        containerElem.addAttribute("name", container.getName());
        if (null != container.getType()) {
            containerElem.addAttribute("type", container.getType());
        }
        ArrayList<INode> rootNodes = new ArrayList<INode>();
        for (INode n : container.getNodes()) {
            if (!this.isRootNode(n)) continue;
            rootNodes.add(n);
        }
        Element dataItemsElem = containerElem.addElement("dataItems");
        for (INode root : rootNodes) {
            this.processNode(dataItemsElem, root);
        }
        for (IDataContainer child : container.getChildren()) {
            this.processContainer(child, containerElem.addElement("dataContainer"));
        }
    }

    private boolean isRootNode(INode n) {
        if (!n.isCategory() && !n.isMetric()) {
            return false;
        }
        for (IEdge e : n.getInEdges(new String[0])) {
            if (!e.isWholePart()) continue;
            return false;
        }
        return true;
    }

    private void addDataItemProperties(IDataItem dataItem, Element dataItemElem) {
        this.setPropertyStr("label", dataItem.getProperty("label"), dataItemElem);
        this.setPropertyStr("caption", dataItem.getProperty("caption"), dataItemElem);
        this.setPropertyStr("queryName", dataItem.getProperty("queryName"), dataItemElem);
        this.setPropertyStr("numCategories", dataItem.getProperty("numCategories"), dataItemElem);
        this.setPropertyStr("calcRef", dataItem.getProperty("calcRef"), dataItemElem);
        this.setPropertyStr("conditionalElementStr", dataItem.getProperty("conditionalElementStr"), dataItemElem);
        this.setPropertyBool("isSummary", dataItem.getProperty("isSummary"), dataItemElem);
        this.setPropertyBool("hasMeasure", dataItem.getProperty("hasMeasure"), dataItemElem);
        this.setPropertyBool("isMeasure", dataItem.getProperty("isMeasure"), dataItemElem);
        this.setPropertyBool("isEdge", dataItem.getProperty("isEdge"), dataItemElem);
    }

    private void setPropertyStr(String propName, IValue propValue, Element dataItemElem) {
        if (propValue != null) {
            dataItemElem.addAttribute(propName, propValue.toString());
        }
    }

    private void setPropertyBool(String propName, IValue propValue, Element dataItemElem) {
        if (propValue != null && propValue.booleanValue()) {
            dataItemElem.addAttribute(propName, "true");
        } else {
            dataItemElem.addAttribute(propName, "false");
        }
    }
}

