/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.controller;

import com.cognos.rap.actions.v5spechelpers.V5X;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CognosServiceResponse {
    private String _name = "";
    private String _value = "";
    private ArrayList<Element> _domValues = null;
    private static final String JSON_VALUE_NAME = "name";
    private static final String JSON_VALUE_VALUE = "value";
    private static final String JSON_VALUE_DOM_VALUES = "domValues";

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setDOMValue(Element domValue) {
        this._domValues = new ArrayList();
        this._domValues.add(domValue);
    }

    public Element getDOMValue() {
        if (this._domValues == null || this._domValues.size() == 0) {
            return null;
        }
        return this._domValues.get(0);
    }

    public String toJSONString() {
        JSONObject jsonObject = new JSONObject();
        if (this._name != null) {
            jsonObject.put((Object)JSON_VALUE_NAME, (Object)this._name);
        }
        if (this._value != null) {
            jsonObject.put((Object)JSON_VALUE_VALUE, (Object)this._value);
        }
        if (this._domValues != null) {
            jsonObject.put((Object)JSON_VALUE_DOM_VALUES, (Object)this._saveDomValuesArrayAsJsonArray());
        }
        return jsonObject.toString();
    }

    private JSONArray _saveDomValuesArrayAsJsonArray() {
        if (this._domValues == null || this._domValues.size() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Element domValue : this._domValues) {
            jsonArray.add((Object)domValue.asXML());
        }
        return jsonArray;
    }

    private static ArrayList<Element> _loadDomValuesArrayFromJsonArray(JSONArray jsonArray) throws DocumentException {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Element> domValues = new ArrayList<Element>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String asXML = (String)jsonArray.get(i);
            Document result = DocumentHelper.parseText((String)asXML);
            domValues.add(result.getRootElement());
        }
        return domValues;
    }

    public static CognosServiceResponse parse(String jsonString) throws IOException, DocumentException {
        JSONObject jsonObject = JSONObject.parse((String)jsonString);
        CognosServiceResponse result = new CognosServiceResponse();
        result._domValues = CognosServiceResponse._loadDomValuesArrayFromJsonArray((JSONArray)jsonObject.get((Object)JSON_VALUE_DOM_VALUES));
        result._name = (String)jsonObject.get((Object)JSON_VALUE_NAME);
        result._value = (String)jsonObject.get((Object)JSON_VALUE_VALUE);
        return result;
    }

    public String getJSONMetaDataBlock() {
        return this.extractJSONContextDataBlock("META-DATA");
    }

    public String getJSONContextDataBlock() {
        return this.extractJSONContextDataBlock("CONTEXT-DATA");
    }

    private String extractJSONContextDataBlock(String token) {
        return this.extractJSONContextDataBlock(token, 0);
    }

    private String extractJSONContextDataBlock(String token, int domIndex) {
        int tokenIdx;
        Element domValue;
        Element block;
        if (this._domValues != null && this._domValues.size() > 0 && (block = V5X.selectSingleNode(domValue = this._domValues.get(domIndex), token, "Block")) != null) {
            return block.getText();
        }
        if (this._value != null && (tokenIdx = this._value.lastIndexOf("<" + token)) >= 0) {
            String result = this._value.substring(tokenIdx);
            tokenIdx = result.indexOf("<Block>{") + 7;
            int endTokenIdx = result.indexOf("}</Block>");
            if (tokenIdx >= 0 && endTokenIdx >= 0) {
                return result.substring(tokenIdx, endTokenIdx + 1);
            }
        }
        return null;
    }

    public void setDOMValues(ArrayList<Element> _domValues) {
        this._domValues = _domValues;
    }

    public ArrayList<Element> getDOMValues() {
        return this._domValues;
    }
}

