/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.controller;

import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.controller.IReportInfo;
import com.cognos.rap.controller.RAPConfigProperties;
import com.cognos.rap.controller.RAPTimer;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.UnsupportedSpecificationException;
import com.cognos.viewer.utility.XMLUtility;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Element;

public class RAPReport {
    private Document _dom = null;
    private IReportInfo _reportInfo = null;
    private RAPTimer m_rapTimer = null;
    private HashMap<String, String> _parameterUpdateMap = null;
    private String _defaultLocale = null;
    private boolean _reportModificationSafeForSecondaryRequest = true;
    private String _productLocale = null;
    private static boolean _bBackwardsCompatibleDrillEnabled = false;

    public String getDefaultLocale() {
        return this._defaultLocale;
    }

    public void setDefaultLocale(String sLocale) {
        this._defaultLocale = sLocale;
    }

    public String getProductLocale() {
        return this._productLocale;
    }

    public void setProductLocale(String sLocale) {
        this._productLocale = sLocale;
    }

    public RAPReport(String reportSpecXML) throws ActionControllerException {
        this.initRAPTimer();
        this.initializeDOM(reportSpecXML);
    }

    public RAPReport(Document reportSpec) {
        this._dom = reportSpec;
        this.initRAPTimer();
    }

    public void setParameterUpdateMap(HashMap<String, String> paramUpdateMap) {
        this._parameterUpdateMap = paramUpdateMap;
    }

    public void addParamUpdate(String name, String valueSpec) {
        if (this._parameterUpdateMap != null) {
            this._parameterUpdateMap.put(name, valueSpec);
        }
    }

    public Document getDOM() {
        return this._dom;
    }

    public boolean isReportInitialized() {
        return this._dom != null;
    }

    public IReportInfo getReportInfo() {
        return this._reportInfo;
    }

    public void setReportInfo(IReportInfo ri) {
        this._reportInfo = ri;
        this._reportInfo.setRAPTimer(this.m_rapTimer);
    }

    private void initRAPTimer() {
        if (RAPConfigProperties.isRAPTimerEnabled() && this.m_rapTimer == null) {
            this.m_rapTimer = new RAPTimer();
        }
    }

    public RAPTimer getRAPTimer() {
        return this.m_rapTimer;
    }

    public String getModelPath() {
        return this._dom.selectSingleNode(".//*[local-name()='modelPath']").getText();
    }

    private void initializeDOM(String reportSpecXML) throws ActionControllerException {
        if (reportSpecXML.length() > 0) {
            if (this.m_rapTimer != null) {
                this.m_rapTimer.addEventTiming("begin spec parse...");
            }
            this._dom = XMLUtility.createXMLDocument(reportSpecXML);
            if (this._dom == null) {
                throw new ActionControllerException();
            }
            Element bookletItem = V5X.selectSingleNode(this._dom, "//V5X//CHILD", "layouts", "layout", "reportPages", "bookletItem");
            if (bookletItem != null) {
                throw new ActionControllerException(new UnsupportedSpecificationException());
            }
        }
    }

    public String getExpressionLocale() {
        return this._dom.getRootElement().attributeValue("expressionLocale");
    }

    public void setReportModificationSafeForSecondaryRequest(boolean safe) {
        this._reportModificationSafeForSecondaryRequest = safe;
    }

    public boolean isReportModificationSafeForSecondaryRequest() {
        return this._reportModificationSafeForSecondaryRequest;
    }
}

