/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.controller;

import com.cognos.rap.actions.BaseActionSet;
import com.cognos.rap.actions.ObjectActionSet;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.rap.actions.v5actionset.V5ActionSet;
import com.cognos.rap.actions.v5infoactionset.V5InfoActionSet;
import com.cognos.rap.controller.ICognosServiceRequest;
import com.cognos.rap.controller.IReportActionController;
import com.cognos.rap.controller.RAPConfigProperties;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionState;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.utility.RAPLogger;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.viewer.utility.ZIPIUtility;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public final class ReportActionController
implements IReportActionController {
    private static final String RAP_TIMING_KEY = "RAP";
    private V5ActionSet _v5ActionSet = null;
    private V5InfoActionSet _v5InfoActionSet = null;
    private Document _actionsDocument = null;
    private ICognosServiceRequest _cognosServiceInterface = null;
    private ReportActionState _state = new ReportActionState();
    private DebugLogger _viewerLogger = null;
    private boolean _callerSetRunFalse = false;

    public ReportActionController() {
        this(null);
    }

    public ReportActionController(ICognosServiceRequest busRequest) {
        this._v5ActionSet = new V5ActionSet();
        this._cognosServiceInterface = busRequest;
        this._v5InfoActionSet = new V5InfoActionSet();
    }

    @Override
    public ICognosServiceRequest getCognosServiceInterface() {
        return this._cognosServiceInterface;
    }

    @Override
    public String getReportActionStateAsString() {
        return this._state.getState();
    }

    @Override
    public ReportActionState getReportActionState() {
        return this._state;
    }

    @Override
    public void setReportActionStateFromString(String state) throws ActionException {
        this._state.setState(state);
    }

    @Override
    public boolean getCallerSetRunFalse() {
        return this._callerSetRunFalse;
    }

    @Override
    public String applyActions(String reportSpec, String actionSpec) throws ActionControllerException {
        if (reportSpec == null || reportSpec.length() == 0) {
            return reportSpec;
        }
        RAPReport rapReport = new RAPReport(reportSpec);
        this.applyActions(rapReport, actionSpec);
        return rapReport.getDOM().asXML();
    }

    public void applyActions(RAPReport rapReport, String actionsSpec) throws ActionControllerException {
        if (!rapReport.isReportInitialized()) {
            return;
        }
        if (this.getViewerLogger() != null) {
            this.getViewerLogger().startTimedEvent(RAP_TIMING_KEY, RAP_TIMING_KEY, RAP_TIMING_KEY);
        }
        this.initialize(actionsSpec);
        ArrayList<ObjectActionSet> actionSetList = new ArrayList<ObjectActionSet>();
        actionSetList.add(this._v5ActionSet);
        actionSetList.add(this._v5InfoActionSet);
        Element actionsRoot = this._actionsDocument.getRootElement();
        List actions = actionsRoot.elements();
        for (int i = 0; i < actions.size(); ++i) {
            boolean bActionApplied = false;
            Element currentAction = (Element)actions.get(i);
            String actionName = currentAction.attributeValue("name");
            if (actionName == null) {
                actionName = currentAction.getName();
            }
            if (rapReport.getRAPTimer() != null) {
                rapReport.getRAPTimer().addEventTiming("begin action: " + actionName);
            }
            ZipiTimer timer = ZIPIUtility.getInstance().doZIPI(actionName, (Node)currentAction, this.isZipiNeeded(currentAction), true);
            try {
                for (BaseActionSet baseActionSet : actionSetList) {
                    baseActionSet.setReportActionController(this);
                    if (!baseActionSet.isActionSupported(actionName)) continue;
                    baseActionSet.applyAction(rapReport, actionName, currentAction);
                    bActionApplied = true;
                    break;
                }
                if (bActionApplied) continue;
                if (this.getViewerLogger() != null) {
                    this.getViewerLogger().endTimedEvent(RAP_TIMING_KEY);
                }
                throw new ActionControllerException(actionName);
            }
            catch (ActionException exception) {
                if (this.getViewerLogger() != null) {
                    this.getViewerLogger().endTimedEvent(RAP_TIMING_KEY);
                }
                RAPLogger.error(exception, this.getClass());
                throw new ActionControllerException(exception);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
        }
        this._callerSetRunFalse = false;
        if ("false".equals(actionsRoot.attributeValue("run"))) {
            this._callerSetRunFalse = true;
        }
        if (this.getViewerLogger() != null) {
            this.getViewerLogger().endTimedEvent(RAP_TIMING_KEY);
        }
    }

    private boolean isZipiNeeded(Element currentAction) {
        boolean isNeeded = false;
        if (ZIPIUtility.getInstance().isZIPIEnablded()) {
            if (RAPConfigProperties.isVerboseZipi()) {
                isNeeded = true;
            } else if (currentAction.selectSingleNode("*[local-name()='selection']") != null) {
                isNeeded = true;
            }
        }
        return isNeeded;
    }

    public void getInfo(RAPReport rapReport, String actionsSpec) throws ActionControllerException {
        if (this.getViewerLogger() != null) {
            this.getViewerLogger().startTimedEvent(RAP_TIMING_KEY, RAP_TIMING_KEY, RAP_TIMING_KEY);
        }
        this.initialize(actionsSpec);
        V5InfoActionSet infoActionSet = this._v5InfoActionSet;
        Element actionsRoot = this._actionsDocument.getRootElement();
        List actions = actionsRoot.elements("getInfoAction");
        Element currentAction = (Element)actions.get(0);
        String actionName = currentAction.attributeValue("name");
        try {
            if (rapReport.getReportInfo() == null) {
                ReportInfo reportInfo = new ReportInfo();
                rapReport.setReportInfo(reportInfo);
            }
            infoActionSet.setReportActionController(this);
            infoActionSet.getInfo(rapReport, actionName, currentAction);
        }
        catch (ActionException exception) {
            if (this.getViewerLogger() != null) {
                this.getViewerLogger().endTimedEvent(RAP_TIMING_KEY);
            }
            throw new ActionControllerException(exception);
        }
        if (this.getViewerLogger() != null) {
            this.getViewerLogger().endTimedEvent(RAP_TIMING_KEY);
        }
    }

    private void initialize(String actionsSpec) throws ActionControllerException {
        this._actionsDocument = XMLUtility.createXMLDocument(actionsSpec);
        if (this._actionsDocument == null) {
            throw new ActionControllerException();
        }
    }

    public void setViewerDebugLogger(DebugLogger logger) {
        this._viewerLogger = logger;
    }

    @Override
    public DebugLogger getViewerLogger() {
        return this._viewerLogger;
    }
}

