/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.controller;

import com.cognos.rap.actions.v5spechelpers.MemberInfo;
import com.cognos.rap.exceptions.ActionException;
import com.cognos.viewer.utility.XMLUtility;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ReportActionState {
    public static final String ELEMENT_NAME_ANCESTORS = "ancestors";
    public static final String ELEMENT_NAME_ANCESTOR = "ancestor";
    public static final String ATTRIBUTE_MEMBER = "member";
    public static final String ELEMENT_NAME_ANCESTOR_MUN = "ancestorMUN";
    public static final String ELEMENT_NAME_ANCESTOR_CAPTION = "ancestorCaption";
    public static final String ATTRIBUTE_DISTANCE = "distance";
    public static final String ELEMENT_NAME_CHILDINFOS = "childInfos";
    public static final String ELEMENT_NAME_CHILDINFO = "childInfo";
    public static final String ATTRIBUTE_HAS_CHILD = "hasChild";
    private Document stateDocument;

    public String getState() {
        return this.stateDocument.asXML();
    }

    public void setState(String stateString) throws ActionException {
        this.stateDocument = stateString == null || stateString.length() == 0 ? this.createStateDocument() : XMLUtility.createXMLDocument(stateString);
    }

    public MemberInfo getAncestorInfoFromState(String mun, int distance) {
        String queryString;
        Element ancestorsElement = this.getAncestorsElement();
        Element ancestorElement = (Element)ancestorsElement.selectSingleNode(queryString = ".//*[local-name()='ancestor'][@distance='" + distance + "'][@" + ATTRIBUTE_MEMBER + "='" + mun + "']");
        if (ancestorElement == null) {
            return null;
        }
        String parentMUN = ancestorElement.elementText(ELEMENT_NAME_ANCESTOR_MUN);
        String parentCaption = ancestorElement.elementText(ELEMENT_NAME_ANCESTOR_CAPTION);
        return new MemberInfo(parentMUN, parentCaption);
    }

    public Element getChildInfoFromCache(String mun) {
        Element childInfosElement = this.getChildInfosElement();
        String queryString = ".//*[local-name()='childInfo'][@member='" + mun + "']";
        return (Element)childInfosElement.selectSingleNode(queryString);
    }

    public void addAncestorInfoToState(String mun, int distance, MemberInfo memberInfo) {
        if (mun == null || memberInfo == null || memberInfo.getMUN() == null || memberInfo.getMemberCaption() == null) {
            return;
        }
        Element ancestorsElement = this.getAncestorsElement();
        Element ancestorElement = ancestorsElement.addElement(ELEMENT_NAME_ANCESTOR);
        ancestorElement.addAttribute(ATTRIBUTE_DISTANCE, String.valueOf(distance));
        ancestorElement.addAttribute(ATTRIBUTE_MEMBER, mun);
        Element ancestorMUNElement = ancestorElement.addElement(ELEMENT_NAME_ANCESTOR_MUN);
        ancestorMUNElement.setText(memberInfo.getMUN());
        Element ancestorCaptionElement = ancestorElement.addElement(ELEMENT_NAME_ANCESTOR_CAPTION);
        ancestorCaptionElement.setText(memberInfo.getMemberCaption());
    }

    public void addChildInfoToState(String mun, MemberInfo memberInfo) {
        if (mun == null || memberInfo == null) {
            return;
        }
        Element childInfosElement = this.getChildInfosElement();
        Element childInfoElement = childInfosElement.addElement(ELEMENT_NAME_CHILDINFO);
        childInfoElement.addAttribute(ATTRIBUTE_MEMBER, mun);
        childInfoElement.addAttribute(ATTRIBUTE_HAS_CHILD, Boolean.toString(memberInfo.isValid()));
    }

    private Element getAncestorsElement() {
        Element ancestorsElement;
        if (this.stateDocument == null) {
            this.stateDocument = this.createStateDocument();
        }
        if ((ancestorsElement = (Element)this.stateDocument.getRootElement().selectSingleNode("//*[local-name()='ancestors']")) == null) {
            ancestorsElement = this.stateDocument.getRootElement().addElement(ELEMENT_NAME_ANCESTORS);
        }
        return ancestorsElement;
    }

    private Element getChildInfosElement() {
        Element childInfosElement;
        if (this.stateDocument == null) {
            this.stateDocument = this.createStateDocument();
        }
        if ((childInfosElement = (Element)this.stateDocument.getRootElement().selectSingleNode("//*[local-name()='childInfos']")) == null) {
            childInfosElement = this.stateDocument.getRootElement().addElement(ELEMENT_NAME_CHILDINFOS);
        }
        return childInfosElement;
    }

    private Document createStateDocument() {
        Document document = DocumentHelper.createDocument();
        document.addElement("state");
        return document;
    }
}

