/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.preprocessor;

import com.cognos.rap.preprocessor.IFlexParamProperty;
import com.cognos.viewer.model.ICognosViewerState;
import org.dom4j.Element;

public class DisplayTypeProperty
implements IFlexParamProperty {
    private String m_containerId = null;

    public DisplayTypeProperty(String containerId) {
        this.m_containerId = containerId;
    }

    @Override
    public void convert(ICognosViewerState state, Element flexParamProperties, Element eRAPCommand) {
        String containerId = this.getContainerId();
        String targetType = this.getTargetType(flexParamProperties);
        if (!"".equals(containerId) && !"".equals(targetType)) {
            Element reportActionNode = eRAPCommand.addElement("reportAction").addAttribute("name", "ChangeDataContainerType");
            reportActionNode.addElement("id").addText(containerId);
            reportActionNode.addElement("target").addText(targetType);
        } else {
            state.getIPFLogger().warn("Failed to upgrade Go Dashboard customization : " + flexParamProperties.asXML() + " for report : " + state.getFormFieldAsString("ui.object"), this.getClass().getName());
        }
    }

    private String getContainerId() {
        return this.m_containerId;
    }

    public String getTargetType(Element flexParamProperties) {
        String formatValue = flexParamProperties.attribute("format").getValue();
        String[] formats = formatValue.split(",");
        String sType = null;
        String sSubtype = null;
        String sDepth = null;
        String sDisplay = null;
        String sStyle = null;
        String sHole = null;
        for (String f : formats) {
            String[] format = f.split(":");
            if ("type".equals(format[0].toLowerCase())) {
                sType = format[1].toLowerCase();
                continue;
            }
            if ("subtype".equals(format[0].toLowerCase())) {
                sSubtype = format[1].toLowerCase();
                continue;
            }
            if ("depth".equals(format[0].toLowerCase())) {
                sDepth = format[1].toLowerCase();
                continue;
            }
            if ("display".equals(format[0].toLowerCase())) {
                sDisplay = format[1].toLowerCase();
                continue;
            }
            if ("style".equals(format[0].toLowerCase())) {
                sStyle = format[1].toLowerCase();
                continue;
            }
            if (!"hole".equals(format[0].toLowerCase())) continue;
            sHole = format[1].toLowerCase();
        }
        return this.getBUXChartId(sType, sSubtype, sDepth, sDisplay, sStyle, sHole);
    }

    private String getBUXChartId(String type, String subtype, String depth, String sDisplay, String style, String hole) {
        String buxChartId = null;
        buxChartId = "column".equals(type) ? this.getBUXColumnChartId(subtype, depth) : ("bar3d".equals(type) ? "column_3daxis" : ("bar".equals(type) ? this.getBUXBarChartId(subtype, depth) : ("line3d".equals(type) ? "line_3daxis" : ("line".equals(type) ? this.getBUXLineChartId(subtype, depth, sDisplay, style) : ("pie".equals(type) ? this.getBuxPieChartId(depth, hole) : ("area3d".equals(type) ? "area_3daxis" : ("area".equals(type) ? this.getBUXAreaChartId(subtype, depth) : ("scatter".equals(type) ? type : ("gauge".equals(type) ? "gauge_dial" : ("list".equals(type) ? "list" : ("crosstab".equals(type) ? "crosstab" : "")))))))))));
        return buxChartId;
    }

    private String getBuxPieChartId(String depth, String hole) {
        String buxPieChartId = null;
        buxPieChartId = "2.5d".equals(depth) ? ("donut".equals(hole) ? "pie_hole" : "pie") : ("donut".equals(hole) ? "pie_flat_hole" : "pie_flat");
        return buxPieChartId;
    }

    private String getBUXAreaChartId(String subtype, String depth) {
        String buxAreaChartId = null;
        if ("stacked".equals(subtype)) {
            if (depth == null) {
                buxAreaChartId = "area_stacked_flat";
            } else if ("2.5d".equals(depth)) {
                buxAreaChartId = "area_stacked";
            }
        } else if ("stacked100".equals(subtype)) {
            if (depth == null) {
                buxAreaChartId = "area_percent_flat";
            } else if ("2.5d".equals(depth)) {
                buxAreaChartId = "area_percent";
            }
        } else if (depth == null) {
            buxAreaChartId = "area_clustered_flat";
        } else if ("2.5d".equals(depth)) {
            buxAreaChartId = "area_clustered";
        }
        return buxAreaChartId;
    }

    private String getBUXLineChartId(String subtype, String depth, String display, String style) {
        String buxLineChartId = null;
        if ("stacked".equals(subtype)) {
            if ("linesandpoints".equals(display)) {
                buxLineChartId = "line_stacked_flat_markers";
            } else if ("linesonly".equals(display)) {
                if (depth == null) {
                    buxLineChartId = "line_stacked_flat";
                } else if ("2.5d".equals(depth)) {
                    buxLineChartId = "line_stacked";
                }
            } else {
                buxLineChartId = "line_stacked_flat_markers";
            }
        } else if ("stacked100".equals(subtype)) {
            if ("linesandpoints".equals(display)) {
                buxLineChartId = "line_percent_flat_markers";
            } else if ("linesonly".equals(display)) {
                if (depth == null) {
                    buxLineChartId = "line_percent_flat";
                } else if ("2.5d".equals(depth)) {
                    buxLineChartId = "line_percent";
                }
            } else {
                buxLineChartId = "line_percent_flat_markers";
            }
        } else if ("linesonly".equals(display)) {
            if (depth == null) {
                if (style == null) {
                    buxLineChartId = "line_clustered_flat";
                } else if ("stepat".equals(style)) {
                    buxLineChartId = "line_stepAtPoint_clustered_flat";
                }
            } else if ("2.5d".equals(depth)) {
                buxLineChartId = "line_clustered";
            }
        } else if ("pointsonly".equals(display)) {
            buxLineChartId = "points_clustered_markers";
        } else if (style == null) {
            buxLineChartId = "line_clustered_flat_markers";
        } else if ("stepat".equals(style)) {
            buxLineChartId = "line_stepAtPoint_clustered_flat_markers";
        }
        return buxLineChartId;
    }

    private String getBUXBarChartId(String subtype, String depth) {
        String buxBarChartId = null;
        if ("stacked".equals(subtype)) {
            if (depth == null) {
                buxBarChartId = "bar_stacked_flat";
            } else if ("2.5d".equals(depth)) {
                buxBarChartId = "bar_stacked";
            }
        } else if ("stacked100".equals(subtype)) {
            if (depth == null) {
                buxBarChartId = "bar_percent_flat";
            } else if ("2.5d".equals(depth)) {
                buxBarChartId = "bar_percent";
            }
        } else if (depth == null) {
            buxBarChartId = "bar_clustered_flat";
        } else if ("2.5d".equals(depth)) {
            buxBarChartId = "bar_clustered";
        }
        return buxBarChartId;
    }

    private String getBUXColumnChartId(String subtype, String depth) {
        String buxColumnChartId = null;
        if ("stacked".equals(subtype)) {
            if (depth == null) {
                buxColumnChartId = "column_stacked_flat";
            } else if ("2.5d".equals(depth)) {
                buxColumnChartId = "column_stacked";
            }
        } else if ("stacked100".equals(subtype)) {
            if (depth == null) {
                buxColumnChartId = "column_percent_flat";
            } else if ("2.5d".equals(depth)) {
                buxColumnChartId = "column_percent";
            }
        } else if (depth == null) {
            buxColumnChartId = "column_clustered_flat";
        } else if ("2.5d".equals(depth)) {
            buxColumnChartId = "column_clustered";
        }
        return buxColumnChartId;
    }
}

