/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.preprocessor;

import com.cognos.rap.exceptions.ActionException;
import com.cognos.rap.preprocessor.ColumnsOrderProperty;
import com.cognos.rap.preprocessor.DisplayTypeProperty;
import com.cognos.rap.preprocessor.FilterProperty;
import com.cognos.rap.preprocessor.IFlexParamProperty;
import com.cognos.rap.preprocessor.PaletteOptionProperty;
import com.cognos.rap.preprocessor.SortProperty;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.XMLUtility;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Element;

public class GODashboardPrepropcessor {
    public static final String ANSUpgrade = "ANSUpgrade";
    private Element m_flexParamProperties = null;
    private String m_containerId = null;
    private String m_reportSpec = null;
    private ArrayList<IFlexParamProperty> m_properties = new ArrayList();
    private ICognosViewerState m_state = null;

    public GODashboardPrepropcessor(ICognosViewerState state, String reportFlexParamProperties, String containerId, String reportSpec) throws ActionException {
        try {
            this.m_containerId = containerId;
            this.m_reportSpec = reportSpec;
            this.m_state = state;
            Document xmlDocument = XMLUtility.createXMLDocument(reportFlexParamProperties);
            this.m_flexParamProperties = xmlDocument.getRootElement();
            if (this.convertReorder()) {
                this.m_properties.add(new ColumnsOrderProperty(containerId));
            }
            if (this.convertSort()) {
                this.m_properties.add(new SortProperty(this.getContainerId(), this.getReportSpec()));
            }
            if (this.convertDisplayType()) {
                this.m_properties.add(new DisplayTypeProperty(this.getContainerId()));
            }
            if (this.convertPaletteOption()) {
                this.m_properties.add(new PaletteOptionProperty());
            }
            if (this.convertFilter()) {
                this.m_properties.add(new FilterProperty());
            }
        }
        catch (Exception exception) {
            throw new ActionException("LDX customization spec could not be loaded");
        }
    }

    private boolean convertDisplayType() {
        String formatValue = this.m_flexParamProperties.attribute("format").getValue();
        return formatValue != null && formatValue.length() != 0 && formatValue.indexOf("type:") != -1;
    }

    public boolean isCrosstab() {
        return "type:crosstab".equals(this.m_flexParamProperties.attributeValue("format"));
    }

    private boolean convertSort() {
        return this.m_flexParamProperties.selectSingleNode("sort") != null;
    }

    private boolean convertFilter() {
        return this.m_flexParamProperties.selectSingleNode("currentFilter") != null;
    }

    private boolean convertPaletteOption() {
        boolean isChart;
        String formatValue = this.m_flexParamProperties.attribute("format").getValue();
        if (formatValue == null || formatValue.length() == 0) {
            return false;
        }
        boolean bl = isChart = formatValue.indexOf("chart") != -1;
        return !isChart || formatValue.indexOf("palette:") != -1;
    }

    private boolean convertReorder() {
        String format = this.m_flexParamProperties.attributeValue("format");
        return format.indexOf("list") != -1 && this.m_flexParamProperties.selectSingleNode("gridpos") != null;
    }

    public Element evaluate(Element RAPCommands) {
        for (IFlexParamProperty pc : this.m_properties) {
            pc.convert(this.m_state, this.m_flexParamProperties, RAPCommands);
        }
        return RAPCommands;
    }

    public String getContainerId() {
        return this.m_containerId;
    }

    public String getReportSpec() {
        return this.m_reportSpec;
    }
}

