/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.preprocessor;

import com.cognos.rap.preprocessor.IFlexParamProperty;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.XMLUtility;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class SortProperty
implements IFlexParamProperty {
    private static final String SORT_ORDER_ASC = "ascending";
    private static final String SORT_ORDER_DESC = "descending";
    private boolean m_isCrosstab = true;
    private String m_containerId = null;
    private String m_reportSpec = null;

    public SortProperty(String containerId, String reportSpec) {
        this.m_containerId = containerId;
        this.m_reportSpec = reportSpec;
    }

    @Override
    public void convert(ICognosViewerState state, Element flexParamProperties, Element RAPCommand2) {
        this.setIsCrosstab(flexParamProperties);
        List sortDetailsList = flexParamProperties.selectNodes("//sort/*/@details");
        for (Attribute sortDetails : sortDetailsList) {
            String sortDetailsValue = sortDetails.getValue();
            this.generateRAPCommand(RAPCommand2, sortDetailsValue);
        }
    }

    private void generateRAPCommand(Element eRAPCommand, String sortDetailsValue) {
        try {
            String[] sortInfo = sortDetailsValue.split("><");
            String sortOrder = this.getSortOrder(sortInfo[2]);
            String sortColumnName = this.getSortColumnName(sortInfo[3]);
            String sortColumnDisplay = this.getSortColumnDisplay(sortInfo[3]);
            String containerId = this.getContainerId();
            Element reportActionNode = eRAPCommand.addElement("reportAction").addAttribute("name", "Sort");
            reportActionNode.addElement("id").addText(containerId);
            Element selectionNode = reportActionNode.addElement("selection");
            Element selectedCellNode = selectionNode.addElement("selectedCell");
            selectedCellNode.addElement("name").addText(sortColumnName);
            selectedCellNode.addElement("display").addText(sortColumnDisplay);
            reportActionNode.addElement("order").addText(sortOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSortColumnDisplay(String columnName) {
        return columnName.substring(1);
    }

    private boolean isCrosstab() {
        return this.m_isCrosstab;
    }

    private void setIsCrosstab(Element flexParamProperties) {
        String format = flexParamProperties.attributeValue("format");
        this.m_isCrosstab = format.indexOf("crosstab") != -1;
    }

    private String getSortColumnName(String columnName) {
        Document reportDocument;
        Element root;
        Element defaultCrosstabColumn;
        if (this.isCrosstab() && (defaultCrosstabColumn = (Element)(root = (reportDocument = XMLUtility.createXMLDocument(this.m_reportSpec)).getRootElement()).selectSingleNode(".//*[local-name()='crosstabColumns']/.//*[@refDataItem]")) != null) {
            return defaultCrosstabColumn.attributeValue("refDataItem");
        }
        return columnName.substring(1);
    }

    private String getSortOrder(String sortOrder) {
        return sortOrder.equals("0") ? SORT_ORDER_ASC : SORT_ORDER_DESC;
    }

    private String getContainerId() {
        return this.m_containerId;
    }
}

