/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.utility;

import com.cognos.rap.actions.v5spechelpers.V5ChartPalette;
import com.cognos.rap.exceptions.ActionException;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ChartPalettesXMLCreator {
    private static Map<String, Color> colorMap = new HashMap<String, Color>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ChartPalettesXMLCreator creator = new ChartPalettesXMLCreator();
        File f = new File(args[0]);
        XMLWriter xmlWriter = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            xmlWriter = new XMLWriter((Writer)new FileWriter(f), format);
            xmlWriter.write(creator.createChartPalettesXMLForFlex());
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.close();
            }
        }
        System.out.println("Created file :" + f.getAbsolutePath());
    }

    private Document createChartPalettesXMLForFlex() throws ActionException {
        Element palettesE = DocumentHelper.createDocument().addElement("viewer").addElement("palettes");
        for (String key : V5ChartPalette.paletteNVMap.keySet()) {
            Element palette = V5ChartPalette.loadPalette(key);
            Element paletteE = palettesE.addElement("palette");
            paletteE.addAttribute("id", key);
            this.createPalette(paletteE, palette.elements());
        }
        return palettesE.getDocument();
    }

    private void createPalette(Element paletteElement, List<Element> paletteEntries) {
        for (Element entry : paletteEntries) {
            Element pattern;
            Element paletteItem = paletteElement.addElement("paletteItem");
            if (entry.getName().equals("chartGradient")) {
                Element gradient = paletteItem.addElement("gradient");
                String angle = this.getAngle(entry.attributeValue("direction"));
                DocumentHelper.makeElement((Branch)gradient, (String)"linear/angle").setText(angle);
                this.processGradientColor(gradient, entry.attributeValue("fromColor"), true);
                this.processGradientColor(gradient, entry.attributeValue("toColor"), false);
                continue;
            }
            if (entry.getName().equals("chartColor")) {
                pattern = paletteItem.addElement("pattern");
                pattern.addElement("type").setText("ePatternSolid");
                Element fgColor = pattern.addElement("fgColor");
                this.setColor(fgColor, entry.attributeValue("value"));
                continue;
            }
            if (!entry.getName().equals("chartPattern")) continue;
            pattern = paletteItem.addElement("pattern");
            pattern.addElement("type").setText(this.getType(entry.attributeValue("patternType")));
            pattern.addElement("bgTransparent").setText("false");
            Element bgColor = pattern.addElement("bgColor");
            this.setColor(bgColor, entry.attributeValue("backgroundColor"));
            Element fgColor = pattern.addElement("fgColor");
            this.setColor(fgColor, entry.attributeValue("foregroundColor"));
        }
    }

    private String getType(String patternType) {
        return "ePattern" + patternType.substring(0, 1).toUpperCase() + patternType.substring(1);
    }

    private String getAngle(String direction) {
        if (direction.equals("down")) {
            return "270";
        }
        if (direction.equals("up")) {
            return "90";
        }
        if (direction.equals("left")) {
            return "180";
        }
        return null;
    }

    private void processGradientColor(Element parent, String color, boolean from) {
        Element colorE = parent.addElement("colors").addElement("color");
        this.setColor(colorE, color);
        colorE.getParent().addElement("percent").setText(from ? "0.000000" : "100.000000");
    }

    private void setColor(Element colorE, String color) {
        if (!color.startsWith("#")) {
            Color cc = colorMap.get(color);
            if (cc == null) {
                throw new RuntimeException("unrecognized color: " + color);
            }
            color = "#" + this.toHex(colorMap.get(color));
        }
        colorE.addElement("red").setText("0x" + color.substring(1, 3));
        colorE.addElement("green").setText("0x" + color.substring(3, 5));
        colorE.addElement("blue").setText("0x" + color.substring(5, 7));
        colorE.addElement("alpha").setText("255");
    }

    private String toHex(Color c) {
        return this.toDoubleDigitsHex(c.getRed()) + this.toDoubleDigitsHex(c.getGreen()) + this.toDoubleDigitsHex(c.getBlue());
    }

    private String toDoubleDigitsHex(int i) {
        String hex = Integer.toHexString(i);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    static {
        colorMap.put("red", Color.RED);
        colorMap.put("green", Color.GREEN);
        colorMap.put("grey", Color.GRAY);
        colorMap.put("black", Color.BLACK);
        colorMap.put("white", Color.WHITE);
        colorMap.put("blue", Color.BLUE);
        colorMap.put("yellow", Color.YELLOW);
        colorMap.put("navy", new Color(128));
        colorMap.put("purple", new Color(0x800080));
    }
}

