/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.utility;

import com.cognos.rap.exceptions.ActionException;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.List;

public class JSONUtility {
    public static JSONObject parse(String md) throws ActionException {
        md = md.replace("\\>", ">");
        md = md.replace("\\&", "&");
        try {
            return (JSONObject)JSON.parse((String)md);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new ActionException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ActionException(e);
        }
    }

    public static String javascriptencode(String str) {
        StringBuilder sbuf = new StringBuilder();
        if (str != null) {
            String prev;
            String strLocal = str;
            do {
                prev = strLocal;
            } while (!(strLocal = strLocal.replaceAll("<\\/[sS][cC][rR][iI][pP][tT]", "")).equals(prev));
            block12: for (int i = 0; i < strLocal.length(); ++i) {
                char x = strLocal.charAt(i);
                switch (x) {
                    case '\b': {
                        sbuf.append("\\b");
                        continue block12;
                    }
                    case '\t': {
                        sbuf.append("\\t");
                        continue block12;
                    }
                    case '\n': {
                        sbuf.append("\\n");
                        continue block12;
                    }
                    case '\u000b': {
                        sbuf.append("\\v");
                        continue block12;
                    }
                    case '\f': {
                        sbuf.append("\\f");
                        continue block12;
                    }
                    case '\r': {
                        sbuf.append("\\r");
                        continue block12;
                    }
                    case '\"': {
                        sbuf.append("\\\"");
                        continue block12;
                    }
                    case '\'': {
                        sbuf.append("\\'");
                        continue block12;
                    }
                    case '\\': {
                        sbuf.append("\\\\");
                        continue block12;
                    }
                    default: {
                        sbuf.append(x);
                    }
                }
            }
        }
        return sbuf.toString();
    }

    public static JSONArray StringList2JSONArray(List<String> stringList) {
        JSONArray result = new JSONArray();
        for (String param : stringList) {
            result.add((Object)param);
        }
        return result;
    }
}

