/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.utility;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class RAPMessageManager {
    private static final RAPMessageManager instance = new RAPMessageManager();
    private HashMap<String, ResourceBundle> resourceMap = new HashMap();
    private static final String resourceFile = "viewer";

    protected RAPMessageManager() {
    }

    public static String convert(String key, String locale) {
        return instance.getMessage(new Locale(locale), key);
    }

    public static String convert(String key, String locale, Object[] args) {
        return instance.getMessage(new Locale(locale), key, args);
    }

    public static String toJavaString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        if (country.length() == 0) {
            return locale.getLanguage();
        }
        StringBuffer ret = new StringBuffer();
        ret.append(locale.getLanguage()).append("_").append(country.toUpperCase());
        return ret.toString();
    }

    protected String getMessage(Locale locale, String key) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        if (resourceBundle != null) {
            return resourceBundle.getString(key);
        }
        return key;
    }

    protected String getMessage(Locale locale, String sKey, Object[] args) {
        String rawMessage = this.getMessage(locale, sKey);
        if (rawMessage == null) {
            return sKey;
        }
        StringBuffer newMsgFormat = new StringBuffer(rawMessage.length());
        int idx = 0;
        while ((idx = rawMessage.indexOf(39)) != -1) {
            newMsgFormat.append(rawMessage.substring(0, idx));
            newMsgFormat.append("''");
            rawMessage = rawMessage.substring(idx + 1);
        }
        newMsgFormat.append(rawMessage);
        return MessageFormat.format(newMsgFormat.toString(), args);
    }

    private synchronized ResourceBundle getResourceBundle(Locale locale) {
        String mapKey = RAPMessageManager.toJavaString(locale);
        if (!this.resourceMap.containsKey(mapKey)) {
            this.resourceMap.put(mapKey, ResourceBundle.getBundle(resourceFile, locale));
        }
        return this.resourceMap.get(mapKey);
    }
}

