/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rap.utility;

import com.cognos.rap.actions.v5spechelpers.V5X;
import com.cognos.rap.utility.RAPLogger;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.io.SAXReader;

public class XMLUtility {
    public static final String DTD_PATH = "../schemas/rspec/7.0/V5_report.dtd";
    public static Map<String, Collection<AttributeDecl>> ElementAttributeMap = null;

    public static Document createXMLDocument(String xmlString) {
        return com.cognos.viewer.utility.XMLUtility.createXMLDocument(xmlString);
    }

    public static Document createXMLDocument(File file) throws IOException {
        return com.cognos.viewer.utility.XMLUtility.createXMLDocument(file);
    }

    public static void cloneChildNode(Element target, Element source, String tagName) {
        Element sourceChild = (Element)source.selectSingleNode(V5X.select(tagName));
        if (sourceChild != null) {
            Element targetChild = (Element)target.selectSingleNode(V5X.select(tagName));
            if (targetChild != null) {
                targetChild.detach();
            }
            target.add((Element)sourceChild.clone());
        }
    }

    public static void copyAttribute(Element source, Element target, String attributeName) {
        AttributeDecl attributeDecl;
        if (source.attributeValue(attributeName) == null) {
            return;
        }
        if (target.attribute(attributeName) != null && (attributeDecl = XMLUtility.getAttributeDecl(target.getName(), attributeName)) != null && attributeDecl.getValue() != null && !attributeDecl.getValue().equals(target.attributeValue(attributeName))) {
            return;
        }
        target.addAttribute(attributeName, source.attributeValue(attributeName));
    }

    public static AttributeDecl getAttributeDecl(String elementName, String attributeName) {
        Collection<AttributeDecl> attributeDecls = XMLUtility.getAttributeDecls(elementName);
        if (attributeDecls == null) {
            return null;
        }
        for (AttributeDecl attributeDecl : attributeDecls) {
            if (!attributeDecl.getAttributeName().equals(attributeName)) continue;
            return attributeDecl;
        }
        return null;
    }

    public static synchronized Collection<AttributeDecl> getAttributeDecls(String elementName) {
        if (ElementAttributeMap == null) {
            ElementAttributeMap = new HashMap<String, Collection<AttributeDecl>>();
            SAXReader saxReader = new SAXReader(true);
            saxReader.setIncludeExternalDTDDeclarations(true);
            String reportString = "<!DOCTYPE report SYSTEM \"../schemas/rspec/7.0/V5_report.dtd\"><report xmlns=\"http://developer.cognos.com/schemas/report/7.0/\" expressionLocale=\"en-us\"></report>";
            Document document = null;
            try {
                document = saxReader.read((Reader)new StringReader(reportString));
            }
            catch (DocumentException e) {
                RAPLogger.error(e, XMLUtility.class);
                return null;
            }
            DocumentType docType = document.getDocType();
            List decls = docType.getExternalDeclarations();
            for (Object decl : decls) {
                if (!(decl instanceof AttributeDecl)) continue;
                AttributeDecl attrDecl = (AttributeDecl)decl;
                Collection<AttributeDecl> attributes = ElementAttributeMap.get(attrDecl.getElementName());
                if (attributes == null) {
                    attributes = new ArrayList<AttributeDecl>();
                    ElementAttributeMap.put(attrDecl.getElementName(), attributes);
                }
                attributes.add(attrDecl);
            }
        }
        return ElementAttributeMap.get(elementName);
    }

    public static Element addElementWithAttributes(Element parent, String childElementName) {
        Element child = parent.addElement(childElementName);
        Collection<AttributeDecl> attributes = XMLUtility.getAttributeDecls(childElementName);
        if (attributes != null) {
            for (AttributeDecl attribute : attributes) {
                if (attribute.getValue() == null) continue;
                child.addAttribute(attribute.getAttributeName(), attribute.getValue());
            }
        }
        return child;
    }

    public static Element createElementInSameNamespace(String name, Element nsElement) {
        Element result = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"textItem", (Namespace)nsElement.getNamespace()));
        return result;
    }

    public static Element removeNodeAndEmptyParentChain(Element node, Collection<String> stopNodeNames) {
        Element parent = node.getParent();
        node.detach();
        if (parent.elements().size() == 0 && !stopNodeNames.contains(parent.getName())) {
            return XMLUtility.removeNodeAndEmptyParentChain(parent, stopNodeNames);
        }
        return parent;
    }

    public static String xmlencode(String value) {
        if (value != null) {
            int rsize = value.length() * 4;
            StringBuilder sbuf = new StringBuilder(rsize);
            block7: for (int i = 0; i < value.length(); ++i) {
                char x = value.charAt(i);
                switch (x) {
                    case '\'': {
                        sbuf.append("&apos;");
                        continue block7;
                    }
                    case '<': {
                        sbuf.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sbuf.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        sbuf.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        sbuf.append("&quot;");
                        continue block7;
                    }
                    default: {
                        sbuf.append(x);
                    }
                }
            }
            return sbuf.toString();
        }
        return "";
    }

    public static String encodeXMLAttribute(String value) {
        return value.replace("\"", "&quot;");
    }

    public static List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    public static List selectNodes(Element e, String xPath) {
        return e.selectNodes(xPath);
    }
}

