/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.viewer.action.AddNotificationAction;
import com.cognos.viewer.action.AuthoredDrillThrough2Action;
import com.cognos.viewer.action.BuxAction;
import com.cognos.viewer.action.BuxCopyPasteAction;
import com.cognos.viewer.action.BuxDropReportOnCanvasAction;
import com.cognos.viewer.action.BuxRunAction;
import com.cognos.viewer.action.BuxRunSpecAction;
import com.cognos.viewer.action.BuxRunSpecificationAction;
import com.cognos.viewer.action.BuxViewAction;
import com.cognos.viewer.action.CMRequestAction;
import com.cognos.viewer.action.CachedOutputAction;
import com.cognos.viewer.action.CancelAction;
import com.cognos.viewer.action.CommentSaveAction;
import com.cognos.viewer.action.ContextAction;
import com.cognos.viewer.action.CreateAnnotationAction;
import com.cognos.viewer.action.DeleteAnnotationAction;
import com.cognos.viewer.action.DeleteNotificationAction;
import com.cognos.viewer.action.DeleteSubscriptionAction;
import com.cognos.viewer.action.DrillAction;
import com.cognos.viewer.action.EditAction;
import com.cognos.viewer.action.EmailAction;
import com.cognos.viewer.action.GetAnnotationInfoAction;
import com.cognos.viewer.action.GetInfoFromReportSpecAction;
import com.cognos.viewer.action.GetJSONLogsAction;
import com.cognos.viewer.action.GetObjectContextAction;
import com.cognos.viewer.action.GetParametersAction;
import com.cognos.viewer.action.GetSubscriptionInfoAction;
import com.cognos.viewer.action.GetTransientsAction;
import com.cognos.viewer.action.ICognosViewerAction;
import com.cognos.viewer.action.LineageAction;
import com.cognos.viewer.action.MobileScheduledAction;
import com.cognos.viewer.action.ModifyReportAction;
import com.cognos.viewer.action.NewAction;
import com.cognos.viewer.action.NoOpAction;
import com.cognos.viewer.action.ObjectDefaultAction;
import com.cognos.viewer.action.OutputAction;
import com.cognos.viewer.action.PageAction;
import com.cognos.viewer.action.ReleaseAction;
import com.cognos.viewer.action.RenderAction;
import com.cognos.viewer.action.ReportAction;
import com.cognos.viewer.action.ResetToOriginalAction;
import com.cognos.viewer.action.RunAction;
import com.cognos.viewer.action.RunIconAction;
import com.cognos.viewer.action.RunInteractiveAction;
import com.cognos.viewer.action.RunLineageSpecificationAction;
import com.cognos.viewer.action.RunPowerPlayAction;
import com.cognos.viewer.action.RunSpecificationAction;
import com.cognos.viewer.action.SaveAsAction;
import com.cognos.viewer.action.SaveInDashboardAction;
import com.cognos.viewer.action.SaveJSONLogsAction;
import com.cognos.viewer.action.SecondaryRequestAction;
import com.cognos.viewer.action.UndoRedoAction;
import com.cognos.viewer.action.UpdateAnnotationAction;
import com.cognos.viewer.action.UpdateSavedReportAction;
import com.cognos.viewer.action.ViewAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.MessageManager;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class ActionFactory {
    private CognosViewerServiceFactory m_serviceFactory = null;
    private static HashMap<String, Constructor> m_actionClasses = new HashMap();

    public ActionFactory(CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        this.m_serviceFactory = serviceFactory;
    }

    public static synchronized void setActionClass(String action, Constructor constructor) {
        m_actionClasses.put(action, constructor);
    }

    public ICognosViewerAction load(ICognosViewerState state) throws CognosViewerException {
        ICognosViewerAction action = null;
        if ("meta-only".equals(state.getFormFieldAsString("frag-directive"))) {
            action = new NoOpAction();
            action.initialize(state, this.m_serviceFactory);
        } else {
            String sActionState = state.getFormFieldAsString("cv.actionState");
            String sAction = state.getFormFieldAsString("ui.primaryAction");
            if (sAction.length() == 0 || sActionState.length() == 0) {
                sAction = state.getAction();
            }
            action = this.load(sAction, state);
        }
        return action;
    }

    public ICognosViewerAction load(String sAction, ICognosViewerState state) throws CognosViewerException {
        ICognosViewerAction action = null;
        Constructor actionConstructor = null;
        try {
            actionConstructor = "".equals(sAction) ? ObjectDefaultAction.class.getConstructor(null) : ((CognosViewerDispatcherHandler.isSortEnabled(state) || CognosViewerDispatcherHandler.isExpandCollapseEnabled()) && "run".equals(sAction) && !"false".equals(state.getObject("LOAD_INTERACTIVE_ACTION")) ? RunInteractiveAction.class.getConstructor(null) : m_actionClasses.get(sAction));
            if (actionConstructor == null && (actionConstructor = this.loadUsingReflection(sAction)) != null) {
                m_actionClasses.put(sAction, actionConstructor);
            }
            action = (ICognosViewerAction)actionConstructor.newInstance(null);
            action.initialize(state, this.m_serviceFactory);
        }
        catch (Exception e) {
            this.throwActionError(e, state.getAction(), state);
        }
        return action;
    }

    public Constructor loadUsingReflection(String sAction) throws Exception {
        char[] acAction = sAction.toCharArray();
        acAction[0] = Character.toUpperCase(acAction[0]);
        String sActionClass = new String(acAction) + "Action";
        Class<?> actionClass = Class.forName("com.cognos.viewer.action." + sActionClass);
        return actionClass.getConstructor(null);
    }

    public void throwActionError(Exception e, String action, ICognosViewerState state) throws CognosViewerException {
        if (!MessageManager.isInitialized()) {
            MessageManager.initialize();
        }
        CognosViewerException cognosViewerException = new CognosViewerException(state.getBusEnvelope(), MessageManager.convert("RV_ACTION_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(state)) + " : " + action, e);
        throw cognosViewerException;
    }

    static {
        try {
            m_actionClasses.put("run", RunAction.class.getConstructor(null));
            m_actionClasses.put("runInteractive", RunInteractiveAction.class.getConstructor(null));
            m_actionClasses.put("runSpecification", RunSpecificationAction.class.getConstructor(null));
            m_actionClasses.put("runPowerPlay", RunPowerPlayAction.class.getConstructor(null));
            m_actionClasses.put("runIcon", RunIconAction.class.getConstructor(null));
            m_actionClasses.put("firstPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("nextPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("previousPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("lastPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("reportAction", ReportAction.class.getConstructor(null));
            m_actionClasses.put("currentPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("lastPage", PageAction.class.getConstructor(null));
            m_actionClasses.put("forward", SecondaryRequestAction.class.getConstructor(null));
            m_actionClasses.put("back", SecondaryRequestAction.class.getConstructor(null));
            m_actionClasses.put("render", RenderAction.class.getConstructor(null));
            m_actionClasses.put("save", SecondaryRequestAction.class.getConstructor(null));
            m_actionClasses.put("saveAs", SaveAsAction.class.getConstructor(null));
            m_actionClasses.put("cancel", CancelAction.class.getConstructor(null));
            m_actionClasses.put("release", ReleaseAction.class.getConstructor(null));
            m_actionClasses.put("drill", DrillAction.class.getConstructor(null));
            m_actionClasses.put("edit", EditAction.class.getConstructor(null));
            m_actionClasses.put("addNotification", AddNotificationAction.class.getConstructor(null));
            m_actionClasses.put("cachedOutput", CachedOutputAction.class.getConstructor(null));
            m_actionClasses.put("deleteNotification", DeleteNotificationAction.class.getConstructor(null));
            m_actionClasses.put("deleteSubscription", DeleteSubscriptionAction.class.getConstructor(null));
            m_actionClasses.put("getContext", ContextAction.class.getConstructor(null));
            m_actionClasses.put("lineage", LineageAction.class.getConstructor(null));
            m_actionClasses.put("getObjectContext", GetObjectContextAction.class.getConstructor(null));
            m_actionClasses.put("getSubscriptionInfo", GetSubscriptionInfoAction.class.getConstructor(null));
            m_actionClasses.put("new", NewAction.class.getConstructor(null));
            m_actionClasses.put("output", OutputAction.class.getConstructor(null));
            m_actionClasses.put("view", ViewAction.class.getConstructor(null));
            m_actionClasses.put("objectDefault", ObjectDefaultAction.class.getConstructor(null));
            m_actionClasses.put("getTransients", GetTransientsAction.class.getConstructor(null));
            m_actionClasses.put("getParameters", GetParametersAction.class.getConstructor(null));
            m_actionClasses.put("noop", NoOpAction.class.getConstructor(null));
            m_actionClasses.put("CMRequest", CMRequestAction.class.getConstructor(null));
            m_actionClasses.put("email", EmailAction.class.getConstructor(null));
            m_actionClasses.put("deleteAnnotation", DeleteAnnotationAction.class.getConstructor(null));
            m_actionClasses.put("getAnnotationInfo", GetAnnotationInfoAction.class.getConstructor(null));
            m_actionClasses.put("createAnnotation", CreateAnnotationAction.class.getConstructor(null));
            m_actionClasses.put("updateAnnotation", UpdateAnnotationAction.class.getConstructor(null));
            m_actionClasses.put("saveInDashboard", SaveInDashboardAction.class.getConstructor(null));
            m_actionClasses.put("modifyReport", ModifyReportAction.class.getConstructor(null));
            m_actionClasses.put("updateSavedReport", UpdateSavedReportAction.class.getConstructor(null));
            m_actionClasses.put("runLineageSpecification", RunLineageSpecificationAction.class.getConstructor(null));
            m_actionClasses.put("getInfoFromReportSpec", GetInfoFromReportSpecAction.class.getConstructor(null));
            m_actionClasses.put("buxDropReportOnCanvas", BuxDropReportOnCanvasAction.class.getConstructor(null));
            m_actionClasses.put("commentSave", CommentSaveAction.class.getConstructor(null));
            m_actionClasses.put("authoredDrillThrough", AuthoredDrillThrough2Action.class.getConstructor(null));
            m_actionClasses.put("undo", UndoRedoAction.class.getConstructor(null));
            m_actionClasses.put("runBux", BuxRunAction.class.getConstructor(null));
            m_actionClasses.put("buxRunSpecification", BuxRunSpecificationAction.class.getConstructor(null));
            m_actionClasses.put("buxRunSpec", BuxRunSpecAction.class.getConstructor(null));
            m_actionClasses.put("resetToOriginal", ResetToOriginalAction.class.getConstructor(null));
            m_actionClasses.put("buxView", BuxViewAction.class.getConstructor(null));
            m_actionClasses.put("bux", BuxAction.class.getConstructor(null));
            m_actionClasses.put("mobileScheduled", MobileScheduledAction.class.getConstructor(null));
            m_actionClasses.put("buxCopyPaste", BuxCopyPasteAction.class.getConstructor(null));
            m_actionClasses.put("getJSONLogs", GetJSONLogsAction.class.getConstructor(null));
            m_actionClasses.put("saveJSONLogs", SaveJSONLogsAction.class.getConstructor(null));
        }
        catch (NoSuchMethodException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

