/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.rap.exceptions.CognosServiceRequestException;
import com.cognos.rap.exceptions.UnsupportedSpecificationException;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.BuxAction;
import com.cognos.viewer.action.BuxCMQueryHelper;
import com.cognos.viewer.action.BuxGetParametersSubAction;
import com.cognos.viewer.action.ModifyReportAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.controller.CognosViewerRAPException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.GoDashboardPreprocessor;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.PPFilterToParameter;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ActionHelper {
    private static final String BASE64 = "base64";
    private static final String PERMISSIONS = "permissions";
    private static final String OBJECT_CLASS = "objectClass";
    private static final String ROUTING_SERVER_GROUP = "routingServerGroup";
    private static final String DEFAULT_NAME = "defaultName";
    private static final String EXECUTION_FORMAT = "executionFormat";
    private static final String HTML = "HTML";
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final String XSLURL = "rv.xsl";
    private static final String OUTPUTFORMAT = "HTMLFragment";
    private static final String OUTPUTFORMAT_RS_ONLY = "XHTMLFRGMT";
    private static final String PRIMARYWAITTHRESHOLD = "3";
    private static final String WIDGET_DISPLAY_TITLE = "displayTitle";

    public static void setDefaultOptions(ICognosViewerState state) throws CognosViewerException {
        String sUseFormat = "";
        String sObjectClass = state.getFormFieldAsString("ui.objectClass");
        sUseFormat = "rs".equals(state.getFormFieldAsString("cv.responseFormat")) ? OUTPUTFORMAT_RS_ONLY : ("powerPlayReport".equals(sObjectClass) || "powerPlay8Report".equals(sObjectClass) || "powerPlay8ReportView".equals(sObjectClass) ? "PDF" : OUTPUTFORMAT);
        OptionManager optionMgr = state.getOptionManager();
        HashMap aOptions = optionMgr.getOptions();
        String sOutputFormat = null;
        if (aOptions.containsKey(OUTPUT_FORMAT)) {
            RunOptionStringArray outputFormat = (RunOptionStringArray)aOptions.get(OUTPUT_FORMAT);
            String[] asOutputFormat = outputFormat.getValue();
            if (asOutputFormat.length > 0) {
                sOutputFormat = asOutputFormat[0];
            }
        } else {
            sOutputFormat = state.getUserPreference("format");
            if (sOutputFormat.length() > 0 && !CognosViewerDispatcherHandler.hasFormatCapability(state, sOutputFormat)) {
                sOutputFormat = null;
            }
            if (sOutputFormat == null || sOutputFormat.length() == 0) {
                sOutputFormat = sUseFormat;
            }
        }
        if (sOutputFormat == null || !sOutputFormat.equals(sUseFormat) && (sOutputFormat.indexOf(HTML) >= 0 || "MHT".equals(sOutputFormat))) {
            sOutputFormat = sUseFormat;
        }
        optionMgr.addOption("run.outputFormat", sOutputFormat);
        if (optionMgr.getOption(RunOptionEnum.outputEncapsulation.toString()) == null) {
            String sOutputEncapsulation = "none";
            if (sOutputFormat.indexOf(HTML) == -1 && sOutputFormat.compareTo("XML") != 0) {
                sOutputEncapsulation = "URLQueryString";
            }
            optionMgr.addOption("run.outputEncapsulation", sOutputEncapsulation);
        }
        if (!aOptions.containsKey("xslURL")) {
            optionMgr.addOption("run.xslURL", XSLURL);
        }
        optionMgr.setPrimaryWaitThreshold(PRIMARYWAITTHRESHOLD, true);
        optionMgr.setSecondaryWaitThreshold(null, true);
        if (optionMgr.getOption("alwaysIncludePrimaryRequest") == null) {
            optionMgr.addOption("asynch.alwaysIncludePrimaryRequest", "true");
        }
        if (optionMgr.getOption(AsynchOptionEnum.attachmentEncoding.toString()) == null) {
            if (sOutputFormat.indexOf(HTML) != -1) {
                ActionHelper.addMIMEEncodingOption(state);
            } else {
                optionMgr.addOption("asynch.attachmentEncoding", BASE64);
            }
        }
        if (state.isBUX()) {
            boolean flashChartOption = state.getDefaultFlashChartOptionValue();
            String sAVS = state.getFormFieldAsString("hasAVSChart");
            if (flashChartOption && ("true".equals(sAVS) || state.isFlashChartOptionDisabled())) {
                flashChartOption = false;
            }
            GenericOptionBoolean genericOptionBoolean = new GenericOptionBoolean();
            genericOptionBoolean.setName("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts");
            genericOptionBoolean.setValue(flashChartOption);
            optionMgr.addOption("http://developer.cognos.com/ceba/constants/systemOptionEnum#flashCharts", (Option)genericOptionBoolean);
            ActionHelper.addDefaultReportNameOption(optionMgr, state);
        }
        ActionHelper.addReturnOutputWhenAvailableOption(state.getOptionManager());
        ActionHelper.setContextBlockSize(state);
        if (CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_PAGING") != null) {
            GenericOptionAnyURI genericOptionAnyURI = new GenericOptionAnyURI();
            genericOptionAnyURI.setName("http://developer.cognos.com/ceba/constants/runOptionEnum#pagination");
            genericOptionAnyURI.setValue(CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_PAGING"));
            optionMgr.addOption("http://developer.cognos.com/ceba/constants/runOptionEnum#pagination", (Option)genericOptionAnyURI);
        }
    }

    private static void addDefaultReportNameOption(OptionManager optionMgr, ICognosViewerState state) {
        String widgetTitle;
        if (state != null && (widgetTitle = state.getFormFieldAsString(WIDGET_DISPLAY_TITLE)) != null && widgetTitle.length() > 0) {
            GenericOptionAnyURI genericOptionAnyURI = new GenericOptionAnyURI();
            genericOptionAnyURI.setName("http://developer.cognos.com/ceba/constants/runOptionEnum#reportName");
            genericOptionAnyURI.setValue(widgetTitle);
            optionMgr.addOption("http://developer.cognos.com/ceba/constants/runOptionEnum#reportName", (Option)genericOptionAnyURI);
        }
    }

    public static void addParameterValues(ICognosViewerState state) throws CognosViewerException {
        String sDrillThroughTargetParameterValues;
        String sGDPromptAnswers;
        String sParameterValues;
        String sSoapSpecification;
        ParameterValueManager parameterValueManager = state.getParameterValueManager();
        String sPPFilter = state.getFormFieldAsString("filter");
        if (sPPFilter.length() != 0 && (sSoapSpecification = PPFilterToParameter.GetParametersFromFilter(sPPFilter)) != null && sSoapSpecification.length() > 0) {
            parameterValueManager.addParameterValues(sSoapSpecification);
        }
        if ((sParameterValues = state.getFormFieldAsString("parameterValues")).length() > 0) {
            ParameterValueManager copyParameters = new ParameterValueManager();
            copyParameters.addParameterValues(sParameterValues);
            if (copyParameters.toArray().length == 0 && state.doParametersNeedCafProtection()) {
                if (!sParameterValues.startsWith("<")) {
                    sParameterValues = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sParameterValues), (boolean)true);
                }
                copyParameters.addParameterValues(sParameterValues);
                parameterValueManager.addParameterValues(copyParameters.getCredentialParameters());
            } else {
                parameterValueManager.addParameterValues(copyParameters.toArray());
            }
        }
        if ((sGDPromptAnswers = state.getFormFieldAsString("gdPromptAnswers")).length() > 0) {
            GoDashboardPreprocessor gdPreprocessor = new GoDashboardPreprocessor(state);
            parameterValueManager.addParameterValues(gdPreprocessor.parsePromptAnswers(sGDPromptAnswers));
        }
        if ((sDrillThroughTargetParameterValues = state.getFormFieldAsString("drillThroughTargetParameterValues")).length() > 0) {
            sDrillThroughTargetParameterValues = XTSExt.web64decode((String)sDrillThroughTargetParameterValues, (boolean)true);
            parameterValueManager.addParameterValues(sDrillThroughTargetParameterValues);
        }
        if ((sDrillThroughTargetParameterValues = state.getFormFieldAsString("ui.drillThroughTargetParameterValues")).length() > 0) {
            sDrillThroughTargetParameterValues = XTSExt.web64decode((String)sDrillThroughTargetParameterValues, (boolean)true);
            parameterValueManager.addParameterValues(sDrillThroughTargetParameterValues);
        }
    }

    public static void addParameterValuesFromConversation(ICognosViewerState state) {
        if (state.getConversation() == null) {
            return;
        }
        ParameterValue[] convParameters = state.getConversation().getParameters();
        ActionHelper.addMissingParameterValuesToParameterManager(convParameters, state.getParameterValueManager());
    }

    public static void addMissingParameterValuesToParameterManager(ParameterValue[] parameters, ParameterValueManager parameterValueManager) {
        if (parameters == null) {
            return;
        }
        if (parameterValueManager == null) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String sParameterName = parameters[i].getName();
            if (parameterValueManager.getParameterValue(sParameterName) != null) continue;
            parameterValueManager.addParameterValue(parameters[i]);
        }
    }

    public static HashMap<String, String> getRAPParameterUpdateMap(ICognosViewerState state) {
        ParameterValueManager parameterValueManager = state.getParameterValueManager();
        if (parameterValueManager == null) {
            return null;
        }
        return parameterValueManager.getRAPParameterUpdateMap();
    }

    public static void applyRAPParameterUpdates(ICognosViewerState state) throws CognosViewerException {
        ParameterValueManager parameterValueManager = state.getParameterValueManager();
        if (parameterValueManager == null) {
            return;
        }
        parameterValueManager.applyRAPParameterUpdates();
    }

    public static void setPromptOption(ICognosViewerState state) throws CognosViewerException {
        OptionManager optionMgr = state.getOptionManager();
        RunOptionBoolean promptRunOption = (RunOptionBoolean)optionMgr.getOption("prompt");
        if (promptRunOption != null) {
            if (state.getFormFieldAsString("promptOnRerun").length() == 0) {
                String executionPrompt = state.getFormFieldAsString("executionPrompt");
                if (state.getFormFieldAsString("cv.objectPermissions").length() > 0 && state.getFormFieldAsString("cv.objectPermissions").indexOf("read") == -1) {
                    executionPrompt = "true";
                } else if (executionPrompt.length() == 0) {
                    executionPrompt = Boolean.toString(promptRunOption.isValue());
                }
                state.setFormFieldFromString("promptOnRerun", executionPrompt);
            }
        } else if ("true".equals(state.getFormFieldAsString("fragment.waitForPromptValues"))) {
            optionMgr.addOption("run.prompt", "false");
            state.setFormFieldFromString("promptOnRerun", "false");
        } else if (state.getFormFieldAsString("filter").length() > 0) {
            optionMgr.addOption("run.prompt", "false");
            state.setFormFieldFromString("promptOnRerun", state.getFormFieldAsString("executionPrompt"));
        } else if (!state.isBUX() && state.getFormFieldAsString("ui.spec").length() > 0) {
            optionMgr.addOption("run.prompt", "false");
            state.setFormFieldFromString("promptOnRerun", "true");
        } else if (state.getFormFieldAsString("executionPrompt").length() > 0) {
            optionMgr.addOption("run.prompt", state.getFormFieldAsString("executionPrompt"));
            state.setFormFieldFromString("promptOnRerun", state.getFormFieldAsString("executionPrompt"));
        } else if (state.getFormFieldAsString("cv.objectPermissions").length() > 0 && state.getFormFieldAsString("cv.objectPermissions").indexOf("read") == -1) {
            state.setFormFieldFromString("promptOnRerun", "true");
        }
    }

    public static boolean isInitialRequest(ICognosViewerState state) {
        String sConversation = state.getFormFieldAsString("ui.conversation");
        return sConversation.length() == 0;
    }

    public static void addContextOptions(ICognosViewerState state) throws CognosViewerException {
        String sContextSelection;
        String sContextType;
        OptionManager optionManager = state.getOptionManager();
        String sContextFormat = state.getFormFieldAsString("context.format");
        if (sContextFormat.length() > 0) {
            optionManager.addOption("context.format", sContextFormat);
        }
        if ((sContextType = state.getFormFieldAsString("context.type")).length() > 0) {
            optionManager.addOption("context.type", sContextType);
        }
        if ((sContextSelection = state.getFormFieldAsString("context.selection")).length() > 0) {
            optionManager.addOption("context.selection", sContextSelection);
        }
    }

    public static void addOptionsFromConversation(ICognosViewerState state) throws CognosViewerException {
        Option[] options;
        AsynchRequest conversation = state.getConversation();
        if (conversation != null && (options = conversation.getOptions()) != null) {
            OptionManager optionManager = state.getOptionManager();
            optionManager.addOptions(options, false);
        }
    }

    public static void addObjectPropertiesToState(ICognosViewerState state, CMServerResponse cmResponse) throws CognosViewerException {
        String sFormat;
        String sObjectClass;
        Option outputFormatOption;
        if (cmResponse.getProperty(EXECUTION_FORMAT).length() > 0 && (outputFormatOption = state.getOptionManager().getOption(OUTPUT_FORMAT)) == null && ("view".equals(state.getAction()) || CognosViewerDispatcherHandler.hasFormatCapability(state, cmResponse.getProperty(EXECUTION_FORMAT)))) {
            state.getOptionManager().addOption("run.outputFormat", cmResponse.getProperty(EXECUTION_FORMAT));
            state.setFormFieldFromString("run.outputFormat", cmResponse.getProperty(EXECUTION_FORMAT));
        }
        if (cmResponse.getProperty("executionPrompt").length() > 0) {
            state.setFormFieldFromString("executionPrompt", cmResponse.getProperty("executionPrompt"));
        }
        if (state.getFormFieldAsString("authoredDrill.request").length() > 0 || "".equals(state.getFormFieldAsString("ui.name")) && cmResponse.getProperty(DEFAULT_NAME).length() > 0) {
            state.setFormFieldFromString("ui.name", cmResponse.getProperty(DEFAULT_NAME));
        }
        if (cmResponse.getProperty(ROUTING_SERVER_GROUP).length() > 0) {
            state.setFormFieldFromString("ui.routingServerGroup", cmResponse.getProperty(ROUTING_SERVER_GROUP));
        }
        if ((sObjectClass = cmResponse.getProperty(OBJECT_CLASS)).length() > 0) {
            state.setFormFieldFromString("ui.objectClass", sObjectClass);
        }
        if ("reportView".equals(state.getFormFieldAsString("ui.objectClass"))) {
            ActionHelper.addBaseObjectClass(state, cmResponse);
        }
        if (state.getFormFieldAsString("cv.objectPermissions").length() == 0) {
            ActionHelper.addObjectPermissionsToState(state, cmResponse, -1);
        }
        if (state.getFormFieldAsString("packageBase").length() <= 0) {
            String sPackageBase = cmResponse.getStringValue(cmResponse.getRootXPath() + "/metadataModelPackage/value/item/searchPath/value");
            if (sPackageBase.length() > 0) {
                state.setFormFieldFromString("packageBase", sPackageBase);
            } else {
                Element packageSearchPath = cmResponse.queryForNode(cmResponse.getRootXPath() + "/ancestors/value/item[./objectClass = 'package']/searchPath");
                if (packageSearchPath == null) {
                    packageSearchPath = cmResponse.queryForNode(cmResponse.getRootXPath() + "/item[@xsi:type='bus:package']/searchPath/value");
                }
                if (packageSearchPath != null) {
                    state.setFormFieldFromString("packageBase", packageSearchPath.getText());
                }
            }
        }
        if (state.getFormFieldAsString("modelPath").length() <= 0) {
            String sPackageBase;
            String sModelPath = cmResponse.getStringValue(cmResponse.getRootXPath() + "/metadataModel/value/item/searchPath/value");
            if (sModelPath.length() == 0) {
                sModelPath = cmResponse.getStringValue(cmResponse.getRootXPath() + "/base/value/item/metadataModel/value/item/searchPath/value");
            }
            if (sModelPath.length() == 0 && (sPackageBase = state.getFormFieldAsString("packageBase")).length() != 0) {
                sModelPath = sPackageBase + "/model[last()]";
            }
            state.setFormFieldFromString("modelPath", sModelPath);
        }
        if (cmResponse.getProperty("searchPath").length() > 0) {
            state.addObject("searchPath", cmResponse.getProperty("searchPath"));
        }
        if ((CognosViewerDispatcherHandler.isSortEnabled(state) || CognosViewerDispatcherHandler.isExpandCollapseEnabled()) && HTML.equalsIgnoreCase(sFormat = ActionHelper.getExecutionFormat(state, cmResponse))) {
            BuxCMQueryHelper.setLimitedInteractiveMode(state, cmResponse, 1);
            if ("false".equals(state.getFormFieldAsString("limitedInteractiveMode"))) {
                ActionHelper.prepareForRunSpecification(state, cmResponse);
            }
        }
        if (state.getAction().equals("modifyCMReport")) {
            if (sObjectClass.equals("reportView")) {
                ActionHelper.addBaseReportSearchPath(state, cmResponse);
                ActionHelper.setPromptValuesForReportView(state, cmResponse);
            } else {
                ActionHelper.setPromptValues(state, cmResponse);
            }
        }
    }

    private static void prepareForRunSpecification(ICognosViewerState state, CMServerResponse cmResponse) throws CognosViewerException {
        Element optionsProp;
        if (cmResponse.getProperty(OBJECT_CLASS).equals("reportView")) {
            ActionHelper.addBaseReportSearchPath(state, cmResponse);
            ActionHelper.setPromptValuesForReportView(state, cmResponse);
        } else {
            ActionHelper.setPromptValues(state, cmResponse);
        }
        if (state.getOptionManager().getOption("verticalElements") == null && (optionsProp = cmResponse.getComplexProperty(PropEnum.options.getValue())) != null) {
            ActionHelper.addVerticalElementsToState(state, optionsProp);
        }
    }

    private static String getExecutionFormat(ICognosViewerState state, CMServerResponse cmResponse) {
        RunOptionStringArray outputFormat;
        String[] asOutputFormat;
        String sFormat = cmResponse.getContentFormat();
        OptionManager optionMgr = state.getOptionManager();
        HashMap aOptions = optionMgr.getOptions();
        if (aOptions.containsKey(OUTPUT_FORMAT) && (asOutputFormat = (outputFormat = (RunOptionStringArray)aOptions.get(OUTPUT_FORMAT)).getValue()).length > 0) {
            sFormat = asOutputFormat[0];
        }
        return sFormat;
    }

    public static void addBaseObjectClass(ICognosViewerState state, CMServerResponse cmResponse) {
        Element objectClassBaseProperty;
        Element baseProperty = cmResponse.getComplexProperty(PropEnum.base.getValue());
        if (baseProperty != null && (objectClassBaseProperty = (Element)baseProperty.selectSingleNode("./value/item/objectClass/value")) != null) {
            String sBaseObjectClass = objectClassBaseProperty.getText();
            state.setFormFieldFromString("baseReportObjectClass", sBaseObjectClass);
        }
    }

    public static void addBaseReportSearchPath(ICognosViewerState state, CMServerResponse cmResponse) {
        Element objectClassBaseProperty;
        Element baseProperty = cmResponse.getComplexProperty(PropEnum.base.getValue());
        if (baseProperty != null && (objectClassBaseProperty = (Element)baseProperty.selectSingleNode("./value/item/searchPath/value")) != null) {
            String sBaseObjectSearchPath = objectClassBaseProperty.getText();
            state.setFormFieldFromString("baseReportSearchPath", sBaseObjectSearchPath);
        }
    }

    public static void addObjectPermissionsToState(ICognosViewerState state, CMServerResponse cmResponse, int iQueryReply) {
        Element value;
        Element permissions = iQueryReply != -1 ? cmResponse.getComplexProperty(PERMISSIONS, iQueryReply) : cmResponse.getComplexProperty(PERMISSIONS);
        if (permissions != null && (value = permissions.element("value")) != null) {
            StringBuffer buffer = new StringBuffer();
            Iterator permissionsIterator = value.elementIterator();
            while (permissionsIterator.hasNext()) {
                Element permission = (Element)permissionsIterator.next();
                buffer.append(permission.getText() + " ");
            }
            state.setFormFieldFromString("cv.objectPermissions", buffer.toString());
        }
    }

    public static void addAncestorsTitlesToState(ICognosViewerState state, CMServerResponse cmResponse, int cmQueryReplyPosition) {
        StringBuilder sb = new StringBuilder();
        if (cmResponse != null) {
            List list;
            Element ancestors = null;
            String reportName = null;
            if (cmQueryReplyPosition != -1) {
                ancestors = cmResponse.getComplexProperty("ancestors", cmQueryReplyPosition);
                reportName = cmResponse.getProperty(DEFAULT_NAME, cmQueryReplyPosition);
            } else {
                ancestors = cmResponse.getComplexProperty("ancestors");
                reportName = cmResponse.getProperty(DEFAULT_NAME);
            }
            if (ancestors != null && (list = ancestors.selectNodes("value/item/title")) != null) {
                ListIterator itr = list.listIterator();
                while (itr.hasNext()) {
                    sb.append(((Element)itr.next()).getText()).append(" > ");
                }
            }
            if (reportName != null) {
                sb.append(reportName);
            }
        }
        if (sb.length() == 0) {
            sb.append("Unavailable");
        }
        state.setFormFieldFromString("originalReportLocation", sb.toString());
    }

    public static boolean hasQueryResult(BIBusEnvelope busEnvelope) {
        Element soapBody;
        return busEnvelope != null && (soapBody = busEnvelope.getBody()) != null && (soapBody.selectSingleNode("./*[local-name()='queryResponse']/*[local-name()='result']/*") != null || soapBody.selectSingleNode("./*[local-name()='queryResponse']/*[local-name()='returns']/*[local-name()='item']/*[local-name()='queryResult']/*") != null);
    }

    public static void setPromptValuesForReportView(ICognosViewerState state, CMServerResponse cmResponse) throws CognosViewerException {
        Element parametersNode = cmResponse.getComplexProperty("parameters").element("value");
        if (parametersNode != null) {
            state.getParameterValueManager().addParameterValues(parametersNode.asXML());
        }
    }

    public static void setPromptValues(ICognosViewerState state, SOAPResponse actionResponse) throws CognosViewerException {
        Element parametersNode = (Element)actionResponse.getBusEnvelope().getBody().selectSingleNode(".//*[local-name()='parameters']/*[local-name()='value']");
        if (parametersNode != null) {
            state.getParameterValueManager().addParameterValues(parametersNode.asXML());
        }
    }

    public static void mergePromptValuesFromReport(ICognosViewerState state, SOAPResponse actionResponse) throws CognosViewerException {
        ParameterValueManager parameterValueManager = state.getParameterValueManager();
        Element parametersNode = (Element)actionResponse.getBusEnvelope().getBody().selectSingleNode(".//*[local-name()='parameters']/*[local-name()='value']");
        if (parametersNode == null) {
            return;
        }
        ParameterValue[] parameterValues = parameterValueManager.parseXMLSpecification(parametersNode.asXML());
        for (int i = 0; i < parameterValues.length; ++i) {
            if (parameterValueManager.getParameterValue(parameterValues[i].getName()) != null) continue;
            parameterValueManager.addParameterValue(parameterValues[i]);
        }
    }

    public static void addOutputLocationOption(ICognosViewerState state) throws CognosViewerException {
        if (state.getOptionManager().getOption("outputLocation") == null) {
            String optionValue = CognosViewerDispatcherHandler.getOutputLocation(state);
            if ("runPowerPlay".equals(state.getAction())) {
                state.getOptionManager().addOption("powerPlay8.outputLocation_pp", optionValue);
            } else {
                state.getOptionManager().addOption("run.outputLocation", optionValue);
            }
        }
    }

    public static void addReturnOutputWhenAvailableOption(OptionManager optionManager) throws CognosViewerException {
        if (optionManager.getOption(RunOptionEnum.returnOutputWhenAvailable.toString()) == null) {
            optionManager.addOption("run." + RunOptionEnum.returnOutputWhenAvailable.toString(), "true");
        }
    }

    public static void handleException(Exception exception, BIBusEnvelope envelope) throws CognosViewerException {
        if (exception instanceof CognosViewerException) {
            throw (CognosViewerException)exception;
        }
        CognosViewerException cognosViewerException = new CognosViewerException(envelope, exception.getMessage(), exception);
        throw cognosViewerException;
    }

    public static void addVerticalElementsToState(ICognosViewerState state, Element option) throws CognosViewerException {
        Element verticalElements = (Element)option.selectSingleNode("./value/item[./name = 'verticalElements']/value");
        if (verticalElements != null) {
            state.setFormFieldFromString("run.verticalElements", verticalElements.getText());
            state.getOptionManager().addOption("run.verticalElements", verticalElements.getText());
        }
    }

    public static void addBUXAsynchOptions(ICognosViewerState state, OptionManager optionManager) throws CognosViewerException {
        String primaryWait = null;
        String sIsSavedReport = state.getFormFieldAsString("widget.isSavedReport");
        primaryWait = "true".equals(sIsSavedReport) ? "1" : PRIMARYWAITTHRESHOLD;
        optionManager.setPrimaryWaitThreshold(primaryWait, true);
        optionManager.setSecondaryWaitThreshold("5", true);
        optionManager.addOption("asynch.alwaysIncludePrimaryRequest", "false");
    }

    public static void prepareForBUXRunRequest(ICognosViewerState state) throws CognosViewerException {
        state.getOptionManager().addOption("run.xslURL", "bux.xsl");
        ActionHelper.addBUXAsynchOptions(state, state.getOptionManager());
        if (state instanceof CognosViewerDispatcherHandlerState) {
            String originalAction = state.getFormFieldAsString("ui.action");
            state.setFormFieldFromString("ui.action", "runSpecification");
            ((CognosViewerDispatcherHandlerState)state).initializeXslRunOptions();
            state.setFormFieldFromString("ui.action", originalAction);
        }
    }

    public static void addAsynchOptions(ICognosViewerState state, int primaryWaitThreshold, int secondaryWaitThreshold, boolean alwaysIncludePrimaryRequest) throws CognosViewerException {
        OptionManager optionManager = state.getOptionManager();
        optionManager.setPrimaryWaitThreshold(Integer.toString(primaryWaitThreshold));
        optionManager.setSecondaryWaitThreshold(Integer.toString(secondaryWaitThreshold));
        optionManager.addOption("asynch.alwaysIncludePrimaryRequest", Boolean.toString(alwaysIncludePrimaryRequest));
    }

    public static void addIROTOptions(ICognosViewerState state) throws CognosViewerException {
        OptionManager optionManager = state.getOptionManager();
        optionManager.addOption("asynch.attachmentEncoding", BASE64);
        optionManager.addOption("run.outputEncapsulation", "URLQueryString");
        optionManager.addOption("run.outputFormat", HTML);
        optionManager.addOption("run.xslURL", "V5html.xsl");
        optionManager.addOption("run.promptFormat", OUTPUTFORMAT);
        optionManager.addOption("generic.anyURI.http://developer.cognos.com/ceba/constants/runOptionEnum#promptXslUrl", XSLURL);
        boolean bDownload = "true".equals(state.getFormFieldAsString("cv.promptForDownload"));
        if (!bDownload && !"mobileData".equals(state.getResponseFormat())) {
            optionManager.addOption("generic.boolean.http://developer.cognos.com/ceba/constants/runOptionEnum#preview", "true");
        }
    }

    public static void setContextBlockSize(ICognosViewerState state) {
        if (state.isBUX()) {
            state.getBusEnvelope().setFormField("_ContextBlockSize", "30000");
        }
    }

    public static void addReturnSpecificationOption(ICognosViewerState state) throws CognosViewerException {
        if (state.isBUX() && state.getOptionManager().getOption(RunOptionEnum.returnSpecification.toString()) == null) {
            state.getOptionManager().addOption("run." + RunOptionEnum.returnSpecification.toString(), "true");
        }
    }

    public static void handleRunResponse(ICognosViewerState state, CognosViewerServiceFactory serviceFactory, SOAPResponse soapInteruptResponse) throws CognosViewerException {
        ActionHelper.setReportSpecification(state, soapInteruptResponse);
        if (!"false".equals(state.getFormFieldAsString("rap.getReportInfo")) || "false".equals(CognosViewerDispatcherHandler.getConfigValues().getProperty("useSavedReportInfo"))) {
            ActionHelper.getReportInfo(state, serviceFactory);
        }
    }

    public static void setReportSpecification(ICognosViewerState state, SOAPResponse soapResponse) throws CognosViewerException {
        Element soapBody;
        BIBusEnvelope busEnvelope = soapResponse.getBusEnvelope();
        if (busEnvelope != null && (soapBody = busEnvelope.getBody()) != null) {
            Element asyncSpec = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/item[@xsi:type='bus:asynchDetailAsynchSpecification']/*[local-name()='specification']/*[local-name()='value']");
            if (asyncSpec == null) {
                asyncSpec = (Element)soapBody.selectSingleNode(".//*[local-name()='specification']/*[local-name()='value']");
            }
            if (asyncSpec != null) {
                state.setReportSpecification(asyncSpec.getText());
            }
        }
    }

    private static void getReportInfo(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        String sAction = state.getFormFieldAsString("ui.action");
        String sSpec = state.getFormFieldAsString("ui.spec");
        String sPrimaryAction = state.getFormFieldAsString("ui.primaryAction");
        String preserveTags = state.getFormFieldAsString("ui.preserveRapTags");
        if (state.isBUX() && !sPrimaryAction.equals("runSpecification") && sSpec.length() > 0) {
            Element reportActions = DocumentHelper.createElement((String)"reportActions");
            reportActions.addAttribute("run", "false");
            reportActions.add(BuxAction.createSetReportPropertiesAction());
            String reportAction = "reportAction";
            String name = "name";
            Element processLockedFiltersAction = reportActions.addElement(reportAction);
            processLockedFiltersAction.addAttribute(name, "ProcessLockedFilters");
            ActionHelper.addFilters(state, reportActions);
            Element processSortLabelsAction = reportActions.addElement(reportAction);
            processSortLabelsAction.addAttribute(name, "ProcessSortLabels");
            Element getInfoReportAction = reportActions.addElement(reportAction);
            getInfoReportAction.addAttribute(name, "GetInfo");
            if (preserveTags != null && preserveTags.equals("true")) {
                getInfoReportAction.addElement("preserveTags");
            }
            state.setFormFieldFromString("cv.actionContext", reportActions.asXML());
            state.setFormFieldFromString("ui.action", "modifyReport");
            ActionFactory actionFactory = new ActionFactory(serviceFactory);
            ModifyReportAction modifyReportAction = (ModifyReportAction)actionFactory.load("modifyReport", state);
            modifyReportAction.execute();
        }
    }

    public static void addFilters(ICognosViewerState state, Element parent) {
        Document document;
        String updateDataFiltersString = state.getFormFieldAsString("cv.updateDataFilters");
        if (!"".equals(updateDataFiltersString) && (document = XMLUtility.createXMLDocument(updateDataFiltersString)) != null && document.getRootElement() != null) {
            Element updateDataFilterNode = document.getRootElement();
            Iterator iterator = updateDataFilterNode.elementIterator("filter");
            while (iterator.hasNext()) {
                Element filter = (Element)iterator.next();
                Element updateDataFilterAction = parent.addElement("reportAction");
                updateDataFilterAction.addAttribute("name", "UpdateDataFilter");
                updateDataFilterAction.addElement("inlineValues");
                updateDataFilterAction.setText(filter.getText());
            }
        }
    }

    public static void addMIMEEncodingOption(ICognosViewerState state) throws CognosViewerException {
        String asynchOptionEncoding = "MIME";
        if (CognosViewerDispatcherHandler.getConfigValues().getProperty("attachmentEncoding") != null) {
            asynchOptionEncoding = CognosViewerDispatcherHandler.getConfigValues().getProperty("attachmentEncoding");
        }
        state.getOptionManager().addOption("asynch.attachmentEncoding", asynchOptionEncoding);
    }

    public static void addDelayedLoadingExecutionParamsToParameterManager(ICognosViewerState state) throws CognosViewerException {
        if (state.getFormFieldAsString("delayedLoadingExecutionParams").length() == 0) {
            return;
        }
        Document parametersDocument = XMLUtility.createXMLDocument(state.getFormFieldAsString("delayedLoadingExecutionParams"));
        Element parameterValues = parametersDocument.getRootElement();
        if (parameterValues != null) {
            ParameterValueManager paramManager = new ParameterValueManager();
            paramManager.addParametersValues(parameterValues, false);
            ActionHelper.addMissingParameterValuesToParameterManager(paramManager.toArray(), state.getParameterValueManager());
        }
    }

    public static SOAPResponse handleActionControllerException(ActionControllerException e, ICognosViewerState state) throws CognosViewerException {
        if (e.getCause() instanceof CognosServiceRequestException) {
            CognosViewerException viewerExeption;
            if (e.getCause().getCause() instanceof CognosViewerException && CognosViewerDispatcherHandlerState.isAuthenticationFaultEnvelope((viewerExeption = (CognosViewerException)e.getCause().getCause()).getFaultEnvelope())) {
                throw viewerExeption;
            }
            Object value = ((CognosServiceRequestException)e.getCause()).getCustomValue();
            return (SOAPResponse)value;
        }
        if (e.getCause() instanceof UnsupportedSpecificationException) {
            CognosViewerException exception = new CognosViewerException(state.getBusEnvelope(), MessageManager.convert("IDS_CONTENT_INSERT_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(state)), null);
            throw exception;
        }
        throw new CognosViewerRAPException(state, (Exception)e.getCause(), state.getFormFieldAsString("cv.actionContext"));
    }

    private static void removeParamsFromConversation(ICognosViewerState state, HashSet<String> paramsToRemove) {
        AsynchRequest conv = state.getConversation();
        if (conv != null) {
            Object[] parameters = conv.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String sParameterName = parameters[i].getName();
                if (!paramsToRemove.contains(sParameterName)) continue;
                parameters = (ParameterValue[])ArrayUtils.removeElement((Object[])parameters, (Object)parameters[i]);
            }
            conv.setParameters((ParameterValue[])parameters);
        }
    }

    public static void processIWidgetUserParameters(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) throws CognosViewerException {
        if ("true".equals(state.getFormFieldAsString("widget.userParameters")) || "true".equals(state.getFormFieldAsString("widget.forceGetParameters"))) {
            state.removeFormField("widget.userParameters");
            String reportPromptsFormField = state.getFormFieldAsString("viewerReportPrompts");
            if (reportPromptsFormField.length() == 0) {
                BuxGetParametersSubAction subAction = new BuxGetParametersSubAction(state, serviceFactory);
                subAction.setCanHandleWorkingResponse(false);
                SOAPResponse soapResponse = subAction.executeRequest();
                subAction.setSoapResponse(soapResponse);
                subAction.handleResponse();
                reportPromptsFormField = state.getFormFieldAsString("reportPrompts");
            }
            if (reportPromptsFormField.length() > 0) {
                Element reportPrompts = null;
                try {
                    Element root = DocumentHelper.parseText((String)reportPromptsFormField).getRootElement();
                    reportPrompts = (Element)root.selectSingleNode("./reportParameters");
                    if (reportPrompts == null) {
                        return;
                    }
                }
                catch (DocumentException e) {
                    IPFLogger.getInstance().error("Could no parse viewerReportPrompts information", "ActionHelper");
                    return;
                }
                ParameterValueManager parameterValueManager = state.getParameterValueManager();
                HashMap parameterValues = parameterValueManager.getParameterValues();
                Iterator it = parameterValues.entrySet().iterator();
                HashSet<String> paramsToRemove = new HashSet<String>();
                while (it.hasNext()) {
                    Map.Entry parameter = it.next();
                    String paramName = (String)parameter.getKey();
                    String delimiter = paramName.indexOf("'") == -1 ? "'" : "\"";
                    Element getParameterInfo = (Element)reportPrompts.selectSingleNode("./reportParameter[@parameterName = " + delimiter + paramName + delimiter + "]");
                    if (getParameterInfo == null) {
                        it.remove();
                        paramsToRemove.add(paramName);
                        continue;
                    }
                    ParameterValue parameterValue = (ParameterValue)parameter.getValue();
                    if ("true".equals(getParameterInfo.attributeValue("multivalued")) || parameterValue.getValue().length <= 1) continue;
                    parameterValue.setValue(new ParmValueItem[]{parameterValue.getValue()[0]});
                }
                if (!paramsToRemove.isEmpty()) {
                    ActionHelper.removeParamsFromConversation(state, paramsToRemove);
                }
            } else {
                state.setParmaeterValueManager(new ParameterValueManager());
                state.removeFormField("ui.conversation");
                state.clearConversation();
            }
        }
    }
}

