/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionBoolean;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionEnum;
import com.cognos.developer.schemas.bibus._3.DrillThroughOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.NameValue;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.action.DrillThroughAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerReportSpecificationFactory;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.AsynchSpecificationMarshaller;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.model.marshallers.PropEnumMarshaller;
import com.cognos.viewer.model.marshallers.SearchPathMultipleObjectMarshaller;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AuthoredDrillThrough2Action
extends DrillThroughAction {
    private static final Namespace drillThroughNamespace = DocumentHelper.createNamespace((String)"dts", (String)"http://developer.cognos.com/schemas/drillThroughSpecification/1/");
    private static final Namespace xsiNamespace = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private Element m_authoredDrilllRequest = null;
    private ParameterValue[] m_credentialParameters = null;
    private boolean m_drillServiceOnly = false;

    @Override
    public void initialize(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) {
        super.initialize(state, serviceFactory);
        this.m_drillServiceOnly = "true".equals(this.m_state.getFormFieldAsString("cv.drillServiceOnly"));
    }

    @Override
    public void prepareRequest() throws CognosViewerException {
        String dynamicDrill;
        if (this.m_state.getFormFieldAsString("ui.routingServerGroup").isEmpty()) {
            this.getSourceRoutingServerGroup();
        }
        if ((dynamicDrill = this.getProperty("dynamicDrill")) != null && "true".equals(dynamicDrill)) {
            DrillThroughOptionBoolean editSpecification = new DrillThroughOptionBoolean();
            editSpecification.setName(DrillThroughOptionEnum.useEditSpecification);
            editSpecification.setValue(true);
            this.m_state.getOptionManager().addOption("drillThrough.useEditSpecification", (Option)editSpecification);
        }
    }

    private void getSourceRoutingServerGroup() throws CognosViewerException {
        String sRoutingServerGroup = "";
        String sQuerySearchPath = "";
        String sSourceSearchPath = this.getProperty("source");
        if (sSourceSearchPath.length() > 0) {
            sQuerySearchPath = sSourceSearchPath;
        } else {
            ArrayList<String> objPathValues = this.getObjectPathsValues();
            if (objPathValues.size() > 0) {
                String sFirstPathValue = objPathValues.get(0);
                if (objPathValues.size() != 2) {
                    sFirstPathValue = sFirstPathValue + "/..";
                }
                sQuerySearchPath = sFirstPathValue;
            }
        }
        if (sQuerySearchPath.length() > 0) {
            IArgumentMarshaller[] contentManagerQueryArguments = new IArgumentMarshaller[]{new SearchPathMultipleObjectMarshaller(new SearchPathMultipleObject(sQuerySearchPath)), new PropEnumMarshaller(new PropEnum[]{PropEnum.routingServerGroup})};
            ICognosViewerRequest cmServerRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            CMServerResponse cmResponse = (CMServerResponse)cmServerRequest.executeRequest("query", this.m_state, contentManagerQueryArguments, "");
            if (cmResponse.getProperty(PropEnum.routingServerGroup.getValue()).length() > 0) {
                sRoutingServerGroup = cmResponse.getProperty(PropEnum.routingServerGroup.getValue());
            }
        }
        this.m_state.setFormFieldFromString("ui.routingServerGroup", sRoutingServerGroup);
    }

    public ParameterValue[] getCredentialParameters() throws CognosViewerException {
        if (this.m_credentialParameters == null) {
            String sExecutionParameters = this.getProperty("executionParameters");
            if (sExecutionParameters.length() > 0 && !sExecutionParameters.startsWith("<")) {
                sExecutionParameters = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sExecutionParameters), (boolean)true);
            }
            ParameterValueManager parameterValueManager = new ParameterValueManager();
            if (sExecutionParameters.length() > 0) {
                try {
                    parameterValueManager.addParameterValues(sExecutionParameters);
                }
                catch (Exception exception) {
                    this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
                }
            }
            this.m_credentialParameters = parameterValueManager.getCredentialParameters();
        }
        return this.m_credentialParameters;
    }

    public void addPromptRunOptions(OptionManager optionManager, boolean drillServiceOnly) throws CognosViewerException {
        optionManager.addOption("run.promptFormat", drillServiceOnly ? "XHTMLFRGMT" : "HTMLFragment");
        if (drillServiceOnly) {
            optionManager.addOption("generic.anyURI.http://developer.cognos.com/ceba/constants/runOptionEnum#promptXslUrl", "V5html_viewer.xsl");
        }
        optionManager.addOption("run.outputFormat", "HTMLFragment");
        optionManager.addOption("run.xslURL", "sa.xsl");
        optionManager.addOption("run.prompt", "false");
        String sCVId = this.m_state.getFormFieldAsString("cv.id");
        if (sCVId.length() != 0) {
            NameValue nameValue = new NameValue();
            nameValue.setName("CognosViewerID");
            nameValue.setValue(sCVId);
            optionManager.newRunOptionNameValueArray(RunOptionEnum.xslParameters, new NameValue[]{nameValue});
        }
    }

    public ParameterValue[] getSourceContextValues() {
        ParameterValueManager parameterValueManager = new ParameterValueManager();
        try {
            Element drillParameters;
            if (this.m_authoredDrilllRequest == null) {
                String sDrillRequest = this.m_state.getFormFieldAsString("authoredDrill.request");
                this.m_authoredDrilllRequest = this.parseXMLSpecification(sDrillRequest);
                this.m_state.getDebugLogger().logXML(sDrillRequest, "authoredDrillRequest.xml", true, "authoredDrillRequest");
            }
            if (this.m_authoredDrilllRequest != null && (drillParameters = (Element)this.m_authoredDrilllRequest.selectSingleNode("./*[local-name()='drillParameters']")) != null) {
                List drillParametersList = drillParameters.elements("param");
                int listSize = drillParametersList.size();
                for (int index = 0; index < listSize; ++index) {
                    Element drillParameter = (Element)drillParametersList.get(index);
                    String sSelectChoicesSpecification = drillParameter.getText();
                    parameterValueManager.addParameterValue(drillParameter.attributeValue("name"), sSelectChoicesSpecification);
                }
            }
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
        }
        return parameterValueManager.toArray();
    }

    public void setDrillTargetAction() throws CognosViewerException {
        String sDrillAction = this.getActionProperty();
        if ("default".equals(sDrillAction)) {
            sDrillAction = "";
        }
        this.m_state.setFormFieldFromString("ui.action", sDrillAction);
    }

    public void setDrillTargetSearchPath() throws CognosViewerException {
        String sTarget = this.getProperty("target");
        this.m_state.setFormFieldFromString("ui.object", sTarget);
    }

    public void setDrillTargetBookmark() throws CognosViewerException {
        String sBookmark = this.getProperty("bookmark");
        if (sBookmark.length() > 0) {
            this.m_state.setFormFieldFromString("ui.bookmark", sBookmark);
        }
    }

    public void setDrillTargetPromptValue() throws CognosViewerException {
        OptionManager optionManager = this.m_state.getOptionManager();
        String sPrompt = this.getProperty("prompt");
        if (sPrompt.length() > 0) {
            if ("yes".equals(sPrompt)) {
                sPrompt = "true";
            } else if ("no".equals(sPrompt)) {
                sPrompt = "false";
            }
            optionManager.addOption("run.prompt", sPrompt);
        }
    }

    public void setDrillTargetLocale() throws CognosViewerException {
        OptionManager optionManager = this.m_state.getOptionManager();
        String sLocale = this.getProperty("locale");
        if (sLocale.length() > 0) {
            optionManager.addOption("run.outputLocale", sLocale);
            this.m_state.setFormFieldFromString("ui.outputLocale", sLocale);
        }
    }

    public void setDrillTargetFormat() throws CognosViewerException {
        OptionManager optionManager = this.m_state.getOptionManager();
        String sFormat = this.getProperty("format");
        if (sFormat.length() > 0) {
            if ("HTMLFragment".equals(sFormat)) {
                sFormat = "HTML";
            }
            this.m_state.addObject("drillThroughFormat", sFormat);
            optionManager.addOption("run.outputFormat", sFormat);
            this.m_state.setFormFieldFromString("ui.format", sFormat);
        }
    }

    public void prepareToInvokeTarget(SOAPResponse runSpecificationResponse) throws CognosViewerException {
        this.m_state.setFormFieldFromString("ui.primaryAction", "");
        this.m_state.setFormFieldFromString("ui.conversation", "");
        this.processRunSpecificationResponse(runSpecificationResponse);
        this.setDrillTargetAction();
        this.setDrillTargetSearchPath();
        this.setDrillTargetBookmark();
        this.setDrillTargetPromptValue();
        this.setDrillTargetLocale();
        this.setDrillTargetFormat();
        if (this.m_state instanceof CognosViewerDispatcherHandlerState) {
            ((CognosViewerDispatcherHandlerState)this.m_state).initializeXslRunOptions();
        }
    }

    public void processRunSpecificationResponse(SOAPResponse runSpecificationResponse) throws CognosViewerException {
        BIBusEnvelope busEnvelope;
        if (runSpecificationResponse != null && (busEnvelope = runSpecificationResponse.getBusEnvelope()) != null) {
            Element soapBody = busEnvelope.getBody();
            Element asynchDetailDrillThroughRequest = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='details']/item[@xsi:type='bus:asynchDetailDrillThroughRequest']");
            boolean bIncludeUnmappedExecutionParameterValues = CognosViewerDispatcherHandler.getConfigValues().getBoolean("enablePassAllParameters");
            if (asynchDetailDrillThroughRequest != null) {
                ParameterValueManager parameterValueManager = new ParameterValueManager();
                Element parameterValues = asynchDetailDrillThroughRequest.element("parameters");
                if (parameterValues.elements().size() == 0) {
                    boolean bPassSourceContextParametersWhenNoneMap = CognosViewerDispatcherHandler.getConfigValues().getBoolean("enablePassAllParametersWhenNoneMap");
                    if (bPassSourceContextParametersWhenNoneMap) {
                        parameterValueManager.addParameterValues(this.getSourceContextValues());
                    }
                } else {
                    parameterValueManager.addParameterValues(parameterValues.asXML());
                }
                parameterValueManager.addParameterValues(bIncludeUnmappedExecutionParameterValues ? this.getAllUnmappedExecutionParameterValues() : this.getCredentialParameters());
                this.m_state.setParmaeterValueManager(parameterValueManager);
                Element options = asynchDetailDrillThroughRequest.element("options");
                OptionMarshaller optionsMarshaller = new OptionMarshaller(null);
                Option[] drillThroughOptions = optionsMarshaller.unmarshall(options);
                try {
                    this.m_state.getOptionManager().addOptions(drillThroughOptions, true);
                }
                catch (CognosViewerException e) {
                    this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
                }
            }
        }
    }

    public AsynchSpecification getDrillThroughSpecification() throws CognosViewerException {
        CognosViewerReportSpecificationFactory specificationFactory = new CognosViewerReportSpecificationFactory();
        AsynchSpecification asynchSpecification = specificationFactory.load("reportServiceDrillThroughSpecification");
        Specification specification = new Specification();
        Element drillThroughSpecification = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"drillThroughSpecification", (Namespace)drillThroughNamespace));
        drillThroughSpecification.add(xsiNamespace);
        String sLocale = this.getProperty("locale");
        if (sLocale.length() > 0) {
            drillThroughSpecification.addAttribute("locale", sLocale);
        }
        Element modelSearchPath = drillThroughSpecification.addElement(DocumentHelper.createQName((String)"modelSearchPaths", (Namespace)drillThroughNamespace));
        ArrayList<String> objPathValues = this.getObjectPathsValues();
        for (String objPathValue : objPathValues) {
            Element searchPath = modelSearchPath.addElement(DocumentHelper.createQName((String)"searchPath", (Namespace)drillThroughNamespace));
            searchPath.setText(objPathValue);
        }
        this.buildParameterAssignments(drillThroughSpecification);
        Element reportTarget = drillThroughSpecification.addElement(DocumentHelper.createQName((String)"reportTarget", (Namespace)drillThroughNamespace));
        Element action = reportTarget.addElement(DocumentHelper.createQName((String)"action", (Namespace)drillThroughNamespace));
        action.setText("http://developer.cognos.com/schemas/bibus/3/constants/drillThroughActionEnum#" + this.getActionProperty());
        Element targetSearchPath = reportTarget.addElement(DocumentHelper.createQName((String)"targetSearchPath", (Namespace)drillThroughNamespace));
        targetSearchPath.setText(this.getProperty("target"));
        String sDrillThroughSpecification = drillThroughSpecification.asXML();
        if (this.m_state.getDebugLogger().isDebugEnabled()) {
            this.m_state.getDebugLogger().log(sDrillThroughSpecification.getBytes(), "drillThroughSpecification.xml", true, "drillThroughSpec");
        }
        specification.set_value(sDrillThroughSpecification);
        asynchSpecification.setValue(specification);
        return asynchSpecification;
    }

    private ArrayList<String> getObjectPathsValues() throws CognosViewerException {
        Element objectPaths;
        Element root;
        ArrayList<String> result = new ArrayList<String>();
        String sObjectPaths = this.getProperty("objectPaths");
        if (sObjectPaths != null && sObjectPaths.length() > 0 && (root = this.parseXMLSpecification(sObjectPaths = "<root xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">" + sObjectPaths + "</root>")) != null && (objectPaths = root.element("objectPaths")) != null) {
            List items = objectPaths.selectNodes("item");
            for (int iIndex = 0; iIndex < items.size(); ++iIndex) {
                Element item = (Element)items.get(iIndex);
                result.add(item.getText());
            }
        }
        return result;
    }

    private Element buildParameterAssignments(Element drillThroughSpecification) throws CognosViewerException {
        Element drillParameters;
        Element parameterAssignments = drillThroughSpecification.addElement(DocumentHelper.createQName((String)"parameterAssignments", (Namespace)drillThroughNamespace));
        if (this.m_authoredDrilllRequest == null) {
            String sDrillRequest = this.m_state.getFormFieldAsString("authoredDrill.request");
            this.m_authoredDrilllRequest = this.parseXMLSpecification(sDrillRequest);
            this.m_state.getDebugLogger().logXML(sDrillRequest, "authoredDrillRequest.xml", true, "authoredDrillRequest");
        }
        if (this.m_authoredDrilllRequest != null && (drillParameters = (Element)this.m_authoredDrilllRequest.selectSingleNode("./*[local-name()='drillParameters']")) != null) {
            List drillParametersList = drillParameters.elements("param");
            int listSize = drillParametersList.size();
            for (int index = 0; index < listSize; ++index) {
                Element item;
                Element selectOption;
                String sSelectChoicesSpecification;
                Element selectChoices;
                Element drillParameter = (Element)drillParametersList.get(index);
                String parameterName = drillParameter.attributeValue("name");
                if (parameterName.startsWith("p_")) {
                    parameterName = parameterName.substring(2, parameterName.length());
                }
                if ((selectChoices = this.parseXMLSpecification(sSelectChoicesSpecification = drillParameter.getText())) == null || (selectOption = selectChoices.element("selectOption")) == null) continue;
                String munAttributeValue = selectOption.attributeValue("mun");
                String propertyToPassAttributeValue = selectChoices.attributeValue("propertyToPass");
                if (propertyToPassAttributeValue == null) {
                    propertyToPassAttributeValue = selectOption.attributeValue("propertyToPass");
                }
                if (munAttributeValue == null && (propertyToPassAttributeValue == null || propertyToPassAttributeValue.length() <= 0)) continue;
                Element parameterAssignment = parameterAssignments.addElement(DocumentHelper.createQName((String)"parameterAssignment", (Namespace)drillThroughNamespace));
                Element parameterNameNode = parameterAssignment.addElement(DocumentHelper.createQName((String)"parameterName", (Namespace)drillThroughNamespace));
                parameterNameNode.setText(parameterName);
                if (propertyToPassAttributeValue != null && propertyToPassAttributeValue.length() > 0) {
                    item = parameterAssignment.addElement(DocumentHelper.createQName((String)"item", (Namespace)drillThroughNamespace));
                    StringBuffer sbItem = new StringBuffer("roleValue('_");
                    sbItem.append(propertyToPassAttributeValue);
                    sbItem.append("',");
                    sbItem.append(selectOption.attributeValue("useValue"));
                    sbItem.append(")");
                    item.setText(sbItem.toString());
                } else {
                    item = parameterAssignment.addElement(DocumentHelper.createQName((String)"item", (Namespace)drillThroughNamespace));
                    item.setText("roleValue('')");
                }
                if (munAttributeValue == null) continue;
                Element extension = parameterAssignment.addElement(DocumentHelper.createQName((String)"extension", (Namespace)drillThroughNamespace));
                Element sourceUsage = extension.addElement(DocumentHelper.createQName((String)"sourceUsage", (Namespace)drillThroughNamespace));
                sourceUsage.setText("attribute");
            }
        }
        if (parameterAssignments.elements().size() == 0) {
            parameterAssignments.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
        return parameterAssignments;
    }

    public IArgumentMarshaller getParameterValuesArgument() {
        ParameterValueManager sourceValues = new ParameterValueManager();
        sourceValues.addParameterValues(this.getSourceContextValues());
        try {
            sourceValues.addParameterValues(this.getCredentialParameters());
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
        }
        return new ParameterValuesMarshaller(sourceValues.toArray(), DocumentHelper.createQName((String)"parameterValues", (Namespace)BIBusEnvelope.NS_BUS));
    }

    public ParameterValue[] getAllUnmappedExecutionParameterValues() {
        ParameterValueManager unmappedExecutionParameters = new ParameterValueManager();
        ParameterValueManager drillThroughSourceParameters = new ParameterValueManager();
        drillThroughSourceParameters.addParameterValues(this.getSourceContextValues());
        try {
            String sExecutionParameters = this.getProperty("executionParameters");
            if (sExecutionParameters.length() > 0) {
                if (!sExecutionParameters.startsWith("<")) {
                    sExecutionParameters = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sExecutionParameters), (boolean)true);
                }
                unmappedExecutionParameters.addParameterValues(sExecutionParameters);
                ParameterValue[] drillThroughSourceParametersArray = drillThroughSourceParameters.toArray();
                for (int index = 0; index < drillThroughSourceParametersArray.length; ++index) {
                    ParameterValue drillThroughSourceParameter = drillThroughSourceParametersArray[index];
                    unmappedExecutionParameters.removeParameterValue(drillThroughSourceParameter.getName());
                }
            }
        }
        catch (Exception exception) {
            this.m_state.getIPFLogger().error(exception.getMessage(), exception, this.getClass().getName());
        }
        return unmappedExecutionParameters.toArray();
    }

    protected String getActionProperty() throws CognosViewerException {
        return this.getProperty("action");
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        OptionManager optionManager = this.m_state.getOptionManager();
        SOAPResponse result = null;
        String sDrillAction = this.getProperty("action");
        if (!this.m_drillServiceOnly && "view".equals(sDrillAction)) {
            result = this.executeView();
        } else {
            this.m_arguments = new IArgumentMarshaller[3];
            this.m_arguments[0] = new AsynchSpecificationMarshaller(this.getDrillThroughSpecification(), true);
            this.m_arguments[1] = this.getParameterValuesArgument();
            this.addPromptRunOptions(optionManager, this.m_drillServiceOnly);
            this.addSelectionContextOptions(optionManager);
            this.m_arguments[2] = new OptionMarshaller(optionManager.toArray());
            ICognosViewerRequest rsRequest = this.m_serviceFactory.getService(CognosViewerServiceFactory.REPORTSERVICEREQUEST);
            SOAPResponse rsResponse = rsRequest.executeRequest("runSpecification", this.m_state, this.m_arguments, "session");
            optionManager.clear();
            if (this.m_drillServiceOnly) {
                BIBusEnvelope envelope = rsResponse.getBusEnvelope();
                rsResponse.addObject("SOAPResponse", envelope);
                rsResponse.setFormFieldFromString("cv.responseFormat", "xmlResponse");
                return rsResponse;
            }
            result = this.isActionRequestComplete(rsResponse) ? this.resumeExecution(rsResponse) : rsResponse;
        }
        return result;
    }

    public SOAPResponse executeView() throws CognosViewerException {
        ParameterValueManager parameterValueManager = this.m_state.getParameterValueManager();
        parameterValueManager.addParameterValues(this.getSourceContextValues());
        parameterValueManager.addParameterValues(this.getCredentialParameters());
        this.prepareToInvokeTarget(null);
        return this.invokeTarget();
    }

    public boolean isDrillThroughToSelf() throws CognosViewerException {
        String sSource = this.getProperty("source");
        String sTarget = this.getProperty("target");
        return sSource.length() != 0 && sTarget.length() != 0 && sSource.equals(sTarget);
    }

    public void addSelectionContextOptions(OptionManager optionManager) throws CognosViewerException {
        String sSelectionContext = this.getProperty("selectionContext");
        DrillThroughOptionXMLEncodedXML drillThroughSelectionContext = new DrillThroughOptionXMLEncodedXML();
        drillThroughSelectionContext.setName(DrillThroughOptionEnum.selectionContext);
        drillThroughSelectionContext.setValue(new XmlEncodedXML(sSelectionContext));
        optionManager.addOption("drillThrough.selectionContext", (Option)drillThroughSelectionContext);
    }

    public void setDrillThroughParameterValues(SOAPResponse determineDrillResponse) throws CognosViewerException {
        ParameterValueManager parameterValueManager = this.m_state.getParameterValueManager();
        Element drillThroughParameterValuesResponseNode = (Element)determineDrillResponse.getBusEnvelope().getBody().selectSingleNode("./*/*/*[local-name()='details']/*[local-name()='item'][@xsi:type='bus:asynchDetailParameterValues']/*[local-name()='parameters']");
        ParameterValue[] parameterValues = new ParameterValuesMarshaller(null).unmarshall(drillThroughParameterValuesResponseNode);
        parameterValueManager.addParameterValues(parameterValues);
        parameterValueManager.addParameterValues(this.getCredentialParameters());
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse runSpecificationResponse) throws CognosViewerException {
        this.prepareToInvokeTarget(runSpecificationResponse);
        return this.invokeTarget();
    }

    @Override
    protected boolean insertAsynchReportOutput() {
        return this.m_drillServiceOnly ? false : super.insertAsynchReportOutput();
    }

    public SearchPathSingleObject getDrillTarget() throws CognosViewerException {
        String sTarget = this.getProperty("target");
        if (sTarget.length() > 0) {
            return new SearchPathSingleObject(sTarget);
        }
        return null;
    }

    public String getProperty(String sName) throws CognosViewerException {
        Element node;
        if (this.m_authoredDrilllRequest == null) {
            String sDrillRequest = this.m_state.getFormFieldAsString("authoredDrill.request");
            this.m_authoredDrilllRequest = this.parseXMLSpecification(sDrillRequest);
            this.m_state.getDebugLogger().logXML(sDrillRequest, "authoredDrillRequest.xml", true, "authoredDrillRequest");
        }
        String sPropertyValue = "";
        if (this.m_authoredDrilllRequest != null && (node = (Element)this.m_authoredDrilllRequest.selectSingleNode("./*[local-name()='param'][@name='" + sName + "']")) != null) {
            sPropertyValue = node.getText();
        }
        return sPropertyValue;
    }

    public Element parseXMLSpecification(String sSpecification) throws CognosViewerException {
        Element drillRequest = null;
        if (sSpecification != null && sSpecification.length() > 0) {
            try {
                Document document = XMLUtility.createXMLDocument(sSpecification);
                drillRequest = document.getRootElement();
            }
            catch (Exception exception) {
                CognosViewerException cognosViewerException = new CognosViewerException(this.m_state.getBusEnvelope(), exception.getMessage(), exception);
                throw cognosViewerException;
            }
        }
        return drillRequest;
    }
}

