/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.rap.actions.ReportInfo;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxCMQueryHelper;
import com.cognos.viewer.action.BuxChangeContentLocaleSubAction;
import com.cognos.viewer.action.BuxExtractReportPartSubAction;
import com.cognos.viewer.action.BuxGetParametersSubAction;
import com.cognos.viewer.action.BuxQueryReportSpecSubAction;
import com.cognos.viewer.action.BuxQueryReportViewSubAction;
import com.cognos.viewer.action.BuxRunReportSubAction;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.action.BuxSubActions;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.RAPPreProcessReportSubAction;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.OptionMarshaller;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.NameValuePairArrayList;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BuxAction
extends CognosViewerAction {
    private BuxSubActions m_subActions = new BuxSubActions();
    protected boolean m_droppingReport = false;
    protected boolean m_changedContentLocale = false;
    protected boolean m_openReportFromClipboard = false;
    protected boolean m_bRunReport = true;
    private static HashMap<String, Boolean> ignoredParams = new HashMap();

    @Override
    public void initialize(ICognosViewerState state, CognosViewerServiceFactory serviceFactory) {
        super.initialize(state, serviceFactory);
        this.m_droppingReport = this.m_state.isDroppingReportBUXAction();
        String sContentLocale = CognosViewerDispatcherHandlerState.getContentLocale(this.m_state);
        String sLastContentLocaleSaved = this.m_state.getFormFieldAsString("lastLocaleSaved");
        if (sContentLocale.length() != 0 && sLastContentLocaleSaved.length() != 0) {
            Locale contentLocale = MessageManager.getLocale(sContentLocale);
            Locale lastSavedLocale = MessageManager.getLocale(sLastContentLocaleSaved);
            if (!contentLocale.getLanguage().equals(lastSavedLocale.getLanguage())) {
                this.m_changedContentLocale = true;
            }
        }
        String openReportFromClipboard = this.m_state.getFormFieldAsString("openReportFromClipboard");
        this.m_openReportFromClipboard = "true".equals(openReportFromClipboard);
        this.setRunReportOption(this.m_state);
    }

    @Override
    protected boolean insertAsynchReportOutput() {
        return false;
    }

    @Override
    public void prepareRequest() throws CognosViewerException {
        BIBusEnvelope busEnvelope = this.m_state.getBusEnvelope();
        busEnvelope.setFormField("keepIterators", "true");
        if (!this.m_state.getCapabilities().hasCapability("canUseDashboardViewer")) {
            CognosViewerException exception = new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("IDS_CONTENT_DISPLAY_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
            throw exception;
        }
        this.m_state.setFormFieldFromString("cv.showFaultPage", "false");
        String reportPartId = this.m_state.getFormFieldAsString("reportpart_id");
        if (!this.m_droppingReport || reportPartId.length() > 0 || "true".equals(this.m_state.getFormFieldAsString("widget.runFromSavedOutput"))) {
            String sIsSavedReport = this.m_state.getFormFieldAsString("widget.isSavedReport");
            BuxCMQueryHelper.queryPropertiesForBothCurrentAndBaseReport(this.m_state, this.m_serviceFactory, this.m_state.getFormFieldAsString("ui.object"), sIsSavedReport.equals("true") ? this.m_state.getFormFieldAsString("originalReport") : null);
        }
        String objectPermissions = this.m_state.getFormFieldAsString("cv.objectPermissions");
        String objectClass = this.m_state.getFormFieldAsString("ui.objectClass");
        if (objectPermissions.indexOf("read") != -1) {
            if ("reportView".equals(objectClass)) {
                this.m_subActions.add(new BuxQueryReportViewSubAction(this.m_state, this.m_serviceFactory));
            }
            if (this.m_droppingReport || this.m_changedContentLocale || !this.m_bRunReport) {
                boolean bNoSavedReportInfoAndNotRunningReport;
                if (!this.m_openReportFromClipboard) {
                    this.m_subActions.add(new BuxQueryReportSpecSubAction(this.m_state, this.m_serviceFactory));
                }
                if (this.m_changedContentLocale) {
                    this.m_subActions.add(new BuxChangeContentLocaleSubAction(this.m_state, this.m_serviceFactory));
                }
                boolean bl = bNoSavedReportInfoAndNotRunningReport = !this.m_bRunReport && !"false".equals(this.m_state.getFormFieldAsString("rap.getReportInfo"));
                if (this.m_droppingReport || this.m_changedContentLocale || bNoSavedReportInfoAndNotRunningReport) {
                    this.m_subActions.add(new RAPPreProcessReportSubAction(this.m_state, this.m_serviceFactory));
                }
            }
        }
        if (reportPartId.length() > 0) {
            this.m_subActions.add(new BuxExtractReportPartSubAction(this.m_state, this.m_serviceFactory));
        }
        if (reportPartId.length() > 0 || this.m_state.getFormFieldAsString("widget.globalPromptInfo").length() > 0) {
            this.m_subActions.add(new BuxGetParametersSubAction(this.m_state, this.m_serviceFactory));
        }
        ActionHelper.processIWidgetUserParameters(this.m_state, this.m_serviceFactory);
        this.m_subActions.add(new BuxRunReportSubAction(this.m_state, this.m_serviceFactory));
    }

    private void setRunReportOption(ICognosViewerState state) {
        String runReportValue = this.m_state.getFormFieldAsString("widget.runReport");
        if (runReportValue.length() > 0) {
            this.m_bRunReport = !runReportValue.equals("false");
        }
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        SOAPResponse soapResponse = null;
        while (this.m_subActions.size() > 0) {
            try {
                JSONObject reportInfoProperties;
                BuxSubAction subAction = this.m_subActions.get(0);
                if ("com.cognos.viewer.action.BuxGetParametersSubAction".equalsIgnoreCase(subAction.getClass().getName()) && this.m_state.getFormFieldAsString("widget.globalPromptInfo").length() <= 0 && this.m_state.getFormFieldAsString("reportpart_id").length() > 0 && (reportInfoProperties = ReportInfo.getReportLevelProperties(this.m_state.getFormFieldAsString("rap.reportInfo"))) != null && !ReportInfo.isPromptWidget(reportInfoProperties)) {
                    this.m_subActions.remove(0);
                    subAction = this.m_subActions.get(0);
                }
                this.clearTrackingFromState();
                soapResponse = subAction.executeRequest();
                if (soapResponse != null && !this.isActionRequestComplete(soapResponse)) {
                    return soapResponse;
                }
                this.invokeResponseHandler(soapResponse);
            }
            catch (CognosViewerException e) {
                throw e;
            }
            catch (Exception e) {
                this.m_state.addObject("enableToolbarOnFault", "true");
                ActionHelper.handleException(e, this.m_state.getBusEnvelope());
            }
        }
        return soapResponse;
    }

    private void invokeResponseHandler(SOAPResponse soapResponse) throws CognosViewerException {
        if (soapResponse != null) {
            if (this.m_subActions.size() > 1) {
                this.m_state.getParameterValueManager().addCredentialParametersFromSOAPResponse(soapResponse);
            }
            BuxSubAction subAction = this.m_subActions.get(0);
            subAction.setSoapResponse(soapResponse);
            this.m_subActions.get(0).handleResponse();
        }
        this.m_subActions.remove(0);
    }

    @Override
    protected SOAPResponse resumeExecution(SOAPResponse soapResponse) throws CognosViewerException {
        try {
            this.invokeResponseHandler(soapResponse);
        }
        catch (Exception exception) {
            throw new CognosViewerException(soapResponse.getBusEnvelope(), exception.getLocalizedMessage(), exception);
        }
        return this.executeRequest();
    }

    public static Element createSetReportPropertiesAction() throws CognosViewerException {
        Element setReportPropertiesAction = DocumentHelper.createElement((String)"reportAction");
        setReportPropertiesAction.addAttribute("name", "SetReportProperties");
        String useReportAuthoredStyles = "useReportAuthoredStyles";
        Element useReportAuthoredStylesElement = setReportPropertiesAction.addElement(useReportAuthoredStyles);
        useReportAuthoredStylesElement.setText(Boolean.toString(CognosViewerDispatcherHandler.getConfigValues().getBoolean(useReportAuthoredStyles)));
        return setReportPropertiesAction;
    }

    @Override
    public void saveState(NameValuePairArrayList nameValuePairArrayList) throws CognosViewerException {
        nameValuePairArrayList.add("subActionArrayList", this.m_subActions.toString());
        OptionMarshaller optionMarshaller = new OptionMarshaller(this.m_state.getOptionManager().toArray());
        Element root = DocumentHelper.createElement((String)"root");
        optionMarshaller.marshall(root);
        nameValuePairArrayList.add("options", XTSExt.web64encode((String)root.selectSingleNode("./*[local-name()='options']").asXML(), (boolean)true));
        Element parametersElem = (Element)this.m_state.getObject("parameters");
        if (parametersElem != null) {
            nameValuePairArrayList.add("parameters", XTSExt.web64encode((String)parametersElem.asXML(), (boolean)true));
        }
    }

    @Override
    public void loadState(HashMap actionState) throws CognosViewerException {
        try {
            String serializedString = (String)actionState.get("subActionArrayList");
            this.m_subActions.fromString(serializedString, this.m_state, this.m_serviceFactory);
            Document optionsDocument = XMLUtility.createXMLDocument(XTSExt.web64decode((String)((String)actionState.get("options")), (boolean)true));
            Element optionsRoot = optionsDocument.getRootElement();
            OptionMarshaller optionMarshaller = new OptionMarshaller(new Option[0]);
            Option[] optionsArray = optionMarshaller.unmarshall(optionsRoot);
            this.m_state.getOptionManager().addOptions(optionsArray, true);
            String sParameters = XTSExt.web64decode((String)((String)actionState.get("parameters")), (boolean)true);
            if (sParameters != null && sParameters.length() > 0) {
                Document parametersDocument = XMLUtility.createXMLDocument(sParameters);
                this.m_state.addObject("parameters", parametersDocument.getRootElement());
            }
        }
        catch (Exception exception) {
            throw new CognosViewerException(null, exception.getLocalizedMessage(), exception);
        }
    }

    public BuxSubActions getSubActions() {
        return this.m_subActions;
    }

    static {
        ignoredParams.put("ui.action", true);
        ignoredParams.put("ui.primaryAction", true);
        ignoredParams.put("m_tracking", true);
        ignoredParams.put("conversation", true);
        ignoredParams.put("cv.responseFormat", true);
        ignoredParams.put("flexParam_properties", true);
    }
}

