/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.ViewAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerRequest;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.model.marshallers.IArgumentMarshaller;
import com.cognos.viewer.model.marshallers.QueryRequestMarshaller;
import com.cognos.viewer.utility.IPFLogger;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BuxCMQueryHelper {
    public static final Integer CM_QUERY_PROPERTIES_FOR_VIEW = 1;
    public static final Integer CM_QUERY_PROPERTIES_FOR_CURRENT_REPORT = 2;
    public static final Integer CM_QUERY_PROPERTIES_FOR_BASE_REPORT = 3;
    public static final int OUTPUT_QUERYREPLY = 1;
    public static final int REPORT_QUERYREPLY = 2;
    private static HashMap<Integer, PropEnum[]> m_cmQueryProperties = new HashMap();
    public static RefProp[] m_ContentManagerRefProperties;

    private static void processCommonCMResponseProperties(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition, int originalReportQueryReplyPosition) {
        state.setFormFieldFromString("ui.objectClass", cmResponse.getProperty(PropEnum.objectClass.getValue(), reportQueryReplyPosition), false);
        ActionHelper.addObjectPermissionsToState(state, cmResponse, reportQueryReplyPosition);
        int queryReplyPosition = originalReportQueryReplyPosition != -1 ? originalReportQueryReplyPosition : reportQueryReplyPosition;
        state.setFormFieldFromString("ui.name", cmResponse.getProperty(PropEnum.defaultName.getValue(), queryReplyPosition), false);
        ActionHelper.addAncestorsTitlesToState(state, cmResponse, queryReplyPosition);
        if (cmResponse.getProperty("searchPath", queryReplyPosition).length() > 0) {
            state.addObject("searchPath", cmResponse.getProperty("searchPath", queryReplyPosition));
        }
    }

    private static void processCMResponse(ICognosViewerState state, CMServerResponse cmResponse, Integer cmCurrentReportQueryProperties, int cmCurrentReportQueryReplyPosition, Integer cmOriginalReportQueryProperties, int cmOriginalReportQueryReplyPosition) throws CognosViewerException {
        BuxCMQueryHelper.processCommonCMResponseProperties(state, cmResponse, cmCurrentReportQueryReplyPosition, cmOriginalReportQueryReplyPosition);
        if (cmCurrentReportQueryProperties.equals(CM_QUERY_PROPERTIES_FOR_VIEW)) {
            BuxCMQueryHelper.setCreationTime(state, cmResponse);
            BuxCMQueryHelper.setReRunObject(state, cmResponse);
        } else {
            BuxCMQueryHelper.setReportViewBasePath(state, cmResponse, cmCurrentReportQueryReplyPosition);
            BuxCMQueryHelper.setLimitedInteractiveMode(state, cmResponse, cmCurrentReportQueryReplyPosition);
            BuxCMQueryHelper.setModelPath(state, cmResponse, cmCurrentReportQueryReplyPosition);
            BuxCMQueryHelper.setPackageBase(state, cmResponse, cmCurrentReportQueryReplyPosition);
            BuxCMQueryHelper.setRoutingServerGroup(state, cmResponse, cmCurrentReportQueryReplyPosition);
            if (cmOriginalReportQueryProperties != null) {
                BuxCMQueryHelper.setModificationTime(state, cmResponse, cmOriginalReportQueryReplyPosition);
                BuxCMQueryHelper.setBaseReportAvailability(state, cmResponse, cmOriginalReportQueryReplyPosition);
            } else {
                BuxCMQueryHelper.setModificationTime(state, cmResponse, cmCurrentReportQueryReplyPosition);
                BuxCMQueryHelper.setBaseReportAvailability(state, cmResponse, cmCurrentReportQueryReplyPosition);
            }
            if (cmCurrentReportQueryProperties.equals(CM_QUERY_PROPERTIES_FOR_CURRENT_REPORT)) {
                BuxCMQueryHelper.setCreationTime(state, cmResponse);
                BuxCMQueryHelper.setVerticalElementsOption(state, cmResponse, cmCurrentReportQueryReplyPosition);
                BuxCMQueryHelper.setParametersValue(state, cmResponse, cmCurrentReportQueryReplyPosition);
                BuxCMQueryHelper.setReRunObject(state, cmResponse);
                BuxCMQueryHelper.setExecutionPrompt(state, cmResponse, cmCurrentReportQueryReplyPosition);
                BuxCMQueryHelper.setAAFLaunchParameters(state, cmResponse, cmCurrentReportQueryReplyPosition);
            }
        }
    }

    private static void setReRunObject(ICognosViewerState state, CMServerResponse cmResponse) {
        state.setFormFieldFromString("ui.reRunObj", state.getFormFieldAsString("ui.object"), false);
    }

    private static void setRoutingServerGroup(ICognosViewerState state, CMServerResponse cmResponse, int cmCurrentReportQueryReplyPosition) {
        String routingServerGroup = cmResponse.getProperty(PropEnum.routingServerGroup.getValue(), cmCurrentReportQueryReplyPosition);
        if (routingServerGroup.length() > 0) {
            state.setFormFieldFromString("ui.routingServerGroup", routingServerGroup);
        }
    }

    private static void setModelPath(ICognosViewerState state, CMServerResponse cmResponse, int cmCurrentReportQueryReplyPosition) {
        Element metadataModel;
        if ("".equals(state.getFormFieldAsString("modelPath")) && (metadataModel = cmResponse.getComplexProperty(PropEnum.metadataModel.getValue(), cmCurrentReportQueryReplyPosition)) != null) {
            Element modificationTime;
            Element modelPath = (Element)metadataModel.selectSingleNode("./value/item/searchPath/value");
            if (modelPath != null) {
                state.setFormFieldFromString("modelPath", modelPath.getText());
            }
            if ((modificationTime = (Element)metadataModel.selectSingleNode("./value/item/modificationTime/value")) != null) {
                state.setFormFieldFromString("metaDataModelModificationTime", modificationTime.getText());
            }
        }
    }

    private static void setPackageBase(ICognosViewerState state, CMServerResponse cmResponse, int cmCurrentReportQueryReplyPosition) {
        String sPackageBase;
        if ("".equals(state.getFormFieldAsString("packageBase")) && (sPackageBase = cmResponse.getStringValue("*[local-name()='queryResponse']/returns/item/queryResult/item/metadataModelPackage/value/item/searchPath/value")).length() > 0) {
            state.setFormFieldFromString("packageBase", sPackageBase);
            if ("".equals(state.getFormFieldAsString("modelPath"))) {
                state.setFormFieldFromString("modelPath", sPackageBase + "/model[last()]");
            }
        }
    }

    private static void setParametersValue(ICognosViewerState state, CMServerResponse cmResponse, int cmCurrentReportQueryReplyPosition) {
        Element parametersElem = cmResponse.getComplexProperty(PropEnum.parameters.getValue(), cmCurrentReportQueryReplyPosition);
        if (parametersElem != null) {
            state.addObject("parameters", parametersElem);
        }
    }

    private static void setBaseReportAvailability(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        Element itemElement;
        Element permissions = cmResponse.getComplexProperty("permissions", reportQueryReplyPosition);
        if (permissions == null) {
            state.setFormFieldFromString("baseReportAvailable", "false");
            return;
        }
        Element permissionsValueElement = permissions.element("value");
        if (permissionsValueElement != null && (itemElement = permissionsValueElement.element("item")) == null) {
            state.setFormFieldFromString("baseReportAvailable", "false");
            return;
        }
        state.setFormFieldFromString("baseReportAvailable", "true");
    }

    private static void setCreationTime(ICognosViewerState state, CMServerResponse cmResponse) {
        Element reportVersionCreationTime;
        Element parent = cmResponse.getComplexProperty(PropEnum.parent.getValue(), 1);
        if (parent != null && (reportVersionCreationTime = (Element)parent.selectSingleNode("value/item/creationTime/value")) != null) {
            state.setFormFieldFromString("creationTime", reportVersionCreationTime.getText());
        }
    }

    private static void setModificationTime(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        String sBaseReportModificationTime = cmResponse.getProperty(PropEnum.modificationTime.getValue(), reportQueryReplyPosition);
        if (sBaseReportModificationTime.length() > 0) {
            state.setFormFieldFromString("baseReportModificationTime", sBaseReportModificationTime, true);
        }
    }

    private static void setReportViewBasePath(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        Element baseProp;
        if ("reportView".equals(state.getFormFieldAsString("ui.objectClass")) && (baseProp = cmResponse.getComplexProperty(PropEnum.base.getValue(), reportQueryReplyPosition)) != null) {
            String baseReportSearchPath = baseProp.selectSingleNode("value/item/searchPath/value").getText();
            state.setFormFieldFromString("baseReportSearchPath", baseReportSearchPath);
        }
    }

    private static void setVerticalElementsOption(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) throws CognosViewerException {
        Element optionsProp;
        if (state.getOptionManager().getOption("verticalElements") == null && (optionsProp = cmResponse.getComplexProperty(PropEnum.options.getValue(), reportQueryReplyPosition)) != null) {
            ActionHelper.addVerticalElementsToState(state, optionsProp);
        }
    }

    private static void setAAFLaunchParameters(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        Element AAFLaunchParameters;
        Element optionsProp;
        Capabilities capabilities = state.getCapabilities();
        if ((capabilities.hasCapability("canUseAdaptiveAnalytics") || capabilities.hasCapability("canUseAdaptiveAnalyticsAdministration")) && (optionsProp = cmResponse.getComplexProperty(PropEnum.options.getValue(), reportQueryReplyPosition)) != null && (AAFLaunchParameters = (Element)optionsProp.selectSingleNode("./value/item[./name = 'http://developer.cognos.com/ceba/constants/serviceProvider#AA_Info']/value")) != null) {
            String value = AAFLaunchParameters.getText();
            try {
                Document document = DocumentHelper.parseText((String)value);
                Element baseURL = (Element)document.selectSingleNode("./*[local-name()='aaInfo']/*[local-name()='item'][./*[local-name()='name']='baseUrl']/*[local-name()='value']");
                if (baseURL != null) {
                    state.addObject("AAFBaseUrl", baseURL.getText());
                }
            }
            catch (Exception e) {
                IPFLogger.getInstance().error("Could not parse AAF Options", BuxCMQueryHelper.class.getName());
            }
        }
    }

    public static void setLimitedInteractiveMode(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        if ("true".equals(state.getFormFieldAsString("limitedInteractiveMode"))) {
            return;
        }
        String runAsOwner = cmResponse.getProperty(PropEnum.runAsOwner.getValue(), reportQueryReplyPosition);
        String runWithOwnerCapabilities = cmResponse.getProperty(PropEnum.runWithOwnerCapabilities.getValue(), reportQueryReplyPosition);
        Element module = cmResponse.getComplexProperty(PropEnum.module.getValue(), reportQueryReplyPosition);
        String permissions = state.getFormFieldAsString("cv.objectPermissions");
        if (permissions.indexOf("read") == -1 && permissions.indexOf("execute") != -1 || "true".equals(runAsOwner) || "true".equals(runWithOwnerCapabilities) || module != null && module.hasContent()) {
            state.setFormFieldFromString("limitedInteractiveMode", "true");
        } else {
            state.setFormFieldFromString("limitedInteractiveMode", "false");
        }
    }

    private static void setExecutionPrompt(ICognosViewerState state, CMServerResponse cmResponse, int reportQueryReplyPosition) {
        String executionPromptValue = cmResponse.getProperty(PropEnum.executionPrompt.getValue(), reportQueryReplyPosition);
        if (executionPromptValue.length() > 0) {
            state.setFormFieldFromString("executionPrompt", executionPromptValue);
        }
    }

    public static String generateDefaultOutputSearchPath(String searchPath) {
        if (searchPath.indexOf("defaultOutput") == -1) {
            return "defaultOutput(" + searchPath + ",'HTML', '', 'HTML XHTML')";
        }
        return searchPath;
    }

    public static CMServerResponse getSavedOutput(ICognosViewerState state, CognosViewerServiceFactory serviceFactory, String outputSearchPath, Integer cmQueryProperties) throws CognosViewerException {
        if (outputSearchPath == null || outputSearchPath.length() == 0) {
            return null;
        }
        String originalAction = state.getFormFieldAsString("ui.action");
        CMServerResponse cmResponse = null;
        try {
            cmResponse = (CMServerResponse)BuxCMQueryHelper.executeViewAction(state, serviceFactory, outputSearchPath, cmQueryProperties);
        }
        catch (CognosViewerException e) {
            state.setFormFieldFromString("ui.action", originalAction);
            throw e;
        }
        BuxCMQueryHelper.processCMResponse(state, cmResponse, cmQueryProperties, 2, null, -1);
        if (cmResponse.getProperty(PropEnum.defaultName.getValue(), 1).length() == 0) {
            state.setFormFieldFromString("ui.action", originalAction);
            return null;
        }
        return cmResponse;
    }

    private static SOAPResponse executeViewAction(ICognosViewerState state, CognosViewerServiceFactory serviceFactory, String outputSearchPath, Integer cmQueryProperties) throws CognosViewerException {
        PropEnum[] reportQueryProperties;
        ActionFactory actionFactory = new ActionFactory(serviceFactory);
        String originalObj = state.getFormFieldAsString("ui.object");
        state.setFormFieldFromString("ui.action", "view");
        state.setFormFieldFromString("ui.object", outputSearchPath);
        ViewAction viewAction = (ViewAction)actionFactory.load("view", state);
        if (cmQueryProperties != null && (reportQueryProperties = m_cmQueryProperties.get(cmQueryProperties)) != null) {
            RefProp[] refProps = null;
            String objectClass = state.getFormFieldAsString("ui.objectClass");
            if (!"reportView".equals(objectClass) && cmQueryProperties != CM_QUERY_PROPERTIES_FOR_VIEW) {
                refProps = m_ContentManagerRefProperties;
            }
            QueryRequest reportQuery = BuxCMQueryHelper.createQueryRequest(originalObj, reportQueryProperties, refProps);
            viewAction.addExtraQueryRequests(new QueryRequest[]{reportQuery});
        }
        CMServerResponse cmResponse = null;
        try {
            cmResponse = (CMServerResponse)viewAction.execute();
        }
        catch (CognosViewerException e) {
            state.setFormFieldFromString("ui.object", originalObj);
            throw e;
        }
        state.setFormFieldFromString("ui.object", originalObj);
        return cmResponse;
    }

    public static void queryPropertiesForBothCurrentAndBaseReport(ICognosViewerState state, CognosViewerServiceFactory serviceFactory, String sCurrentReportSearchPath, String sBaseReportSearchPath) throws CognosViewerException {
        Integer currentReportQueryProps = CM_QUERY_PROPERTIES_FOR_CURRENT_REPORT;
        QueryRequest currentReportQuery = null;
        PropEnum[] currentReportQueryProperties = m_cmQueryProperties.get(currentReportQueryProps);
        if (currentReportQueryProperties != null && sCurrentReportSearchPath != null && sCurrentReportSearchPath.length() > 0) {
            currentReportQuery = BuxCMQueryHelper.createQueryRequest(sCurrentReportSearchPath, currentReportQueryProperties, m_ContentManagerRefProperties);
        }
        Integer baseReportQueryProps = CM_QUERY_PROPERTIES_FOR_BASE_REPORT;
        QueryRequest baseReportQuery = null;
        PropEnum[] baseReportQueryProperties = m_cmQueryProperties.get(baseReportQueryProps);
        if (baseReportQueryProperties != null && sBaseReportSearchPath != null && sBaseReportSearchPath.length() > 0) {
            baseReportQuery = BuxCMQueryHelper.createQueryRequest(sBaseReportSearchPath, baseReportQueryProperties, null);
        }
        if (currentReportQuery != null || baseReportQuery != null) {
            QueryRequest[] queryRequests;
            int currentReportPosition = 1;
            int baseReportPosition = 2;
            if (baseReportQuery == null) {
                baseReportPosition = -1;
                baseReportQueryProps = null;
                queryRequests = new QueryRequest[]{currentReportQuery};
            } else {
                queryRequests = new QueryRequest[]{currentReportQuery, baseReportQuery};
            }
            IArgumentMarshaller[] arguments = new IArgumentMarshaller[]{new QueryRequestMarshaller(queryRequests)};
            ICognosViewerRequest cmRequest = serviceFactory.getService(CognosViewerServiceFactory.CMSERVICEREQUEST);
            CMServerResponse cmResponse = (CMServerResponse)cmRequest.executeRequest("queryMultiple", state, arguments, "");
            BuxCMQueryHelper.processCMResponse(state, cmResponse, currentReportQueryProps, currentReportPosition, baseReportQueryProps, baseReportPosition);
        }
    }

    private static QueryRequest createQueryRequest(String sCurrentReportSearchPath, PropEnum[] currentReportQueryProperties, RefProp[] refProps) {
        QueryRequest query = new QueryRequest();
        query.setSearch(sCurrentReportSearchPath);
        query.setProperties(currentReportQueryProperties);
        if (refProps != null) {
            QueryOptions queryOptions = new QueryOptions();
            queryOptions.setRefProps(refProps);
            query.setOptions(queryOptions);
        }
        return query;
    }

    static {
        m_cmQueryProperties.put(CM_QUERY_PROPERTIES_FOR_VIEW, new PropEnum[]{PropEnum.defaultName, PropEnum.objectClass, PropEnum.ancestors, PropEnum.permissions, PropEnum.searchPath});
        m_cmQueryProperties.put(CM_QUERY_PROPERTIES_FOR_CURRENT_REPORT, new PropEnum[]{PropEnum.defaultName, PropEnum.objectClass, PropEnum.ancestors, PropEnum.permissions, PropEnum.searchPath, PropEnum.modificationTime, PropEnum.defaultPortalAction, PropEnum.options, PropEnum.runAsOwner, PropEnum.runWithOwnerCapabilities, PropEnum.base, PropEnum.executionPrompt, PropEnum.locale, PropEnum.routingServerGroup, PropEnum.metadataModelPackage, PropEnum.metadataModel, PropEnum.name, PropEnum.parameters, PropEnum.module});
        m_cmQueryProperties.put(CM_QUERY_PROPERTIES_FOR_BASE_REPORT, new PropEnum[]{PropEnum.permissions, PropEnum.modificationTime, PropEnum.defaultName, PropEnum.ancestors});
        m_ContentManagerRefProperties = null;
        m_ContentManagerRefProperties = new RefProp[3];
        RefProp baseRefProp = new RefProp();
        baseRefProp.setRefPropName(PropEnum.base);
        baseRefProp.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.permissions, PropEnum.metadataModel, PropEnum.metadataModelPackage, PropEnum.ancestors});
        BuxCMQueryHelper.m_ContentManagerRefProperties[0] = baseRefProp;
        RefProp metaDataModelRefProp = new RefProp();
        metaDataModelRefProp.setRefPropName(PropEnum.metadataModel);
        metaDataModelRefProp.setProperties(new PropEnum[]{PropEnum.modificationTime, PropEnum.searchPath, PropEnum.parent});
        BuxCMQueryHelper.m_ContentManagerRefProperties[1] = metaDataModelRefProp;
        RefProp metaDataModelPackageRefProp = new RefProp();
        metaDataModelPackageRefProp.setRefPropName(PropEnum.metadataModelPackage);
        metaDataModelPackageRefProp.setProperties(new PropEnum[]{PropEnum.searchPath});
        BuxCMQueryHelper.m_ContentManagerRefProperties[2] = metaDataModelPackageRefProp;
    }
}

