/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.rap.controller.ICognosServiceRequest;
import com.cognos.rap.controller.RAPReport;
import com.cognos.rap.controller.ReportActionController;
import com.cognos.rap.exceptions.ActionControllerException;
import com.cognos.viewer.action.ActionHelper;
import com.cognos.viewer.action.BuxSubAction;
import com.cognos.viewer.action.ModifyReportAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CognosServiceRequest;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.CognosViewerServiceFactory;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.SOAPResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BuxChangeContentLocaleSubAction
extends BuxSubAction {
    public BuxChangeContentLocaleSubAction(ICognosViewerState state, CognosViewerServiceFactory factory) {
        this.initialize(state, factory);
    }

    @Override
    public SOAPResponse executeRequest() throws CognosViewerException {
        return this.applyReportActionProcessorChanges();
    }

    @Override
    protected void handleResponse() throws CognosViewerException {
    }

    public ICognosServiceRequest getCognosServiceRequest() {
        return new CognosServiceRequest(this.m_state, this.m_serviceFactory);
    }

    public SOAPResponse applyReportActionProcessorChanges() throws CognosViewerException {
        String reportSpec = this.m_state.getFormFieldAsString("ui.spec");
        try {
            Element reportActionsNode = this.createActions();
            ReportActionController rap = new ReportActionController(this.getCognosServiceRequest());
            rap.setViewerDebugLogger(this.m_state.getDebugLogger());
            RAPReport rapReport = new RAPReport(reportSpec);
            rapReport.setDefaultLocale(CognosViewerDispatcherHandlerState.getContentLocale(this.m_state));
            rapReport.setProductLocale(CognosViewerDispatcherHandlerState.getProductLocale(this.m_state));
            if (this.m_state.getDebugLogger().isDebugEnabled()) {
                this.m_state.getDebugLogger().logXML(reportActionsNode.asXML(), "rapAction.xml", true, "rapAction - Change locale");
            }
            rap.applyActions(rapReport, reportActionsNode.asXML());
            ModifyReportAction.saveReportInfoToState(this.m_state, rapReport);
        }
        catch (ActionControllerException e) {
            return ActionHelper.handleActionControllerException(e, this.m_state);
        }
        catch (Exception e) {
            this.m_state.getIPFLogger().error(e.getMessage(), e, this.getClass().getName());
            this.m_state.setFormFieldFromString("ui.spec", ModifyReportAction.getEmptyReportSpec());
        }
        return new CMServerBlankResponse(this.m_state);
    }

    private Element createActions() {
        Element reportActionsNode = DocumentHelper.createElement((String)"reportActions");
        reportActionsNode.addElement("reportAction").addAttribute("name", "ChangeLocale");
        return reportActionsNode;
    }
}

