/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.action;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.viewer.action.ActionFactory;
import com.cognos.viewer.action.BuxAction;
import com.cognos.viewer.action.BuxCMQueryHelper;
import com.cognos.viewer.action.ReportOutputAction;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.MessageManager;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;

public class BuxDropReportOnCanvasAction
extends ReportOutputAction {
    @Override
    public void prepareRequest() throws CognosViewerException {
        if (!this.m_state.getCapabilities().hasCapability("canUseDashboardViewer")) {
            CognosViewerException exception = new CognosViewerException(this.m_state.getBusEnvelope(), MessageManager.convert("IDS_CONTENT_DISPLAY_ERROR", CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)), null);
            throw exception;
        }
        this.m_state.setFormFieldFromString("cv.showFaultPage", "false");
    }

    @Override
    protected SOAPResponse executeRequest() throws CognosViewerException {
        String outputSearchPath = BuxCMQueryHelper.generateDefaultOutputSearchPath(this.m_state.getFormFieldAsString("ui.object"));
        CMServerResponse cmResponse = BuxCMQueryHelper.getSavedOutput(this.m_state, this.m_serviceFactory, outputSearchPath, BuxCMQueryHelper.CM_QUERY_PROPERTIES_FOR_CURRENT_REPORT);
        if (this.shouldViewSavedOutput(cmResponse)) {
            this.m_state.setFormFieldFromString("ui.object", "storeID(\"" + cmResponse.getProperty(PropEnum.storeID.getValue(), 1) + "\")");
            return cmResponse;
        }
        ActionFactory actionFactory = new ActionFactory(this.m_serviceFactory);
        this.m_state.setFormFieldFromString("ui.primaryAction", "bux");
        BuxAction buxAction = (BuxAction)actionFactory.load("bux", this.m_state);
        return buxAction.execute();
    }

    private boolean shouldViewSavedOutput(CMServerResponse cmResponse) {
        if (cmResponse != null) {
            boolean bInteractiveOutput;
            String type = null;
            String dataDescriptor = cmResponse.getProperty(PropEnum.dataDescriptor.getValue(), 1);
            if (dataDescriptor != null && !dataDescriptor.isEmpty()) {
                try {
                    JSONObject dataDescriptorValues = (JSONObject)JSON.parse((String)dataDescriptor);
                    type = (String)dataDescriptorValues.get((Object)"type");
                }
                catch (Exception dataDescriptorValues) {
                    // empty catch block
                }
            }
            if (bInteractiveOutput = "interactive".equalsIgnoreCase(type)) {
                return false;
            }
            boolean bViewOutput = "viewOutput".equals(cmResponse.getProperty(PropEnum.defaultPortalAction.getValue(), 2));
            if (bViewOutput || !this.m_state.getFormFieldAsString("cv.objectPermissions").contains("execute")) {
                return true;
            }
        }
        return false;
    }
}

